/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.renderstate;

import de.bluecolored.bluemap.core.map.renderstate.TileActionResolver;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Keyed;
import de.bluecolored.bluemap.core.util.Registry;

public interface TileState
extends Keyed,
TileActionResolver {
    public static final TileState UNKNOWN = new Impl(Key.bluemap("unknown"));
    public static final TileState RENDERED = new Impl(Key.bluemap("rendered"), (changed, bounds) -> switch (bounds) {
        default -> throw new MatchException(null, null);
        case TileActionResolver.BoundsSituation.INSIDE -> {
            if (changed) {
                yield TileActionResolver.ActionAndNextState.RENDER_RENDERED;
            }
            yield TileActionResolver.ActionAndNextState.NONE_RENDERED;
        }
        case TileActionResolver.BoundsSituation.EDGE -> TileActionResolver.ActionAndNextState.RENDER_RENDERED_EDGE;
        case TileActionResolver.BoundsSituation.OUTSIDE -> TileActionResolver.ActionAndNextState.DELETE_OUT_OF_BOUNDS;
    });
    public static final TileState RENDERED_EDGE = new Impl(Key.bluemap("rendered-edge"), (changed, bounds) -> switch (bounds) {
        default -> throw new MatchException(null, null);
        case TileActionResolver.BoundsSituation.INSIDE -> TileActionResolver.ActionAndNextState.RENDER_RENDERED;
        case TileActionResolver.BoundsSituation.EDGE -> {
            if (changed) {
                yield TileActionResolver.ActionAndNextState.RENDER_RENDERED_EDGE;
            }
            yield TileActionResolver.ActionAndNextState.NONE_RENDERED_EDGE;
        }
        case TileActionResolver.BoundsSituation.OUTSIDE -> TileActionResolver.ActionAndNextState.DELETE_OUT_OF_BOUNDS;
    });
    public static final TileState OUT_OF_BOUNDS = new Impl(Key.bluemap("out-of-bounds"), (changed, bounds) -> switch (bounds) {
        default -> throw new MatchException(null, null);
        case TileActionResolver.BoundsSituation.INSIDE -> TileActionResolver.ActionAndNextState.RENDER_RENDERED;
        case TileActionResolver.BoundsSituation.EDGE -> TileActionResolver.ActionAndNextState.RENDER_RENDERED_EDGE;
        case TileActionResolver.BoundsSituation.OUTSIDE -> TileActionResolver.ActionAndNextState.NONE_OUT_OF_BOUNDS;
    });
    public static final TileState NOT_GENERATED = new Impl(Key.bluemap("not-generated"));
    public static final TileState MISSING_LIGHT = new Impl(Key.bluemap("missing-light"));
    public static final TileState LOW_INHABITED_TIME = new Impl(Key.bluemap("low-inhabited-time"));
    public static final TileState CHUNK_ERROR = new Impl(Key.bluemap("chunk-error"));
    public static final TileState RENDER_ERROR = new Impl(Key.bluemap("render-error"), (changed, bounds) -> switch (bounds) {
        default -> throw new MatchException(null, null);
        case TileActionResolver.BoundsSituation.INSIDE -> TileActionResolver.ActionAndNextState.RENDER_RENDERED;
        case TileActionResolver.BoundsSituation.EDGE -> TileActionResolver.ActionAndNextState.RENDER_RENDERED_EDGE;
        case TileActionResolver.BoundsSituation.OUTSIDE -> TileActionResolver.ActionAndNextState.DELETE_OUT_OF_BOUNDS;
    });
    public static final Registry<TileState> REGISTRY = new Registry((Keyed[])new TileState[]{UNKNOWN, RENDERED, RENDERED_EDGE, OUT_OF_BOUNDS, NOT_GENERATED, MISSING_LIGHT, LOW_INHABITED_TIME, CHUNK_ERROR, RENDER_ERROR});

    public static class Impl
    implements TileState {
        private final Key key;
        private final TileActionResolver resolver;
        private TileActionResolver.ActionAndNextState noActionThisNextState;

        public Impl(Key key) {
            this.key = key;
            this.resolver = (changed, bounds) -> {
                if (!changed) {
                    return this.noActionThisNextState();
                }
                return switch (bounds) {
                    default -> throw new MatchException(null, null);
                    case TileActionResolver.BoundsSituation.INSIDE -> TileActionResolver.ActionAndNextState.RENDER_RENDERED;
                    case TileActionResolver.BoundsSituation.EDGE -> TileActionResolver.ActionAndNextState.RENDER_RENDERED_EDGE;
                    case TileActionResolver.BoundsSituation.OUTSIDE -> TileActionResolver.ActionAndNextState.DELETE_OUT_OF_BOUNDS;
                };
            };
        }

        public String toString() {
            return this.key.getFormatted();
        }

        @Override
        public TileActionResolver.ActionAndNextState findActionAndNextState(boolean changed, TileActionResolver.BoundsSituation bounds) {
            return this.resolver.findActionAndNextState(changed, bounds);
        }

        private TileActionResolver.ActionAndNextState noActionThisNextState() {
            if (this.noActionThisNextState == null) {
                this.noActionThisNextState = new TileActionResolver.ActionAndNextState(TileActionResolver.Action.NONE, this);
            }
            return this.noActionThisNextState;
        }

        @Override
        public Key getKey() {
            return this.key;
        }

        public TileActionResolver getResolver() {
            return this.resolver;
        }

        public TileActionResolver.ActionAndNextState getNoActionThisNextState() {
            return this.noActionThisNextState;
        }

        public Impl(Key key, TileActionResolver resolver) {
            this.key = key;
            this.resolver = resolver;
        }
    }
}

