/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resources.VersionManifest;
import de.bluecolored.bluemap.core.resources.adapter.AbstractTypeAdapterFactory;
import de.bluecolored.bluemap.core.resources.pack.PackVersion;
import de.bluecolored.bluemap.core.util.FileHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class MinecraftVersion {
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private static final String EARLIEST_RESOURCEPACK_VERSION = "1.13";
    private static final String EARLIEST_DATAPACK_VERSION = "1.19.4";
    private final String id;
    private final Path resourcePack;
    private final PackVersion resourcePackVersion;
    private final Path dataPack;
    private final PackVersion dataPackVersion;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinecraftVersion that = (MinecraftVersion)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static MinecraftVersion load(@Nullable String id, Path dataRoot, boolean allowDownload) throws IOException {
        Path dataPack;
        Path resourcePack;
        try {
            VersionManifest manifest = VersionManifest.getOrFetch();
            if (id == null) {
                id = manifest.getLatest().getRelease();
            }
            VersionManifest.Version version = manifest.getVersion(id);
            VersionManifest.Version resourcePackVersion = manifest.getVersion(EARLIEST_RESOURCEPACK_VERSION);
            VersionManifest.Version dataPackVersion = manifest.getVersion(EARLIEST_DATAPACK_VERSION);
            if (version.compareTo(resourcePackVersion) > 0) {
                resourcePackVersion = version;
            }
            if (version.compareTo(dataPackVersion) > 0) {
                dataPackVersion = version;
            }
            resourcePack = dataRoot.resolve(MinecraftVersion.getClientVersionFileName(resourcePackVersion.getId()));
            dataPack = dataRoot.resolve(MinecraftVersion.getClientVersionFileName(dataPackVersion.getId()));
            if (allowDownload) {
                if (!Files.exists(resourcePack, new LinkOption[0])) {
                    MinecraftVersion.download(resourcePackVersion, resourcePack);
                }
                if (!Files.exists(dataPack, new LinkOption[0])) {
                    MinecraftVersion.download(dataPackVersion, dataPack);
                }
            }
        }
        catch (IOException ex) {
            if (id == null) {
                throw ex;
            }
            Logger.global.logWarning("Failed to fetch version-info from mojang-servers: " + String.valueOf(ex));
            dataPack = resourcePack = dataRoot.resolve(MinecraftVersion.getClientVersionFileName(id));
        }
        if (!Files.exists(resourcePack, new LinkOption[0])) {
            throw new IOException("Resource-File missing: " + String.valueOf(resourcePack));
        }
        if (!Files.exists(dataPack, new LinkOption[0])) {
            throw new IOException("Resource-File missing: " + String.valueOf(dataPack));
        }
        try {
            VersionInfo resourcePackVersionInfo = MinecraftVersion.loadVersionInfo(resourcePack);
            VersionInfo dataPackVersionInfo = resourcePack.equals(dataPack) ? resourcePackVersionInfo : MinecraftVersion.loadVersionInfo(dataPack);
            return new MinecraftVersion(id, resourcePack, resourcePackVersionInfo.getPackVersion().getResource(), dataPack, dataPackVersionInfo.getPackVersion().getData());
        }
        catch (IOException ex) {
            if (allowDownload) {
                Files.deleteIfExists(resourcePack);
                Files.deleteIfExists(dataPack);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void download(VersionManifest.Version version, Path file) throws IOException {
        VersionManifest.Download download = version.fetchDetail().getDownloads().getClient();
        Logger.global.logInfo("Downloading '" + download.getUrl() + "' to '" + String.valueOf(file) + "'...");
        FileHelper.createDirectories(file.toAbsolutePath().normalize().getParent(), new FileAttribute[0]);
        Path unverifiedFile = file.getParent().resolve(file.getFileName().toString() + ".unverified");
        try {
            try (DigestInputStream in = new DigestInputStream(download.createInputStream(), MessageDigest.getInstance("SHA-1"));
                 OutputStream out = Files.newOutputStream(unverifiedFile, new OpenOption[0]);){
                in.transferTo(out);
                if (!Arrays.equals(in.getMessageDigest().digest(), MinecraftVersion.hexStringToByteArray(download.getSha1()))) {
                    throw new IOException("SHA-1 of the downloaded file does not match!");
                }
            }
            FileHelper.atomicMove(unverifiedFile, file);
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            Logger.global.logWarning("Failed to download '" + download.getUrl() + "': " + String.valueOf(ex));
        }
        finally {
            Files.deleteIfExists(unverifiedFile);
        }
    }

    private static String getClientVersionFileName(String versionId) {
        return "minecraft-client-" + versionId + ".jar";
    }

    public static byte[] hexStringToByteArray(String hexString) {
        int length = hexString.length();
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Invalid hex-string.");
        }
        int halfLength = length / 2;
        byte[] data = new byte[halfLength];
        for (int i = 0; i < halfLength; ++i) {
            int c = i * 2;
            data[i] = (byte)((Character.digit(hexString.charAt(c), 16) << 4) + Character.digit(hexString.charAt(c + 1), 16));
        }
        return data;
    }

    private static VersionInfo loadVersionInfo(Path file) throws IOException {
        try (FileSystem fileSystem = FileSystems.newFileSystem(file, (ClassLoader)null);){
            for (Path fsRoot : fileSystem.getRootDirectories()) {
                Path versionFile;
                if (!Files.isDirectory(fsRoot, new LinkOption[0]) || !Files.exists(versionFile = fsRoot.resolve("version.json"), new LinkOption[0])) continue;
                try (BufferedReader reader = Files.newBufferedReader(versionFile, StandardCharsets.UTF_8);){
                    VersionInfo versionInfo = GSON.fromJson((Reader)reader, VersionInfo.class);
                    return versionInfo;
                }
            }
            VersionInfo versionInfo = new VersionInfo();
            return versionInfo;
        }
    }

    public String getId() {
        return this.id;
    }

    public Path getResourcePack() {
        return this.resourcePack;
    }

    public PackVersion getResourcePackVersion() {
        return this.resourcePackVersion;
    }

    public Path getDataPack() {
        return this.dataPack;
    }

    public PackVersion getDataPackVersion() {
        return this.dataPackVersion;
    }

    private MinecraftVersion(String id, Path resourcePack, PackVersion resourcePackVersion, Path dataPack, PackVersion dataPackVersion) {
        this.id = id;
        this.resourcePack = resourcePack;
        this.resourcePackVersion = resourcePackVersion;
        this.dataPack = dataPack;
        this.dataPackVersion = dataPackVersion;
    }

    private static class VersionInfo {
        private PackVersions packVersion = new PackVersions();

        private VersionInfo() {
        }

        public PackVersions getPackVersion() {
            return this.packVersion;
        }
    }

    @JsonAdapter(value=Adapter.class)
    private static class PackVersions {
        @SerializedName(value="resource_major", alternate={"resource"})
        private int resourceMajor = 4;
        private int resourceMinor = 0;
        @SerializedName(value="data_major", alternate={"data"})
        private int dataMajor = 4;
        private int dataMinor = 0;

        public PackVersions(int resource, int data) {
            this.resourceMajor = resource;
            this.dataMajor = data;
        }

        public PackVersion getResource() {
            return new PackVersion(this.resourceMajor, this.resourceMinor);
        }

        public PackVersion getData() {
            return new PackVersion(this.dataMajor, this.dataMinor);
        }

        public int getResourceMajor() {
            return this.resourceMajor;
        }

        public int getResourceMinor() {
            return this.resourceMinor;
        }

        public int getDataMajor() {
            return this.dataMajor;
        }

        public int getDataMinor() {
            return this.dataMinor;
        }

        public PackVersions() {
        }

        private static class Adapter
        extends AbstractTypeAdapterFactory<PackVersions> {
            public Adapter() {
                super(PackVersions.class);
            }

            @Override
            public PackVersions read(JsonReader in, Gson gson) throws IOException {
                return in.peek() == JsonToken.NUMBER ? new PackVersions(in.nextInt(), 4) : gson.getDelegateAdapter(this, TypeToken.get(PackVersions.class)).read(in);
            }
        }
    }
}

