/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.bluecolored.bluemap.core.util.Key;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Adapter.class)
public class ResourcePath<T>
extends Key {
    private T resource = null;

    public ResourcePath(String formatted) {
        super(formatted.toLowerCase(Locale.ROOT));
    }

    public ResourcePath(String namespace, String value) {
        super(namespace.toLowerCase(Locale.ROOT), value.toLowerCase(Locale.ROOT));
    }

    public ResourcePath(Key key) {
        super(key.getNamespace(), key.getValue());
    }

    public ResourcePath(Path filePath, int namespacePos, int valuePos) {
        super(ResourcePath.parsePath(filePath, namespacePos, valuePos).toLowerCase(Locale.ROOT));
    }

    @Nullable
    public T getResource() {
        return this.resource;
    }

    @Nullable
    public T getResource(Function<ResourcePath<T>, T> supplier) {
        if (this.resource == null) {
            this.resource = supplier.apply(this);
        }
        return this.resource;
    }

    public void setResource(T resource) {
        this.resource = resource;
    }

    private static String parsePath(Path filePath, int namespacePos, int valuePos) {
        if (filePath.getNameCount() <= valuePos) {
            throw new IllegalArgumentException("The provided filePath has not enough segments!");
        }
        String namespace = filePath.getName(namespacePos).toString();
        String path = filePath.subpath(valuePos, filePath.getNameCount()).toString().replace(filePath.getFileSystem().getSeparator(), "/");
        int dotIndex = path.lastIndexOf(46);
        if (dotIndex != -1) {
            path = path.substring(0, dotIndex);
        }
        return namespace + ":" + path;
    }

    static class Adapter
    implements TypeAdapterFactory {
        Adapter() {
        }

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!type.getRawType().isAssignableFrom(ResourcePath.class)) {
                return null;
            }
            return new TypeAdapter<T>(this){

                @Override
                public void write(JsonWriter out, T value) throws IOException {
                    out.value(((ResourcePath)value).getFormatted());
                }

                @Override
                public T read(JsonReader in) throws IOException {
                    return new ResourcePath(in.nextString());
                }
            };
        }
    }
}

