/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.model;

import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.pack.ResourcePool;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.Element;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.Face;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.TextureVariable;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.Direction;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class Model {
    @Nullable
    private ResourcePath<Model> parent;
    private Map<String, TextureVariable> textures = new HashMap<String, TextureVariable>();
    private Element @Nullable [] elements;
    private Boolean ambientocclusion;
    private transient boolean culling = false;
    private transient boolean occluding = false;

    public Model(Map<String, TextureVariable> textures) {
        this.textures.putAll(textures);
    }

    public Model(Element ... elements) {
        this.elements = elements;
    }

    public Model(Map<String, TextureVariable> textures, Element ... elements) {
        this.textures.putAll(textures);
        this.elements = elements;
    }

    public Model(Map<String, TextureVariable> textures, Element @Nullable [] elements, boolean ambientocclusion) {
        this.textures.putAll(textures);
        this.elements = elements;
    }

    public Model(@Nullable ResourcePath<Model> parent, Map<String, TextureVariable> textures) {
        this.parent = parent;
        this.textures.putAll(textures);
    }

    public Model(@Nullable ResourcePath<Model> parent, Map<String, TextureVariable> textures, Element @Nullable [] elements, boolean ambientocclusion) {
        this.parent = parent;
        this.textures.putAll(textures);
        this.elements = elements;
    }

    public synchronized void optimize(ResourcePool<Texture> texturePool) {
        for (TextureVariable variable : this.textures.values()) {
            variable.optimize(texturePool);
        }
        if (this.elements != null) {
            for (Element element : this.elements) {
                if (element == null) continue;
                element.optimize(texturePool);
            }
        }
    }

    public synchronized void applyParent(ResourcePool<Model> modelPool) {
        if (this.parent == null) {
            return;
        }
        ResourcePath<Model> parentPath = this.parent;
        this.parent = null;
        Model parent = parentPath.getResource(modelPool::get);
        if (parent != null) {
            parent.applyParent(modelPool);
            if (this.ambientocclusion == null && parent.ambientocclusion != null) {
                this.ambientocclusion = parent.ambientocclusion;
            }
            parent.textures.forEach(this::applyTextureVariable);
            if (this.elements == null && parent.elements != null) {
                this.elements = new Element[parent.elements.length];
                for (int i = 0; i < this.elements.length; ++i) {
                    if (parent.elements[i] == null) continue;
                    this.elements[i] = parent.elements[i].copy();
                }
            }
        }
    }

    private synchronized void applyTextureVariable(String key, TextureVariable value) {
        if (!this.textures.containsKey(key)) {
            this.textures.put(key, value.copy());
        }
    }

    public synchronized void calculateProperties(ResourcePool<Texture> texturePool) {
        if (this.elements == null) {
            return;
        }
        block0: for (Element element : this.elements) {
            if (element == null || !element.isFullCube()) continue;
            this.occluding = true;
            this.culling = true;
            for (Direction dir : Direction.values()) {
                Face face = element.getFaces().get((Object)dir);
                if (face == null) {
                    this.culling = false;
                    break block0;
                }
                ResourcePath<Texture> textureResourcePath = face.getTexture().getTexturePath(this.textures::get);
                if (textureResourcePath == null) {
                    this.culling = false;
                    break block0;
                }
                Texture texture = textureResourcePath.getResource(texturePool::get);
                if (texture != null && !(texture.getColorStraight().a < 1.0f)) continue;
                this.culling = false;
                break block0;
            }
            break;
        }
    }

    public boolean isAmbientocclusion() {
        if (this.ambientocclusion == null) {
            return true;
        }
        return this.ambientocclusion;
    }

    private Model() {
    }

    @Nullable
    public ResourcePath<Model> getParent() {
        return this.parent;
    }

    public Map<String, TextureVariable> getTextures() {
        return this.textures;
    }

    public Element @Nullable [] getElements() {
        return this.elements;
    }

    public boolean isCulling() {
        return this.culling;
    }

    public boolean isOccluding() {
        return this.occluding;
    }
}

