/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage.file;

import de.bluecolored.bluemap.core.storage.GridStorage;
import de.bluecolored.bluemap.core.storage.ItemStorage;
import de.bluecolored.bluemap.core.storage.compression.CompressedInputStream;
import de.bluecolored.bluemap.core.storage.compression.Compression;
import de.bluecolored.bluemap.core.storage.file.FileItemStorage;
import de.bluecolored.bluemap.core.util.FileHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class FileGridStorage
implements GridStorage {
    private static final Pattern ITEM_PATH_PATTERN = Pattern.compile("x(-?\\d+)z(-?\\d+)");
    private final Path root;
    private final String suffix;
    private final Compression compression;
    private final boolean atomic;

    @Override
    public OutputStream write(int x, int z) throws IOException {
        return this.cell(x, z).write();
    }

    @Override
    @Nullable
    public CompressedInputStream read(int x, int z) throws IOException {
        return this.cell(x, z).read();
    }

    @Override
    public void delete(int x, int z) throws IOException {
        this.cell(x, z).delete();
    }

    @Override
    public boolean exists(int x, int z) throws IOException {
        return this.cell(x, z).exists();
    }

    @Override
    public ItemStorage cell(int x, int z) {
        return new FileItemStorage(this.getItemPath(x, z), this.compression, this.atomic);
    }

    @Override
    public Stream<GridStorage.Cell> stream() throws IOException {
        if (!Files.exists(this.root, new LinkOption[0])) {
            return Stream.empty();
        }
        return FileHelper.walk(this.root, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(itemPath -> {
            Path path = itemPath;
            if (!path.startsWith(this.root)) {
                return null;
            }
            String name = (path = this.root.relativize(path)).toString();
            if (!name.endsWith(this.suffix)) {
                return null;
            }
            name = name.substring(0, name.length() - this.suffix.length());
            Matcher matcher = ITEM_PATH_PATTERN.matcher(name = name.replace(this.root.getFileSystem().getSeparator(), ""));
            if (!matcher.matches()) {
                return null;
            }
            int x = Integer.parseInt(matcher.group(1));
            int z = Integer.parseInt(matcher.group(2));
            return new PathCell(x, z, (Path)itemPath, this.compression, this.atomic);
        }).filter(Objects::nonNull);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    public Path getItemPath(int x, int z) {
        String encodedPosition = "x" + x + "z" + z;
        LinkedList<Object> folders = new LinkedList<Object>();
        StringBuilder folder = new StringBuilder();
        for (int i = 0; i < encodedPosition.length(); ++i) {
            char c = encodedPosition.charAt(i);
            folder.append(c);
            if (c < '0' || c > '9') continue;
            folders.add(folder.toString());
            folder.delete(0, folder.length());
        }
        String fileName = (String)folders.removeLast();
        folders.add(fileName + this.suffix);
        Path gridPath = this.root;
        for (String string : folders) {
            gridPath = gridPath.resolve(string);
        }
        return gridPath;
    }

    public FileGridStorage(Path root, String suffix, Compression compression, boolean atomic) {
        this.root = root;
        this.suffix = suffix;
        this.compression = compression;
        this.atomic = atomic;
    }

    private static class PathCell
    extends FileItemStorage
    implements GridStorage.Cell {
        private final int x;
        private final int z;

        public PathCell(int x, int z, Path itemPath, Compression compression, boolean atomic) {
            super(itemPath, compression, atomic);
            this.x = x;
            this.z = z;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getZ() {
            return this.z;
        }
    }
}

