/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage.sql;

import com.github.benmanes.caffeine.cache.Cache;
import de.bluecolored.bluemap.core.storage.GridStorage;
import de.bluecolored.bluemap.core.storage.ItemStorage;
import de.bluecolored.bluemap.core.storage.KeyedMapStorage;
import de.bluecolored.bluemap.core.storage.compression.Compression;
import de.bluecolored.bluemap.core.storage.sql.SQLGridStorage;
import de.bluecolored.bluemap.core.storage.sql.SQLItemStorage;
import de.bluecolored.bluemap.core.storage.sql.commandset.CommandSet;
import de.bluecolored.bluemap.core.util.Caches;
import de.bluecolored.bluemap.core.util.Key;
import java.io.IOException;
import java.util.function.DoublePredicate;

public class SQLMapStorage
extends KeyedMapStorage {
    private final String mapId;
    private final CommandSet sql;
    private final Cache<Key, ItemStorage> itemStorages = Caches.build();
    private final Cache<Key, GridStorage> gridStorages = Caches.build();

    public SQLMapStorage(String mapId, CommandSet sql, Compression compression) {
        super(compression);
        this.mapId = mapId;
        this.sql = sql;
    }

    @Override
    public ItemStorage item(Key key, Compression compression) {
        ItemStorage item = this.itemStorages.getIfPresent(key);
        if (item != null) {
            return item;
        }
        return this.itemStorages.get(key, k -> new SQLItemStorage(this.sql, this.mapId, key, compression));
    }

    @Override
    public GridStorage grid(Key key, Compression compression) {
        GridStorage grid = this.gridStorages.getIfPresent(key);
        if (grid != null) {
            return grid;
        }
        return this.gridStorages.get(key, k -> new SQLGridStorage(this.sql, this.mapId, key, compression));
    }

    @Override
    public void delete(DoublePredicate onProgress) throws IOException {
        int tileCount = this.sql.countMapGridsItems(this.mapId);
        if (tileCount > 0) {
            int totalDeleted = 0;
            int deleted = 0;
            do {
                if (onProgress.test((double)(totalDeleted += (deleted = this.sql.purgeMapGrids(this.mapId, 1000))) / (double)tileCount)) continue;
                return;
            } while (deleted > 0 && totalDeleted < tileCount);
        }
        this.sql.purgeMap(this.mapId);
    }

    @Override
    public boolean exists() throws IOException {
        return this.sql.hasMap(this.mapId);
    }

    @Override
    public boolean isClosed() {
        return this.sql.isClosed();
    }
}

