/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluenbt.adapter;

import de.bluecolored.bluenbt.BlueNBT;
import de.bluecolored.bluenbt.NBTAdapter;
import de.bluecolored.bluenbt.NBTName;
import de.bluecolored.bluenbt.NBTSerializer;
import de.bluecolored.bluenbt.NBTWriter;
import de.bluecolored.bluenbt.TypeSerializer;
import de.bluecolored.bluenbt.TypeSerializerFactory;
import de.bluecolored.bluenbt.TypeToken;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class DefaultSerializerFactory
implements TypeSerializerFactory {
    public static final DefaultSerializerFactory INSTANCE = new DefaultSerializerFactory();

    public <T> Optional<TypeSerializer<T>> create(TypeToken<T> type, BlueNBT blueNBT) {
        return Optional.of(this.createFor(type, blueNBT));
    }

    public <T> TypeSerializer<T> createFor(TypeToken<T> type, BlueNBT blueNBT) {
        return new DefaultAdapter<T>(type, blueNBT);
    }

    static class DefaultAdapter<T>
    implements TypeSerializer<T> {
        private static final Map<Type, Function<Field, SpecialFieldWriter>> SPECIAL_ACCESSORS = Map.of(Boolean.TYPE, field -> (object, writer) -> writer.value(field.getBoolean(object) ? (byte)1 : (byte)0), Byte.TYPE, field -> (object, writer) -> writer.value(field.getByte(object)), Short.TYPE, field -> (object, writer) -> writer.value(field.getShort(object)), Character.TYPE, field -> (object, writer) -> writer.value(field.getChar(object)), Integer.TYPE, field -> (object, writer) -> writer.value(field.getInt(object)), Long.TYPE, field -> (object, writer) -> writer.value(field.getLong(object)), Float.TYPE, field -> (object, writer) -> writer.value(field.getFloat(object)), Double.TYPE, field -> (object, writer) -> writer.value(field.getDouble(object)));
        private final TypeToken<T> type;
        private final Map<String, FieldWriter> fields = new HashMap<String, FieldWriter>();

        public DefaultAdapter(TypeToken<T> type, BlueNBT blueNBT) {
            Class<T> raw;
            this.type = type;
            HashMap<Class, TypeSerializer> typeSerializerCache = new HashMap<Class, TypeSerializer>();
            TypeToken<Object> typeToken = type;
            while (typeToken != null && (raw = typeToken.getRawType()) != Object.class) {
                for (Field field : raw.getDeclaredFields()) {
                    TypeSerializerFieldWriter accessor;
                    TypeSerializer<?> typeSerializer;
                    TypeToken<?> fieldType;
                    Class<TypeSerializer<?>> serializerType;
                    int modifiers = field.getModifiers();
                    if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                    field.setAccessible(true);
                    String name = blueNBT.getNamingStrategy().apply(field);
                    NBTName nbtName = field.getAnnotation(NBTName.class);
                    if (nbtName != null && nbtName.value().length > 0) {
                        name = nbtName.value()[0];
                    }
                    if ((serializerType = this.findSerializerType(field, (fieldType = TypeToken.of(typeToken.resolve(field.getGenericType()))).getRawType())) != null) {
                        typeSerializer = typeSerializerCache.computeIfAbsent(serializerType, t2 -> this.createTypeSerializerInstance((Class<? extends TypeSerializer<?>>)t2, fieldType, blueNBT));
                    } else {
                        if (SPECIAL_ACCESSORS.containsKey(fieldType.getType())) {
                            accessor = (TypeSerializerFieldWriter)((Object)SPECIAL_ACCESSORS.get(fieldType.getType()).apply(field));
                            this.fields.put(name, accessor);
                            continue;
                        }
                        typeSerializer = blueNBT.getTypeSerializer(fieldType);
                    }
                    accessor = new TypeSerializerFieldWriter(field, typeSerializer);
                    this.fields.put(name, accessor);
                }
                Type superType = typeToken.resolve(raw.getGenericSuperclass());
                typeToken = superType != null ? TypeToken.of(superType) : null;
            }
        }

        @Override
        public void write(T value, NBTWriter writer) throws IOException {
            try {
                writer.beginCompound();
                for (Map.Entry<String, FieldWriter> field : this.fields.entrySet()) {
                    field.getValue().write(field.getKey(), value, writer);
                }
                writer.endCompound();
            }
            catch (IllegalAccessException ex) {
                throw new IOException("Failed to create instance of type '" + String.valueOf(this.type) + "'!", ex);
            }
        }

        @Nullable
        private Class<? extends TypeSerializer<?>> findSerializerType(Field field, Class<?> type) {
            NBTSerializer fieldSerializer = field.getAnnotation(NBTSerializer.class);
            if (fieldSerializer != null) {
                return fieldSerializer.value();
            }
            NBTAdapter fieldAdapter = field.getAnnotation(NBTAdapter.class);
            if (fieldAdapter != null) {
                return fieldAdapter.value();
            }
            NBTSerializer typeSerializer = type.getAnnotation(NBTSerializer.class);
            if (typeSerializer != null) {
                return typeSerializer.value();
            }
            NBTAdapter typeAdapter = type.getAnnotation(NBTAdapter.class);
            if (typeAdapter != null) {
                return typeAdapter.value();
            }
            return null;
        }

        private TypeSerializer<?> createTypeSerializerInstance(Class<? extends TypeSerializer<?>> serializerType, TypeToken<?> fieldType, BlueNBT blueNBT) {
            try {
                try {
                    return this.callConstructor(serializerType.getDeclaredConstructor(TypeToken.class, BlueNBT.class), fieldType, blueNBT);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        return this.callConstructor(serializerType.getDeclaredConstructor(TypeToken.class), fieldType);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        try {
                            return this.callConstructor(serializerType.getDeclaredConstructor(BlueNBT.class), blueNBT);
                        }
                        catch (NoSuchMethodException noSuchMethodException3) {
                            return this.callConstructor(serializerType.getDeclaredConstructor(new Class[0]), new Object[0]);
                        }
                    }
                }
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalStateException("Failed to create instance of TypeSerializer: " + String.valueOf(serializerType), ex);
            }
        }

        private <U> U callConstructor(Constructor<U> constructor, Object ... args) throws ReflectiveOperationException {
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
    }

    private static class TypeSerializerFieldWriter<T>
    implements FieldWriter {
        private final Field field;
        private final TypeSerializer<T> typeSerializer;

        @Override
        public void write(String name, Object object, NBTWriter writer) throws IOException, IllegalAccessException {
            Object value = this.field.get(object);
            if (value != null) {
                writer.name(name);
                this.typeSerializer.write(value, writer);
            }
        }

        public TypeSerializerFieldWriter(Field field, TypeSerializer<T> typeSerializer) {
            this.field = field;
            this.typeSerializer = typeSerializer;
        }
    }

    private static interface SpecialFieldWriter
    extends FieldWriter {
        @Override
        default public void write(String name, Object object, NBTWriter writer) throws IOException, IllegalAccessException {
            writer.name(name);
            this.writeValue(object, writer);
        }

        public void writeValue(Object var1, NBTWriter var2) throws IOException, IllegalAccessException;
    }

    private static interface FieldWriter {
        public void write(String var1, Object var2, NBTWriter var3) throws IOException, IllegalAccessException;
    }
}

