/* automatically generated by rust-bindgen 0.72.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    fn extract_bit(byte: u8, index: usize) -> bool {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        Self::extract_bit(byte, index)
    }
    #[inline]
    pub unsafe fn raw_get_bit(this: *const Self, index: usize) -> bool {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            *(core::ptr::addr_of!((*this).storage) as *const u8).offset(byte_index as isize)
        };
        Self::extract_bit(byte, index)
    }
    #[inline]
    fn change_bit(byte: u8, index: usize, val: bool) -> u8 {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val { byte | mask } else { byte & !mask }
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        *byte = Self::change_bit(*byte, index, val);
    }
    #[inline]
    pub unsafe fn raw_set_bit(this: *mut Self, index: usize, val: bool) {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            (core::ptr::addr_of_mut!((*this).storage) as *mut u8).offset(byte_index as isize)
        };
        unsafe { *byte = Self::change_bit(*byte, index, val) };
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub unsafe fn raw_get(this: *const Self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if unsafe { Self::raw_get_bit(this, i + bit_offset) } {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
    #[inline]
    pub unsafe fn raw_set(this: *mut Self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            unsafe { Self::raw_set_bit(this, index + bit_offset, val_bit_is_set) };
        }
    }
}
unsafe extern "C" {
    pub fn realloc(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
pub type LLONG = i64;
pub const ccx_stream_type_CCX_STREAM_TYPE_UNKNOWNSTREAM: ccx_stream_type = 0;
pub const ccx_stream_type_CCX_STREAM_TYPE_VIDEO_MPEG1: ccx_stream_type = 1;
pub const ccx_stream_type_CCX_STREAM_TYPE_VIDEO_MPEG2: ccx_stream_type = 2;
pub const ccx_stream_type_CCX_STREAM_TYPE_AUDIO_MPEG1: ccx_stream_type = 3;
pub const ccx_stream_type_CCX_STREAM_TYPE_AUDIO_MPEG2: ccx_stream_type = 4;
pub const ccx_stream_type_CCX_STREAM_TYPE_PRIVATE_TABLE_MPEG2: ccx_stream_type = 5;
pub const ccx_stream_type_CCX_STREAM_TYPE_PRIVATE_MPEG2: ccx_stream_type = 6;
pub const ccx_stream_type_CCX_STREAM_TYPE_MHEG_PACKETS: ccx_stream_type = 7;
pub const ccx_stream_type_CCX_STREAM_TYPE_MPEG2_ANNEX_A_DSM_CC: ccx_stream_type = 8;
pub const ccx_stream_type_CCX_STREAM_TYPE_ITU_T_H222_1: ccx_stream_type = 9;
pub const ccx_stream_type_CCX_STREAM_TYPE_ISO_IEC_13818_6_TYPE_A: ccx_stream_type = 10;
pub const ccx_stream_type_CCX_STREAM_TYPE_ISO_IEC_13818_6_TYPE_B: ccx_stream_type = 11;
pub const ccx_stream_type_CCX_STREAM_TYPE_ISO_IEC_13818_6_TYPE_C: ccx_stream_type = 12;
pub const ccx_stream_type_CCX_STREAM_TYPE_ISO_IEC_13818_6_TYPE_D: ccx_stream_type = 13;
pub const ccx_stream_type_CCX_STREAM_TYPE_AUDIO_AAC: ccx_stream_type = 15;
pub const ccx_stream_type_CCX_STREAM_TYPE_VIDEO_MPEG4: ccx_stream_type = 16;
pub const ccx_stream_type_CCX_STREAM_TYPE_VIDEO_H264: ccx_stream_type = 27;
pub const ccx_stream_type_CCX_STREAM_TYPE_VIDEO_HEVC: ccx_stream_type = 36;
pub const ccx_stream_type_CCX_STREAM_TYPE_PRIVATE_USER_MPEG2: ccx_stream_type = 128;
pub const ccx_stream_type_CCX_STREAM_TYPE_AUDIO_AC3: ccx_stream_type = 129;
pub const ccx_stream_type_CCX_STREAM_TYPE_AUDIO_HDMV_DTS: ccx_stream_type = 130;
pub const ccx_stream_type_CCX_STREAM_TYPE_AUDIO_DTS: ccx_stream_type = 138;
pub type ccx_stream_type = ::std::os::raw::c_uint;
pub const ccx_datasource_CCX_DS_FILE: ccx_datasource = 0;
pub const ccx_datasource_CCX_DS_STDIN: ccx_datasource = 1;
pub const ccx_datasource_CCX_DS_NETWORK: ccx_datasource = 2;
pub const ccx_datasource_CCX_DS_TCP: ccx_datasource = 3;
pub type ccx_datasource = ::std::os::raw::c_uint;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ccx_output_format {
    CCX_OF_RAW = 0,
    CCX_OF_SRT = 1,
    CCX_OF_SAMI = 2,
    CCX_OF_TRANSCRIPT = 3,
    CCX_OF_RCWT = 4,
    CCX_OF_NULL = 5,
    CCX_OF_SMPTETT = 6,
    CCX_OF_SPUPNG = 7,
    CCX_OF_DVDRAW = 8,
    CCX_OF_WEBVTT = 9,
    CCX_OF_SIMPLE_XML = 10,
    CCX_OF_G608 = 11,
    CCX_OF_CURL = 12,
    CCX_OF_SSA = 13,
    CCX_OF_MCC = 14,
    CCX_OF_SCC = 15,
    CCX_OF_CCD = 16,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ccx_output_date_format {
    ODF_NONE = 0,
    ODF_HHMMSS = 1,
    ODF_SECONDS = 2,
    ODF_DATE = 3,
    ODF_HHMMSSMS = 4,
}
pub const ccx_stream_mode_enum_CCX_SM_ELEMENTARY_OR_NOT_FOUND: ccx_stream_mode_enum = 0;
pub const ccx_stream_mode_enum_CCX_SM_TRANSPORT: ccx_stream_mode_enum = 1;
pub const ccx_stream_mode_enum_CCX_SM_PROGRAM: ccx_stream_mode_enum = 2;
pub const ccx_stream_mode_enum_CCX_SM_ASF: ccx_stream_mode_enum = 3;
pub const ccx_stream_mode_enum_CCX_SM_MCPOODLESRAW: ccx_stream_mode_enum = 4;
pub const ccx_stream_mode_enum_CCX_SM_RCWT: ccx_stream_mode_enum = 5;
pub const ccx_stream_mode_enum_CCX_SM_MYTH: ccx_stream_mode_enum = 6;
pub const ccx_stream_mode_enum_CCX_SM_MP4: ccx_stream_mode_enum = 7;
pub const ccx_stream_mode_enum_CCX_SM_WTV: ccx_stream_mode_enum = 9;
pub const ccx_stream_mode_enum_CCX_SM_GXF: ccx_stream_mode_enum = 11;
pub const ccx_stream_mode_enum_CCX_SM_MKV: ccx_stream_mode_enum = 12;
pub const ccx_stream_mode_enum_CCX_SM_MXF: ccx_stream_mode_enum = 13;
pub const ccx_stream_mode_enum_CCX_SM_SCC: ccx_stream_mode_enum = 14;
pub const ccx_stream_mode_enum_CCX_SM_AUTODETECT: ccx_stream_mode_enum = 16;
pub type ccx_stream_mode_enum = ::std::os::raw::c_uint;
pub const ccx_encoding_type_CCX_ENC_UNICODE: ccx_encoding_type = 0;
pub const ccx_encoding_type_CCX_ENC_LATIN_1: ccx_encoding_type = 1;
pub const ccx_encoding_type_CCX_ENC_UTF_8: ccx_encoding_type = 2;
pub const ccx_encoding_type_CCX_ENC_ASCII: ccx_encoding_type = 3;
pub type ccx_encoding_type = ::std::os::raw::c_uint;
pub const ccx_bufferdata_type_CCX_UNKNOWN: ccx_bufferdata_type = 0;
pub const ccx_bufferdata_type_CCX_PES: ccx_bufferdata_type = 1;
pub const ccx_bufferdata_type_CCX_RAW: ccx_bufferdata_type = 2;
pub const ccx_bufferdata_type_CCX_H264: ccx_bufferdata_type = 3;
pub const ccx_bufferdata_type_CCX_HAUPPAGE: ccx_bufferdata_type = 4;
pub const ccx_bufferdata_type_CCX_TELETEXT: ccx_bufferdata_type = 5;
pub const ccx_bufferdata_type_CCX_PRIVATE_MPEG2_CC: ccx_bufferdata_type = 6;
pub const ccx_bufferdata_type_CCX_DVB_SUBTITLE: ccx_bufferdata_type = 7;
pub const ccx_bufferdata_type_CCX_ISDB_SUBTITLE: ccx_bufferdata_type = 8;
pub const ccx_bufferdata_type_CCX_RAW_TYPE: ccx_bufferdata_type = 9;
pub const ccx_bufferdata_type_CCX_DVD_SUBTITLE: ccx_bufferdata_type = 10;
pub const ccx_bufferdata_type_CCX_HEVC: ccx_bufferdata_type = 11;
pub type ccx_bufferdata_type = ::std::os::raw::c_uint;
pub const ccx_frame_type_CCX_FRAME_TYPE_RESET_OR_UNKNOWN: ccx_frame_type = 0;
pub const ccx_frame_type_CCX_FRAME_TYPE_I_FRAME: ccx_frame_type = 1;
pub const ccx_frame_type_CCX_FRAME_TYPE_P_FRAME: ccx_frame_type = 2;
pub const ccx_frame_type_CCX_FRAME_TYPE_B_FRAME: ccx_frame_type = 3;
pub const ccx_frame_type_CCX_FRAME_TYPE_D_FRAME: ccx_frame_type = 4;
pub type ccx_frame_type = ::std::os::raw::c_uint;
pub const ccx_code_type_CCX_CODEC_ANY: ccx_code_type = 0;
pub const ccx_code_type_CCX_CODEC_TELETEXT: ccx_code_type = 1;
pub const ccx_code_type_CCX_CODEC_DVB: ccx_code_type = 2;
pub const ccx_code_type_CCX_CODEC_ISDB_CC: ccx_code_type = 3;
pub const ccx_code_type_CCX_CODEC_ATSC_CC: ccx_code_type = 4;
pub const ccx_code_type_CCX_CODEC_NONE: ccx_code_type = 5;
pub type ccx_code_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct gop_time_code {
    pub drop_frame_flag: ::std::os::raw::c_int,
    pub time_code_hours: ::std::os::raw::c_int,
    pub time_code_minutes: ::std::os::raw::c_int,
    pub marker_bit: ::std::os::raw::c_int,
    pub time_code_seconds: ::std::os::raw::c_int,
    pub time_code_pictures: ::std::os::raw::c_int,
    pub inited: ::std::os::raw::c_int,
    pub ms: LLONG,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of gop_time_code"][::std::mem::size_of::<gop_time_code>() - 40usize];
    ["Alignment of gop_time_code"][::std::mem::align_of::<gop_time_code>() - 8usize];
    ["Offset of field: gop_time_code::drop_frame_flag"]
        [::std::mem::offset_of!(gop_time_code, drop_frame_flag) - 0usize];
    ["Offset of field: gop_time_code::time_code_hours"]
        [::std::mem::offset_of!(gop_time_code, time_code_hours) - 4usize];
    ["Offset of field: gop_time_code::time_code_minutes"]
        [::std::mem::offset_of!(gop_time_code, time_code_minutes) - 8usize];
    ["Offset of field: gop_time_code::marker_bit"]
        [::std::mem::offset_of!(gop_time_code, marker_bit) - 12usize];
    ["Offset of field: gop_time_code::time_code_seconds"]
        [::std::mem::offset_of!(gop_time_code, time_code_seconds) - 16usize];
    ["Offset of field: gop_time_code::time_code_pictures"]
        [::std::mem::offset_of!(gop_time_code, time_code_pictures) - 20usize];
    ["Offset of field: gop_time_code::inited"]
        [::std::mem::offset_of!(gop_time_code, inited) - 24usize];
    ["Offset of field: gop_time_code::ms"][::std::mem::offset_of!(gop_time_code, ms) - 32usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ccx_common_timing_settings_t {
    pub disable_sync_check: ::std::os::raw::c_int,
    pub no_sync: ::std::os::raw::c_int,
    pub is_elementary_stream: ::std::os::raw::c_int,
    pub file_position: *mut LLONG,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_common_timing_settings_t"]
        [::std::mem::size_of::<ccx_common_timing_settings_t>() - 24usize];
    ["Alignment of ccx_common_timing_settings_t"]
        [::std::mem::align_of::<ccx_common_timing_settings_t>() - 8usize];
    ["Offset of field: ccx_common_timing_settings_t::disable_sync_check"]
        [::std::mem::offset_of!(ccx_common_timing_settings_t, disable_sync_check) - 0usize];
    ["Offset of field: ccx_common_timing_settings_t::no_sync"]
        [::std::mem::offset_of!(ccx_common_timing_settings_t, no_sync) - 4usize];
    ["Offset of field: ccx_common_timing_settings_t::is_elementary_stream"]
        [::std::mem::offset_of!(ccx_common_timing_settings_t, is_elementary_stream) - 8usize];
    ["Offset of field: ccx_common_timing_settings_t::file_position"]
        [::std::mem::offset_of!(ccx_common_timing_settings_t, file_position) - 16usize];
};
impl Default for ccx_common_timing_settings_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ccx_boundary_time {
    pub hh: ::std::os::raw::c_int,
    pub mm: ::std::os::raw::c_int,
    pub ss: ::std::os::raw::c_int,
    pub time_in_ms: LLONG,
    pub set: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_boundary_time"][::std::mem::size_of::<ccx_boundary_time>() - 32usize];
    ["Alignment of ccx_boundary_time"][::std::mem::align_of::<ccx_boundary_time>() - 8usize];
    ["Offset of field: ccx_boundary_time::hh"]
        [::std::mem::offset_of!(ccx_boundary_time, hh) - 0usize];
    ["Offset of field: ccx_boundary_time::mm"]
        [::std::mem::offset_of!(ccx_boundary_time, mm) - 4usize];
    ["Offset of field: ccx_boundary_time::ss"]
        [::std::mem::offset_of!(ccx_boundary_time, ss) - 8usize];
    ["Offset of field: ccx_boundary_time::time_in_ms"]
        [::std::mem::offset_of!(ccx_boundary_time, time_in_ms) - 16usize];
    ["Offset of field: ccx_boundary_time::set"]
        [::std::mem::offset_of!(ccx_boundary_time, set) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ccx_common_timing_ctx {
    pub pts_set: ::std::os::raw::c_int,
    pub min_pts_adjusted: ::std::os::raw::c_int,
    pub seen_known_frame_type: ::std::os::raw::c_int,
    pub pending_min_pts: LLONG,
    pub unknown_frame_count: ::std::os::raw::c_uint,
    pub current_pts: LLONG,
    pub current_picture_coding_type: ccx_frame_type,
    pub current_tref: ::std::os::raw::c_int,
    pub min_pts: LLONG,
    pub max_pts: LLONG,
    pub sync_pts: LLONG,
    pub minimum_fts: LLONG,
    pub fts_now: LLONG,
    pub fts_offset: LLONG,
    pub fts_fc_offset: LLONG,
    pub fts_max: LLONG,
    pub fts_global: LLONG,
    pub sync_pts2fts_set: ::std::os::raw::c_int,
    pub sync_pts2fts_fts: LLONG,
    pub sync_pts2fts_pts: LLONG,
    pub pts_reset: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_common_timing_ctx"][::std::mem::size_of::<ccx_common_timing_ctx>() - 152usize];
    ["Alignment of ccx_common_timing_ctx"]
        [::std::mem::align_of::<ccx_common_timing_ctx>() - 8usize];
    ["Offset of field: ccx_common_timing_ctx::pts_set"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, pts_set) - 0usize];
    ["Offset of field: ccx_common_timing_ctx::min_pts_adjusted"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, min_pts_adjusted) - 4usize];
    ["Offset of field: ccx_common_timing_ctx::seen_known_frame_type"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, seen_known_frame_type) - 8usize];
    ["Offset of field: ccx_common_timing_ctx::pending_min_pts"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, pending_min_pts) - 16usize];
    ["Offset of field: ccx_common_timing_ctx::unknown_frame_count"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, unknown_frame_count) - 24usize];
    ["Offset of field: ccx_common_timing_ctx::current_pts"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, current_pts) - 32usize];
    ["Offset of field: ccx_common_timing_ctx::current_picture_coding_type"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, current_picture_coding_type) - 40usize];
    ["Offset of field: ccx_common_timing_ctx::current_tref"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, current_tref) - 44usize];
    ["Offset of field: ccx_common_timing_ctx::min_pts"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, min_pts) - 48usize];
    ["Offset of field: ccx_common_timing_ctx::max_pts"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, max_pts) - 56usize];
    ["Offset of field: ccx_common_timing_ctx::sync_pts"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, sync_pts) - 64usize];
    ["Offset of field: ccx_common_timing_ctx::minimum_fts"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, minimum_fts) - 72usize];
    ["Offset of field: ccx_common_timing_ctx::fts_now"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, fts_now) - 80usize];
    ["Offset of field: ccx_common_timing_ctx::fts_offset"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, fts_offset) - 88usize];
    ["Offset of field: ccx_common_timing_ctx::fts_fc_offset"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, fts_fc_offset) - 96usize];
    ["Offset of field: ccx_common_timing_ctx::fts_max"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, fts_max) - 104usize];
    ["Offset of field: ccx_common_timing_ctx::fts_global"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, fts_global) - 112usize];
    ["Offset of field: ccx_common_timing_ctx::sync_pts2fts_set"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, sync_pts2fts_set) - 120usize];
    ["Offset of field: ccx_common_timing_ctx::sync_pts2fts_fts"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, sync_pts2fts_fts) - 128usize];
    ["Offset of field: ccx_common_timing_ctx::sync_pts2fts_pts"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, sync_pts2fts_pts) - 136usize];
    ["Offset of field: ccx_common_timing_ctx::pts_reset"]
        [::std::mem::offset_of!(ccx_common_timing_ctx, pts_reset) - 144usize];
};
impl Default for ccx_common_timing_ctx {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn get_fts(ctx: *mut ccx_common_timing_ctx, current_field: ::std::os::raw::c_int) -> LLONG;
}
pub const subdatatype_CC_DATATYPE_GENERIC: subdatatype = 0;
pub const subdatatype_CC_DATATYPE_DVB: subdatatype = 1;
pub type subdatatype = ::std::os::raw::c_uint;
pub const subtype_CC_BITMAP: subtype = 0;
pub const subtype_CC_608: subtype = 1;
pub const subtype_CC_TEXT: subtype = 2;
pub const subtype_CC_RAW: subtype = 3;
pub type subtype = ::std::os::raw::c_uint;
#[doc = " Raw Subtitle struct used as output of decoder (cc608)\n and input for encoder (sami, srt, transcript or smptett etc)\n\n if subtype CC_BITMAP then data contain nb_data numbers of rectangle\n which have to be displayed at same time."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cc_subtitle {
    #[doc = " A generic data which contain data according to decoder\n @warn decoder cant output multiple types of data"]
    pub data: *mut ::std::os::raw::c_void,
    pub datatype: subdatatype,
    #[doc = " number of data"]
    pub nb_data: ::std::os::raw::c_uint,
    #[doc = "  type of subtitle"]
    pub type_: subtype,
    #[doc = " Encoding type of Text, must be ignored in case of subtype as bitmap or cc_screen"]
    pub enc_type: ccx_encoding_type,
    pub start_time: LLONG,
    pub end_time: LLONG,
    pub flags: ::std::os::raw::c_int,
    pub lang_index: ::std::os::raw::c_int,
    #[doc = " flag to tell that decoder has given output"]
    pub got_output: ::std::os::raw::c_int,
    pub mode: [::std::os::raw::c_char; 5usize],
    pub info: [::std::os::raw::c_char; 4usize],
    #[doc = " Used for DVB end time in ms"]
    pub time_out: ::std::os::raw::c_int,
    #[doc = " Raw PTS value when this subtitle started (for DVB timing)"]
    pub start_pts: LLONG,
    #[doc = " Teletext page number (for multi-page extraction, issue #665)"]
    pub teletext_page: u16,
    pub next: *mut cc_subtitle,
    pub prev: *mut cc_subtitle,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of cc_subtitle"][::std::mem::size_of::<cc_subtitle>() - 104usize];
    ["Alignment of cc_subtitle"][::std::mem::align_of::<cc_subtitle>() - 8usize];
    ["Offset of field: cc_subtitle::data"][::std::mem::offset_of!(cc_subtitle, data) - 0usize];
    ["Offset of field: cc_subtitle::datatype"]
        [::std::mem::offset_of!(cc_subtitle, datatype) - 8usize];
    ["Offset of field: cc_subtitle::nb_data"]
        [::std::mem::offset_of!(cc_subtitle, nb_data) - 12usize];
    ["Offset of field: cc_subtitle::type_"][::std::mem::offset_of!(cc_subtitle, type_) - 16usize];
    ["Offset of field: cc_subtitle::enc_type"]
        [::std::mem::offset_of!(cc_subtitle, enc_type) - 20usize];
    ["Offset of field: cc_subtitle::start_time"]
        [::std::mem::offset_of!(cc_subtitle, start_time) - 24usize];
    ["Offset of field: cc_subtitle::end_time"]
        [::std::mem::offset_of!(cc_subtitle, end_time) - 32usize];
    ["Offset of field: cc_subtitle::flags"][::std::mem::offset_of!(cc_subtitle, flags) - 40usize];
    ["Offset of field: cc_subtitle::lang_index"]
        [::std::mem::offset_of!(cc_subtitle, lang_index) - 44usize];
    ["Offset of field: cc_subtitle::got_output"]
        [::std::mem::offset_of!(cc_subtitle, got_output) - 48usize];
    ["Offset of field: cc_subtitle::mode"][::std::mem::offset_of!(cc_subtitle, mode) - 52usize];
    ["Offset of field: cc_subtitle::info"][::std::mem::offset_of!(cc_subtitle, info) - 57usize];
    ["Offset of field: cc_subtitle::time_out"]
        [::std::mem::offset_of!(cc_subtitle, time_out) - 64usize];
    ["Offset of field: cc_subtitle::start_pts"]
        [::std::mem::offset_of!(cc_subtitle, start_pts) - 72usize];
    ["Offset of field: cc_subtitle::teletext_page"]
        [::std::mem::offset_of!(cc_subtitle, teletext_page) - 80usize];
    ["Offset of field: cc_subtitle::next"][::std::mem::offset_of!(cc_subtitle, next) - 88usize];
    ["Offset of field: cc_subtitle::prev"][::std::mem::offset_of!(cc_subtitle, prev) - 96usize];
};
impl Default for cc_subtitle {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " Simple doubly linked list implementation.\n\n Some of the internal functions (\"__xxx\") are useful when\n manipulating whole lists rather than single entries, as\n sometimes we already know the next/prev entries and we can\n generate better code by using them directly rather than\n using the generic single-entry routines."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct list_head {
    pub next: *mut list_head,
    pub prev: *mut list_head,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of list_head"][::std::mem::size_of::<list_head>() - 16usize];
    ["Alignment of list_head"][::std::mem::align_of::<list_head>() - 8usize];
    ["Offset of field: list_head::next"][::std::mem::offset_of!(list_head, next) - 0usize];
    ["Offset of field: list_head::prev"][::std::mem::offset_of!(list_head, prev) - 8usize];
};
impl Default for list_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const DTVCC_COMMANDS_C0_CODES_DTVCC_C0_NUL: DTVCC_COMMANDS_C0_CODES = 0;
pub const DTVCC_COMMANDS_C0_CODES_DTVCC_C0_ETX: DTVCC_COMMANDS_C0_CODES = 3;
pub const DTVCC_COMMANDS_C0_CODES_DTVCC_C0_BS: DTVCC_COMMANDS_C0_CODES = 8;
pub const DTVCC_COMMANDS_C0_CODES_DTVCC_C0_FF: DTVCC_COMMANDS_C0_CODES = 12;
pub const DTVCC_COMMANDS_C0_CODES_DTVCC_C0_CR: DTVCC_COMMANDS_C0_CODES = 13;
pub const DTVCC_COMMANDS_C0_CODES_DTVCC_C0_HCR: DTVCC_COMMANDS_C0_CODES = 14;
pub const DTVCC_COMMANDS_C0_CODES_DTVCC_C0_EXT1: DTVCC_COMMANDS_C0_CODES = 16;
pub const DTVCC_COMMANDS_C0_CODES_DTVCC_C0_P16: DTVCC_COMMANDS_C0_CODES = 24;
pub type DTVCC_COMMANDS_C0_CODES = ::std::os::raw::c_uint;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_CW0: DTVCC_COMMANDS_C1_CODES = 128;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_CW1: DTVCC_COMMANDS_C1_CODES = 129;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_CW2: DTVCC_COMMANDS_C1_CODES = 130;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_CW3: DTVCC_COMMANDS_C1_CODES = 131;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_CW4: DTVCC_COMMANDS_C1_CODES = 132;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_CW5: DTVCC_COMMANDS_C1_CODES = 133;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_CW6: DTVCC_COMMANDS_C1_CODES = 134;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_CW7: DTVCC_COMMANDS_C1_CODES = 135;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_CLW: DTVCC_COMMANDS_C1_CODES = 136;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_DSW: DTVCC_COMMANDS_C1_CODES = 137;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_HDW: DTVCC_COMMANDS_C1_CODES = 138;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_TGW: DTVCC_COMMANDS_C1_CODES = 139;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_DLW: DTVCC_COMMANDS_C1_CODES = 140;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_DLY: DTVCC_COMMANDS_C1_CODES = 141;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_DLC: DTVCC_COMMANDS_C1_CODES = 142;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_RST: DTVCC_COMMANDS_C1_CODES = 143;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_SPA: DTVCC_COMMANDS_C1_CODES = 144;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_SPC: DTVCC_COMMANDS_C1_CODES = 145;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_SPL: DTVCC_COMMANDS_C1_CODES = 146;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_RSV93: DTVCC_COMMANDS_C1_CODES = 147;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_RSV94: DTVCC_COMMANDS_C1_CODES = 148;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_RSV95: DTVCC_COMMANDS_C1_CODES = 149;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_RSV96: DTVCC_COMMANDS_C1_CODES = 150;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_SWA: DTVCC_COMMANDS_C1_CODES = 151;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_DF0: DTVCC_COMMANDS_C1_CODES = 152;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_DF1: DTVCC_COMMANDS_C1_CODES = 153;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_DF2: DTVCC_COMMANDS_C1_CODES = 154;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_DF3: DTVCC_COMMANDS_C1_CODES = 155;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_DF4: DTVCC_COMMANDS_C1_CODES = 156;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_DF5: DTVCC_COMMANDS_C1_CODES = 157;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_DF6: DTVCC_COMMANDS_C1_CODES = 158;
pub const DTVCC_COMMANDS_C1_CODES_DTVCC_C1_DF7: DTVCC_COMMANDS_C1_CODES = 159;
pub type DTVCC_COMMANDS_C1_CODES = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DTVCC_S_COMMANDS_C1 {
    pub code: ::std::os::raw::c_int,
    pub name: *const ::std::os::raw::c_char,
    pub description: *const ::std::os::raw::c_char,
    pub length: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of DTVCC_S_COMMANDS_C1"][::std::mem::size_of::<DTVCC_S_COMMANDS_C1>() - 32usize];
    ["Alignment of DTVCC_S_COMMANDS_C1"][::std::mem::align_of::<DTVCC_S_COMMANDS_C1>() - 8usize];
    ["Offset of field: DTVCC_S_COMMANDS_C1::code"]
        [::std::mem::offset_of!(DTVCC_S_COMMANDS_C1, code) - 0usize];
    ["Offset of field: DTVCC_S_COMMANDS_C1::name"]
        [::std::mem::offset_of!(DTVCC_S_COMMANDS_C1, name) - 8usize];
    ["Offset of field: DTVCC_S_COMMANDS_C1::description"]
        [::std::mem::offset_of!(DTVCC_S_COMMANDS_C1, description) - 16usize];
    ["Offset of field: DTVCC_S_COMMANDS_C1::length"]
        [::std::mem::offset_of!(DTVCC_S_COMMANDS_C1, length) - 24usize];
};
impl Default for DTVCC_S_COMMANDS_C1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum dtvcc_window_justify {
    DTVCC_WINDOW_JUSTIFY_LEFT = 0,
    DTVCC_WINDOW_JUSTIFY_RIGHT = 1,
    DTVCC_WINDOW_JUSTIFY_CENTER = 2,
    DTVCC_WINDOW_JUSTIFY_FULL = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum dtvcc_window_pd {
    DTVCC_WINDOW_PD_LEFT_RIGHT = 0,
    DTVCC_WINDOW_PD_RIGHT_LEFT = 1,
    DTVCC_WINDOW_PD_TOP_BOTTOM = 2,
    DTVCC_WINDOW_PD_BOTTOM_TOP = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum dtvcc_window_sd {
    DTVCC_WINDOW_SD_LEFT_RIGHT = 0,
    DTVCC_WINDOW_SD_RIGHT_LEFT = 1,
    DTVCC_WINDOW_SD_TOP_BOTTOM = 2,
    DTVCC_WINDOW_SD_BOTTOM_TOP = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum dtvcc_window_sde {
    DTVCC_WINDOW_SDE_SNAP = 0,
    DTVCC_WINDOW_SDE_FADE = 1,
    DTVCC_WINDOW_SDE_WIPE = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum dtvcc_window_ed {
    DTVCC_WINDOW_ED_LEFT_RIGHT = 0,
    DTVCC_WINDOW_ED_RIGHT_LEFT = 1,
    DTVCC_WINDOW_ED_TOP_BOTTOM = 2,
    DTVCC_WINDOW_ED_BOTTOM_TOP = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum dtvcc_window_fo {
    DTVCC_WINDOW_FO_SOLID = 0,
    DTVCC_WINDOW_FO_FLASH = 1,
    DTVCC_WINDOW_FO_TRANSLUCENT = 2,
    DTVCC_WINDOW_FO_TRANSPARENT = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum dtvcc_window_border {
    DTVCC_WINDOW_BORDER_NONE = 0,
    DTVCC_WINDOW_BORDER_RAISED = 1,
    DTVCC_WINDOW_BORDER_DEPRESSED = 2,
    DTVCC_WINDOW_BORDER_UNIFORM = 3,
    DTVCC_WINDOW_BORDER_SHADOW_LEFT = 4,
    DTVCC_WINDOW_BORDER_SHADOW_RIGHT = 5,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum dtvcc_pen_size {
    DTVCC_PEN_SIZE_SMALL = 0,
    DTVCC_PEN_SIZE_STANDART = 1,
    DTVCC_PEN_SIZE_LARGE = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum dtvcc_pen_font_style {
    DTVCC_PEN_FONT_STYLE_DEFAULT_OR_UNDEFINED = 0,
    DTVCC_PEN_FONT_STYLE_MONOSPACED_WITH_SERIFS = 1,
    DTVCC_PEN_FONT_STYLE_PROPORTIONALLY_SPACED_WITH_SERIFS = 2,
    DTVCC_PEN_FONT_STYLE_MONOSPACED_WITHOUT_SERIFS = 3,
    DTVCC_PEN_FONT_STYLE_PROPORTIONALLY_SPACED_WITHOUT_SERIFS = 4,
    DTVCC_PEN_FONT_STYLE_CASUAL_FONT_TYPE = 5,
    DTVCC_PEN_FONT_STYLE_CURSIVE_FONT_TYPE = 6,
    DTVCC_PEN_FONT_STYLE_SMALL_CAPITALS = 7,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum dtvcc_pen_text_tag {
    DTVCC_PEN_TEXT_TAG_DIALOG = 0,
    DTVCC_PEN_TEXT_TAG_SOURCE_OR_SPEAKER_ID = 1,
    DTVCC_PEN_TEXT_TAG_ELECTRONIC_VOICE = 2,
    DTVCC_PEN_TEXT_TAG_FOREIGN_LANGUAGE = 3,
    DTVCC_PEN_TEXT_TAG_VOICEOVER = 4,
    DTVCC_PEN_TEXT_TAG_AUDIBLE_TRANSLATION = 5,
    DTVCC_PEN_TEXT_TAG_SUBTITLE_TRANSLATION = 6,
    DTVCC_PEN_TEXT_TAG_VOICE_QUALITY_DESCRIPTION = 7,
    DTVCC_PEN_TEXT_TAG_SONG_LYRICS = 8,
    DTVCC_PEN_TEXT_TAG_SOUND_EFFECT_DESCRIPTION = 9,
    DTVCC_PEN_TEXT_TAG_MUSICAL_SCORE_DESCRIPTION = 10,
    DTVCC_PEN_TEXT_TAG_EXPLETIVE = 11,
    DTVCC_PEN_TEXT_TAG_UNDEFINED_12 = 12,
    DTVCC_PEN_TEXT_TAG_UNDEFINED_13 = 13,
    DTVCC_PEN_TEXT_TAG_UNDEFINED_14 = 14,
    DTVCC_PEN_TEXT_TAG_NOT_TO_BE_DISPLAYED = 15,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum dtvcc_pen_offset {
    DTVCC_PEN_OFFSET_SUBSCRIPT = 0,
    DTVCC_PEN_OFFSET_NORMAL = 1,
    DTVCC_PEN_OFFSET_SUPERSCRIPT = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum dtvcc_pen_edge {
    DTVCC_PEN_EDGE_NONE = 0,
    DTVCC_PEN_EDGE_RAISED = 1,
    DTVCC_PEN_EDGE_DEPRESSED = 2,
    DTVCC_PEN_EDGE_UNIFORM = 3,
    DTVCC_PEN_EDGE_LEFT_DROP_SHADOW = 4,
    DTVCC_PEN_EDGE_RIGHT_DROP_SHADOW = 5,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum dtvcc_pen_anchor_point {
    DTVCC_ANCHOR_POINT_TOP_LEFT = 0,
    DTVCC_ANCHOR_POINT_TOP_CENTER = 1,
    DTVCC_ANCHOR_POINT_TOP_RIGHT = 2,
    DTVCC_ANCHOR_POINT_MIDDLE_LEFT = 3,
    DTVCC_ANCHOR_POINT_MIDDLE_CENTER = 4,
    DTVCC_ANCHOR_POINT_MIDDLE_RIGHT = 5,
    DTVCC_ANCHOR_POINT_BOTTOM_LEFT = 6,
    DTVCC_ANCHOR_POINT_BOTTOM_CENTER = 7,
    DTVCC_ANCHOR_POINT_BOTTOM_RIGHT = 8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dtvcc_pen_color {
    pub fg_color: ::std::os::raw::c_int,
    pub fg_opacity: ::std::os::raw::c_int,
    pub bg_color: ::std::os::raw::c_int,
    pub bg_opacity: ::std::os::raw::c_int,
    pub edge_color: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dtvcc_pen_color"][::std::mem::size_of::<dtvcc_pen_color>() - 20usize];
    ["Alignment of dtvcc_pen_color"][::std::mem::align_of::<dtvcc_pen_color>() - 4usize];
    ["Offset of field: dtvcc_pen_color::fg_color"]
        [::std::mem::offset_of!(dtvcc_pen_color, fg_color) - 0usize];
    ["Offset of field: dtvcc_pen_color::fg_opacity"]
        [::std::mem::offset_of!(dtvcc_pen_color, fg_opacity) - 4usize];
    ["Offset of field: dtvcc_pen_color::bg_color"]
        [::std::mem::offset_of!(dtvcc_pen_color, bg_color) - 8usize];
    ["Offset of field: dtvcc_pen_color::bg_opacity"]
        [::std::mem::offset_of!(dtvcc_pen_color, bg_opacity) - 12usize];
    ["Offset of field: dtvcc_pen_color::edge_color"]
        [::std::mem::offset_of!(dtvcc_pen_color, edge_color) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dtvcc_pen_attribs {
    pub pen_size: ::std::os::raw::c_int,
    pub offset: ::std::os::raw::c_int,
    pub text_tag: ::std::os::raw::c_int,
    pub font_tag: ::std::os::raw::c_int,
    pub edge_type: ::std::os::raw::c_int,
    pub underline: ::std::os::raw::c_int,
    pub italic: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dtvcc_pen_attribs"][::std::mem::size_of::<dtvcc_pen_attribs>() - 28usize];
    ["Alignment of dtvcc_pen_attribs"][::std::mem::align_of::<dtvcc_pen_attribs>() - 4usize];
    ["Offset of field: dtvcc_pen_attribs::pen_size"]
        [::std::mem::offset_of!(dtvcc_pen_attribs, pen_size) - 0usize];
    ["Offset of field: dtvcc_pen_attribs::offset"]
        [::std::mem::offset_of!(dtvcc_pen_attribs, offset) - 4usize];
    ["Offset of field: dtvcc_pen_attribs::text_tag"]
        [::std::mem::offset_of!(dtvcc_pen_attribs, text_tag) - 8usize];
    ["Offset of field: dtvcc_pen_attribs::font_tag"]
        [::std::mem::offset_of!(dtvcc_pen_attribs, font_tag) - 12usize];
    ["Offset of field: dtvcc_pen_attribs::edge_type"]
        [::std::mem::offset_of!(dtvcc_pen_attribs, edge_type) - 16usize];
    ["Offset of field: dtvcc_pen_attribs::underline"]
        [::std::mem::offset_of!(dtvcc_pen_attribs, underline) - 20usize];
    ["Offset of field: dtvcc_pen_attribs::italic"]
        [::std::mem::offset_of!(dtvcc_pen_attribs, italic) - 24usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct dtvcc_window_attribs {
    pub justify: ::std::os::raw::c_int,
    pub print_direction: ::std::os::raw::c_int,
    pub scroll_direction: ::std::os::raw::c_int,
    pub word_wrap: ::std::os::raw::c_int,
    pub display_effect: ::std::os::raw::c_int,
    pub effect_direction: ::std::os::raw::c_int,
    pub effect_speed: ::std::os::raw::c_int,
    pub fill_color: ::std::os::raw::c_int,
    pub fill_opacity: ::std::os::raw::c_int,
    pub border_type: ::std::os::raw::c_int,
    pub border_color: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dtvcc_window_attribs"][::std::mem::size_of::<dtvcc_window_attribs>() - 44usize];
    ["Alignment of dtvcc_window_attribs"][::std::mem::align_of::<dtvcc_window_attribs>() - 4usize];
    ["Offset of field: dtvcc_window_attribs::justify"]
        [::std::mem::offset_of!(dtvcc_window_attribs, justify) - 0usize];
    ["Offset of field: dtvcc_window_attribs::print_direction"]
        [::std::mem::offset_of!(dtvcc_window_attribs, print_direction) - 4usize];
    ["Offset of field: dtvcc_window_attribs::scroll_direction"]
        [::std::mem::offset_of!(dtvcc_window_attribs, scroll_direction) - 8usize];
    ["Offset of field: dtvcc_window_attribs::word_wrap"]
        [::std::mem::offset_of!(dtvcc_window_attribs, word_wrap) - 12usize];
    ["Offset of field: dtvcc_window_attribs::display_effect"]
        [::std::mem::offset_of!(dtvcc_window_attribs, display_effect) - 16usize];
    ["Offset of field: dtvcc_window_attribs::effect_direction"]
        [::std::mem::offset_of!(dtvcc_window_attribs, effect_direction) - 20usize];
    ["Offset of field: dtvcc_window_attribs::effect_speed"]
        [::std::mem::offset_of!(dtvcc_window_attribs, effect_speed) - 24usize];
    ["Offset of field: dtvcc_window_attribs::fill_color"]
        [::std::mem::offset_of!(dtvcc_window_attribs, fill_color) - 28usize];
    ["Offset of field: dtvcc_window_attribs::fill_opacity"]
        [::std::mem::offset_of!(dtvcc_window_attribs, fill_opacity) - 32usize];
    ["Offset of field: dtvcc_window_attribs::border_type"]
        [::std::mem::offset_of!(dtvcc_window_attribs, border_type) - 36usize];
    ["Offset of field: dtvcc_window_attribs::border_color"]
        [::std::mem::offset_of!(dtvcc_window_attribs, border_color) - 40usize];
};
#[doc = " Since 1-byte and 2-byte symbols could appear in captions and\n since we have to keep symbols alignment and several windows could appear on a screen at one time,\n we use special structure for holding symbols"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dtvcc_symbol {
    pub sym: ::std::os::raw::c_ushort,
    pub init: ::std::os::raw::c_uchar,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dtvcc_symbol"][::std::mem::size_of::<dtvcc_symbol>() - 4usize];
    ["Alignment of dtvcc_symbol"][::std::mem::align_of::<dtvcc_symbol>() - 2usize];
    ["Offset of field: dtvcc_symbol::sym"][::std::mem::offset_of!(dtvcc_symbol, sym) - 0usize];
    ["Offset of field: dtvcc_symbol::init"][::std::mem::offset_of!(dtvcc_symbol, init) - 2usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dtvcc_window {
    pub is_defined: ::std::os::raw::c_int,
    pub number: ::std::os::raw::c_int,
    pub priority: ::std::os::raw::c_int,
    pub col_lock: ::std::os::raw::c_int,
    pub row_lock: ::std::os::raw::c_int,
    pub visible: ::std::os::raw::c_int,
    pub anchor_vertical: ::std::os::raw::c_int,
    pub relative_pos: ::std::os::raw::c_int,
    pub anchor_horizontal: ::std::os::raw::c_int,
    pub row_count: ::std::os::raw::c_int,
    pub anchor_point: ::std::os::raw::c_int,
    pub col_count: ::std::os::raw::c_int,
    pub pen_style: ::std::os::raw::c_int,
    pub win_style: ::std::os::raw::c_int,
    pub commands: [::std::os::raw::c_uchar; 6usize],
    pub attribs: dtvcc_window_attribs,
    pub pen_row: ::std::os::raw::c_int,
    pub pen_column: ::std::os::raw::c_int,
    pub rows: [*mut dtvcc_symbol; 15usize],
    pub pen_colors: [[dtvcc_pen_color; 210usize]; 15usize],
    pub pen_attribs: [[dtvcc_pen_attribs; 210usize]; 15usize],
    pub pen_color_pattern: dtvcc_pen_color,
    pub pen_attribs_pattern: dtvcc_pen_attribs,
    pub memory_reserved: ::std::os::raw::c_int,
    pub is_empty: ::std::os::raw::c_int,
    pub time_ms_show: LLONG,
    pub time_ms_hide: LLONG,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dtvcc_window"][::std::mem::size_of::<dtvcc_window>() - 151512usize];
    ["Alignment of dtvcc_window"][::std::mem::align_of::<dtvcc_window>() - 8usize];
    ["Offset of field: dtvcc_window::is_defined"]
        [::std::mem::offset_of!(dtvcc_window, is_defined) - 0usize];
    ["Offset of field: dtvcc_window::number"]
        [::std::mem::offset_of!(dtvcc_window, number) - 4usize];
    ["Offset of field: dtvcc_window::priority"]
        [::std::mem::offset_of!(dtvcc_window, priority) - 8usize];
    ["Offset of field: dtvcc_window::col_lock"]
        [::std::mem::offset_of!(dtvcc_window, col_lock) - 12usize];
    ["Offset of field: dtvcc_window::row_lock"]
        [::std::mem::offset_of!(dtvcc_window, row_lock) - 16usize];
    ["Offset of field: dtvcc_window::visible"]
        [::std::mem::offset_of!(dtvcc_window, visible) - 20usize];
    ["Offset of field: dtvcc_window::anchor_vertical"]
        [::std::mem::offset_of!(dtvcc_window, anchor_vertical) - 24usize];
    ["Offset of field: dtvcc_window::relative_pos"]
        [::std::mem::offset_of!(dtvcc_window, relative_pos) - 28usize];
    ["Offset of field: dtvcc_window::anchor_horizontal"]
        [::std::mem::offset_of!(dtvcc_window, anchor_horizontal) - 32usize];
    ["Offset of field: dtvcc_window::row_count"]
        [::std::mem::offset_of!(dtvcc_window, row_count) - 36usize];
    ["Offset of field: dtvcc_window::anchor_point"]
        [::std::mem::offset_of!(dtvcc_window, anchor_point) - 40usize];
    ["Offset of field: dtvcc_window::col_count"]
        [::std::mem::offset_of!(dtvcc_window, col_count) - 44usize];
    ["Offset of field: dtvcc_window::pen_style"]
        [::std::mem::offset_of!(dtvcc_window, pen_style) - 48usize];
    ["Offset of field: dtvcc_window::win_style"]
        [::std::mem::offset_of!(dtvcc_window, win_style) - 52usize];
    ["Offset of field: dtvcc_window::commands"]
        [::std::mem::offset_of!(dtvcc_window, commands) - 56usize];
    ["Offset of field: dtvcc_window::attribs"]
        [::std::mem::offset_of!(dtvcc_window, attribs) - 64usize];
    ["Offset of field: dtvcc_window::pen_row"]
        [::std::mem::offset_of!(dtvcc_window, pen_row) - 108usize];
    ["Offset of field: dtvcc_window::pen_column"]
        [::std::mem::offset_of!(dtvcc_window, pen_column) - 112usize];
    ["Offset of field: dtvcc_window::rows"][::std::mem::offset_of!(dtvcc_window, rows) - 120usize];
    ["Offset of field: dtvcc_window::pen_colors"]
        [::std::mem::offset_of!(dtvcc_window, pen_colors) - 240usize];
    ["Offset of field: dtvcc_window::pen_attribs"]
        [::std::mem::offset_of!(dtvcc_window, pen_attribs) - 63240usize];
    ["Offset of field: dtvcc_window::pen_color_pattern"]
        [::std::mem::offset_of!(dtvcc_window, pen_color_pattern) - 151440usize];
    ["Offset of field: dtvcc_window::pen_attribs_pattern"]
        [::std::mem::offset_of!(dtvcc_window, pen_attribs_pattern) - 151460usize];
    ["Offset of field: dtvcc_window::memory_reserved"]
        [::std::mem::offset_of!(dtvcc_window, memory_reserved) - 151488usize];
    ["Offset of field: dtvcc_window::is_empty"]
        [::std::mem::offset_of!(dtvcc_window, is_empty) - 151492usize];
    ["Offset of field: dtvcc_window::time_ms_show"]
        [::std::mem::offset_of!(dtvcc_window, time_ms_show) - 151496usize];
    ["Offset of field: dtvcc_window::time_ms_hide"]
        [::std::mem::offset_of!(dtvcc_window, time_ms_hide) - 151504usize];
};
impl Default for dtvcc_window {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dtvcc_tv_screen {
    pub chars: [[dtvcc_symbol; 210usize]; 75usize],
    pub pen_colors: [[dtvcc_pen_color; 210usize]; 75usize],
    pub pen_attribs: [[dtvcc_pen_attribs; 210usize]; 75usize],
    pub time_ms_show: LLONG,
    pub time_ms_hide: LLONG,
    pub cc_count: ::std::os::raw::c_uint,
    pub service_number: ::std::os::raw::c_int,
    pub old_cc_time_end: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dtvcc_tv_screen"][::std::mem::size_of::<dtvcc_tv_screen>() - 819032usize];
    ["Alignment of dtvcc_tv_screen"][::std::mem::align_of::<dtvcc_tv_screen>() - 8usize];
    ["Offset of field: dtvcc_tv_screen::chars"]
        [::std::mem::offset_of!(dtvcc_tv_screen, chars) - 0usize];
    ["Offset of field: dtvcc_tv_screen::pen_colors"]
        [::std::mem::offset_of!(dtvcc_tv_screen, pen_colors) - 63000usize];
    ["Offset of field: dtvcc_tv_screen::pen_attribs"]
        [::std::mem::offset_of!(dtvcc_tv_screen, pen_attribs) - 378000usize];
    ["Offset of field: dtvcc_tv_screen::time_ms_show"]
        [::std::mem::offset_of!(dtvcc_tv_screen, time_ms_show) - 819000usize];
    ["Offset of field: dtvcc_tv_screen::time_ms_hide"]
        [::std::mem::offset_of!(dtvcc_tv_screen, time_ms_hide) - 819008usize];
    ["Offset of field: dtvcc_tv_screen::cc_count"]
        [::std::mem::offset_of!(dtvcc_tv_screen, cc_count) - 819016usize];
    ["Offset of field: dtvcc_tv_screen::service_number"]
        [::std::mem::offset_of!(dtvcc_tv_screen, service_number) - 819020usize];
    ["Offset of field: dtvcc_tv_screen::old_cc_time_end"]
        [::std::mem::offset_of!(dtvcc_tv_screen, old_cc_time_end) - 819024usize];
};
impl Default for dtvcc_tv_screen {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " Holds data on the CEA 708 services that are encountered during file parse\n This can be interesting, so CCExtractor uses it for the report functionality."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ccx_decoder_dtvcc_report {
    pub reset_count: ::std::os::raw::c_int,
    pub services: [::std::os::raw::c_uint; 63usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_decoder_dtvcc_report"]
        [::std::mem::size_of::<ccx_decoder_dtvcc_report>() - 256usize];
    ["Alignment of ccx_decoder_dtvcc_report"]
        [::std::mem::align_of::<ccx_decoder_dtvcc_report>() - 4usize];
    ["Offset of field: ccx_decoder_dtvcc_report::reset_count"]
        [::std::mem::offset_of!(ccx_decoder_dtvcc_report, reset_count) - 0usize];
    ["Offset of field: ccx_decoder_dtvcc_report::services"]
        [::std::mem::offset_of!(ccx_decoder_dtvcc_report, services) - 4usize];
};
impl Default for ccx_decoder_dtvcc_report {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dtvcc_service_decoder {
    pub windows: [dtvcc_window; 8usize],
    pub current_window: ::std::os::raw::c_int,
    pub tv: *mut dtvcc_tv_screen,
    pub cc_count: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dtvcc_service_decoder"]
        [::std::mem::size_of::<dtvcc_service_decoder>() - 1212120usize];
    ["Alignment of dtvcc_service_decoder"]
        [::std::mem::align_of::<dtvcc_service_decoder>() - 8usize];
    ["Offset of field: dtvcc_service_decoder::windows"]
        [::std::mem::offset_of!(dtvcc_service_decoder, windows) - 0usize];
    ["Offset of field: dtvcc_service_decoder::current_window"]
        [::std::mem::offset_of!(dtvcc_service_decoder, current_window) - 1212096usize];
    ["Offset of field: dtvcc_service_decoder::tv"]
        [::std::mem::offset_of!(dtvcc_service_decoder, tv) - 1212104usize];
    ["Offset of field: dtvcc_service_decoder::cc_count"]
        [::std::mem::offset_of!(dtvcc_service_decoder, cc_count) - 1212112usize];
};
impl Default for dtvcc_service_decoder {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ccx_decoder_dtvcc_settings {
    pub enabled: ::std::os::raw::c_int,
    pub print_file_reports: ::std::os::raw::c_int,
    pub no_rollup: ::std::os::raw::c_int,
    pub report: *mut ccx_decoder_dtvcc_report,
    pub active_services_count: ::std::os::raw::c_int,
    pub services_enabled: [::std::os::raw::c_int; 63usize],
    pub timing: *mut ccx_common_timing_ctx,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_decoder_dtvcc_settings"]
        [::std::mem::size_of::<ccx_decoder_dtvcc_settings>() - 288usize];
    ["Alignment of ccx_decoder_dtvcc_settings"]
        [::std::mem::align_of::<ccx_decoder_dtvcc_settings>() - 8usize];
    ["Offset of field: ccx_decoder_dtvcc_settings::enabled"]
        [::std::mem::offset_of!(ccx_decoder_dtvcc_settings, enabled) - 0usize];
    ["Offset of field: ccx_decoder_dtvcc_settings::print_file_reports"]
        [::std::mem::offset_of!(ccx_decoder_dtvcc_settings, print_file_reports) - 4usize];
    ["Offset of field: ccx_decoder_dtvcc_settings::no_rollup"]
        [::std::mem::offset_of!(ccx_decoder_dtvcc_settings, no_rollup) - 8usize];
    ["Offset of field: ccx_decoder_dtvcc_settings::report"]
        [::std::mem::offset_of!(ccx_decoder_dtvcc_settings, report) - 16usize];
    ["Offset of field: ccx_decoder_dtvcc_settings::active_services_count"]
        [::std::mem::offset_of!(ccx_decoder_dtvcc_settings, active_services_count) - 24usize];
    ["Offset of field: ccx_decoder_dtvcc_settings::services_enabled"]
        [::std::mem::offset_of!(ccx_decoder_dtvcc_settings, services_enabled) - 28usize];
    ["Offset of field: ccx_decoder_dtvcc_settings::timing"]
        [::std::mem::offset_of!(ccx_decoder_dtvcc_settings, timing) - 280usize];
};
impl Default for ccx_decoder_dtvcc_settings {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " TODO\n solution requires \"sink\" or \"writer\" entity to write captions to output file\n decoders have to know nothing about output files"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dtvcc_ctx {
    pub is_active: ::std::os::raw::c_int,
    pub active_services_count: ::std::os::raw::c_int,
    pub services_active: [::std::os::raw::c_int; 63usize],
    pub report_enabled: ::std::os::raw::c_int,
    pub report: *mut ccx_decoder_dtvcc_report,
    pub decoders: [dtvcc_service_decoder; 63usize],
    pub current_packet: [::std::os::raw::c_uchar; 128usize],
    pub current_packet_length: ::std::os::raw::c_int,
    pub is_current_packet_header_parsed: ::std::os::raw::c_int,
    pub last_sequence: ::std::os::raw::c_int,
    pub encoder: *mut ::std::os::raw::c_void,
    pub no_rollup: ::std::os::raw::c_int,
    pub timing: *mut ccx_common_timing_ctx,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dtvcc_ctx"][::std::mem::size_of::<dtvcc_ctx>() - 76364000usize];
    ["Alignment of dtvcc_ctx"][::std::mem::align_of::<dtvcc_ctx>() - 8usize];
    ["Offset of field: dtvcc_ctx::is_active"]
        [::std::mem::offset_of!(dtvcc_ctx, is_active) - 0usize];
    ["Offset of field: dtvcc_ctx::active_services_count"]
        [::std::mem::offset_of!(dtvcc_ctx, active_services_count) - 4usize];
    ["Offset of field: dtvcc_ctx::services_active"]
        [::std::mem::offset_of!(dtvcc_ctx, services_active) - 8usize];
    ["Offset of field: dtvcc_ctx::report_enabled"]
        [::std::mem::offset_of!(dtvcc_ctx, report_enabled) - 260usize];
    ["Offset of field: dtvcc_ctx::report"][::std::mem::offset_of!(dtvcc_ctx, report) - 264usize];
    ["Offset of field: dtvcc_ctx::decoders"]
        [::std::mem::offset_of!(dtvcc_ctx, decoders) - 272usize];
    ["Offset of field: dtvcc_ctx::current_packet"]
        [::std::mem::offset_of!(dtvcc_ctx, current_packet) - 76363832usize];
    ["Offset of field: dtvcc_ctx::current_packet_length"]
        [::std::mem::offset_of!(dtvcc_ctx, current_packet_length) - 76363960usize];
    ["Offset of field: dtvcc_ctx::is_current_packet_header_parsed"]
        [::std::mem::offset_of!(dtvcc_ctx, is_current_packet_header_parsed) - 76363964usize];
    ["Offset of field: dtvcc_ctx::last_sequence"]
        [::std::mem::offset_of!(dtvcc_ctx, last_sequence) - 76363968usize];
    ["Offset of field: dtvcc_ctx::encoder"]
        [::std::mem::offset_of!(dtvcc_ctx, encoder) - 76363976usize];
    ["Offset of field: dtvcc_ctx::no_rollup"]
        [::std::mem::offset_of!(dtvcc_ctx, no_rollup) - 76363984usize];
    ["Offset of field: dtvcc_ctx::timing"]
        [::std::mem::offset_of!(dtvcc_ctx, timing) - 76363992usize];
};
impl Default for dtvcc_ctx {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn dtvcc_clear_packet(ctx: *mut dtvcc_ctx);
}
unsafe extern "C" {
    pub fn dtvcc_windows_reset(decoder: *mut dtvcc_service_decoder);
}
unsafe extern "C" {
    pub fn dtvcc_decoder_flush(dtvcc: *mut dtvcc_ctx, decoder: *mut dtvcc_service_decoder);
}
unsafe extern "C" {
    pub fn dtvcc_process_current_packet(dtvcc: *mut dtvcc_ctx, len: ::std::os::raw::c_int);
}
unsafe extern "C" {
    pub fn dtvcc_process_service_block(
        dtvcc: *mut dtvcc_ctx,
        decoder: *mut dtvcc_service_decoder,
        data: *mut ::std::os::raw::c_uchar,
        data_length: ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn dtvcc_tv_clear(decoder: *mut dtvcc_service_decoder);
}
unsafe extern "C" {
    pub fn dtvcc_decoder_has_visible_windows(
        decoder: *mut dtvcc_service_decoder,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn dtvcc_window_clear_row(window: *mut dtvcc_window, row_index: ::std::os::raw::c_int);
}
unsafe extern "C" {
    pub fn dtvcc_window_clear_text(window: *mut dtvcc_window);
}
unsafe extern "C" {
    pub fn dtvcc_window_clear(
        decoder: *mut dtvcc_service_decoder,
        window_id: ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn dtvcc_window_apply_style(window: *mut dtvcc_window, style: *mut dtvcc_window_attribs);
}
unsafe extern "C" {
    pub fn dtvcc_decoders_reset(dtvcc: *mut dtvcc_ctx);
}
unsafe extern "C" {
    pub fn dtvcc_compare_win_priorities(
        a: *const ::std::os::raw::c_void,
        b: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn dtvcc_window_update_time_show(
        window: *mut dtvcc_window,
        timing: *mut ccx_common_timing_ctx,
    );
}
unsafe extern "C" {
    pub fn dtvcc_window_update_time_hide(
        window: *mut dtvcc_window,
        timing: *mut ccx_common_timing_ctx,
    );
}
unsafe extern "C" {
    pub fn dtvcc_screen_update_time_show(tv: *mut dtvcc_tv_screen, time: LLONG);
}
unsafe extern "C" {
    pub fn dtvcc_screen_update_time_hide(tv: *mut dtvcc_tv_screen, time: LLONG);
}
unsafe extern "C" {
    pub fn dtvcc_get_window_dimensions(
        window: *mut dtvcc_window,
        x1: *mut ::std::os::raw::c_int,
        x2: *mut ::std::os::raw::c_int,
        y1: *mut ::std::os::raw::c_int,
        y2: *mut ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn dtvcc_is_window_overlapping(
        decoder: *mut dtvcc_service_decoder,
        window: *mut dtvcc_window,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn dtvcc_window_copy_to_screen(
        decoder: *mut dtvcc_service_decoder,
        window: *mut dtvcc_window,
    );
}
unsafe extern "C" {
    pub fn dtvcc_screen_print(dtvcc: *mut dtvcc_ctx, decoder: *mut dtvcc_service_decoder);
}
unsafe extern "C" {
    pub fn dtvcc_process_hcr(decoder: *mut dtvcc_service_decoder);
}
unsafe extern "C" {
    pub fn dtvcc_process_ff(decoder: *mut dtvcc_service_decoder);
}
unsafe extern "C" {
    pub fn dtvcc_process_etx(decoder: *mut dtvcc_service_decoder);
}
unsafe extern "C" {
    pub fn dtvcc_process_bs(decoder: *mut dtvcc_service_decoder);
}
unsafe extern "C" {
    pub fn dtvcc_window_rollup(decoder: *mut dtvcc_service_decoder, window: *mut dtvcc_window);
}
unsafe extern "C" {
    pub fn dtvcc_process_cr(dtvcc: *mut dtvcc_ctx, decoder: *mut dtvcc_service_decoder);
}
unsafe extern "C" {
    pub fn dtvcc_process_character(decoder: *mut dtvcc_service_decoder, symbol: dtvcc_symbol);
}
unsafe extern "C" {
    pub fn dtvcc_handle_CWx_SetCurrentWindow(
        decoder: *mut dtvcc_service_decoder,
        window_id: ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn dtvcc_handle_CLW_ClearWindows(
        dtvcc: *mut dtvcc_ctx,
        decoder: *mut dtvcc_service_decoder,
        windows_bitmap: ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn dtvcc_handle_DSW_DisplayWindows(
        decoder: *mut dtvcc_service_decoder,
        windows_bitmap: ::std::os::raw::c_int,
        timing: *mut ccx_common_timing_ctx,
    );
}
unsafe extern "C" {
    pub fn dtvcc_handle_HDW_HideWindows(
        dtvcc: *mut dtvcc_ctx,
        decoder: *mut dtvcc_service_decoder,
        windows_bitmap: ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn dtvcc_handle_TGW_ToggleWindows(
        dtvcc: *mut dtvcc_ctx,
        decoder: *mut dtvcc_service_decoder,
        windows_bitmap: ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn dtvcc_handle_DFx_DefineWindow(
        decoder: *mut dtvcc_service_decoder,
        window_id: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_uchar,
        timing: *mut ccx_common_timing_ctx,
    );
}
unsafe extern "C" {
    pub fn dtvcc_handle_SWA_SetWindowAttributes(
        decoder: *mut dtvcc_service_decoder,
        data: *mut ::std::os::raw::c_uchar,
    );
}
unsafe extern "C" {
    pub fn dtvcc_handle_DLW_DeleteWindows(
        dtvcc: *mut dtvcc_ctx,
        decoder: *mut dtvcc_service_decoder,
        windows_bitmap: ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn dtvcc_handle_SPA_SetPenAttributes(
        decoder: *mut dtvcc_service_decoder,
        data: *mut ::std::os::raw::c_uchar,
    );
}
unsafe extern "C" {
    pub fn dtvcc_handle_SPC_SetPenColor(
        decoder: *mut dtvcc_service_decoder,
        data: *mut ::std::os::raw::c_uchar,
    );
}
unsafe extern "C" {
    pub fn dtvcc_handle_SPL_SetPenLocation(
        decoder: *mut dtvcc_service_decoder,
        data: *mut ::std::os::raw::c_uchar,
    );
}
unsafe extern "C" {
    pub fn dtvcc_handle_RST_Reset(decoder: *mut dtvcc_service_decoder);
}
unsafe extern "C" {
    pub fn dtvcc_handle_DLY_Delay(
        decoder: *mut dtvcc_service_decoder,
        tenths_of_sec: ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn dtvcc_handle_DLC_DelayCancel(decoder: *mut dtvcc_service_decoder);
}
unsafe extern "C" {
    pub fn dtvcc_handle_C0_P16(
        decoder: *mut dtvcc_service_decoder,
        data: *mut ::std::os::raw::c_uchar,
    );
}
unsafe extern "C" {
    pub fn dtvcc_handle_G0(
        decoder: *mut dtvcc_service_decoder,
        data: *mut ::std::os::raw::c_uchar,
        data_length: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn dtvcc_handle_G1(
        decoder: *mut dtvcc_service_decoder,
        data: *mut ::std::os::raw::c_uchar,
        data_length: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn dtvcc_handle_C0(
        dtvcc: *mut dtvcc_ctx,
        decoder: *mut dtvcc_service_decoder,
        data: *mut ::std::os::raw::c_uchar,
        data_length: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn dtvcc_handle_C1(
        dtvcc: *mut dtvcc_ctx,
        decoder: *mut dtvcc_service_decoder,
        data: *mut ::std::os::raw::c_uchar,
        data_length: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn dtvcc_handle_C2(
        decoder: *mut dtvcc_service_decoder,
        data: *mut ::std::os::raw::c_uchar,
        data_length: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn dtvcc_handle_C3(
        decoder: *mut dtvcc_service_decoder,
        data: *mut ::std::os::raw::c_uchar,
        data_length: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn dtvcc_handle_extended_char(
        decoder: *mut dtvcc_service_decoder,
        data: *mut ::std::os::raw::c_uchar,
        data_length: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub const ccx_eia608_format_SFORMAT_CC_SCREEN: ccx_eia608_format = 0;
pub const ccx_eia608_format_SFORMAT_CC_LINE: ccx_eia608_format = 1;
pub const ccx_eia608_format_SFORMAT_XDS: ccx_eia608_format = 2;
pub type ccx_eia608_format = ::std::os::raw::c_uint;
pub const cc_modes_MODE_POPON: cc_modes = 0;
pub const cc_modes_MODE_ROLLUP_2: cc_modes = 1;
pub const cc_modes_MODE_ROLLUP_3: cc_modes = 2;
pub const cc_modes_MODE_ROLLUP_4: cc_modes = 3;
pub const cc_modes_MODE_TEXT: cc_modes = 4;
pub const cc_modes_MODE_PAINTON: cc_modes = 5;
pub const cc_modes_MODE_FAKE_ROLLUP_1: cc_modes = 100;
pub type cc_modes = ::std::os::raw::c_uint;
pub const font_bits_FONT_REGULAR: font_bits = 0;
pub const font_bits_FONT_ITALICS: font_bits = 1;
pub const font_bits_FONT_UNDERLINED: font_bits = 2;
pub const font_bits_FONT_UNDERLINED_ITALICS: font_bits = 3;
pub type font_bits = ::std::os::raw::c_uint;
pub const ccx_decoder_608_color_code_COL_WHITE: ccx_decoder_608_color_code = 0;
pub const ccx_decoder_608_color_code_COL_GREEN: ccx_decoder_608_color_code = 1;
pub const ccx_decoder_608_color_code_COL_BLUE: ccx_decoder_608_color_code = 2;
pub const ccx_decoder_608_color_code_COL_CYAN: ccx_decoder_608_color_code = 3;
pub const ccx_decoder_608_color_code_COL_RED: ccx_decoder_608_color_code = 4;
pub const ccx_decoder_608_color_code_COL_YELLOW: ccx_decoder_608_color_code = 5;
pub const ccx_decoder_608_color_code_COL_MAGENTA: ccx_decoder_608_color_code = 6;
pub const ccx_decoder_608_color_code_COL_USERDEFINED: ccx_decoder_608_color_code = 7;
pub const ccx_decoder_608_color_code_COL_BLACK: ccx_decoder_608_color_code = 8;
pub const ccx_decoder_608_color_code_COL_TRANSPARENT: ccx_decoder_608_color_code = 9;
pub const ccx_decoder_608_color_code_COL_MAX: ccx_decoder_608_color_code = 10;
pub type ccx_decoder_608_color_code = ::std::os::raw::c_uint;
#[doc = " This structure have fields which need to be ignored according to format,\n for example if format is SFORMAT_XDS then all fields other then\n xds related (xds_str, xds_len and  cur_xds_packet_class) should be\n ignored and not to be dereferenced.\n\n TODO use union inside struct for each kind of fields"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct eia608_screen {
    #[doc = " format of data inside this structure"]
    pub format: ccx_eia608_format,
    pub characters: [[::std::os::raw::c_uchar; 33usize]; 15usize],
    pub colors: [[ccx_decoder_608_color_code; 33usize]; 15usize],
    pub fonts: [[font_bits; 33usize]; 15usize],
    pub row_used: [::std::os::raw::c_int; 15usize],
    pub empty: ::std::os::raw::c_int,
    #[doc = " start time of this CC buffer"]
    pub start_time: LLONG,
    #[doc = " end time of this CC buffer"]
    pub end_time: LLONG,
    pub mode: cc_modes,
    pub channel: ::std::os::raw::c_int,
    pub my_field: ::std::os::raw::c_int,
    #[doc = " XDS string"]
    pub xds_str: *mut ::std::os::raw::c_char,
    #[doc = " length of XDS string"]
    pub xds_len: usize,
    #[doc = " Class of XDS string"]
    pub cur_xds_packet_class: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of eia608_screen"][::std::mem::size_of::<eia608_screen>() - 4584usize];
    ["Alignment of eia608_screen"][::std::mem::align_of::<eia608_screen>() - 8usize];
    ["Offset of field: eia608_screen::format"]
        [::std::mem::offset_of!(eia608_screen, format) - 0usize];
    ["Offset of field: eia608_screen::characters"]
        [::std::mem::offset_of!(eia608_screen, characters) - 4usize];
    ["Offset of field: eia608_screen::colors"]
        [::std::mem::offset_of!(eia608_screen, colors) - 500usize];
    ["Offset of field: eia608_screen::fonts"]
        [::std::mem::offset_of!(eia608_screen, fonts) - 2480usize];
    ["Offset of field: eia608_screen::row_used"]
        [::std::mem::offset_of!(eia608_screen, row_used) - 4460usize];
    ["Offset of field: eia608_screen::empty"]
        [::std::mem::offset_of!(eia608_screen, empty) - 4520usize];
    ["Offset of field: eia608_screen::start_time"]
        [::std::mem::offset_of!(eia608_screen, start_time) - 4528usize];
    ["Offset of field: eia608_screen::end_time"]
        [::std::mem::offset_of!(eia608_screen, end_time) - 4536usize];
    ["Offset of field: eia608_screen::mode"]
        [::std::mem::offset_of!(eia608_screen, mode) - 4544usize];
    ["Offset of field: eia608_screen::channel"]
        [::std::mem::offset_of!(eia608_screen, channel) - 4548usize];
    ["Offset of field: eia608_screen::my_field"]
        [::std::mem::offset_of!(eia608_screen, my_field) - 4552usize];
    ["Offset of field: eia608_screen::xds_str"]
        [::std::mem::offset_of!(eia608_screen, xds_str) - 4560usize];
    ["Offset of field: eia608_screen::xds_len"]
        [::std::mem::offset_of!(eia608_screen, xds_len) - 4568usize];
    ["Offset of field: eia608_screen::cur_xds_packet_class"]
        [::std::mem::offset_of!(eia608_screen, cur_xds_packet_class) - 4576usize];
};
impl Default for eia608_screen {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ccx_decoders_common_settings_t {
    pub subs_delay: LLONG,
    pub output_format: ccx_output_format,
    pub fix_padding: ::std::os::raw::c_int,
    pub extraction_start: ccx_boundary_time,
    pub extraction_end: ccx_boundary_time,
    pub cc_to_stdout: ::std::os::raw::c_int,
    pub extract: ::std::os::raw::c_int,
    pub fullbin: ::std::os::raw::c_int,
    pub no_rollup: ::std::os::raw::c_int,
    pub noscte20: ::std::os::raw::c_int,
    pub settings_608: *mut ccx_decoder_608_settings,
    pub settings_dtvcc: *mut ccx_decoder_dtvcc_settings,
    pub cc_channel: ::std::os::raw::c_int,
    pub send_to_srv: ::std::os::raw::c_uint,
    pub hauppauge_mode: ::std::os::raw::c_uint,
    pub program_number: ::std::os::raw::c_int,
    pub codec: ccx_code_type,
    pub xds_write_to_file: ::std::os::raw::c_int,
    pub private_data: *mut ::std::os::raw::c_void,
    pub ocr_quantmode: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_decoders_common_settings_t"]
        [::std::mem::size_of::<ccx_decoders_common_settings_t>() - 160usize];
    ["Alignment of ccx_decoders_common_settings_t"]
        [::std::mem::align_of::<ccx_decoders_common_settings_t>() - 8usize];
    ["Offset of field: ccx_decoders_common_settings_t::subs_delay"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, subs_delay) - 0usize];
    ["Offset of field: ccx_decoders_common_settings_t::output_format"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, output_format) - 8usize];
    ["Offset of field: ccx_decoders_common_settings_t::fix_padding"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, fix_padding) - 12usize];
    ["Offset of field: ccx_decoders_common_settings_t::extraction_start"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, extraction_start) - 16usize];
    ["Offset of field: ccx_decoders_common_settings_t::extraction_end"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, extraction_end) - 48usize];
    ["Offset of field: ccx_decoders_common_settings_t::cc_to_stdout"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, cc_to_stdout) - 80usize];
    ["Offset of field: ccx_decoders_common_settings_t::extract"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, extract) - 84usize];
    ["Offset of field: ccx_decoders_common_settings_t::fullbin"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, fullbin) - 88usize];
    ["Offset of field: ccx_decoders_common_settings_t::no_rollup"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, no_rollup) - 92usize];
    ["Offset of field: ccx_decoders_common_settings_t::noscte20"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, noscte20) - 96usize];
    ["Offset of field: ccx_decoders_common_settings_t::settings_608"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, settings_608) - 104usize];
    ["Offset of field: ccx_decoders_common_settings_t::settings_dtvcc"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, settings_dtvcc) - 112usize];
    ["Offset of field: ccx_decoders_common_settings_t::cc_channel"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, cc_channel) - 120usize];
    ["Offset of field: ccx_decoders_common_settings_t::send_to_srv"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, send_to_srv) - 124usize];
    ["Offset of field: ccx_decoders_common_settings_t::hauppauge_mode"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, hauppauge_mode) - 128usize];
    ["Offset of field: ccx_decoders_common_settings_t::program_number"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, program_number) - 132usize];
    ["Offset of field: ccx_decoders_common_settings_t::codec"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, codec) - 136usize];
    ["Offset of field: ccx_decoders_common_settings_t::xds_write_to_file"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, xds_write_to_file) - 140usize];
    ["Offset of field: ccx_decoders_common_settings_t::private_data"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, private_data) - 144usize];
    ["Offset of field: ccx_decoders_common_settings_t::ocr_quantmode"]
        [::std::mem::offset_of!(ccx_decoders_common_settings_t, ocr_quantmode) - 152usize];
};
impl Default for ccx_decoders_common_settings_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lib_cc_decode {
    pub cc_stats: [::std::os::raw::c_int; 4usize],
    pub saw_caption_block: ::std::os::raw::c_int,
    pub processed_enough: ::std::os::raw::c_int,
    pub context_cc608_field_1: *mut ::std::os::raw::c_void,
    pub context_cc608_field_2: *mut ::std::os::raw::c_void,
    pub no_rollup: ::std::os::raw::c_int,
    pub noscte20: ::std::os::raw::c_int,
    pub fix_padding: ::std::os::raw::c_int,
    pub write_format: ccx_output_format,
    pub extraction_start: ccx_boundary_time,
    pub extraction_end: ccx_boundary_time,
    pub subs_delay: LLONG,
    pub extract: ::std::os::raw::c_int,
    pub fullbin: ::std::os::raw::c_int,
    pub dec_sub: cc_subtitle,
    pub in_bufferdatatype: ccx_bufferdata_type,
    pub hauppauge_mode: ::std::os::raw::c_uint,
    pub frames_since_last_gop: ::std::os::raw::c_int,
    pub saw_gop_header: ::std::os::raw::c_int,
    pub max_gop_length: ::std::os::raw::c_int,
    pub last_gop_length: ::std::os::raw::c_int,
    pub total_pulldownfields: ::std::os::raw::c_uint,
    pub total_pulldownframes: ::std::os::raw::c_uint,
    pub program_number: ::std::os::raw::c_int,
    pub list: list_head,
    pub timing: *mut ccx_common_timing_ctx,
    pub codec: ccx_code_type,
    pub has_ccdata_buffered: ::std::os::raw::c_int,
    pub is_alloc: ::std::os::raw::c_int,
    pub avc_ctx: *mut avc_ctx,
    pub private_data: *mut ::std::os::raw::c_void,
    pub current_hor_size: ::std::os::raw::c_uint,
    pub current_vert_size: ::std::os::raw::c_uint,
    pub current_aspect_ratio: ::std::os::raw::c_uint,
    pub current_frame_rate: ::std::os::raw::c_uint,
    pub no_bitstream_error: ::std::os::raw::c_int,
    pub saw_seqgoppic: ::std::os::raw::c_int,
    pub in_pic_data: ::std::os::raw::c_int,
    pub current_progressive_sequence: ::std::os::raw::c_uint,
    pub current_pulldownfields: ::std::os::raw::c_uint,
    pub temporal_reference: ::std::os::raw::c_int,
    pub picture_coding_type: ccx_frame_type,
    pub num_key_frames: ::std::os::raw::c_uint,
    pub picture_structure: ::std::os::raw::c_uint,
    pub repeat_first_field: ::std::os::raw::c_uint,
    pub progressive_frame: ::std::os::raw::c_uint,
    pub pulldownfields: ::std::os::raw::c_uint,
    pub top_field_first: ::std::os::raw::c_uint,
    pub stat_numuserheaders: ::std::os::raw::c_int,
    pub stat_dvdccheaders: ::std::os::raw::c_int,
    pub stat_scte20ccheaders: ::std::os::raw::c_int,
    pub stat_replay5000headers: ::std::os::raw::c_int,
    pub stat_replay4000headers: ::std::os::raw::c_int,
    pub stat_dishheaders: ::std::os::raw::c_int,
    pub stat_hdtv: ::std::os::raw::c_int,
    pub stat_divicom: ::std::os::raw::c_int,
    pub false_pict_header: ::std::os::raw::c_int,
    pub dtvcc: *mut dtvcc_ctx,
    pub dtvcc_rust: *mut ::std::os::raw::c_void,
    pub current_field: ::std::os::raw::c_int,
    pub maxtref: ::std::os::raw::c_int,
    pub cc_data_count: [::std::os::raw::c_int; 101usize],
    pub cc_fts: [LLONG; 101usize],
    pub cc_data_pkts: [[::std::os::raw::c_uchar; 931usize]; 101usize],
    pub anchor_seq_number: ::std::os::raw::c_int,
    pub xds_ctx: *mut ccx_decoders_xds_context,
    pub vbi_decoder: *mut ccx_decoder_vbi_ctx,
    pub writedata: ::std::option::Option<
        unsafe extern "C" fn(
            data: *const ::std::os::raw::c_uchar,
            length: ::std::os::raw::c_int,
            private_data: *mut ::std::os::raw::c_void,
            sub: *mut cc_subtitle,
        ) -> ::std::os::raw::c_int,
    >,
    pub ocr_quantmode: ::std::os::raw::c_int,
    pub prev: *mut lib_cc_decode,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of lib_cc_decode"][::std::mem::size_of::<lib_cc_decode>() - 95760usize];
    ["Alignment of lib_cc_decode"][::std::mem::align_of::<lib_cc_decode>() - 8usize];
    ["Offset of field: lib_cc_decode::cc_stats"]
        [::std::mem::offset_of!(lib_cc_decode, cc_stats) - 0usize];
    ["Offset of field: lib_cc_decode::saw_caption_block"]
        [::std::mem::offset_of!(lib_cc_decode, saw_caption_block) - 16usize];
    ["Offset of field: lib_cc_decode::processed_enough"]
        [::std::mem::offset_of!(lib_cc_decode, processed_enough) - 20usize];
    ["Offset of field: lib_cc_decode::context_cc608_field_1"]
        [::std::mem::offset_of!(lib_cc_decode, context_cc608_field_1) - 24usize];
    ["Offset of field: lib_cc_decode::context_cc608_field_2"]
        [::std::mem::offset_of!(lib_cc_decode, context_cc608_field_2) - 32usize];
    ["Offset of field: lib_cc_decode::no_rollup"]
        [::std::mem::offset_of!(lib_cc_decode, no_rollup) - 40usize];
    ["Offset of field: lib_cc_decode::noscte20"]
        [::std::mem::offset_of!(lib_cc_decode, noscte20) - 44usize];
    ["Offset of field: lib_cc_decode::fix_padding"]
        [::std::mem::offset_of!(lib_cc_decode, fix_padding) - 48usize];
    ["Offset of field: lib_cc_decode::write_format"]
        [::std::mem::offset_of!(lib_cc_decode, write_format) - 52usize];
    ["Offset of field: lib_cc_decode::extraction_start"]
        [::std::mem::offset_of!(lib_cc_decode, extraction_start) - 56usize];
    ["Offset of field: lib_cc_decode::extraction_end"]
        [::std::mem::offset_of!(lib_cc_decode, extraction_end) - 88usize];
    ["Offset of field: lib_cc_decode::subs_delay"]
        [::std::mem::offset_of!(lib_cc_decode, subs_delay) - 120usize];
    ["Offset of field: lib_cc_decode::extract"]
        [::std::mem::offset_of!(lib_cc_decode, extract) - 128usize];
    ["Offset of field: lib_cc_decode::fullbin"]
        [::std::mem::offset_of!(lib_cc_decode, fullbin) - 132usize];
    ["Offset of field: lib_cc_decode::dec_sub"]
        [::std::mem::offset_of!(lib_cc_decode, dec_sub) - 136usize];
    ["Offset of field: lib_cc_decode::in_bufferdatatype"]
        [::std::mem::offset_of!(lib_cc_decode, in_bufferdatatype) - 240usize];
    ["Offset of field: lib_cc_decode::hauppauge_mode"]
        [::std::mem::offset_of!(lib_cc_decode, hauppauge_mode) - 244usize];
    ["Offset of field: lib_cc_decode::frames_since_last_gop"]
        [::std::mem::offset_of!(lib_cc_decode, frames_since_last_gop) - 248usize];
    ["Offset of field: lib_cc_decode::saw_gop_header"]
        [::std::mem::offset_of!(lib_cc_decode, saw_gop_header) - 252usize];
    ["Offset of field: lib_cc_decode::max_gop_length"]
        [::std::mem::offset_of!(lib_cc_decode, max_gop_length) - 256usize];
    ["Offset of field: lib_cc_decode::last_gop_length"]
        [::std::mem::offset_of!(lib_cc_decode, last_gop_length) - 260usize];
    ["Offset of field: lib_cc_decode::total_pulldownfields"]
        [::std::mem::offset_of!(lib_cc_decode, total_pulldownfields) - 264usize];
    ["Offset of field: lib_cc_decode::total_pulldownframes"]
        [::std::mem::offset_of!(lib_cc_decode, total_pulldownframes) - 268usize];
    ["Offset of field: lib_cc_decode::program_number"]
        [::std::mem::offset_of!(lib_cc_decode, program_number) - 272usize];
    ["Offset of field: lib_cc_decode::list"]
        [::std::mem::offset_of!(lib_cc_decode, list) - 280usize];
    ["Offset of field: lib_cc_decode::timing"]
        [::std::mem::offset_of!(lib_cc_decode, timing) - 296usize];
    ["Offset of field: lib_cc_decode::codec"]
        [::std::mem::offset_of!(lib_cc_decode, codec) - 304usize];
    ["Offset of field: lib_cc_decode::has_ccdata_buffered"]
        [::std::mem::offset_of!(lib_cc_decode, has_ccdata_buffered) - 308usize];
    ["Offset of field: lib_cc_decode::is_alloc"]
        [::std::mem::offset_of!(lib_cc_decode, is_alloc) - 312usize];
    ["Offset of field: lib_cc_decode::avc_ctx"]
        [::std::mem::offset_of!(lib_cc_decode, avc_ctx) - 320usize];
    ["Offset of field: lib_cc_decode::private_data"]
        [::std::mem::offset_of!(lib_cc_decode, private_data) - 328usize];
    ["Offset of field: lib_cc_decode::current_hor_size"]
        [::std::mem::offset_of!(lib_cc_decode, current_hor_size) - 336usize];
    ["Offset of field: lib_cc_decode::current_vert_size"]
        [::std::mem::offset_of!(lib_cc_decode, current_vert_size) - 340usize];
    ["Offset of field: lib_cc_decode::current_aspect_ratio"]
        [::std::mem::offset_of!(lib_cc_decode, current_aspect_ratio) - 344usize];
    ["Offset of field: lib_cc_decode::current_frame_rate"]
        [::std::mem::offset_of!(lib_cc_decode, current_frame_rate) - 348usize];
    ["Offset of field: lib_cc_decode::no_bitstream_error"]
        [::std::mem::offset_of!(lib_cc_decode, no_bitstream_error) - 352usize];
    ["Offset of field: lib_cc_decode::saw_seqgoppic"]
        [::std::mem::offset_of!(lib_cc_decode, saw_seqgoppic) - 356usize];
    ["Offset of field: lib_cc_decode::in_pic_data"]
        [::std::mem::offset_of!(lib_cc_decode, in_pic_data) - 360usize];
    ["Offset of field: lib_cc_decode::current_progressive_sequence"]
        [::std::mem::offset_of!(lib_cc_decode, current_progressive_sequence) - 364usize];
    ["Offset of field: lib_cc_decode::current_pulldownfields"]
        [::std::mem::offset_of!(lib_cc_decode, current_pulldownfields) - 368usize];
    ["Offset of field: lib_cc_decode::temporal_reference"]
        [::std::mem::offset_of!(lib_cc_decode, temporal_reference) - 372usize];
    ["Offset of field: lib_cc_decode::picture_coding_type"]
        [::std::mem::offset_of!(lib_cc_decode, picture_coding_type) - 376usize];
    ["Offset of field: lib_cc_decode::num_key_frames"]
        [::std::mem::offset_of!(lib_cc_decode, num_key_frames) - 380usize];
    ["Offset of field: lib_cc_decode::picture_structure"]
        [::std::mem::offset_of!(lib_cc_decode, picture_structure) - 384usize];
    ["Offset of field: lib_cc_decode::repeat_first_field"]
        [::std::mem::offset_of!(lib_cc_decode, repeat_first_field) - 388usize];
    ["Offset of field: lib_cc_decode::progressive_frame"]
        [::std::mem::offset_of!(lib_cc_decode, progressive_frame) - 392usize];
    ["Offset of field: lib_cc_decode::pulldownfields"]
        [::std::mem::offset_of!(lib_cc_decode, pulldownfields) - 396usize];
    ["Offset of field: lib_cc_decode::top_field_first"]
        [::std::mem::offset_of!(lib_cc_decode, top_field_first) - 400usize];
    ["Offset of field: lib_cc_decode::stat_numuserheaders"]
        [::std::mem::offset_of!(lib_cc_decode, stat_numuserheaders) - 404usize];
    ["Offset of field: lib_cc_decode::stat_dvdccheaders"]
        [::std::mem::offset_of!(lib_cc_decode, stat_dvdccheaders) - 408usize];
    ["Offset of field: lib_cc_decode::stat_scte20ccheaders"]
        [::std::mem::offset_of!(lib_cc_decode, stat_scte20ccheaders) - 412usize];
    ["Offset of field: lib_cc_decode::stat_replay5000headers"]
        [::std::mem::offset_of!(lib_cc_decode, stat_replay5000headers) - 416usize];
    ["Offset of field: lib_cc_decode::stat_replay4000headers"]
        [::std::mem::offset_of!(lib_cc_decode, stat_replay4000headers) - 420usize];
    ["Offset of field: lib_cc_decode::stat_dishheaders"]
        [::std::mem::offset_of!(lib_cc_decode, stat_dishheaders) - 424usize];
    ["Offset of field: lib_cc_decode::stat_hdtv"]
        [::std::mem::offset_of!(lib_cc_decode, stat_hdtv) - 428usize];
    ["Offset of field: lib_cc_decode::stat_divicom"]
        [::std::mem::offset_of!(lib_cc_decode, stat_divicom) - 432usize];
    ["Offset of field: lib_cc_decode::false_pict_header"]
        [::std::mem::offset_of!(lib_cc_decode, false_pict_header) - 436usize];
    ["Offset of field: lib_cc_decode::dtvcc"]
        [::std::mem::offset_of!(lib_cc_decode, dtvcc) - 440usize];
    ["Offset of field: lib_cc_decode::dtvcc_rust"]
        [::std::mem::offset_of!(lib_cc_decode, dtvcc_rust) - 448usize];
    ["Offset of field: lib_cc_decode::current_field"]
        [::std::mem::offset_of!(lib_cc_decode, current_field) - 456usize];
    ["Offset of field: lib_cc_decode::maxtref"]
        [::std::mem::offset_of!(lib_cc_decode, maxtref) - 460usize];
    ["Offset of field: lib_cc_decode::cc_data_count"]
        [::std::mem::offset_of!(lib_cc_decode, cc_data_count) - 464usize];
    ["Offset of field: lib_cc_decode::cc_fts"]
        [::std::mem::offset_of!(lib_cc_decode, cc_fts) - 872usize];
    ["Offset of field: lib_cc_decode::cc_data_pkts"]
        [::std::mem::offset_of!(lib_cc_decode, cc_data_pkts) - 1680usize];
    ["Offset of field: lib_cc_decode::anchor_seq_number"]
        [::std::mem::offset_of!(lib_cc_decode, anchor_seq_number) - 95712usize];
    ["Offset of field: lib_cc_decode::xds_ctx"]
        [::std::mem::offset_of!(lib_cc_decode, xds_ctx) - 95720usize];
    ["Offset of field: lib_cc_decode::vbi_decoder"]
        [::std::mem::offset_of!(lib_cc_decode, vbi_decoder) - 95728usize];
    ["Offset of field: lib_cc_decode::writedata"]
        [::std::mem::offset_of!(lib_cc_decode, writedata) - 95736usize];
    ["Offset of field: lib_cc_decode::ocr_quantmode"]
        [::std::mem::offset_of!(lib_cc_decode, ocr_quantmode) - 95744usize];
    ["Offset of field: lib_cc_decode::prev"]
        [::std::mem::offset_of!(lib_cc_decode, prev) - 95752usize];
};
impl Default for lib_cc_decode {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ccx_decoder_608_report {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub cc_channels: [u8; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_decoder_608_report"][::std::mem::size_of::<ccx_decoder_608_report>() - 5usize];
    ["Alignment of ccx_decoder_608_report"]
        [::std::mem::align_of::<ccx_decoder_608_report>() - 1usize];
    ["Offset of field: ccx_decoder_608_report::cc_channels"]
        [::std::mem::offset_of!(ccx_decoder_608_report, cc_channels) - 1usize];
};
impl ccx_decoder_608_report {
    #[inline]
    pub fn xds(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_xds(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn xds_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_xds_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(xds: u8) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let xds: u8 = unsafe { ::std::mem::transmute(xds) };
            xds as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ccx_decoder_608_settings {
    pub direct_rollup: ::std::os::raw::c_int,
    pub force_rollup: ::std::os::raw::c_int,
    pub no_rollup: ::std::os::raw::c_int,
    pub default_color: ccx_decoder_608_color_code,
    pub screens_to_process: ::std::os::raw::c_int,
    pub report: *mut ccx_decoder_608_report,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_decoder_608_settings"]
        [::std::mem::size_of::<ccx_decoder_608_settings>() - 32usize];
    ["Alignment of ccx_decoder_608_settings"]
        [::std::mem::align_of::<ccx_decoder_608_settings>() - 8usize];
    ["Offset of field: ccx_decoder_608_settings::direct_rollup"]
        [::std::mem::offset_of!(ccx_decoder_608_settings, direct_rollup) - 0usize];
    ["Offset of field: ccx_decoder_608_settings::force_rollup"]
        [::std::mem::offset_of!(ccx_decoder_608_settings, force_rollup) - 4usize];
    ["Offset of field: ccx_decoder_608_settings::no_rollup"]
        [::std::mem::offset_of!(ccx_decoder_608_settings, no_rollup) - 8usize];
    ["Offset of field: ccx_decoder_608_settings::default_color"]
        [::std::mem::offset_of!(ccx_decoder_608_settings, default_color) - 12usize];
    ["Offset of field: ccx_decoder_608_settings::screens_to_process"]
        [::std::mem::offset_of!(ccx_decoder_608_settings, screens_to_process) - 16usize];
    ["Offset of field: ccx_decoder_608_settings::report"]
        [::std::mem::offset_of!(ccx_decoder_608_settings, report) - 24usize];
};
impl Default for ccx_decoder_608_settings {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ccx_encoders_transcript_format {
    pub showStartTime: ::std::os::raw::c_int,
    pub showEndTime: ::std::os::raw::c_int,
    pub showMode: ::std::os::raw::c_int,
    pub showCC: ::std::os::raw::c_int,
    pub relativeTimestamp: ::std::os::raw::c_int,
    pub xds: ::std::os::raw::c_int,
    pub useColors: ::std::os::raw::c_int,
    pub isFinal: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_encoders_transcript_format"]
        [::std::mem::size_of::<ccx_encoders_transcript_format>() - 32usize];
    ["Alignment of ccx_encoders_transcript_format"]
        [::std::mem::align_of::<ccx_encoders_transcript_format>() - 4usize];
    ["Offset of field: ccx_encoders_transcript_format::showStartTime"]
        [::std::mem::offset_of!(ccx_encoders_transcript_format, showStartTime) - 0usize];
    ["Offset of field: ccx_encoders_transcript_format::showEndTime"]
        [::std::mem::offset_of!(ccx_encoders_transcript_format, showEndTime) - 4usize];
    ["Offset of field: ccx_encoders_transcript_format::showMode"]
        [::std::mem::offset_of!(ccx_encoders_transcript_format, showMode) - 8usize];
    ["Offset of field: ccx_encoders_transcript_format::showCC"]
        [::std::mem::offset_of!(ccx_encoders_transcript_format, showCC) - 12usize];
    ["Offset of field: ccx_encoders_transcript_format::relativeTimestamp"]
        [::std::mem::offset_of!(ccx_encoders_transcript_format, relativeTimestamp) - 16usize];
    ["Offset of field: ccx_encoders_transcript_format::xds"]
        [::std::mem::offset_of!(ccx_encoders_transcript_format, xds) - 20usize];
    ["Offset of field: ccx_encoders_transcript_format::useColors"]
        [::std::mem::offset_of!(ccx_encoders_transcript_format, useColors) - 24usize];
    ["Offset of field: ccx_encoders_transcript_format::isFinal"]
        [::std::mem::offset_of!(ccx_encoders_transcript_format, isFinal) - 28usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ccx_s_write {
    pub fh: ::std::os::raw::c_int,
    pub temporarily_closed: ::std::os::raw::c_int,
    pub filename: *mut ::std::os::raw::c_char,
    pub original_filename: *mut ::std::os::raw::c_char,
    pub spupng_data: *mut ::std::os::raw::c_void,
    pub with_semaphore: ::std::os::raw::c_int,
    pub semaphore_filename: *mut ::std::os::raw::c_char,
    pub with_playlist: ::std::os::raw::c_int,
    pub playlist_filename: *mut ::std::os::raw::c_char,
    pub renaming_extension: ::std::os::raw::c_int,
    pub append_mode: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_s_write"][::std::mem::size_of::<ccx_s_write>() - 72usize];
    ["Alignment of ccx_s_write"][::std::mem::align_of::<ccx_s_write>() - 8usize];
    ["Offset of field: ccx_s_write::fh"][::std::mem::offset_of!(ccx_s_write, fh) - 0usize];
    ["Offset of field: ccx_s_write::temporarily_closed"]
        [::std::mem::offset_of!(ccx_s_write, temporarily_closed) - 4usize];
    ["Offset of field: ccx_s_write::filename"]
        [::std::mem::offset_of!(ccx_s_write, filename) - 8usize];
    ["Offset of field: ccx_s_write::original_filename"]
        [::std::mem::offset_of!(ccx_s_write, original_filename) - 16usize];
    ["Offset of field: ccx_s_write::spupng_data"]
        [::std::mem::offset_of!(ccx_s_write, spupng_data) - 24usize];
    ["Offset of field: ccx_s_write::with_semaphore"]
        [::std::mem::offset_of!(ccx_s_write, with_semaphore) - 32usize];
    ["Offset of field: ccx_s_write::semaphore_filename"]
        [::std::mem::offset_of!(ccx_s_write, semaphore_filename) - 40usize];
    ["Offset of field: ccx_s_write::with_playlist"]
        [::std::mem::offset_of!(ccx_s_write, with_playlist) - 48usize];
    ["Offset of field: ccx_s_write::playlist_filename"]
        [::std::mem::offset_of!(ccx_s_write, playlist_filename) - 56usize];
    ["Offset of field: ccx_s_write::renaming_extension"]
        [::std::mem::offset_of!(ccx_s_write, renaming_extension) - 64usize];
    ["Offset of field: ccx_s_write::append_mode"]
        [::std::mem::offset_of!(ccx_s_write, append_mode) - 68usize];
};
impl Default for ccx_s_write {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct demuxer_cfg {
    pub m2ts: ::std::os::raw::c_int,
    pub auto_stream: ccx_stream_mode_enum,
    pub codec: ccx_code_type,
    pub nocodec: ccx_code_type,
    pub ts_autoprogram: ::std::os::raw::c_uint,
    pub ts_allprogram: ::std::os::raw::c_uint,
    pub ts_cappids: [::std::os::raw::c_uint; 128usize],
    pub nb_ts_cappid: ::std::os::raw::c_int,
    pub ts_forced_cappid: ::std::os::raw::c_uint,
    pub ts_forced_program: ::std::os::raw::c_int,
    pub ts_forced_program_selected: ::std::os::raw::c_uint,
    pub ts_datastreamtype: ::std::os::raw::c_int,
    pub ts_forced_streamtype: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of demuxer_cfg"][::std::mem::size_of::<demuxer_cfg>() - 560usize];
    ["Alignment of demuxer_cfg"][::std::mem::align_of::<demuxer_cfg>() - 4usize];
    ["Offset of field: demuxer_cfg::m2ts"][::std::mem::offset_of!(demuxer_cfg, m2ts) - 0usize];
    ["Offset of field: demuxer_cfg::auto_stream"]
        [::std::mem::offset_of!(demuxer_cfg, auto_stream) - 4usize];
    ["Offset of field: demuxer_cfg::codec"][::std::mem::offset_of!(demuxer_cfg, codec) - 8usize];
    ["Offset of field: demuxer_cfg::nocodec"]
        [::std::mem::offset_of!(demuxer_cfg, nocodec) - 12usize];
    ["Offset of field: demuxer_cfg::ts_autoprogram"]
        [::std::mem::offset_of!(demuxer_cfg, ts_autoprogram) - 16usize];
    ["Offset of field: demuxer_cfg::ts_allprogram"]
        [::std::mem::offset_of!(demuxer_cfg, ts_allprogram) - 20usize];
    ["Offset of field: demuxer_cfg::ts_cappids"]
        [::std::mem::offset_of!(demuxer_cfg, ts_cappids) - 24usize];
    ["Offset of field: demuxer_cfg::nb_ts_cappid"]
        [::std::mem::offset_of!(demuxer_cfg, nb_ts_cappid) - 536usize];
    ["Offset of field: demuxer_cfg::ts_forced_cappid"]
        [::std::mem::offset_of!(demuxer_cfg, ts_forced_cappid) - 540usize];
    ["Offset of field: demuxer_cfg::ts_forced_program"]
        [::std::mem::offset_of!(demuxer_cfg, ts_forced_program) - 544usize];
    ["Offset of field: demuxer_cfg::ts_forced_program_selected"]
        [::std::mem::offset_of!(demuxer_cfg, ts_forced_program_selected) - 548usize];
    ["Offset of field: demuxer_cfg::ts_datastreamtype"]
        [::std::mem::offset_of!(demuxer_cfg, ts_datastreamtype) - 552usize];
    ["Offset of field: demuxer_cfg::ts_forced_streamtype"]
        [::std::mem::offset_of!(demuxer_cfg, ts_forced_streamtype) - 556usize];
};
impl Default for demuxer_cfg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct encoder_cfg {
    pub extract: ::std::os::raw::c_int,
    pub dtvcc_extract: ::std::os::raw::c_int,
    pub gui_mode_reports: ::std::os::raw::c_int,
    pub output_filename: *mut ::std::os::raw::c_char,
    pub write_format: ccx_output_format,
    pub keep_output_closed: ::std::os::raw::c_int,
    pub force_flush: ::std::os::raw::c_int,
    pub append_mode: ::std::os::raw::c_int,
    pub ucla: ::std::os::raw::c_int,
    pub encoding: ccx_encoding_type,
    pub date_format: ccx_output_date_format,
    pub millis_separator: ::std::os::raw::c_char,
    pub autodash: ::std::os::raw::c_int,
    pub trim_subs: ::std::os::raw::c_int,
    pub sentence_cap: ::std::os::raw::c_int,
    pub splitbysentence: ::std::os::raw::c_int,
    pub filter_profanity: ::std::os::raw::c_int,
    pub with_semaphore: ::std::os::raw::c_int,
    pub start_credits_text: *mut ::std::os::raw::c_char,
    pub end_credits_text: *mut ::std::os::raw::c_char,
    pub startcreditsnotbefore: ccx_boundary_time,
    pub startcreditsnotafter: ccx_boundary_time,
    pub startcreditsforatleast: ccx_boundary_time,
    pub startcreditsforatmost: ccx_boundary_time,
    pub endcreditsforatleast: ccx_boundary_time,
    pub endcreditsforatmost: ccx_boundary_time,
    pub transcript_settings: ccx_encoders_transcript_format,
    pub send_to_srv: ::std::os::raw::c_uint,
    pub no_bom: ::std::os::raw::c_int,
    pub first_input_file: *mut ::std::os::raw::c_char,
    pub multiple_files: ::std::os::raw::c_int,
    pub no_font_color: ::std::os::raw::c_int,
    pub no_type_setting: ::std::os::raw::c_int,
    pub cc_to_stdout: ::std::os::raw::c_int,
    pub line_terminator_lf: ::std::os::raw::c_int,
    pub subs_delay: LLONG,
    pub program_number: ::std::os::raw::c_int,
    pub in_format: ::std::os::raw::c_uchar,
    pub nospupngocr: ::std::os::raw::c_int,
    pub force_dropframe: ::std::os::raw::c_int,
    pub scc_framerate: ::std::os::raw::c_int,
    pub scc_accurate_timing: ::std::os::raw::c_int,
    pub render_font: *mut ::std::os::raw::c_char,
    pub render_font_italics: *mut ::std::os::raw::c_char,
    pub services_enabled: [::std::os::raw::c_int; 63usize],
    pub services_charsets: *mut *mut ::std::os::raw::c_char,
    pub all_services_charset: *mut ::std::os::raw::c_char,
    pub extract_only_708: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of encoder_cfg"][::std::mem::size_of::<encoder_cfg>() - 688usize];
    ["Alignment of encoder_cfg"][::std::mem::align_of::<encoder_cfg>() - 8usize];
    ["Offset of field: encoder_cfg::extract"]
        [::std::mem::offset_of!(encoder_cfg, extract) - 0usize];
    ["Offset of field: encoder_cfg::dtvcc_extract"]
        [::std::mem::offset_of!(encoder_cfg, dtvcc_extract) - 4usize];
    ["Offset of field: encoder_cfg::gui_mode_reports"]
        [::std::mem::offset_of!(encoder_cfg, gui_mode_reports) - 8usize];
    ["Offset of field: encoder_cfg::output_filename"]
        [::std::mem::offset_of!(encoder_cfg, output_filename) - 16usize];
    ["Offset of field: encoder_cfg::write_format"]
        [::std::mem::offset_of!(encoder_cfg, write_format) - 24usize];
    ["Offset of field: encoder_cfg::keep_output_closed"]
        [::std::mem::offset_of!(encoder_cfg, keep_output_closed) - 28usize];
    ["Offset of field: encoder_cfg::force_flush"]
        [::std::mem::offset_of!(encoder_cfg, force_flush) - 32usize];
    ["Offset of field: encoder_cfg::append_mode"]
        [::std::mem::offset_of!(encoder_cfg, append_mode) - 36usize];
    ["Offset of field: encoder_cfg::ucla"][::std::mem::offset_of!(encoder_cfg, ucla) - 40usize];
    ["Offset of field: encoder_cfg::encoding"]
        [::std::mem::offset_of!(encoder_cfg, encoding) - 44usize];
    ["Offset of field: encoder_cfg::date_format"]
        [::std::mem::offset_of!(encoder_cfg, date_format) - 48usize];
    ["Offset of field: encoder_cfg::millis_separator"]
        [::std::mem::offset_of!(encoder_cfg, millis_separator) - 52usize];
    ["Offset of field: encoder_cfg::autodash"]
        [::std::mem::offset_of!(encoder_cfg, autodash) - 56usize];
    ["Offset of field: encoder_cfg::trim_subs"]
        [::std::mem::offset_of!(encoder_cfg, trim_subs) - 60usize];
    ["Offset of field: encoder_cfg::sentence_cap"]
        [::std::mem::offset_of!(encoder_cfg, sentence_cap) - 64usize];
    ["Offset of field: encoder_cfg::splitbysentence"]
        [::std::mem::offset_of!(encoder_cfg, splitbysentence) - 68usize];
    ["Offset of field: encoder_cfg::filter_profanity"]
        [::std::mem::offset_of!(encoder_cfg, filter_profanity) - 72usize];
    ["Offset of field: encoder_cfg::with_semaphore"]
        [::std::mem::offset_of!(encoder_cfg, with_semaphore) - 76usize];
    ["Offset of field: encoder_cfg::start_credits_text"]
        [::std::mem::offset_of!(encoder_cfg, start_credits_text) - 80usize];
    ["Offset of field: encoder_cfg::end_credits_text"]
        [::std::mem::offset_of!(encoder_cfg, end_credits_text) - 88usize];
    ["Offset of field: encoder_cfg::startcreditsnotbefore"]
        [::std::mem::offset_of!(encoder_cfg, startcreditsnotbefore) - 96usize];
    ["Offset of field: encoder_cfg::startcreditsnotafter"]
        [::std::mem::offset_of!(encoder_cfg, startcreditsnotafter) - 128usize];
    ["Offset of field: encoder_cfg::startcreditsforatleast"]
        [::std::mem::offset_of!(encoder_cfg, startcreditsforatleast) - 160usize];
    ["Offset of field: encoder_cfg::startcreditsforatmost"]
        [::std::mem::offset_of!(encoder_cfg, startcreditsforatmost) - 192usize];
    ["Offset of field: encoder_cfg::endcreditsforatleast"]
        [::std::mem::offset_of!(encoder_cfg, endcreditsforatleast) - 224usize];
    ["Offset of field: encoder_cfg::endcreditsforatmost"]
        [::std::mem::offset_of!(encoder_cfg, endcreditsforatmost) - 256usize];
    ["Offset of field: encoder_cfg::transcript_settings"]
        [::std::mem::offset_of!(encoder_cfg, transcript_settings) - 288usize];
    ["Offset of field: encoder_cfg::send_to_srv"]
        [::std::mem::offset_of!(encoder_cfg, send_to_srv) - 320usize];
    ["Offset of field: encoder_cfg::no_bom"]
        [::std::mem::offset_of!(encoder_cfg, no_bom) - 324usize];
    ["Offset of field: encoder_cfg::first_input_file"]
        [::std::mem::offset_of!(encoder_cfg, first_input_file) - 328usize];
    ["Offset of field: encoder_cfg::multiple_files"]
        [::std::mem::offset_of!(encoder_cfg, multiple_files) - 336usize];
    ["Offset of field: encoder_cfg::no_font_color"]
        [::std::mem::offset_of!(encoder_cfg, no_font_color) - 340usize];
    ["Offset of field: encoder_cfg::no_type_setting"]
        [::std::mem::offset_of!(encoder_cfg, no_type_setting) - 344usize];
    ["Offset of field: encoder_cfg::cc_to_stdout"]
        [::std::mem::offset_of!(encoder_cfg, cc_to_stdout) - 348usize];
    ["Offset of field: encoder_cfg::line_terminator_lf"]
        [::std::mem::offset_of!(encoder_cfg, line_terminator_lf) - 352usize];
    ["Offset of field: encoder_cfg::subs_delay"]
        [::std::mem::offset_of!(encoder_cfg, subs_delay) - 360usize];
    ["Offset of field: encoder_cfg::program_number"]
        [::std::mem::offset_of!(encoder_cfg, program_number) - 368usize];
    ["Offset of field: encoder_cfg::in_format"]
        [::std::mem::offset_of!(encoder_cfg, in_format) - 372usize];
    ["Offset of field: encoder_cfg::nospupngocr"]
        [::std::mem::offset_of!(encoder_cfg, nospupngocr) - 376usize];
    ["Offset of field: encoder_cfg::force_dropframe"]
        [::std::mem::offset_of!(encoder_cfg, force_dropframe) - 380usize];
    ["Offset of field: encoder_cfg::scc_framerate"]
        [::std::mem::offset_of!(encoder_cfg, scc_framerate) - 384usize];
    ["Offset of field: encoder_cfg::scc_accurate_timing"]
        [::std::mem::offset_of!(encoder_cfg, scc_accurate_timing) - 388usize];
    ["Offset of field: encoder_cfg::render_font"]
        [::std::mem::offset_of!(encoder_cfg, render_font) - 392usize];
    ["Offset of field: encoder_cfg::render_font_italics"]
        [::std::mem::offset_of!(encoder_cfg, render_font_italics) - 400usize];
    ["Offset of field: encoder_cfg::services_enabled"]
        [::std::mem::offset_of!(encoder_cfg, services_enabled) - 408usize];
    ["Offset of field: encoder_cfg::services_charsets"]
        [::std::mem::offset_of!(encoder_cfg, services_charsets) - 664usize];
    ["Offset of field: encoder_cfg::all_services_charset"]
        [::std::mem::offset_of!(encoder_cfg, all_services_charset) - 672usize];
    ["Offset of field: encoder_cfg::extract_only_708"]
        [::std::mem::offset_of!(encoder_cfg, extract_only_708) - 680usize];
};
impl Default for encoder_cfg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ccx_s_options {
    pub extract: ::std::os::raw::c_int,
    pub no_rollup: ::std::os::raw::c_int,
    pub noscte20: ::std::os::raw::c_int,
    pub webvtt_create_css: ::std::os::raw::c_int,
    pub cc_channel: ::std::os::raw::c_int,
    pub buffer_input: ::std::os::raw::c_int,
    pub nofontcolor: ::std::os::raw::c_int,
    pub nohtmlescape: ::std::os::raw::c_int,
    pub notypesetting: ::std::os::raw::c_int,
    pub extraction_start: ccx_boundary_time,
    pub extraction_end: ccx_boundary_time,
    pub print_file_reports: ::std::os::raw::c_int,
    pub settings_608: ccx_decoder_608_settings,
    pub settings_dtvcc: ccx_decoder_dtvcc_settings,
    pub is_608_enabled: ::std::os::raw::c_int,
    pub is_708_enabled: ::std::os::raw::c_int,
    pub millis_separator: ::std::os::raw::c_char,
    pub binary_concat: ::std::os::raw::c_int,
    pub use_gop_as_pts: ::std::os::raw::c_int,
    pub fix_padding: ::std::os::raw::c_int,
    pub gui_mode_reports: ::std::os::raw::c_int,
    pub no_progress_bar: ::std::os::raw::c_int,
    pub sentence_cap_file: *mut ::std::os::raw::c_char,
    pub live_stream: ::std::os::raw::c_int,
    pub filter_profanity_file: *mut ::std::os::raw::c_char,
    pub messages_target: ::std::os::raw::c_int,
    pub timestamp_map: ::std::os::raw::c_int,
    pub dolevdist: ::std::os::raw::c_int,
    pub levdistmincnt: ::std::os::raw::c_int,
    pub levdistmaxpct: ::std::os::raw::c_int,
    pub investigate_packets: ::std::os::raw::c_int,
    pub fullbin: ::std::os::raw::c_int,
    pub nosync: ::std::os::raw::c_int,
    pub hauppauge_mode: ::std::os::raw::c_uint,
    pub wtvconvertfix: ::std::os::raw::c_int,
    pub wtvmpeg2: ::std::os::raw::c_int,
    pub auto_myth: ::std::os::raw::c_int,
    pub mp4vidtrack: ::std::os::raw::c_uint,
    pub extract_chapters: ::std::os::raw::c_int,
    pub usepicorder: ::std::os::raw::c_int,
    pub xmltv: ::std::os::raw::c_int,
    pub xmltvliveinterval: ::std::os::raw::c_int,
    pub xmltvoutputinterval: ::std::os::raw::c_int,
    pub xmltvonlycurrent: ::std::os::raw::c_int,
    pub keep_output_closed: ::std::os::raw::c_int,
    pub force_flush: ::std::os::raw::c_int,
    pub append_mode: ::std::os::raw::c_int,
    pub ucla: ::std::os::raw::c_int,
    pub tickertext: ::std::os::raw::c_int,
    pub hardsubx: ::std::os::raw::c_int,
    pub hardsubx_and_common: ::std::os::raw::c_int,
    pub dvblang: *mut ::std::os::raw::c_char,
    pub ocrlang: *const ::std::os::raw::c_char,
    pub ocr_oem: ::std::os::raw::c_int,
    pub psm: ::std::os::raw::c_int,
    pub ocr_quantmode: ::std::os::raw::c_int,
    pub ocr_line_split: ::std::os::raw::c_int,
    pub ocr_blacklist: ::std::os::raw::c_int,
    pub mkvlang: *mut ::std::os::raw::c_char,
    pub analyze_video_stream: ::std::os::raw::c_int,
    pub hardsubx_ocr_mode: ::std::os::raw::c_int,
    pub hardsubx_subcolor: ::std::os::raw::c_int,
    pub hardsubx_min_sub_duration: f32,
    pub hardsubx_detect_italics: ::std::os::raw::c_int,
    pub hardsubx_conf_thresh: f32,
    pub hardsubx_hue: f32,
    pub hardsubx_lum_thresh: f32,
    pub transcript_settings: ccx_encoders_transcript_format,
    pub date_format: ccx_output_date_format,
    pub send_to_srv: ::std::os::raw::c_uint,
    pub write_format: ccx_output_format,
    pub write_format_rewritten: ::std::os::raw::c_int,
    pub use_ass_instead_of_ssa: ::std::os::raw::c_int,
    pub use_webvtt_styling: ::std::os::raw::c_int,
    pub debug_mask: LLONG,
    pub debug_mask_on_debug: LLONG,
    pub udpsrc: *mut ::std::os::raw::c_char,
    pub udpaddr: *mut ::std::os::raw::c_char,
    pub udpport: ::std::os::raw::c_uint,
    pub tcpport: *mut ::std::os::raw::c_char,
    pub tcp_password: *mut ::std::os::raw::c_char,
    pub tcp_desc: *mut ::std::os::raw::c_char,
    pub srv_addr: *mut ::std::os::raw::c_char,
    pub srv_port: *mut ::std::os::raw::c_char,
    pub noautotimeref: ::std::os::raw::c_int,
    pub input_source: ccx_datasource,
    pub output_filename: *mut ::std::os::raw::c_char,
    pub inputfile: *mut *mut ::std::os::raw::c_char,
    pub num_input_files: ::std::os::raw::c_int,
    pub demux_cfg: demuxer_cfg,
    pub enc_cfg: encoder_cfg,
    pub subs_delay: LLONG,
    pub cc_to_stdout: ::std::os::raw::c_int,
    pub pes_header_to_stdout: ::std::os::raw::c_int,
    pub ignore_pts_jumps: ::std::os::raw::c_int,
    pub multiprogram: ::std::os::raw::c_int,
    pub out_interval: ::std::os::raw::c_int,
    pub segment_on_key_frames_only: ::std::os::raw::c_int,
    pub scc_framerate: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_s_options"][::std::mem::size_of::<ccx_s_options>() - 2128usize];
    ["Alignment of ccx_s_options"][::std::mem::align_of::<ccx_s_options>() - 8usize];
    ["Offset of field: ccx_s_options::extract"]
        [::std::mem::offset_of!(ccx_s_options, extract) - 0usize];
    ["Offset of field: ccx_s_options::no_rollup"]
        [::std::mem::offset_of!(ccx_s_options, no_rollup) - 4usize];
    ["Offset of field: ccx_s_options::noscte20"]
        [::std::mem::offset_of!(ccx_s_options, noscte20) - 8usize];
    ["Offset of field: ccx_s_options::webvtt_create_css"]
        [::std::mem::offset_of!(ccx_s_options, webvtt_create_css) - 12usize];
    ["Offset of field: ccx_s_options::cc_channel"]
        [::std::mem::offset_of!(ccx_s_options, cc_channel) - 16usize];
    ["Offset of field: ccx_s_options::buffer_input"]
        [::std::mem::offset_of!(ccx_s_options, buffer_input) - 20usize];
    ["Offset of field: ccx_s_options::nofontcolor"]
        [::std::mem::offset_of!(ccx_s_options, nofontcolor) - 24usize];
    ["Offset of field: ccx_s_options::nohtmlescape"]
        [::std::mem::offset_of!(ccx_s_options, nohtmlescape) - 28usize];
    ["Offset of field: ccx_s_options::notypesetting"]
        [::std::mem::offset_of!(ccx_s_options, notypesetting) - 32usize];
    ["Offset of field: ccx_s_options::extraction_start"]
        [::std::mem::offset_of!(ccx_s_options, extraction_start) - 40usize];
    ["Offset of field: ccx_s_options::extraction_end"]
        [::std::mem::offset_of!(ccx_s_options, extraction_end) - 72usize];
    ["Offset of field: ccx_s_options::print_file_reports"]
        [::std::mem::offset_of!(ccx_s_options, print_file_reports) - 104usize];
    ["Offset of field: ccx_s_options::settings_608"]
        [::std::mem::offset_of!(ccx_s_options, settings_608) - 112usize];
    ["Offset of field: ccx_s_options::settings_dtvcc"]
        [::std::mem::offset_of!(ccx_s_options, settings_dtvcc) - 144usize];
    ["Offset of field: ccx_s_options::is_608_enabled"]
        [::std::mem::offset_of!(ccx_s_options, is_608_enabled) - 432usize];
    ["Offset of field: ccx_s_options::is_708_enabled"]
        [::std::mem::offset_of!(ccx_s_options, is_708_enabled) - 436usize];
    ["Offset of field: ccx_s_options::millis_separator"]
        [::std::mem::offset_of!(ccx_s_options, millis_separator) - 440usize];
    ["Offset of field: ccx_s_options::binary_concat"]
        [::std::mem::offset_of!(ccx_s_options, binary_concat) - 444usize];
    ["Offset of field: ccx_s_options::use_gop_as_pts"]
        [::std::mem::offset_of!(ccx_s_options, use_gop_as_pts) - 448usize];
    ["Offset of field: ccx_s_options::fix_padding"]
        [::std::mem::offset_of!(ccx_s_options, fix_padding) - 452usize];
    ["Offset of field: ccx_s_options::gui_mode_reports"]
        [::std::mem::offset_of!(ccx_s_options, gui_mode_reports) - 456usize];
    ["Offset of field: ccx_s_options::no_progress_bar"]
        [::std::mem::offset_of!(ccx_s_options, no_progress_bar) - 460usize];
    ["Offset of field: ccx_s_options::sentence_cap_file"]
        [::std::mem::offset_of!(ccx_s_options, sentence_cap_file) - 464usize];
    ["Offset of field: ccx_s_options::live_stream"]
        [::std::mem::offset_of!(ccx_s_options, live_stream) - 472usize];
    ["Offset of field: ccx_s_options::filter_profanity_file"]
        [::std::mem::offset_of!(ccx_s_options, filter_profanity_file) - 480usize];
    ["Offset of field: ccx_s_options::messages_target"]
        [::std::mem::offset_of!(ccx_s_options, messages_target) - 488usize];
    ["Offset of field: ccx_s_options::timestamp_map"]
        [::std::mem::offset_of!(ccx_s_options, timestamp_map) - 492usize];
    ["Offset of field: ccx_s_options::dolevdist"]
        [::std::mem::offset_of!(ccx_s_options, dolevdist) - 496usize];
    ["Offset of field: ccx_s_options::levdistmincnt"]
        [::std::mem::offset_of!(ccx_s_options, levdistmincnt) - 500usize];
    ["Offset of field: ccx_s_options::levdistmaxpct"]
        [::std::mem::offset_of!(ccx_s_options, levdistmaxpct) - 504usize];
    ["Offset of field: ccx_s_options::investigate_packets"]
        [::std::mem::offset_of!(ccx_s_options, investigate_packets) - 508usize];
    ["Offset of field: ccx_s_options::fullbin"]
        [::std::mem::offset_of!(ccx_s_options, fullbin) - 512usize];
    ["Offset of field: ccx_s_options::nosync"]
        [::std::mem::offset_of!(ccx_s_options, nosync) - 516usize];
    ["Offset of field: ccx_s_options::hauppauge_mode"]
        [::std::mem::offset_of!(ccx_s_options, hauppauge_mode) - 520usize];
    ["Offset of field: ccx_s_options::wtvconvertfix"]
        [::std::mem::offset_of!(ccx_s_options, wtvconvertfix) - 524usize];
    ["Offset of field: ccx_s_options::wtvmpeg2"]
        [::std::mem::offset_of!(ccx_s_options, wtvmpeg2) - 528usize];
    ["Offset of field: ccx_s_options::auto_myth"]
        [::std::mem::offset_of!(ccx_s_options, auto_myth) - 532usize];
    ["Offset of field: ccx_s_options::mp4vidtrack"]
        [::std::mem::offset_of!(ccx_s_options, mp4vidtrack) - 536usize];
    ["Offset of field: ccx_s_options::extract_chapters"]
        [::std::mem::offset_of!(ccx_s_options, extract_chapters) - 540usize];
    ["Offset of field: ccx_s_options::usepicorder"]
        [::std::mem::offset_of!(ccx_s_options, usepicorder) - 544usize];
    ["Offset of field: ccx_s_options::xmltv"]
        [::std::mem::offset_of!(ccx_s_options, xmltv) - 548usize];
    ["Offset of field: ccx_s_options::xmltvliveinterval"]
        [::std::mem::offset_of!(ccx_s_options, xmltvliveinterval) - 552usize];
    ["Offset of field: ccx_s_options::xmltvoutputinterval"]
        [::std::mem::offset_of!(ccx_s_options, xmltvoutputinterval) - 556usize];
    ["Offset of field: ccx_s_options::xmltvonlycurrent"]
        [::std::mem::offset_of!(ccx_s_options, xmltvonlycurrent) - 560usize];
    ["Offset of field: ccx_s_options::keep_output_closed"]
        [::std::mem::offset_of!(ccx_s_options, keep_output_closed) - 564usize];
    ["Offset of field: ccx_s_options::force_flush"]
        [::std::mem::offset_of!(ccx_s_options, force_flush) - 568usize];
    ["Offset of field: ccx_s_options::append_mode"]
        [::std::mem::offset_of!(ccx_s_options, append_mode) - 572usize];
    ["Offset of field: ccx_s_options::ucla"]
        [::std::mem::offset_of!(ccx_s_options, ucla) - 576usize];
    ["Offset of field: ccx_s_options::tickertext"]
        [::std::mem::offset_of!(ccx_s_options, tickertext) - 580usize];
    ["Offset of field: ccx_s_options::hardsubx"]
        [::std::mem::offset_of!(ccx_s_options, hardsubx) - 584usize];
    ["Offset of field: ccx_s_options::hardsubx_and_common"]
        [::std::mem::offset_of!(ccx_s_options, hardsubx_and_common) - 588usize];
    ["Offset of field: ccx_s_options::dvblang"]
        [::std::mem::offset_of!(ccx_s_options, dvblang) - 592usize];
    ["Offset of field: ccx_s_options::ocrlang"]
        [::std::mem::offset_of!(ccx_s_options, ocrlang) - 600usize];
    ["Offset of field: ccx_s_options::ocr_oem"]
        [::std::mem::offset_of!(ccx_s_options, ocr_oem) - 608usize];
    ["Offset of field: ccx_s_options::psm"][::std::mem::offset_of!(ccx_s_options, psm) - 612usize];
    ["Offset of field: ccx_s_options::ocr_quantmode"]
        [::std::mem::offset_of!(ccx_s_options, ocr_quantmode) - 616usize];
    ["Offset of field: ccx_s_options::ocr_line_split"]
        [::std::mem::offset_of!(ccx_s_options, ocr_line_split) - 620usize];
    ["Offset of field: ccx_s_options::ocr_blacklist"]
        [::std::mem::offset_of!(ccx_s_options, ocr_blacklist) - 624usize];
    ["Offset of field: ccx_s_options::mkvlang"]
        [::std::mem::offset_of!(ccx_s_options, mkvlang) - 632usize];
    ["Offset of field: ccx_s_options::analyze_video_stream"]
        [::std::mem::offset_of!(ccx_s_options, analyze_video_stream) - 640usize];
    ["Offset of field: ccx_s_options::hardsubx_ocr_mode"]
        [::std::mem::offset_of!(ccx_s_options, hardsubx_ocr_mode) - 644usize];
    ["Offset of field: ccx_s_options::hardsubx_subcolor"]
        [::std::mem::offset_of!(ccx_s_options, hardsubx_subcolor) - 648usize];
    ["Offset of field: ccx_s_options::hardsubx_min_sub_duration"]
        [::std::mem::offset_of!(ccx_s_options, hardsubx_min_sub_duration) - 652usize];
    ["Offset of field: ccx_s_options::hardsubx_detect_italics"]
        [::std::mem::offset_of!(ccx_s_options, hardsubx_detect_italics) - 656usize];
    ["Offset of field: ccx_s_options::hardsubx_conf_thresh"]
        [::std::mem::offset_of!(ccx_s_options, hardsubx_conf_thresh) - 660usize];
    ["Offset of field: ccx_s_options::hardsubx_hue"]
        [::std::mem::offset_of!(ccx_s_options, hardsubx_hue) - 664usize];
    ["Offset of field: ccx_s_options::hardsubx_lum_thresh"]
        [::std::mem::offset_of!(ccx_s_options, hardsubx_lum_thresh) - 668usize];
    ["Offset of field: ccx_s_options::transcript_settings"]
        [::std::mem::offset_of!(ccx_s_options, transcript_settings) - 672usize];
    ["Offset of field: ccx_s_options::date_format"]
        [::std::mem::offset_of!(ccx_s_options, date_format) - 704usize];
    ["Offset of field: ccx_s_options::send_to_srv"]
        [::std::mem::offset_of!(ccx_s_options, send_to_srv) - 708usize];
    ["Offset of field: ccx_s_options::write_format"]
        [::std::mem::offset_of!(ccx_s_options, write_format) - 712usize];
    ["Offset of field: ccx_s_options::write_format_rewritten"]
        [::std::mem::offset_of!(ccx_s_options, write_format_rewritten) - 716usize];
    ["Offset of field: ccx_s_options::use_ass_instead_of_ssa"]
        [::std::mem::offset_of!(ccx_s_options, use_ass_instead_of_ssa) - 720usize];
    ["Offset of field: ccx_s_options::use_webvtt_styling"]
        [::std::mem::offset_of!(ccx_s_options, use_webvtt_styling) - 724usize];
    ["Offset of field: ccx_s_options::debug_mask"]
        [::std::mem::offset_of!(ccx_s_options, debug_mask) - 728usize];
    ["Offset of field: ccx_s_options::debug_mask_on_debug"]
        [::std::mem::offset_of!(ccx_s_options, debug_mask_on_debug) - 736usize];
    ["Offset of field: ccx_s_options::udpsrc"]
        [::std::mem::offset_of!(ccx_s_options, udpsrc) - 744usize];
    ["Offset of field: ccx_s_options::udpaddr"]
        [::std::mem::offset_of!(ccx_s_options, udpaddr) - 752usize];
    ["Offset of field: ccx_s_options::udpport"]
        [::std::mem::offset_of!(ccx_s_options, udpport) - 760usize];
    ["Offset of field: ccx_s_options::tcpport"]
        [::std::mem::offset_of!(ccx_s_options, tcpport) - 768usize];
    ["Offset of field: ccx_s_options::tcp_password"]
        [::std::mem::offset_of!(ccx_s_options, tcp_password) - 776usize];
    ["Offset of field: ccx_s_options::tcp_desc"]
        [::std::mem::offset_of!(ccx_s_options, tcp_desc) - 784usize];
    ["Offset of field: ccx_s_options::srv_addr"]
        [::std::mem::offset_of!(ccx_s_options, srv_addr) - 792usize];
    ["Offset of field: ccx_s_options::srv_port"]
        [::std::mem::offset_of!(ccx_s_options, srv_port) - 800usize];
    ["Offset of field: ccx_s_options::noautotimeref"]
        [::std::mem::offset_of!(ccx_s_options, noautotimeref) - 808usize];
    ["Offset of field: ccx_s_options::input_source"]
        [::std::mem::offset_of!(ccx_s_options, input_source) - 812usize];
    ["Offset of field: ccx_s_options::output_filename"]
        [::std::mem::offset_of!(ccx_s_options, output_filename) - 816usize];
    ["Offset of field: ccx_s_options::inputfile"]
        [::std::mem::offset_of!(ccx_s_options, inputfile) - 824usize];
    ["Offset of field: ccx_s_options::num_input_files"]
        [::std::mem::offset_of!(ccx_s_options, num_input_files) - 832usize];
    ["Offset of field: ccx_s_options::demux_cfg"]
        [::std::mem::offset_of!(ccx_s_options, demux_cfg) - 836usize];
    ["Offset of field: ccx_s_options::enc_cfg"]
        [::std::mem::offset_of!(ccx_s_options, enc_cfg) - 1400usize];
    ["Offset of field: ccx_s_options::subs_delay"]
        [::std::mem::offset_of!(ccx_s_options, subs_delay) - 2088usize];
    ["Offset of field: ccx_s_options::cc_to_stdout"]
        [::std::mem::offset_of!(ccx_s_options, cc_to_stdout) - 2096usize];
    ["Offset of field: ccx_s_options::pes_header_to_stdout"]
        [::std::mem::offset_of!(ccx_s_options, pes_header_to_stdout) - 2100usize];
    ["Offset of field: ccx_s_options::ignore_pts_jumps"]
        [::std::mem::offset_of!(ccx_s_options, ignore_pts_jumps) - 2104usize];
    ["Offset of field: ccx_s_options::multiprogram"]
        [::std::mem::offset_of!(ccx_s_options, multiprogram) - 2108usize];
    ["Offset of field: ccx_s_options::out_interval"]
        [::std::mem::offset_of!(ccx_s_options, out_interval) - 2112usize];
    ["Offset of field: ccx_s_options::segment_on_key_frames_only"]
        [::std::mem::offset_of!(ccx_s_options, segment_on_key_frames_only) - 2116usize];
    ["Offset of field: ccx_s_options::scc_framerate"]
        [::std::mem::offset_of!(ccx_s_options, scc_framerate) - 2120usize];
};
impl Default for ccx_s_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type iconv_t = *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dtvcc_writer_ctx {
    pub fd: ::std::os::raw::c_int,
    pub fhandle: *mut ::std::os::raw::c_void,
    pub charset: *mut ::std::os::raw::c_char,
    pub filename: *mut ::std::os::raw::c_char,
    pub cd: iconv_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dtvcc_writer_ctx"][::std::mem::size_of::<dtvcc_writer_ctx>() - 40usize];
    ["Alignment of dtvcc_writer_ctx"][::std::mem::align_of::<dtvcc_writer_ctx>() - 8usize];
    ["Offset of field: dtvcc_writer_ctx::fd"]
        [::std::mem::offset_of!(dtvcc_writer_ctx, fd) - 0usize];
    ["Offset of field: dtvcc_writer_ctx::fhandle"]
        [::std::mem::offset_of!(dtvcc_writer_ctx, fhandle) - 8usize];
    ["Offset of field: dtvcc_writer_ctx::charset"]
        [::std::mem::offset_of!(dtvcc_writer_ctx, charset) - 16usize];
    ["Offset of field: dtvcc_writer_ctx::filename"]
        [::std::mem::offset_of!(dtvcc_writer_ctx, filename) - 24usize];
    ["Offset of field: dtvcc_writer_ctx::cd"]
        [::std::mem::offset_of!(dtvcc_writer_ctx, cd) - 32usize];
};
impl Default for dtvcc_writer_ctx {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ccx_mcc_caption_time {
    pub hour: ::std::os::raw::c_uint,
    pub minute: ::std::os::raw::c_uint,
    pub second: ::std::os::raw::c_uint,
    pub millisecond: ::std::os::raw::c_uint,
    pub frame: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_mcc_caption_time"][::std::mem::size_of::<ccx_mcc_caption_time>() - 20usize];
    ["Alignment of ccx_mcc_caption_time"][::std::mem::align_of::<ccx_mcc_caption_time>() - 4usize];
    ["Offset of field: ccx_mcc_caption_time::hour"]
        [::std::mem::offset_of!(ccx_mcc_caption_time, hour) - 0usize];
    ["Offset of field: ccx_mcc_caption_time::minute"]
        [::std::mem::offset_of!(ccx_mcc_caption_time, minute) - 4usize];
    ["Offset of field: ccx_mcc_caption_time::second"]
        [::std::mem::offset_of!(ccx_mcc_caption_time, second) - 8usize];
    ["Offset of field: ccx_mcc_caption_time::millisecond"]
        [::std::mem::offset_of!(ccx_mcc_caption_time, millisecond) - 12usize];
    ["Offset of field: ccx_mcc_caption_time::frame"]
        [::std::mem::offset_of!(ccx_mcc_caption_time, frame) - 16usize];
};
#[doc = " Context of encoder, This structure gives single interface\n to all encoder"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct encoder_ctx {
    pub buffer: *mut ::std::os::raw::c_uchar,
    pub capacity: ::std::os::raw::c_uint,
    pub srt_counter: ::std::os::raw::c_uint,
    pub cea_708_counter: ::std::os::raw::c_uint,
    pub wrote_webvtt_header: ::std::os::raw::c_uint,
    pub wrote_ccd_channel_header: ::std::os::raw::c_char,
    pub send_to_srv: ::std::os::raw::c_uint,
    pub multiple_files: ::std::os::raw::c_int,
    pub first_input_file: *mut ::std::os::raw::c_char,
    pub out: *mut ccx_s_write,
    pub nb_out: ::std::os::raw::c_int,
    pub in_fileformat: ::std::os::raw::c_uint,
    pub keep_output_closed: ::std::os::raw::c_uint,
    pub force_flush: ::std::os::raw::c_int,
    pub ucla: ::std::os::raw::c_int,
    pub timing: *mut ccx_common_timing_ctx,
    pub encoding: ccx_encoding_type,
    pub write_format: ccx_output_format,
    pub generates_file: ::std::os::raw::c_int,
    pub transcript_settings: *mut ccx_encoders_transcript_format,
    pub no_bom: ::std::os::raw::c_int,
    pub sentence_cap: ::std::os::raw::c_int,
    pub filter_profanity: ::std::os::raw::c_int,
    pub trim_subs: ::std::os::raw::c_int,
    pub autodash: ::std::os::raw::c_int,
    pub no_font_color: ::std::os::raw::c_int,
    pub no_type_setting: ::std::os::raw::c_int,
    pub gui_mode_reports: ::std::os::raw::c_int,
    pub subline: *mut ::std::os::raw::c_uchar,
    pub extract: ::std::os::raw::c_int,
    pub dtvcc_extract: ::std::os::raw::c_int,
    pub dtvcc_writers: [dtvcc_writer_ctx; 63usize],
    pub prev_start: LLONG,
    pub subs_delay: LLONG,
    pub last_displayed_subs_ms: LLONG,
    pub date_format: ccx_output_date_format,
    pub millis_separator: ::std::os::raw::c_char,
    pub startcredits_displayed: ::std::os::raw::c_int,
    pub start_credits_text: *mut ::std::os::raw::c_char,
    pub end_credits_text: *mut ::std::os::raw::c_char,
    pub startcreditsnotbefore: ccx_boundary_time,
    pub startcreditsnotafter: ccx_boundary_time,
    pub startcreditsforatleast: ccx_boundary_time,
    pub startcreditsforatmost: ccx_boundary_time,
    pub endcreditsforatleast: ccx_boundary_time,
    pub endcreditsforatmost: ccx_boundary_time,
    pub encoded_crlf: [::std::os::raw::c_uchar; 16usize],
    pub encoded_crlf_length: ::std::os::raw::c_uint,
    pub encoded_br: [::std::os::raw::c_uchar; 16usize],
    pub encoded_br_length: ::std::os::raw::c_uint,
    pub header_printed_flag: ::std::os::raw::c_int,
    pub next_caption_time: ccx_mcc_caption_time,
    pub cdp_hdr_seq: ::std::os::raw::c_uint,
    pub force_dropframe: ::std::os::raw::c_int,
    pub scc_framerate: ::std::os::raw::c_int,
    pub scc_accurate_timing: ::std::os::raw::c_int,
    pub scc_last_transmission_end: LLONG,
    pub scc_last_display_end: LLONG,
    pub new_sentence: ::std::os::raw::c_int,
    pub program_number: ::std::os::raw::c_int,
    pub list: list_head,
    pub sbs_enabled: ::std::os::raw::c_int,
    pub prev: *mut encoder_ctx,
    pub write_previous: ::std::os::raw::c_int,
    pub is_mkv: ::std::os::raw::c_int,
    pub last_string: *mut ::std::os::raw::c_char,
    pub segment_pending: ::std::os::raw::c_int,
    pub segment_last_key_frame: ::std::os::raw::c_int,
    pub nospupngocr: ::std::os::raw::c_int,
    pub tlt_out: [*mut ccx_s_write; 8usize],
    pub tlt_out_pages: [u16; 8usize],
    pub tlt_srt_counter: [::std::os::raw::c_uint; 8usize],
    pub tlt_out_count: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of encoder_ctx"][::std::mem::size_of::<encoder_ctx>() - 3216usize];
    ["Alignment of encoder_ctx"][::std::mem::align_of::<encoder_ctx>() - 8usize];
    ["Offset of field: encoder_ctx::buffer"][::std::mem::offset_of!(encoder_ctx, buffer) - 0usize];
    ["Offset of field: encoder_ctx::capacity"]
        [::std::mem::offset_of!(encoder_ctx, capacity) - 8usize];
    ["Offset of field: encoder_ctx::srt_counter"]
        [::std::mem::offset_of!(encoder_ctx, srt_counter) - 12usize];
    ["Offset of field: encoder_ctx::cea_708_counter"]
        [::std::mem::offset_of!(encoder_ctx, cea_708_counter) - 16usize];
    ["Offset of field: encoder_ctx::wrote_webvtt_header"]
        [::std::mem::offset_of!(encoder_ctx, wrote_webvtt_header) - 20usize];
    ["Offset of field: encoder_ctx::wrote_ccd_channel_header"]
        [::std::mem::offset_of!(encoder_ctx, wrote_ccd_channel_header) - 24usize];
    ["Offset of field: encoder_ctx::send_to_srv"]
        [::std::mem::offset_of!(encoder_ctx, send_to_srv) - 28usize];
    ["Offset of field: encoder_ctx::multiple_files"]
        [::std::mem::offset_of!(encoder_ctx, multiple_files) - 32usize];
    ["Offset of field: encoder_ctx::first_input_file"]
        [::std::mem::offset_of!(encoder_ctx, first_input_file) - 40usize];
    ["Offset of field: encoder_ctx::out"][::std::mem::offset_of!(encoder_ctx, out) - 48usize];
    ["Offset of field: encoder_ctx::nb_out"][::std::mem::offset_of!(encoder_ctx, nb_out) - 56usize];
    ["Offset of field: encoder_ctx::in_fileformat"]
        [::std::mem::offset_of!(encoder_ctx, in_fileformat) - 60usize];
    ["Offset of field: encoder_ctx::keep_output_closed"]
        [::std::mem::offset_of!(encoder_ctx, keep_output_closed) - 64usize];
    ["Offset of field: encoder_ctx::force_flush"]
        [::std::mem::offset_of!(encoder_ctx, force_flush) - 68usize];
    ["Offset of field: encoder_ctx::ucla"][::std::mem::offset_of!(encoder_ctx, ucla) - 72usize];
    ["Offset of field: encoder_ctx::timing"][::std::mem::offset_of!(encoder_ctx, timing) - 80usize];
    ["Offset of field: encoder_ctx::encoding"]
        [::std::mem::offset_of!(encoder_ctx, encoding) - 88usize];
    ["Offset of field: encoder_ctx::write_format"]
        [::std::mem::offset_of!(encoder_ctx, write_format) - 92usize];
    ["Offset of field: encoder_ctx::generates_file"]
        [::std::mem::offset_of!(encoder_ctx, generates_file) - 96usize];
    ["Offset of field: encoder_ctx::transcript_settings"]
        [::std::mem::offset_of!(encoder_ctx, transcript_settings) - 104usize];
    ["Offset of field: encoder_ctx::no_bom"]
        [::std::mem::offset_of!(encoder_ctx, no_bom) - 112usize];
    ["Offset of field: encoder_ctx::sentence_cap"]
        [::std::mem::offset_of!(encoder_ctx, sentence_cap) - 116usize];
    ["Offset of field: encoder_ctx::filter_profanity"]
        [::std::mem::offset_of!(encoder_ctx, filter_profanity) - 120usize];
    ["Offset of field: encoder_ctx::trim_subs"]
        [::std::mem::offset_of!(encoder_ctx, trim_subs) - 124usize];
    ["Offset of field: encoder_ctx::autodash"]
        [::std::mem::offset_of!(encoder_ctx, autodash) - 128usize];
    ["Offset of field: encoder_ctx::no_font_color"]
        [::std::mem::offset_of!(encoder_ctx, no_font_color) - 132usize];
    ["Offset of field: encoder_ctx::no_type_setting"]
        [::std::mem::offset_of!(encoder_ctx, no_type_setting) - 136usize];
    ["Offset of field: encoder_ctx::gui_mode_reports"]
        [::std::mem::offset_of!(encoder_ctx, gui_mode_reports) - 140usize];
    ["Offset of field: encoder_ctx::subline"]
        [::std::mem::offset_of!(encoder_ctx, subline) - 144usize];
    ["Offset of field: encoder_ctx::extract"]
        [::std::mem::offset_of!(encoder_ctx, extract) - 152usize];
    ["Offset of field: encoder_ctx::dtvcc_extract"]
        [::std::mem::offset_of!(encoder_ctx, dtvcc_extract) - 156usize];
    ["Offset of field: encoder_ctx::dtvcc_writers"]
        [::std::mem::offset_of!(encoder_ctx, dtvcc_writers) - 160usize];
    ["Offset of field: encoder_ctx::prev_start"]
        [::std::mem::offset_of!(encoder_ctx, prev_start) - 2680usize];
    ["Offset of field: encoder_ctx::subs_delay"]
        [::std::mem::offset_of!(encoder_ctx, subs_delay) - 2688usize];
    ["Offset of field: encoder_ctx::last_displayed_subs_ms"]
        [::std::mem::offset_of!(encoder_ctx, last_displayed_subs_ms) - 2696usize];
    ["Offset of field: encoder_ctx::date_format"]
        [::std::mem::offset_of!(encoder_ctx, date_format) - 2704usize];
    ["Offset of field: encoder_ctx::millis_separator"]
        [::std::mem::offset_of!(encoder_ctx, millis_separator) - 2708usize];
    ["Offset of field: encoder_ctx::startcredits_displayed"]
        [::std::mem::offset_of!(encoder_ctx, startcredits_displayed) - 2712usize];
    ["Offset of field: encoder_ctx::start_credits_text"]
        [::std::mem::offset_of!(encoder_ctx, start_credits_text) - 2720usize];
    ["Offset of field: encoder_ctx::end_credits_text"]
        [::std::mem::offset_of!(encoder_ctx, end_credits_text) - 2728usize];
    ["Offset of field: encoder_ctx::startcreditsnotbefore"]
        [::std::mem::offset_of!(encoder_ctx, startcreditsnotbefore) - 2736usize];
    ["Offset of field: encoder_ctx::startcreditsnotafter"]
        [::std::mem::offset_of!(encoder_ctx, startcreditsnotafter) - 2768usize];
    ["Offset of field: encoder_ctx::startcreditsforatleast"]
        [::std::mem::offset_of!(encoder_ctx, startcreditsforatleast) - 2800usize];
    ["Offset of field: encoder_ctx::startcreditsforatmost"]
        [::std::mem::offset_of!(encoder_ctx, startcreditsforatmost) - 2832usize];
    ["Offset of field: encoder_ctx::endcreditsforatleast"]
        [::std::mem::offset_of!(encoder_ctx, endcreditsforatleast) - 2864usize];
    ["Offset of field: encoder_ctx::endcreditsforatmost"]
        [::std::mem::offset_of!(encoder_ctx, endcreditsforatmost) - 2896usize];
    ["Offset of field: encoder_ctx::encoded_crlf"]
        [::std::mem::offset_of!(encoder_ctx, encoded_crlf) - 2928usize];
    ["Offset of field: encoder_ctx::encoded_crlf_length"]
        [::std::mem::offset_of!(encoder_ctx, encoded_crlf_length) - 2944usize];
    ["Offset of field: encoder_ctx::encoded_br"]
        [::std::mem::offset_of!(encoder_ctx, encoded_br) - 2948usize];
    ["Offset of field: encoder_ctx::encoded_br_length"]
        [::std::mem::offset_of!(encoder_ctx, encoded_br_length) - 2964usize];
    ["Offset of field: encoder_ctx::header_printed_flag"]
        [::std::mem::offset_of!(encoder_ctx, header_printed_flag) - 2968usize];
    ["Offset of field: encoder_ctx::next_caption_time"]
        [::std::mem::offset_of!(encoder_ctx, next_caption_time) - 2972usize];
    ["Offset of field: encoder_ctx::cdp_hdr_seq"]
        [::std::mem::offset_of!(encoder_ctx, cdp_hdr_seq) - 2992usize];
    ["Offset of field: encoder_ctx::force_dropframe"]
        [::std::mem::offset_of!(encoder_ctx, force_dropframe) - 2996usize];
    ["Offset of field: encoder_ctx::scc_framerate"]
        [::std::mem::offset_of!(encoder_ctx, scc_framerate) - 3000usize];
    ["Offset of field: encoder_ctx::scc_accurate_timing"]
        [::std::mem::offset_of!(encoder_ctx, scc_accurate_timing) - 3004usize];
    ["Offset of field: encoder_ctx::scc_last_transmission_end"]
        [::std::mem::offset_of!(encoder_ctx, scc_last_transmission_end) - 3008usize];
    ["Offset of field: encoder_ctx::scc_last_display_end"]
        [::std::mem::offset_of!(encoder_ctx, scc_last_display_end) - 3016usize];
    ["Offset of field: encoder_ctx::new_sentence"]
        [::std::mem::offset_of!(encoder_ctx, new_sentence) - 3024usize];
    ["Offset of field: encoder_ctx::program_number"]
        [::std::mem::offset_of!(encoder_ctx, program_number) - 3028usize];
    ["Offset of field: encoder_ctx::list"][::std::mem::offset_of!(encoder_ctx, list) - 3032usize];
    ["Offset of field: encoder_ctx::sbs_enabled"]
        [::std::mem::offset_of!(encoder_ctx, sbs_enabled) - 3048usize];
    ["Offset of field: encoder_ctx::prev"][::std::mem::offset_of!(encoder_ctx, prev) - 3056usize];
    ["Offset of field: encoder_ctx::write_previous"]
        [::std::mem::offset_of!(encoder_ctx, write_previous) - 3064usize];
    ["Offset of field: encoder_ctx::is_mkv"]
        [::std::mem::offset_of!(encoder_ctx, is_mkv) - 3068usize];
    ["Offset of field: encoder_ctx::last_string"]
        [::std::mem::offset_of!(encoder_ctx, last_string) - 3072usize];
    ["Offset of field: encoder_ctx::segment_pending"]
        [::std::mem::offset_of!(encoder_ctx, segment_pending) - 3080usize];
    ["Offset of field: encoder_ctx::segment_last_key_frame"]
        [::std::mem::offset_of!(encoder_ctx, segment_last_key_frame) - 3084usize];
    ["Offset of field: encoder_ctx::nospupngocr"]
        [::std::mem::offset_of!(encoder_ctx, nospupngocr) - 3088usize];
    ["Offset of field: encoder_ctx::tlt_out"]
        [::std::mem::offset_of!(encoder_ctx, tlt_out) - 3096usize];
    ["Offset of field: encoder_ctx::tlt_out_pages"]
        [::std::mem::offset_of!(encoder_ctx, tlt_out_pages) - 3160usize];
    ["Offset of field: encoder_ctx::tlt_srt_counter"]
        [::std::mem::offset_of!(encoder_ctx, tlt_srt_counter) - 3176usize];
    ["Offset of field: encoder_ctx::tlt_out_count"]
        [::std::mem::offset_of!(encoder_ctx, tlt_out_count) - 3208usize];
};
impl Default for encoder_ctx {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn write_spumux_header(ctx: *mut encoder_ctx, out: *mut ccx_s_write);
}
unsafe extern "C" {
    pub fn write_spumux_footer(out: *mut ccx_s_write);
}
unsafe extern "C" {
    pub fn get_visible_start(
        ctx: *mut ccx_common_timing_ctx,
        current_field: ::std::os::raw::c_int,
    ) -> LLONG;
}
unsafe extern "C" {
    pub fn get_visible_end(
        ctx: *mut ccx_common_timing_ctx,
        current_field: ::std::os::raw::c_int,
    ) -> LLONG;
}
unsafe extern "C" {
    pub fn do_cb(
        ctx: *mut lib_cc_decode,
        cc_block: *mut ::std::os::raw::c_uchar,
        sub: *mut cc_subtitle,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn printdata(
        ctx: *mut lib_cc_decode,
        data1: *const ::std::os::raw::c_uchar,
        length1: ::std::os::raw::c_int,
        data2: *const ::std::os::raw::c_uchar,
        length2: ::std::os::raw::c_int,
        sub: *mut cc_subtitle,
    );
}
unsafe extern "C" {
    pub fn dtvcc_process_data(dtvcc: *mut dtvcc_ctx, data: *const ::std::os::raw::c_uchar);
}
unsafe extern "C" {
    pub fn dtvcc_init(opts: *mut ccx_decoder_dtvcc_settings) -> *mut dtvcc_ctx;
}
unsafe extern "C" {
    pub fn dtvcc_free(arg1: *mut *mut dtvcc_ctx);
}
unsafe extern "C" {
    pub fn ccxr_dtvcc_init(
        settings_dtvcc: *mut ccx_decoder_dtvcc_settings,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn ccxr_dtvcc_free(dtvcc_rust: *mut ::std::os::raw::c_void);
}
unsafe extern "C" {
    pub fn ccxr_dtvcc_process_data(
        dtvcc_rust: *mut ::std::os::raw::c_void,
        cc_valid: ::std::os::raw::c_uchar,
        cc_type: ::std::os::raw::c_uchar,
        data1: ::std::os::raw::c_uchar,
        data2: ::std::os::raw::c_uchar,
    );
}
unsafe extern "C" {
    pub fn ccxr_dtvcc_is_active(dtvcc_rust: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn ccxr_dtvcc_set_active(
        dtvcc_rust: *mut ::std::os::raw::c_void,
        active: ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn dtvcc_write_done(tv: *mut dtvcc_tv_screen, encoder: *mut encoder_ctx);
}
unsafe extern "C" {
    pub fn dtvcc_writer_init(
        writer: *mut dtvcc_writer_ctx,
        base_filename: *mut ::std::os::raw::c_char,
        program_number: ::std::os::raw::c_int,
        service_number: ::std::os::raw::c_int,
        write_format: ccx_output_format,
        cfg: *mut encoder_cfg,
    );
}
unsafe extern "C" {
    pub fn dtvcc_writer_cleanup(writer: *mut dtvcc_writer_ctx);
}
unsafe extern "C" {
    pub fn dtvcc_writer_output(
        writer: *mut dtvcc_writer_ctx,
        decoder: *mut dtvcc_service_decoder,
        encoder: *mut encoder_ctx,
    );
}
unsafe extern "C" {
    pub fn dtvcc_is_row_empty(
        tv: *mut dtvcc_tv_screen,
        row_index: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn dtvcc_is_screen_empty(
        tv: *mut dtvcc_tv_screen,
        encoder: *mut encoder_ctx,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn dtvcc_get_write_interval(
        tv: *mut dtvcc_tv_screen,
        row_index: ::std::os::raw::c_int,
        first: *mut ::std::os::raw::c_int,
        last: *mut ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn dtvcc_color_to_hex(
        color: ::std::os::raw::c_int,
        hR: *mut ::std::os::raw::c_uint,
        hG: *mut ::std::os::raw::c_uint,
        hB: *mut ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn dtvcc_change_pen_colors(
        tv: *mut dtvcc_tv_screen,
        pen_color: dtvcc_pen_color,
        row_index: ::std::os::raw::c_int,
        column_index: ::std::os::raw::c_int,
        encoder: *mut encoder_ctx,
        buf_len: *mut usize,
        open: ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn dtvcc_change_pen_attribs(
        tv: *mut dtvcc_tv_screen,
        pen_attribs: dtvcc_pen_attribs,
        row_index: ::std::os::raw::c_int,
        column_index: ::std::os::raw::c_int,
        encoder: *mut encoder_ctx,
        buf_len: *mut usize,
        open: ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn dtvcc_write_row(
        writer: *mut dtvcc_writer_ctx,
        decoder: *mut dtvcc_service_decoder,
        row_index: ::std::os::raw::c_int,
        encoder: *mut encoder_ctx,
        use_colors: ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn dtvcc_write_srt(
        writer: *mut dtvcc_writer_ctx,
        decoder: *mut dtvcc_service_decoder,
        encoder: *mut encoder_ctx,
    );
}
unsafe extern "C" {
    pub fn dtvcc_write_debug(tv: *mut dtvcc_tv_screen);
}
unsafe extern "C" {
    pub fn dtvcc_write_transcript(
        writer: *mut dtvcc_writer_ctx,
        decoder: *mut dtvcc_service_decoder,
        encoder: *mut encoder_ctx,
    );
}
unsafe extern "C" {
    pub fn dtvcc_write_sami_header(tv: *mut dtvcc_tv_screen, encoder: *mut encoder_ctx);
}
unsafe extern "C" {
    pub fn dtvcc_write_sami_footer(tv: *mut dtvcc_tv_screen, encoder: *mut encoder_ctx);
}
unsafe extern "C" {
    pub fn dtvcc_write_sami(
        writer: *mut dtvcc_writer_ctx,
        decoder: *mut dtvcc_service_decoder,
        encoder: *mut encoder_ctx,
    );
}
unsafe extern "C" {
    pub fn dtvcc_write_scc_header(tv: *mut dtvcc_tv_screen, encoder: *mut encoder_ctx);
}
unsafe extern "C" {
    pub fn dtvcc_write_scc(
        writer: *mut dtvcc_writer_ctx,
        decoder: *mut dtvcc_service_decoder,
        encoder: *mut encoder_ctx,
    );
}
unsafe extern "C" {
    pub fn dtvcc_write(
        writer: *mut dtvcc_writer_ctx,
        decoder: *mut dtvcc_service_decoder,
        encoder: *mut encoder_ctx,
    );
}
unsafe extern "C" {
    pub fn dtvcc_get_internal_from_G0(g0_char: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
}
unsafe extern "C" {
    pub fn dtvcc_get_internal_from_G1(g1_char: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
}
unsafe extern "C" {
    pub fn dtvcc_get_internal_from_G2(g2_char: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
}
unsafe extern "C" {
    pub fn dtvcc_get_internal_from_G3(g3_char: ::std::os::raw::c_uchar) -> ::std::os::raw::c_uchar;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PMT_entry {
    pub program_number: ::std::os::raw::c_uint,
    pub elementary_PID: ::std::os::raw::c_uint,
    pub stream_type: ccx_stream_type,
    pub printable_stream_type: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of PMT_entry"][::std::mem::size_of::<PMT_entry>() - 16usize];
    ["Alignment of PMT_entry"][::std::mem::align_of::<PMT_entry>() - 4usize];
    ["Offset of field: PMT_entry::program_number"]
        [::std::mem::offset_of!(PMT_entry, program_number) - 0usize];
    ["Offset of field: PMT_entry::elementary_PID"]
        [::std::mem::offset_of!(PMT_entry, elementary_PID) - 4usize];
    ["Offset of field: PMT_entry::stream_type"]
        [::std::mem::offset_of!(PMT_entry, stream_type) - 8usize];
    ["Offset of field: PMT_entry::printable_stream_type"]
        [::std::mem::offset_of!(PMT_entry, printable_stream_type) - 12usize];
};
impl Default for PMT_entry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PSI_buffer {
    pub prev_ccounter: u32,
    pub buffer: *mut u8,
    pub buffer_length: u32,
    pub ccounter: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of PSI_buffer"][::std::mem::size_of::<PSI_buffer>() - 24usize];
    ["Alignment of PSI_buffer"][::std::mem::align_of::<PSI_buffer>() - 8usize];
    ["Offset of field: PSI_buffer::prev_ccounter"]
        [::std::mem::offset_of!(PSI_buffer, prev_ccounter) - 0usize];
    ["Offset of field: PSI_buffer::buffer"][::std::mem::offset_of!(PSI_buffer, buffer) - 8usize];
    ["Offset of field: PSI_buffer::buffer_length"]
        [::std::mem::offset_of!(PSI_buffer, buffer_length) - 16usize];
    ["Offset of field: PSI_buffer::ccounter"]
        [::std::mem::offset_of!(PSI_buffer, ccounter) - 20usize];
};
impl Default for PSI_buffer {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct EPG_rating {
    pub country_code: [::std::os::raw::c_char; 4usize],
    pub age: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of EPG_rating"][::std::mem::size_of::<EPG_rating>() - 5usize];
    ["Alignment of EPG_rating"][::std::mem::align_of::<EPG_rating>() - 1usize];
    ["Offset of field: EPG_rating::country_code"]
        [::std::mem::offset_of!(EPG_rating, country_code) - 0usize];
    ["Offset of field: EPG_rating::age"][::std::mem::offset_of!(EPG_rating, age) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EPG_event {
    pub id: u32,
    pub start_time_string: [::std::os::raw::c_char; 74usize],
    pub end_time_string: [::std::os::raw::c_char; 74usize],
    pub running_status: u8,
    pub free_ca_mode: u8,
    pub ISO_639_language_code: [::std::os::raw::c_char; 4usize],
    pub event_name: *mut ::std::os::raw::c_char,
    pub text: *mut ::std::os::raw::c_char,
    pub extended_ISO_639_language_code: [::std::os::raw::c_char; 4usize],
    pub extended_text: *mut ::std::os::raw::c_char,
    pub has_simple: u8,
    pub ratings: *mut EPG_rating,
    pub num_ratings: u32,
    pub categories: *mut u8,
    pub num_categories: u32,
    pub service_id: u16,
    pub count: ::std::os::raw::c_longlong,
    pub live_output: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of EPG_event"][::std::mem::size_of::<EPG_event>() - 248usize];
    ["Alignment of EPG_event"][::std::mem::align_of::<EPG_event>() - 8usize];
    ["Offset of field: EPG_event::id"][::std::mem::offset_of!(EPG_event, id) - 0usize];
    ["Offset of field: EPG_event::start_time_string"]
        [::std::mem::offset_of!(EPG_event, start_time_string) - 4usize];
    ["Offset of field: EPG_event::end_time_string"]
        [::std::mem::offset_of!(EPG_event, end_time_string) - 78usize];
    ["Offset of field: EPG_event::running_status"]
        [::std::mem::offset_of!(EPG_event, running_status) - 152usize];
    ["Offset of field: EPG_event::free_ca_mode"]
        [::std::mem::offset_of!(EPG_event, free_ca_mode) - 153usize];
    ["Offset of field: EPG_event::ISO_639_language_code"]
        [::std::mem::offset_of!(EPG_event, ISO_639_language_code) - 154usize];
    ["Offset of field: EPG_event::event_name"]
        [::std::mem::offset_of!(EPG_event, event_name) - 160usize];
    ["Offset of field: EPG_event::text"][::std::mem::offset_of!(EPG_event, text) - 168usize];
    ["Offset of field: EPG_event::extended_ISO_639_language_code"]
        [::std::mem::offset_of!(EPG_event, extended_ISO_639_language_code) - 176usize];
    ["Offset of field: EPG_event::extended_text"]
        [::std::mem::offset_of!(EPG_event, extended_text) - 184usize];
    ["Offset of field: EPG_event::has_simple"]
        [::std::mem::offset_of!(EPG_event, has_simple) - 192usize];
    ["Offset of field: EPG_event::ratings"][::std::mem::offset_of!(EPG_event, ratings) - 200usize];
    ["Offset of field: EPG_event::num_ratings"]
        [::std::mem::offset_of!(EPG_event, num_ratings) - 208usize];
    ["Offset of field: EPG_event::categories"]
        [::std::mem::offset_of!(EPG_event, categories) - 216usize];
    ["Offset of field: EPG_event::num_categories"]
        [::std::mem::offset_of!(EPG_event, num_categories) - 224usize];
    ["Offset of field: EPG_event::service_id"]
        [::std::mem::offset_of!(EPG_event, service_id) - 228usize];
    ["Offset of field: EPG_event::count"][::std::mem::offset_of!(EPG_event, count) - 232usize];
    ["Offset of field: EPG_event::live_output"]
        [::std::mem::offset_of!(EPG_event, live_output) - 240usize];
};
impl Default for EPG_event {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EIT_program {
    pub array_len: u32,
    pub epg_events: [EPG_event; 10080usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of EIT_program"][::std::mem::size_of::<EIT_program>() - 2499848usize];
    ["Alignment of EIT_program"][::std::mem::align_of::<EIT_program>() - 8usize];
    ["Offset of field: EIT_program::array_len"]
        [::std::mem::offset_of!(EIT_program, array_len) - 0usize];
    ["Offset of field: EIT_program::epg_events"]
        [::std::mem::offset_of!(EIT_program, epg_events) - 8usize];
};
impl Default for EIT_program {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ccx_rational {
    pub num: ::std::os::raw::c_int,
    pub den: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_rational"][::std::mem::size_of::<ccx_rational>() - 8usize];
    ["Alignment of ccx_rational"][::std::mem::align_of::<ccx_rational>() - 4usize];
    ["Offset of field: ccx_rational::num"][::std::mem::offset_of!(ccx_rational, num) - 0usize];
    ["Offset of field: ccx_rational::den"][::std::mem::offset_of!(ccx_rational, den) - 4usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ccx_demux_report {
    pub program_cnt: ::std::os::raw::c_uint,
    pub dvb_sub_pid: [::std::os::raw::c_uint; 10usize],
    pub tlt_sub_pid: [::std::os::raw::c_uint; 10usize],
    pub mp4_cc_track_cnt: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_demux_report"][::std::mem::size_of::<ccx_demux_report>() - 88usize];
    ["Alignment of ccx_demux_report"][::std::mem::align_of::<ccx_demux_report>() - 4usize];
    ["Offset of field: ccx_demux_report::program_cnt"]
        [::std::mem::offset_of!(ccx_demux_report, program_cnt) - 0usize];
    ["Offset of field: ccx_demux_report::dvb_sub_pid"]
        [::std::mem::offset_of!(ccx_demux_report, dvb_sub_pid) - 4usize];
    ["Offset of field: ccx_demux_report::tlt_sub_pid"]
        [::std::mem::offset_of!(ccx_demux_report, tlt_sub_pid) - 44usize];
    ["Offset of field: ccx_demux_report::mp4_cc_track_cnt"]
        [::std::mem::offset_of!(ccx_demux_report, mp4_cc_track_cnt) - 84usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct program_info {
    pub pid: ::std::os::raw::c_int,
    pub program_number: ::std::os::raw::c_int,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub version: u8,
    pub saved_section: [u8; 1021usize],
    pub crc: i32,
    pub _bitfield_align_2: [u8; 0],
    pub _bitfield_2: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub name: [::std::os::raw::c_char; 128usize],
    #[doc = " -1 pid represent that pcr_pid is not available"]
    pub pcr_pid: i16,
    pub got_important_streams_min_pts: [u64; 3usize],
    pub has_all_min_pts: ::std::os::raw::c_int,
    pub virtual_channel: [::std::os::raw::c_char; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of program_info"][::std::mem::size_of::<program_info>() - 1216usize];
    ["Alignment of program_info"][::std::mem::align_of::<program_info>() - 8usize];
    ["Offset of field: program_info::pid"][::std::mem::offset_of!(program_info, pid) - 0usize];
    ["Offset of field: program_info::program_number"]
        [::std::mem::offset_of!(program_info, program_number) - 4usize];
    ["Offset of field: program_info::version"]
        [::std::mem::offset_of!(program_info, version) - 9usize];
    ["Offset of field: program_info::saved_section"]
        [::std::mem::offset_of!(program_info, saved_section) - 10usize];
    ["Offset of field: program_info::crc"][::std::mem::offset_of!(program_info, crc) - 1032usize];
    ["Offset of field: program_info::name"][::std::mem::offset_of!(program_info, name) - 1037usize];
    ["Offset of field: program_info::pcr_pid"]
        [::std::mem::offset_of!(program_info, pcr_pid) - 1166usize];
    ["Offset of field: program_info::got_important_streams_min_pts"]
        [::std::mem::offset_of!(program_info, got_important_streams_min_pts) - 1168usize];
    ["Offset of field: program_info::has_all_min_pts"]
        [::std::mem::offset_of!(program_info, has_all_min_pts) - 1192usize];
    ["Offset of field: program_info::virtual_channel"]
        [::std::mem::offset_of!(program_info, virtual_channel) - 1196usize];
};
impl Default for program_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl program_info {
    #[inline]
    pub fn analysed_PMT_once(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_analysed_PMT_once(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn analysed_PMT_once_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_analysed_PMT_once_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(analysed_PMT_once: u8) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let analysed_PMT_once: u8 = unsafe { ::std::mem::transmute(analysed_PMT_once) };
            analysed_PMT_once as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn valid_crc(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_valid_crc(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn valid_crc_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_valid_crc_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_2(valid_crc: u8) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let valid_crc: u8 = unsafe { ::std::mem::transmute(valid_crc) };
            valid_crc as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cap_info {
    pub pid: ::std::os::raw::c_int,
    pub program_number: ::std::os::raw::c_int,
    pub stream: ccx_stream_type,
    pub codec: ccx_code_type,
    pub capbufsize: i64,
    pub capbuf: *mut ::std::os::raw::c_uchar,
    pub capbuflen: i64,
    pub saw_pesstart: ::std::os::raw::c_int,
    pub prev_counter: ::std::os::raw::c_int,
    pub codec_private_data: *mut ::std::os::raw::c_void,
    pub ignore: ::std::os::raw::c_int,
    #[doc = "List joining all stream in TS"]
    pub all_stream: list_head,
    #[doc = "List joining all sibling Stream in Program"]
    pub sib_head: list_head,
    pub sib_stream: list_head,
    #[doc = "List joining all sibling Stream in Program"]
    pub pg_stream: list_head,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of cap_info"][::std::mem::size_of::<cap_info>() - 128usize];
    ["Alignment of cap_info"][::std::mem::align_of::<cap_info>() - 8usize];
    ["Offset of field: cap_info::pid"][::std::mem::offset_of!(cap_info, pid) - 0usize];
    ["Offset of field: cap_info::program_number"]
        [::std::mem::offset_of!(cap_info, program_number) - 4usize];
    ["Offset of field: cap_info::stream"][::std::mem::offset_of!(cap_info, stream) - 8usize];
    ["Offset of field: cap_info::codec"][::std::mem::offset_of!(cap_info, codec) - 12usize];
    ["Offset of field: cap_info::capbufsize"]
        [::std::mem::offset_of!(cap_info, capbufsize) - 16usize];
    ["Offset of field: cap_info::capbuf"][::std::mem::offset_of!(cap_info, capbuf) - 24usize];
    ["Offset of field: cap_info::capbuflen"][::std::mem::offset_of!(cap_info, capbuflen) - 32usize];
    ["Offset of field: cap_info::saw_pesstart"]
        [::std::mem::offset_of!(cap_info, saw_pesstart) - 40usize];
    ["Offset of field: cap_info::prev_counter"]
        [::std::mem::offset_of!(cap_info, prev_counter) - 44usize];
    ["Offset of field: cap_info::codec_private_data"]
        [::std::mem::offset_of!(cap_info, codec_private_data) - 48usize];
    ["Offset of field: cap_info::ignore"][::std::mem::offset_of!(cap_info, ignore) - 56usize];
    ["Offset of field: cap_info::all_stream"]
        [::std::mem::offset_of!(cap_info, all_stream) - 64usize];
    ["Offset of field: cap_info::sib_head"][::std::mem::offset_of!(cap_info, sib_head) - 80usize];
    ["Offset of field: cap_info::sib_stream"]
        [::std::mem::offset_of!(cap_info, sib_stream) - 96usize];
    ["Offset of field: cap_info::pg_stream"]
        [::std::mem::offset_of!(cap_info, pg_stream) - 112usize];
};
impl Default for cap_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ccx_demuxer {
    pub m2ts: ::std::os::raw::c_int,
    pub stream_mode: ccx_stream_mode_enum,
    pub auto_stream: ccx_stream_mode_enum,
    pub startbytes: [::std::os::raw::c_uchar; 1048576usize],
    pub startbytes_pos: ::std::os::raw::c_uint,
    pub startbytes_avail: ::std::os::raw::c_int,
    pub ts_autoprogram: ::std::os::raw::c_int,
    pub ts_allprogram: ::std::os::raw::c_int,
    pub flag_ts_forced_pn: ::std::os::raw::c_int,
    pub flag_ts_forced_cappid: ::std::os::raw::c_int,
    pub ts_datastreamtype: ::std::os::raw::c_int,
    pub pinfo: [program_info; 128usize],
    pub nb_program: ::std::os::raw::c_int,
    pub codec: ccx_code_type,
    pub nocodec: ccx_code_type,
    pub cinfo_tree: cap_info,
    pub infd: ::std::os::raw::c_int,
    pub past: LLONG,
    pub global_timestamp: i64,
    pub min_global_timestamp: i64,
    pub offset_global_timestamp: i64,
    pub last_global_timestamp: i64,
    pub global_timestamp_inited: ::std::os::raw::c_int,
    pub PID_buffers: [*mut PSI_buffer; 8191usize],
    pub PIDs_seen: [::std::os::raw::c_int; 65536usize],
    pub stream_id_of_each_pid: [u8; 8192usize],
    pub min_pts: [u64; 8192usize],
    pub have_PIDs: [::std::os::raw::c_int; 8192usize],
    pub num_of_PIDs: ::std::os::raw::c_int,
    pub PIDs_programs: [*mut PMT_entry; 65536usize],
    pub freport: ccx_demux_report,
    pub hauppauge_warning_shown: ::std::os::raw::c_uint,
    pub multi_stream_per_prog: ::std::os::raw::c_int,
    pub last_pat_payload: *mut ::std::os::raw::c_uchar,
    pub last_pat_length: ::std::os::raw::c_uint,
    pub filebuffer: *mut ::std::os::raw::c_uchar,
    pub filebuffer_start: LLONG,
    pub filebuffer_pos: ::std::os::raw::c_uint,
    pub bytesinbuffer: ::std::os::raw::c_uint,
    pub warning_program_not_found_shown: ::std::os::raw::c_int,
    pub strangeheader: ::std::os::raw::c_int,
    pub parent: *mut ::std::os::raw::c_void,
    pub private_data: *mut ::std::os::raw::c_void,
    pub print_cfg: ::std::option::Option<unsafe extern "C" fn(ctx: *mut ccx_demuxer)>,
    pub reset: ::std::option::Option<unsafe extern "C" fn(ctx: *mut ccx_demuxer)>,
    pub close: ::std::option::Option<unsafe extern "C" fn(ctx: *mut ccx_demuxer)>,
    pub open: ::std::option::Option<
        unsafe extern "C" fn(
            ctx: *mut ccx_demuxer,
            file_name: *const ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
    >,
    pub is_open:
        ::std::option::Option<unsafe extern "C" fn(ctx: *mut ccx_demuxer) -> ::std::os::raw::c_int>,
    pub get_stream_mode:
        ::std::option::Option<unsafe extern "C" fn(ctx: *mut ccx_demuxer) -> ::std::os::raw::c_int>,
    pub get_filesize: ::std::option::Option<unsafe extern "C" fn(ctx: *mut ccx_demuxer) -> LLONG>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_demuxer"][::std::mem::size_of::<ccx_demuxer>() - 2163144usize];
    ["Alignment of ccx_demuxer"][::std::mem::align_of::<ccx_demuxer>() - 8usize];
    ["Offset of field: ccx_demuxer::m2ts"][::std::mem::offset_of!(ccx_demuxer, m2ts) - 0usize];
    ["Offset of field: ccx_demuxer::stream_mode"]
        [::std::mem::offset_of!(ccx_demuxer, stream_mode) - 4usize];
    ["Offset of field: ccx_demuxer::auto_stream"]
        [::std::mem::offset_of!(ccx_demuxer, auto_stream) - 8usize];
    ["Offset of field: ccx_demuxer::startbytes"]
        [::std::mem::offset_of!(ccx_demuxer, startbytes) - 12usize];
    ["Offset of field: ccx_demuxer::startbytes_pos"]
        [::std::mem::offset_of!(ccx_demuxer, startbytes_pos) - 1048588usize];
    ["Offset of field: ccx_demuxer::startbytes_avail"]
        [::std::mem::offset_of!(ccx_demuxer, startbytes_avail) - 1048592usize];
    ["Offset of field: ccx_demuxer::ts_autoprogram"]
        [::std::mem::offset_of!(ccx_demuxer, ts_autoprogram) - 1048596usize];
    ["Offset of field: ccx_demuxer::ts_allprogram"]
        [::std::mem::offset_of!(ccx_demuxer, ts_allprogram) - 1048600usize];
    ["Offset of field: ccx_demuxer::flag_ts_forced_pn"]
        [::std::mem::offset_of!(ccx_demuxer, flag_ts_forced_pn) - 1048604usize];
    ["Offset of field: ccx_demuxer::flag_ts_forced_cappid"]
        [::std::mem::offset_of!(ccx_demuxer, flag_ts_forced_cappid) - 1048608usize];
    ["Offset of field: ccx_demuxer::ts_datastreamtype"]
        [::std::mem::offset_of!(ccx_demuxer, ts_datastreamtype) - 1048612usize];
    ["Offset of field: ccx_demuxer::pinfo"]
        [::std::mem::offset_of!(ccx_demuxer, pinfo) - 1048616usize];
    ["Offset of field: ccx_demuxer::nb_program"]
        [::std::mem::offset_of!(ccx_demuxer, nb_program) - 1204264usize];
    ["Offset of field: ccx_demuxer::codec"]
        [::std::mem::offset_of!(ccx_demuxer, codec) - 1204268usize];
    ["Offset of field: ccx_demuxer::nocodec"]
        [::std::mem::offset_of!(ccx_demuxer, nocodec) - 1204272usize];
    ["Offset of field: ccx_demuxer::cinfo_tree"]
        [::std::mem::offset_of!(ccx_demuxer, cinfo_tree) - 1204280usize];
    ["Offset of field: ccx_demuxer::infd"]
        [::std::mem::offset_of!(ccx_demuxer, infd) - 1204408usize];
    ["Offset of field: ccx_demuxer::past"]
        [::std::mem::offset_of!(ccx_demuxer, past) - 1204416usize];
    ["Offset of field: ccx_demuxer::global_timestamp"]
        [::std::mem::offset_of!(ccx_demuxer, global_timestamp) - 1204424usize];
    ["Offset of field: ccx_demuxer::min_global_timestamp"]
        [::std::mem::offset_of!(ccx_demuxer, min_global_timestamp) - 1204432usize];
    ["Offset of field: ccx_demuxer::offset_global_timestamp"]
        [::std::mem::offset_of!(ccx_demuxer, offset_global_timestamp) - 1204440usize];
    ["Offset of field: ccx_demuxer::last_global_timestamp"]
        [::std::mem::offset_of!(ccx_demuxer, last_global_timestamp) - 1204448usize];
    ["Offset of field: ccx_demuxer::global_timestamp_inited"]
        [::std::mem::offset_of!(ccx_demuxer, global_timestamp_inited) - 1204456usize];
    ["Offset of field: ccx_demuxer::PID_buffers"]
        [::std::mem::offset_of!(ccx_demuxer, PID_buffers) - 1204464usize];
    ["Offset of field: ccx_demuxer::PIDs_seen"]
        [::std::mem::offset_of!(ccx_demuxer, PIDs_seen) - 1269992usize];
    ["Offset of field: ccx_demuxer::stream_id_of_each_pid"]
        [::std::mem::offset_of!(ccx_demuxer, stream_id_of_each_pid) - 1532136usize];
    ["Offset of field: ccx_demuxer::min_pts"]
        [::std::mem::offset_of!(ccx_demuxer, min_pts) - 1540328usize];
    ["Offset of field: ccx_demuxer::have_PIDs"]
        [::std::mem::offset_of!(ccx_demuxer, have_PIDs) - 1605864usize];
    ["Offset of field: ccx_demuxer::num_of_PIDs"]
        [::std::mem::offset_of!(ccx_demuxer, num_of_PIDs) - 1638632usize];
    ["Offset of field: ccx_demuxer::PIDs_programs"]
        [::std::mem::offset_of!(ccx_demuxer, PIDs_programs) - 1638640usize];
    ["Offset of field: ccx_demuxer::freport"]
        [::std::mem::offset_of!(ccx_demuxer, freport) - 2162928usize];
    ["Offset of field: ccx_demuxer::hauppauge_warning_shown"]
        [::std::mem::offset_of!(ccx_demuxer, hauppauge_warning_shown) - 2163016usize];
    ["Offset of field: ccx_demuxer::multi_stream_per_prog"]
        [::std::mem::offset_of!(ccx_demuxer, multi_stream_per_prog) - 2163020usize];
    ["Offset of field: ccx_demuxer::last_pat_payload"]
        [::std::mem::offset_of!(ccx_demuxer, last_pat_payload) - 2163024usize];
    ["Offset of field: ccx_demuxer::last_pat_length"]
        [::std::mem::offset_of!(ccx_demuxer, last_pat_length) - 2163032usize];
    ["Offset of field: ccx_demuxer::filebuffer"]
        [::std::mem::offset_of!(ccx_demuxer, filebuffer) - 2163040usize];
    ["Offset of field: ccx_demuxer::filebuffer_start"]
        [::std::mem::offset_of!(ccx_demuxer, filebuffer_start) - 2163048usize];
    ["Offset of field: ccx_demuxer::filebuffer_pos"]
        [::std::mem::offset_of!(ccx_demuxer, filebuffer_pos) - 2163056usize];
    ["Offset of field: ccx_demuxer::bytesinbuffer"]
        [::std::mem::offset_of!(ccx_demuxer, bytesinbuffer) - 2163060usize];
    ["Offset of field: ccx_demuxer::warning_program_not_found_shown"]
        [::std::mem::offset_of!(ccx_demuxer, warning_program_not_found_shown) - 2163064usize];
    ["Offset of field: ccx_demuxer::strangeheader"]
        [::std::mem::offset_of!(ccx_demuxer, strangeheader) - 2163068usize];
    ["Offset of field: ccx_demuxer::parent"]
        [::std::mem::offset_of!(ccx_demuxer, parent) - 2163072usize];
    ["Offset of field: ccx_demuxer::private_data"]
        [::std::mem::offset_of!(ccx_demuxer, private_data) - 2163080usize];
    ["Offset of field: ccx_demuxer::print_cfg"]
        [::std::mem::offset_of!(ccx_demuxer, print_cfg) - 2163088usize];
    ["Offset of field: ccx_demuxer::reset"]
        [::std::mem::offset_of!(ccx_demuxer, reset) - 2163096usize];
    ["Offset of field: ccx_demuxer::close"]
        [::std::mem::offset_of!(ccx_demuxer, close) - 2163104usize];
    ["Offset of field: ccx_demuxer::open"]
        [::std::mem::offset_of!(ccx_demuxer, open) - 2163112usize];
    ["Offset of field: ccx_demuxer::is_open"]
        [::std::mem::offset_of!(ccx_demuxer, is_open) - 2163120usize];
    ["Offset of field: ccx_demuxer::get_stream_mode"]
        [::std::mem::offset_of!(ccx_demuxer, get_stream_mode) - 2163128usize];
    ["Offset of field: ccx_demuxer::get_filesize"]
        [::std::mem::offset_of!(ccx_demuxer, get_filesize) - 2163136usize];
};
impl Default for ccx_demuxer {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct demuxer_data {
    pub program_number: ::std::os::raw::c_int,
    pub stream_pid: ::std::os::raw::c_int,
    pub codec: ccx_code_type,
    pub bufferdatatype: ccx_bufferdata_type,
    pub buffer: *mut ::std::os::raw::c_uchar,
    pub len: usize,
    pub rollover_bits: ::std::os::raw::c_uint,
    pub pts: LLONG,
    pub tb: ccx_rational,
    pub next_stream: *mut demuxer_data,
    pub next_program: *mut demuxer_data,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of demuxer_data"][::std::mem::size_of::<demuxer_data>() - 72usize];
    ["Alignment of demuxer_data"][::std::mem::align_of::<demuxer_data>() - 8usize];
    ["Offset of field: demuxer_data::program_number"]
        [::std::mem::offset_of!(demuxer_data, program_number) - 0usize];
    ["Offset of field: demuxer_data::stream_pid"]
        [::std::mem::offset_of!(demuxer_data, stream_pid) - 4usize];
    ["Offset of field: demuxer_data::codec"][::std::mem::offset_of!(demuxer_data, codec) - 8usize];
    ["Offset of field: demuxer_data::bufferdatatype"]
        [::std::mem::offset_of!(demuxer_data, bufferdatatype) - 12usize];
    ["Offset of field: demuxer_data::buffer"]
        [::std::mem::offset_of!(demuxer_data, buffer) - 16usize];
    ["Offset of field: demuxer_data::len"][::std::mem::offset_of!(demuxer_data, len) - 24usize];
    ["Offset of field: demuxer_data::rollover_bits"]
        [::std::mem::offset_of!(demuxer_data, rollover_bits) - 32usize];
    ["Offset of field: demuxer_data::pts"][::std::mem::offset_of!(demuxer_data, pts) - 40usize];
    ["Offset of field: demuxer_data::tb"][::std::mem::offset_of!(demuxer_data, tb) - 48usize];
    ["Offset of field: demuxer_data::next_stream"]
        [::std::mem::offset_of!(demuxer_data, next_stream) - 56usize];
    ["Offset of field: demuxer_data::next_program"]
        [::std::mem::offset_of!(demuxer_data, next_program) - 64usize];
};
impl Default for demuxer_data {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bitstream {
    pub pos: *mut ::std::os::raw::c_uchar,
    pub bpos: ::std::os::raw::c_int,
    pub end: *mut ::std::os::raw::c_uchar,
    pub bitsleft: i64,
    pub error: ::std::os::raw::c_int,
    pub _i_pos: *mut ::std::os::raw::c_uchar,
    pub _i_bpos: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of bitstream"][::std::mem::size_of::<bitstream>() - 56usize];
    ["Alignment of bitstream"][::std::mem::align_of::<bitstream>() - 8usize];
    ["Offset of field: bitstream::pos"][::std::mem::offset_of!(bitstream, pos) - 0usize];
    ["Offset of field: bitstream::bpos"][::std::mem::offset_of!(bitstream, bpos) - 8usize];
    ["Offset of field: bitstream::end"][::std::mem::offset_of!(bitstream, end) - 16usize];
    ["Offset of field: bitstream::bitsleft"][::std::mem::offset_of!(bitstream, bitsleft) - 24usize];
    ["Offset of field: bitstream::error"][::std::mem::offset_of!(bitstream, error) - 32usize];
    ["Offset of field: bitstream::_i_pos"][::std::mem::offset_of!(bitstream, _i_pos) - 40usize];
    ["Offset of field: bitstream::_i_bpos"][::std::mem::offset_of!(bitstream, _i_bpos) - 48usize];
};
impl Default for bitstream {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn net_send_header(data: *const ::std::os::raw::c_uchar, len: usize);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct avc_ctx {
    pub cc_count: ::std::os::raw::c_uchar,
    pub cc_data: *mut ::std::os::raw::c_uchar,
    pub cc_databufsize: i64,
    pub cc_buffer_saved: ::std::os::raw::c_int,
    pub is_hevc: ::std::os::raw::c_int,
    pub got_seq_para: ::std::os::raw::c_int,
    pub nal_ref_idc: ::std::os::raw::c_uint,
    pub seq_parameter_set_id: LLONG,
    pub log2_max_frame_num: ::std::os::raw::c_int,
    pub pic_order_cnt_type: ::std::os::raw::c_int,
    pub log2_max_pic_order_cnt_lsb: ::std::os::raw::c_int,
    pub frame_mbs_only_flag: ::std::os::raw::c_int,
    pub num_nal_unit_type_7: i64,
    pub num_vcl_hrd: i64,
    pub num_nal_hrd: i64,
    pub num_jump_in_frames: i64,
    pub num_unexpected_sei_length: i64,
    pub ccblocks_in_avc_total: ::std::os::raw::c_int,
    pub ccblocks_in_avc_lost: ::std::os::raw::c_int,
    pub frame_num: LLONG,
    pub lastframe_num: LLONG,
    pub currref: ::std::os::raw::c_int,
    pub maxidx: ::std::os::raw::c_int,
    pub lastmaxidx: ::std::os::raw::c_int,
    pub minidx: ::std::os::raw::c_int,
    pub lastminidx: ::std::os::raw::c_int,
    pub maxtref: ::std::os::raw::c_int,
    pub last_gop_maxtref: ::std::os::raw::c_int,
    pub currefpts: LLONG,
    pub last_pic_order_cnt_lsb: LLONG,
    pub last_slice_pts: LLONG,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of avc_ctx"][::std::mem::size_of::<avc_ctx>() - 184usize];
    ["Alignment of avc_ctx"][::std::mem::align_of::<avc_ctx>() - 8usize];
    ["Offset of field: avc_ctx::cc_count"][::std::mem::offset_of!(avc_ctx, cc_count) - 0usize];
    ["Offset of field: avc_ctx::cc_data"][::std::mem::offset_of!(avc_ctx, cc_data) - 8usize];
    ["Offset of field: avc_ctx::cc_databufsize"]
        [::std::mem::offset_of!(avc_ctx, cc_databufsize) - 16usize];
    ["Offset of field: avc_ctx::cc_buffer_saved"]
        [::std::mem::offset_of!(avc_ctx, cc_buffer_saved) - 24usize];
    ["Offset of field: avc_ctx::is_hevc"][::std::mem::offset_of!(avc_ctx, is_hevc) - 28usize];
    ["Offset of field: avc_ctx::got_seq_para"]
        [::std::mem::offset_of!(avc_ctx, got_seq_para) - 32usize];
    ["Offset of field: avc_ctx::nal_ref_idc"]
        [::std::mem::offset_of!(avc_ctx, nal_ref_idc) - 36usize];
    ["Offset of field: avc_ctx::seq_parameter_set_id"]
        [::std::mem::offset_of!(avc_ctx, seq_parameter_set_id) - 40usize];
    ["Offset of field: avc_ctx::log2_max_frame_num"]
        [::std::mem::offset_of!(avc_ctx, log2_max_frame_num) - 48usize];
    ["Offset of field: avc_ctx::pic_order_cnt_type"]
        [::std::mem::offset_of!(avc_ctx, pic_order_cnt_type) - 52usize];
    ["Offset of field: avc_ctx::log2_max_pic_order_cnt_lsb"]
        [::std::mem::offset_of!(avc_ctx, log2_max_pic_order_cnt_lsb) - 56usize];
    ["Offset of field: avc_ctx::frame_mbs_only_flag"]
        [::std::mem::offset_of!(avc_ctx, frame_mbs_only_flag) - 60usize];
    ["Offset of field: avc_ctx::num_nal_unit_type_7"]
        [::std::mem::offset_of!(avc_ctx, num_nal_unit_type_7) - 64usize];
    ["Offset of field: avc_ctx::num_vcl_hrd"]
        [::std::mem::offset_of!(avc_ctx, num_vcl_hrd) - 72usize];
    ["Offset of field: avc_ctx::num_nal_hrd"]
        [::std::mem::offset_of!(avc_ctx, num_nal_hrd) - 80usize];
    ["Offset of field: avc_ctx::num_jump_in_frames"]
        [::std::mem::offset_of!(avc_ctx, num_jump_in_frames) - 88usize];
    ["Offset of field: avc_ctx::num_unexpected_sei_length"]
        [::std::mem::offset_of!(avc_ctx, num_unexpected_sei_length) - 96usize];
    ["Offset of field: avc_ctx::ccblocks_in_avc_total"]
        [::std::mem::offset_of!(avc_ctx, ccblocks_in_avc_total) - 104usize];
    ["Offset of field: avc_ctx::ccblocks_in_avc_lost"]
        [::std::mem::offset_of!(avc_ctx, ccblocks_in_avc_lost) - 108usize];
    ["Offset of field: avc_ctx::frame_num"][::std::mem::offset_of!(avc_ctx, frame_num) - 112usize];
    ["Offset of field: avc_ctx::lastframe_num"]
        [::std::mem::offset_of!(avc_ctx, lastframe_num) - 120usize];
    ["Offset of field: avc_ctx::currref"][::std::mem::offset_of!(avc_ctx, currref) - 128usize];
    ["Offset of field: avc_ctx::maxidx"][::std::mem::offset_of!(avc_ctx, maxidx) - 132usize];
    ["Offset of field: avc_ctx::lastmaxidx"]
        [::std::mem::offset_of!(avc_ctx, lastmaxidx) - 136usize];
    ["Offset of field: avc_ctx::minidx"][::std::mem::offset_of!(avc_ctx, minidx) - 140usize];
    ["Offset of field: avc_ctx::lastminidx"]
        [::std::mem::offset_of!(avc_ctx, lastminidx) - 144usize];
    ["Offset of field: avc_ctx::maxtref"][::std::mem::offset_of!(avc_ctx, maxtref) - 148usize];
    ["Offset of field: avc_ctx::last_gop_maxtref"]
        [::std::mem::offset_of!(avc_ctx, last_gop_maxtref) - 152usize];
    ["Offset of field: avc_ctx::currefpts"][::std::mem::offset_of!(avc_ctx, currefpts) - 160usize];
    ["Offset of field: avc_ctx::last_pic_order_cnt_lsb"]
        [::std::mem::offset_of!(avc_ctx, last_pic_order_cnt_lsb) - 168usize];
    ["Offset of field: avc_ctx::last_slice_pts"]
        [::std::mem::offset_of!(avc_ctx, last_slice_pts) - 176usize];
};
impl Default for avc_ctx {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct file_report {
    pub width: ::std::os::raw::c_uint,
    pub height: ::std::os::raw::c_uint,
    pub aspect_ratio: ::std::os::raw::c_uint,
    pub frame_rate: ::std::os::raw::c_uint,
    pub data_from_608: *mut ccx_decoder_608_report,
    pub data_from_708: *mut ccx_decoder_dtvcc_report,
    pub mp4_cc_track_cnt: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of file_report"][::std::mem::size_of::<file_report>() - 40usize];
    ["Alignment of file_report"][::std::mem::align_of::<file_report>() - 8usize];
    ["Offset of field: file_report::width"][::std::mem::offset_of!(file_report, width) - 0usize];
    ["Offset of field: file_report::height"][::std::mem::offset_of!(file_report, height) - 4usize];
    ["Offset of field: file_report::aspect_ratio"]
        [::std::mem::offset_of!(file_report, aspect_ratio) - 8usize];
    ["Offset of field: file_report::frame_rate"]
        [::std::mem::offset_of!(file_report, frame_rate) - 12usize];
    ["Offset of field: file_report::data_from_608"]
        [::std::mem::offset_of!(file_report, data_from_608) - 16usize];
    ["Offset of field: file_report::data_from_708"]
        [::std::mem::offset_of!(file_report, data_from_708) - 24usize];
    ["Offset of field: file_report::mp4_cc_track_cnt"]
        [::std::mem::offset_of!(file_report, mp4_cc_track_cnt) - 32usize];
};
impl Default for file_report {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ccx_s_teletext_config {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub page: u16,
    pub tid: u16,
    pub offset: f64,
    pub _bitfield_align_2: [u8; 0],
    pub _bitfield_2: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub user_page: u16,
    pub user_pages: [u16; 8usize],
    pub num_user_pages: ::std::os::raw::c_int,
    pub extract_all_pages: ::std::os::raw::c_int,
    pub dolevdist: ::std::os::raw::c_int,
    pub levdistmincnt: ::std::os::raw::c_int,
    pub levdistmaxpct: ::std::os::raw::c_int,
    pub extraction_start: ccx_boundary_time,
    pub extraction_end: ccx_boundary_time,
    pub write_format: ccx_output_format,
    pub gui_mode_reports: ::std::os::raw::c_int,
    pub date_format: ccx_output_date_format,
    pub noautotimeref: ::std::os::raw::c_int,
    pub send_to_srv: ::std::os::raw::c_uint,
    pub encoding: ccx_encoding_type,
    pub nofontcolor: ::std::os::raw::c_int,
    pub nohtmlescape: ::std::os::raw::c_int,
    pub millis_separator: ::std::os::raw::c_char,
    pub latrusmap: ::std::os::raw::c_int,
    pub forceg0latin: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_s_teletext_config"][::std::mem::size_of::<ccx_s_teletext_config>() - 168usize];
    ["Alignment of ccx_s_teletext_config"]
        [::std::mem::align_of::<ccx_s_teletext_config>() - 8usize];
    ["Offset of field: ccx_s_teletext_config::page"]
        [::std::mem::offset_of!(ccx_s_teletext_config, page) - 2usize];
    ["Offset of field: ccx_s_teletext_config::tid"]
        [::std::mem::offset_of!(ccx_s_teletext_config, tid) - 4usize];
    ["Offset of field: ccx_s_teletext_config::offset"]
        [::std::mem::offset_of!(ccx_s_teletext_config, offset) - 8usize];
    ["Offset of field: ccx_s_teletext_config::user_page"]
        [::std::mem::offset_of!(ccx_s_teletext_config, user_page) - 18usize];
    ["Offset of field: ccx_s_teletext_config::user_pages"]
        [::std::mem::offset_of!(ccx_s_teletext_config, user_pages) - 20usize];
    ["Offset of field: ccx_s_teletext_config::num_user_pages"]
        [::std::mem::offset_of!(ccx_s_teletext_config, num_user_pages) - 36usize];
    ["Offset of field: ccx_s_teletext_config::extract_all_pages"]
        [::std::mem::offset_of!(ccx_s_teletext_config, extract_all_pages) - 40usize];
    ["Offset of field: ccx_s_teletext_config::dolevdist"]
        [::std::mem::offset_of!(ccx_s_teletext_config, dolevdist) - 44usize];
    ["Offset of field: ccx_s_teletext_config::levdistmincnt"]
        [::std::mem::offset_of!(ccx_s_teletext_config, levdistmincnt) - 48usize];
    ["Offset of field: ccx_s_teletext_config::levdistmaxpct"]
        [::std::mem::offset_of!(ccx_s_teletext_config, levdistmaxpct) - 52usize];
    ["Offset of field: ccx_s_teletext_config::extraction_start"]
        [::std::mem::offset_of!(ccx_s_teletext_config, extraction_start) - 56usize];
    ["Offset of field: ccx_s_teletext_config::extraction_end"]
        [::std::mem::offset_of!(ccx_s_teletext_config, extraction_end) - 88usize];
    ["Offset of field: ccx_s_teletext_config::write_format"]
        [::std::mem::offset_of!(ccx_s_teletext_config, write_format) - 120usize];
    ["Offset of field: ccx_s_teletext_config::gui_mode_reports"]
        [::std::mem::offset_of!(ccx_s_teletext_config, gui_mode_reports) - 124usize];
    ["Offset of field: ccx_s_teletext_config::date_format"]
        [::std::mem::offset_of!(ccx_s_teletext_config, date_format) - 128usize];
    ["Offset of field: ccx_s_teletext_config::noautotimeref"]
        [::std::mem::offset_of!(ccx_s_teletext_config, noautotimeref) - 132usize];
    ["Offset of field: ccx_s_teletext_config::send_to_srv"]
        [::std::mem::offset_of!(ccx_s_teletext_config, send_to_srv) - 136usize];
    ["Offset of field: ccx_s_teletext_config::encoding"]
        [::std::mem::offset_of!(ccx_s_teletext_config, encoding) - 140usize];
    ["Offset of field: ccx_s_teletext_config::nofontcolor"]
        [::std::mem::offset_of!(ccx_s_teletext_config, nofontcolor) - 144usize];
    ["Offset of field: ccx_s_teletext_config::nohtmlescape"]
        [::std::mem::offset_of!(ccx_s_teletext_config, nohtmlescape) - 148usize];
    ["Offset of field: ccx_s_teletext_config::millis_separator"]
        [::std::mem::offset_of!(ccx_s_teletext_config, millis_separator) - 152usize];
    ["Offset of field: ccx_s_teletext_config::latrusmap"]
        [::std::mem::offset_of!(ccx_s_teletext_config, latrusmap) - 156usize];
    ["Offset of field: ccx_s_teletext_config::forceg0latin"]
        [::std::mem::offset_of!(ccx_s_teletext_config, forceg0latin) - 160usize];
};
impl Default for ccx_s_teletext_config {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ccx_s_teletext_config {
    #[inline]
    pub fn verbose(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_verbose(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn verbose_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_verbose_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(verbose: u8) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let verbose: u8 = unsafe { ::std::mem::transmute(verbose) };
            verbose as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn bom(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_bom(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn bom_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_bom_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn nonempty(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_nonempty(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn nonempty_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_nonempty_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_2(bom: u8, nonempty: u8) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let bom: u8 = unsafe { ::std::mem::transmute(bom) };
            bom as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let nonempty: u8 = unsafe { ::std::mem::transmute(nonempty) };
            nonempty as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct ccx_s_mp4Cfg {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_s_mp4Cfg"][::std::mem::size_of::<ccx_s_mp4Cfg>() - 4usize];
    ["Alignment of ccx_s_mp4Cfg"][::std::mem::align_of::<ccx_s_mp4Cfg>() - 4usize];
};
impl ccx_s_mp4Cfg {
    #[inline]
    pub fn mp4vidtrack(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_mp4vidtrack(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn mp4vidtrack_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_mp4vidtrack_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mp4vidtrack: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let mp4vidtrack: u32 = unsafe { ::std::mem::transmute(mp4vidtrack) };
            mp4vidtrack as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lib_ccx_ctx {
    pub pesheaderbuf: *mut ::std::os::raw::c_uchar,
    pub inputsize: LLONG,
    pub total_inputsize: LLONG,
    pub total_past: LLONG,
    pub last_reported_progress: ::std::os::raw::c_int,
    pub stat_numuserheaders: ::std::os::raw::c_int,
    pub stat_dvdccheaders: ::std::os::raw::c_int,
    pub stat_scte20ccheaders: ::std::os::raw::c_int,
    pub stat_replay5000headers: ::std::os::raw::c_int,
    pub stat_replay4000headers: ::std::os::raw::c_int,
    pub stat_dishheaders: ::std::os::raw::c_int,
    pub stat_hdtv: ::std::os::raw::c_int,
    pub stat_divicom: ::std::os::raw::c_int,
    pub false_pict_header: ::std::os::raw::c_int,
    pub dec_global_setting: *mut ccx_decoders_common_settings_t,
    pub dec_ctx_head: list_head,
    pub rawmode: ::std::os::raw::c_int,
    pub cc_to_stdout: ::std::os::raw::c_int,
    pub pes_header_to_stdout: ::std::os::raw::c_int,
    pub dvb_debug_traces_to_stdout: ::std::os::raw::c_int,
    pub ignore_pts_jumps: ::std::os::raw::c_int,
    pub subs_delay: LLONG,
    pub startcredits_displayed: ::std::os::raw::c_int,
    pub end_credits_displayed: ::std::os::raw::c_int,
    pub last_displayed_subs_ms: LLONG,
    pub screens_to_process: LLONG,
    pub basefilename: *mut ::std::os::raw::c_char,
    pub extension: *const ::std::os::raw::c_char,
    pub current_file: ::std::os::raw::c_int,
    pub inputfile: *mut *mut ::std::os::raw::c_char,
    pub num_input_files: ::std::os::raw::c_int,
    pub teletext_warning_shown: ::std::os::raw::c_uint,
    pub epg_inited: ::std::os::raw::c_int,
    pub epg_buffers: *mut PSI_buffer,
    pub eit_programs: *mut EIT_program,
    pub eit_current_events: *mut i32,
    pub ATSC_source_pg_map: *mut i16,
    pub epg_last_output: ::std::os::raw::c_int,
    pub epg_last_live_output: ::std::os::raw::c_int,
    pub freport: file_report,
    pub hauppauge_mode: ::std::os::raw::c_uint,
    pub live_stream: ::std::os::raw::c_int,
    pub binary_concat: ::std::os::raw::c_int,
    pub multiprogram: ::std::os::raw::c_int,
    pub write_format: ccx_output_format,
    pub demux_ctx: *mut ccx_demuxer,
    pub enc_ctx_head: list_head,
    pub mp4_cfg: ccx_s_mp4Cfg,
    pub out_interval: ::std::os::raw::c_int,
    pub segment_on_key_frames_only: ::std::os::raw::c_int,
    pub segment_counter: ::std::os::raw::c_int,
    pub system_start_time: LLONG,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of lib_ccx_ctx"][::std::mem::size_of::<lib_ccx_ctx>() - 352usize];
    ["Alignment of lib_ccx_ctx"][::std::mem::align_of::<lib_ccx_ctx>() - 8usize];
    ["Offset of field: lib_ccx_ctx::pesheaderbuf"]
        [::std::mem::offset_of!(lib_ccx_ctx, pesheaderbuf) - 0usize];
    ["Offset of field: lib_ccx_ctx::inputsize"]
        [::std::mem::offset_of!(lib_ccx_ctx, inputsize) - 8usize];
    ["Offset of field: lib_ccx_ctx::total_inputsize"]
        [::std::mem::offset_of!(lib_ccx_ctx, total_inputsize) - 16usize];
    ["Offset of field: lib_ccx_ctx::total_past"]
        [::std::mem::offset_of!(lib_ccx_ctx, total_past) - 24usize];
    ["Offset of field: lib_ccx_ctx::last_reported_progress"]
        [::std::mem::offset_of!(lib_ccx_ctx, last_reported_progress) - 32usize];
    ["Offset of field: lib_ccx_ctx::stat_numuserheaders"]
        [::std::mem::offset_of!(lib_ccx_ctx, stat_numuserheaders) - 36usize];
    ["Offset of field: lib_ccx_ctx::stat_dvdccheaders"]
        [::std::mem::offset_of!(lib_ccx_ctx, stat_dvdccheaders) - 40usize];
    ["Offset of field: lib_ccx_ctx::stat_scte20ccheaders"]
        [::std::mem::offset_of!(lib_ccx_ctx, stat_scte20ccheaders) - 44usize];
    ["Offset of field: lib_ccx_ctx::stat_replay5000headers"]
        [::std::mem::offset_of!(lib_ccx_ctx, stat_replay5000headers) - 48usize];
    ["Offset of field: lib_ccx_ctx::stat_replay4000headers"]
        [::std::mem::offset_of!(lib_ccx_ctx, stat_replay4000headers) - 52usize];
    ["Offset of field: lib_ccx_ctx::stat_dishheaders"]
        [::std::mem::offset_of!(lib_ccx_ctx, stat_dishheaders) - 56usize];
    ["Offset of field: lib_ccx_ctx::stat_hdtv"]
        [::std::mem::offset_of!(lib_ccx_ctx, stat_hdtv) - 60usize];
    ["Offset of field: lib_ccx_ctx::stat_divicom"]
        [::std::mem::offset_of!(lib_ccx_ctx, stat_divicom) - 64usize];
    ["Offset of field: lib_ccx_ctx::false_pict_header"]
        [::std::mem::offset_of!(lib_ccx_ctx, false_pict_header) - 68usize];
    ["Offset of field: lib_ccx_ctx::dec_global_setting"]
        [::std::mem::offset_of!(lib_ccx_ctx, dec_global_setting) - 72usize];
    ["Offset of field: lib_ccx_ctx::dec_ctx_head"]
        [::std::mem::offset_of!(lib_ccx_ctx, dec_ctx_head) - 80usize];
    ["Offset of field: lib_ccx_ctx::rawmode"]
        [::std::mem::offset_of!(lib_ccx_ctx, rawmode) - 96usize];
    ["Offset of field: lib_ccx_ctx::cc_to_stdout"]
        [::std::mem::offset_of!(lib_ccx_ctx, cc_to_stdout) - 100usize];
    ["Offset of field: lib_ccx_ctx::pes_header_to_stdout"]
        [::std::mem::offset_of!(lib_ccx_ctx, pes_header_to_stdout) - 104usize];
    ["Offset of field: lib_ccx_ctx::dvb_debug_traces_to_stdout"]
        [::std::mem::offset_of!(lib_ccx_ctx, dvb_debug_traces_to_stdout) - 108usize];
    ["Offset of field: lib_ccx_ctx::ignore_pts_jumps"]
        [::std::mem::offset_of!(lib_ccx_ctx, ignore_pts_jumps) - 112usize];
    ["Offset of field: lib_ccx_ctx::subs_delay"]
        [::std::mem::offset_of!(lib_ccx_ctx, subs_delay) - 120usize];
    ["Offset of field: lib_ccx_ctx::startcredits_displayed"]
        [::std::mem::offset_of!(lib_ccx_ctx, startcredits_displayed) - 128usize];
    ["Offset of field: lib_ccx_ctx::end_credits_displayed"]
        [::std::mem::offset_of!(lib_ccx_ctx, end_credits_displayed) - 132usize];
    ["Offset of field: lib_ccx_ctx::last_displayed_subs_ms"]
        [::std::mem::offset_of!(lib_ccx_ctx, last_displayed_subs_ms) - 136usize];
    ["Offset of field: lib_ccx_ctx::screens_to_process"]
        [::std::mem::offset_of!(lib_ccx_ctx, screens_to_process) - 144usize];
    ["Offset of field: lib_ccx_ctx::basefilename"]
        [::std::mem::offset_of!(lib_ccx_ctx, basefilename) - 152usize];
    ["Offset of field: lib_ccx_ctx::extension"]
        [::std::mem::offset_of!(lib_ccx_ctx, extension) - 160usize];
    ["Offset of field: lib_ccx_ctx::current_file"]
        [::std::mem::offset_of!(lib_ccx_ctx, current_file) - 168usize];
    ["Offset of field: lib_ccx_ctx::inputfile"]
        [::std::mem::offset_of!(lib_ccx_ctx, inputfile) - 176usize];
    ["Offset of field: lib_ccx_ctx::num_input_files"]
        [::std::mem::offset_of!(lib_ccx_ctx, num_input_files) - 184usize];
    ["Offset of field: lib_ccx_ctx::teletext_warning_shown"]
        [::std::mem::offset_of!(lib_ccx_ctx, teletext_warning_shown) - 188usize];
    ["Offset of field: lib_ccx_ctx::epg_inited"]
        [::std::mem::offset_of!(lib_ccx_ctx, epg_inited) - 192usize];
    ["Offset of field: lib_ccx_ctx::epg_buffers"]
        [::std::mem::offset_of!(lib_ccx_ctx, epg_buffers) - 200usize];
    ["Offset of field: lib_ccx_ctx::eit_programs"]
        [::std::mem::offset_of!(lib_ccx_ctx, eit_programs) - 208usize];
    ["Offset of field: lib_ccx_ctx::eit_current_events"]
        [::std::mem::offset_of!(lib_ccx_ctx, eit_current_events) - 216usize];
    ["Offset of field: lib_ccx_ctx::ATSC_source_pg_map"]
        [::std::mem::offset_of!(lib_ccx_ctx, ATSC_source_pg_map) - 224usize];
    ["Offset of field: lib_ccx_ctx::epg_last_output"]
        [::std::mem::offset_of!(lib_ccx_ctx, epg_last_output) - 232usize];
    ["Offset of field: lib_ccx_ctx::epg_last_live_output"]
        [::std::mem::offset_of!(lib_ccx_ctx, epg_last_live_output) - 236usize];
    ["Offset of field: lib_ccx_ctx::freport"]
        [::std::mem::offset_of!(lib_ccx_ctx, freport) - 240usize];
    ["Offset of field: lib_ccx_ctx::hauppauge_mode"]
        [::std::mem::offset_of!(lib_ccx_ctx, hauppauge_mode) - 280usize];
    ["Offset of field: lib_ccx_ctx::live_stream"]
        [::std::mem::offset_of!(lib_ccx_ctx, live_stream) - 284usize];
    ["Offset of field: lib_ccx_ctx::binary_concat"]
        [::std::mem::offset_of!(lib_ccx_ctx, binary_concat) - 288usize];
    ["Offset of field: lib_ccx_ctx::multiprogram"]
        [::std::mem::offset_of!(lib_ccx_ctx, multiprogram) - 292usize];
    ["Offset of field: lib_ccx_ctx::write_format"]
        [::std::mem::offset_of!(lib_ccx_ctx, write_format) - 296usize];
    ["Offset of field: lib_ccx_ctx::demux_ctx"]
        [::std::mem::offset_of!(lib_ccx_ctx, demux_ctx) - 304usize];
    ["Offset of field: lib_ccx_ctx::enc_ctx_head"]
        [::std::mem::offset_of!(lib_ccx_ctx, enc_ctx_head) - 312usize];
    ["Offset of field: lib_ccx_ctx::mp4_cfg"]
        [::std::mem::offset_of!(lib_ccx_ctx, mp4_cfg) - 328usize];
    ["Offset of field: lib_ccx_ctx::out_interval"]
        [::std::mem::offset_of!(lib_ccx_ctx, out_interval) - 332usize];
    ["Offset of field: lib_ccx_ctx::segment_on_key_frames_only"]
        [::std::mem::offset_of!(lib_ccx_ctx, segment_on_key_frames_only) - 336usize];
    ["Offset of field: lib_ccx_ctx::segment_counter"]
        [::std::mem::offset_of!(lib_ccx_ctx, segment_counter) - 340usize];
    ["Offset of field: lib_ccx_ctx::system_start_time"]
        [::std::mem::offset_of!(lib_ccx_ctx, system_start_time) - 344usize];
};
impl Default for lib_ccx_ctx {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn store_hdcc(
        enc_ctx: *mut encoder_ctx,
        ctx: *mut lib_cc_decode,
        cc_data: *mut ::std::os::raw::c_uchar,
        cc_count: ::std::os::raw::c_int,
        sequence_number: ::std::os::raw::c_int,
        current_fts_now: LLONG,
        sub: *mut cc_subtitle,
    );
}
unsafe extern "C" {
    pub fn anchor_hdcc(ctx: *mut lib_cc_decode, seq: ::std::os::raw::c_int);
}
unsafe extern "C" {
    pub fn process_hdcc(enc_ctx: *mut encoder_ctx, ctx: *mut lib_cc_decode, sub: *mut cc_subtitle);
}
unsafe extern "C" {
    pub fn print_file_report(ctx: *mut lib_ccx_ctx);
}
unsafe extern "C" {
    pub fn writercwtdata(
        ctx: *mut lib_cc_decode,
        data: *const ::std::os::raw::c_uchar,
        sub: *mut cc_subtitle,
    );
}
unsafe extern "C" {
    pub fn mprint(fmt: *const ::std::os::raw::c_char, ...);
}
unsafe extern "C" {
    pub fn decode_vbi(
        dec_ctx: *mut lib_cc_decode,
        field: u8,
        buffer: *mut ::std::os::raw::c_uchar,
        len: usize,
        sub: *mut cc_subtitle,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn ccxr_dtvcc_set_encoder(
        dtvcc_rust: *mut ::std::os::raw::c_void,
        encoder: *mut encoder_ctx,
    );
}
pub const AVPictureType_AV_PICTURE_TYPE_NONE: AVPictureType = 0;
pub const AVPictureType_AV_PICTURE_TYPE_I: AVPictureType = 1;
pub const AVPictureType_AV_PICTURE_TYPE_P: AVPictureType = 2;
pub const AVPictureType_AV_PICTURE_TYPE_B: AVPictureType = 3;
pub const AVPictureType_AV_PICTURE_TYPE_S: AVPictureType = 4;
pub const AVPictureType_AV_PICTURE_TYPE_SI: AVPictureType = 5;
pub const AVPictureType_AV_PICTURE_TYPE_SP: AVPictureType = 6;
pub const AVPictureType_AV_PICTURE_TYPE_BI: AVPictureType = 7;
pub type AVPictureType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct AVRational {
    pub num: ::std::os::raw::c_int,
    pub den: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AVRational"][::std::mem::size_of::<AVRational>() - 8usize];
    ["Alignment of AVRational"][::std::mem::align_of::<AVRational>() - 4usize];
    ["Offset of field: AVRational::num"][::std::mem::offset_of!(AVRational, num) - 0usize];
    ["Offset of field: AVRational::den"][::std::mem::offset_of!(AVRational, den) - 4usize];
};
unsafe extern "C" {
    pub fn av_rescale_q(a: i64, bq: AVRational, cq: AVRational) -> i64;
}
pub const AVColorPrimaries_AVCOL_PRI_RESERVED0: AVColorPrimaries = 0;
pub const AVColorPrimaries_AVCOL_PRI_BT709: AVColorPrimaries = 1;
pub const AVColorPrimaries_AVCOL_PRI_UNSPECIFIED: AVColorPrimaries = 2;
pub const AVColorPrimaries_AVCOL_PRI_RESERVED: AVColorPrimaries = 3;
pub const AVColorPrimaries_AVCOL_PRI_BT470M: AVColorPrimaries = 4;
pub const AVColorPrimaries_AVCOL_PRI_BT470BG: AVColorPrimaries = 5;
pub const AVColorPrimaries_AVCOL_PRI_SMPTE170M: AVColorPrimaries = 6;
pub const AVColorPrimaries_AVCOL_PRI_SMPTE240M: AVColorPrimaries = 7;
pub const AVColorPrimaries_AVCOL_PRI_FILM: AVColorPrimaries = 8;
pub const AVColorPrimaries_AVCOL_PRI_BT2020: AVColorPrimaries = 9;
pub const AVColorPrimaries_AVCOL_PRI_SMPTE428: AVColorPrimaries = 10;
pub const AVColorPrimaries_AVCOL_PRI_SMPTEST428_1: AVColorPrimaries = 10;
pub const AVColorPrimaries_AVCOL_PRI_SMPTE431: AVColorPrimaries = 11;
pub const AVColorPrimaries_AVCOL_PRI_SMPTE432: AVColorPrimaries = 12;
pub const AVColorPrimaries_AVCOL_PRI_EBU3213: AVColorPrimaries = 22;
pub const AVColorPrimaries_AVCOL_PRI_JEDEC_P22: AVColorPrimaries = 22;
pub const AVColorPrimaries_AVCOL_PRI_NB: AVColorPrimaries = 23;
pub type AVColorPrimaries = ::std::os::raw::c_uint;
pub const AVColorTransferCharacteristic_AVCOL_TRC_RESERVED0: AVColorTransferCharacteristic = 0;
pub const AVColorTransferCharacteristic_AVCOL_TRC_BT709: AVColorTransferCharacteristic = 1;
pub const AVColorTransferCharacteristic_AVCOL_TRC_UNSPECIFIED: AVColorTransferCharacteristic = 2;
pub const AVColorTransferCharacteristic_AVCOL_TRC_RESERVED: AVColorTransferCharacteristic = 3;
pub const AVColorTransferCharacteristic_AVCOL_TRC_GAMMA22: AVColorTransferCharacteristic = 4;
pub const AVColorTransferCharacteristic_AVCOL_TRC_GAMMA28: AVColorTransferCharacteristic = 5;
pub const AVColorTransferCharacteristic_AVCOL_TRC_SMPTE170M: AVColorTransferCharacteristic = 6;
pub const AVColorTransferCharacteristic_AVCOL_TRC_SMPTE240M: AVColorTransferCharacteristic = 7;
pub const AVColorTransferCharacteristic_AVCOL_TRC_LINEAR: AVColorTransferCharacteristic = 8;
pub const AVColorTransferCharacteristic_AVCOL_TRC_LOG: AVColorTransferCharacteristic = 9;
pub const AVColorTransferCharacteristic_AVCOL_TRC_LOG_SQRT: AVColorTransferCharacteristic = 10;
pub const AVColorTransferCharacteristic_AVCOL_TRC_IEC61966_2_4: AVColorTransferCharacteristic = 11;
pub const AVColorTransferCharacteristic_AVCOL_TRC_BT1361_ECG: AVColorTransferCharacteristic = 12;
pub const AVColorTransferCharacteristic_AVCOL_TRC_IEC61966_2_1: AVColorTransferCharacteristic = 13;
pub const AVColorTransferCharacteristic_AVCOL_TRC_BT2020_10: AVColorTransferCharacteristic = 14;
pub const AVColorTransferCharacteristic_AVCOL_TRC_BT2020_12: AVColorTransferCharacteristic = 15;
pub const AVColorTransferCharacteristic_AVCOL_TRC_SMPTE2084: AVColorTransferCharacteristic = 16;
pub const AVColorTransferCharacteristic_AVCOL_TRC_SMPTEST2084: AVColorTransferCharacteristic = 16;
pub const AVColorTransferCharacteristic_AVCOL_TRC_SMPTE428: AVColorTransferCharacteristic = 17;
pub const AVColorTransferCharacteristic_AVCOL_TRC_SMPTEST428_1: AVColorTransferCharacteristic = 17;
pub const AVColorTransferCharacteristic_AVCOL_TRC_ARIB_STD_B67: AVColorTransferCharacteristic = 18;
pub const AVColorTransferCharacteristic_AVCOL_TRC_NB: AVColorTransferCharacteristic = 19;
pub type AVColorTransferCharacteristic = ::std::os::raw::c_uint;
pub const AVColorSpace_AVCOL_SPC_RGB: AVColorSpace = 0;
pub const AVColorSpace_AVCOL_SPC_BT709: AVColorSpace = 1;
pub const AVColorSpace_AVCOL_SPC_UNSPECIFIED: AVColorSpace = 2;
pub const AVColorSpace_AVCOL_SPC_RESERVED: AVColorSpace = 3;
pub const AVColorSpace_AVCOL_SPC_FCC: AVColorSpace = 4;
pub const AVColorSpace_AVCOL_SPC_BT470BG: AVColorSpace = 5;
pub const AVColorSpace_AVCOL_SPC_SMPTE170M: AVColorSpace = 6;
pub const AVColorSpace_AVCOL_SPC_SMPTE240M: AVColorSpace = 7;
pub const AVColorSpace_AVCOL_SPC_YCGCO: AVColorSpace = 8;
pub const AVColorSpace_AVCOL_SPC_YCOCG: AVColorSpace = 8;
pub const AVColorSpace_AVCOL_SPC_BT2020_NCL: AVColorSpace = 9;
pub const AVColorSpace_AVCOL_SPC_BT2020_CL: AVColorSpace = 10;
pub const AVColorSpace_AVCOL_SPC_SMPTE2085: AVColorSpace = 11;
pub const AVColorSpace_AVCOL_SPC_CHROMA_DERIVED_NCL: AVColorSpace = 12;
pub const AVColorSpace_AVCOL_SPC_CHROMA_DERIVED_CL: AVColorSpace = 13;
pub const AVColorSpace_AVCOL_SPC_ICTCP: AVColorSpace = 14;
pub const AVColorSpace_AVCOL_SPC_IPT_C2: AVColorSpace = 15;
pub const AVColorSpace_AVCOL_SPC_YCGCO_RE: AVColorSpace = 16;
pub const AVColorSpace_AVCOL_SPC_YCGCO_RO: AVColorSpace = 17;
pub const AVColorSpace_AVCOL_SPC_NB: AVColorSpace = 18;
pub type AVColorSpace = ::std::os::raw::c_uint;
pub const AVColorRange_AVCOL_RANGE_UNSPECIFIED: AVColorRange = 0;
pub const AVColorRange_AVCOL_RANGE_MPEG: AVColorRange = 1;
pub const AVColorRange_AVCOL_RANGE_JPEG: AVColorRange = 2;
pub const AVColorRange_AVCOL_RANGE_NB: AVColorRange = 3;
pub type AVColorRange = ::std::os::raw::c_uint;
pub const AVChromaLocation_AVCHROMA_LOC_UNSPECIFIED: AVChromaLocation = 0;
pub const AVChromaLocation_AVCHROMA_LOC_LEFT: AVChromaLocation = 1;
pub const AVChromaLocation_AVCHROMA_LOC_CENTER: AVChromaLocation = 2;
pub const AVChromaLocation_AVCHROMA_LOC_TOPLEFT: AVChromaLocation = 3;
pub const AVChromaLocation_AVCHROMA_LOC_TOP: AVChromaLocation = 4;
pub const AVChromaLocation_AVCHROMA_LOC_BOTTOMLEFT: AVChromaLocation = 5;
pub const AVChromaLocation_AVCHROMA_LOC_BOTTOM: AVChromaLocation = 6;
pub const AVChromaLocation_AVCHROMA_LOC_NB: AVChromaLocation = 7;
pub type AVChromaLocation = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVBuffer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVBufferRef {
    pub buffer: *mut AVBuffer,
    pub data: *mut u8,
    pub size: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AVBufferRef"][::std::mem::size_of::<AVBufferRef>() - 24usize];
    ["Alignment of AVBufferRef"][::std::mem::align_of::<AVBufferRef>() - 8usize];
    ["Offset of field: AVBufferRef::buffer"][::std::mem::offset_of!(AVBufferRef, buffer) - 0usize];
    ["Offset of field: AVBufferRef::data"][::std::mem::offset_of!(AVBufferRef, data) - 8usize];
    ["Offset of field: AVBufferRef::size"][::std::mem::offset_of!(AVBufferRef, size) - 16usize];
};
impl Default for AVBufferRef {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const AVChannel_AV_CHAN_NONE: AVChannel = -1;
pub const AVChannel_AV_CHAN_FRONT_LEFT: AVChannel = 0;
pub const AVChannel_AV_CHAN_FRONT_RIGHT: AVChannel = 1;
pub const AVChannel_AV_CHAN_FRONT_CENTER: AVChannel = 2;
pub const AVChannel_AV_CHAN_LOW_FREQUENCY: AVChannel = 3;
pub const AVChannel_AV_CHAN_BACK_LEFT: AVChannel = 4;
pub const AVChannel_AV_CHAN_BACK_RIGHT: AVChannel = 5;
pub const AVChannel_AV_CHAN_FRONT_LEFT_OF_CENTER: AVChannel = 6;
pub const AVChannel_AV_CHAN_FRONT_RIGHT_OF_CENTER: AVChannel = 7;
pub const AVChannel_AV_CHAN_BACK_CENTER: AVChannel = 8;
pub const AVChannel_AV_CHAN_SIDE_LEFT: AVChannel = 9;
pub const AVChannel_AV_CHAN_SIDE_RIGHT: AVChannel = 10;
pub const AVChannel_AV_CHAN_TOP_CENTER: AVChannel = 11;
pub const AVChannel_AV_CHAN_TOP_FRONT_LEFT: AVChannel = 12;
pub const AVChannel_AV_CHAN_TOP_FRONT_CENTER: AVChannel = 13;
pub const AVChannel_AV_CHAN_TOP_FRONT_RIGHT: AVChannel = 14;
pub const AVChannel_AV_CHAN_TOP_BACK_LEFT: AVChannel = 15;
pub const AVChannel_AV_CHAN_TOP_BACK_CENTER: AVChannel = 16;
pub const AVChannel_AV_CHAN_TOP_BACK_RIGHT: AVChannel = 17;
pub const AVChannel_AV_CHAN_STEREO_LEFT: AVChannel = 29;
pub const AVChannel_AV_CHAN_STEREO_RIGHT: AVChannel = 30;
pub const AVChannel_AV_CHAN_WIDE_LEFT: AVChannel = 31;
pub const AVChannel_AV_CHAN_WIDE_RIGHT: AVChannel = 32;
pub const AVChannel_AV_CHAN_SURROUND_DIRECT_LEFT: AVChannel = 33;
pub const AVChannel_AV_CHAN_SURROUND_DIRECT_RIGHT: AVChannel = 34;
pub const AVChannel_AV_CHAN_LOW_FREQUENCY_2: AVChannel = 35;
pub const AVChannel_AV_CHAN_TOP_SIDE_LEFT: AVChannel = 36;
pub const AVChannel_AV_CHAN_TOP_SIDE_RIGHT: AVChannel = 37;
pub const AVChannel_AV_CHAN_BOTTOM_FRONT_CENTER: AVChannel = 38;
pub const AVChannel_AV_CHAN_BOTTOM_FRONT_LEFT: AVChannel = 39;
pub const AVChannel_AV_CHAN_BOTTOM_FRONT_RIGHT: AVChannel = 40;
pub const AVChannel_AV_CHAN_SIDE_SURROUND_LEFT: AVChannel = 41;
pub const AVChannel_AV_CHAN_SIDE_SURROUND_RIGHT: AVChannel = 42;
pub const AVChannel_AV_CHAN_TOP_SURROUND_LEFT: AVChannel = 43;
pub const AVChannel_AV_CHAN_TOP_SURROUND_RIGHT: AVChannel = 44;
pub const AVChannel_AV_CHAN_BINAURAL_LEFT: AVChannel = 61;
pub const AVChannel_AV_CHAN_BINAURAL_RIGHT: AVChannel = 62;
pub const AVChannel_AV_CHAN_UNUSED: AVChannel = 512;
pub const AVChannel_AV_CHAN_UNKNOWN: AVChannel = 768;
pub const AVChannel_AV_CHAN_AMBISONIC_BASE: AVChannel = 1024;
pub const AVChannel_AV_CHAN_AMBISONIC_END: AVChannel = 2047;
pub type AVChannel = ::std::os::raw::c_int;
pub const AVChannelOrder_AV_CHANNEL_ORDER_UNSPEC: AVChannelOrder = 0;
pub const AVChannelOrder_AV_CHANNEL_ORDER_NATIVE: AVChannelOrder = 1;
pub const AVChannelOrder_AV_CHANNEL_ORDER_CUSTOM: AVChannelOrder = 2;
pub const AVChannelOrder_AV_CHANNEL_ORDER_AMBISONIC: AVChannelOrder = 3;
pub const AVChannelOrder_FF_CHANNEL_ORDER_NB: AVChannelOrder = 4;
pub type AVChannelOrder = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVChannelCustom {
    pub id: AVChannel,
    pub name: [::std::os::raw::c_char; 16usize],
    pub opaque: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AVChannelCustom"][::std::mem::size_of::<AVChannelCustom>() - 32usize];
    ["Alignment of AVChannelCustom"][::std::mem::align_of::<AVChannelCustom>() - 8usize];
    ["Offset of field: AVChannelCustom::id"][::std::mem::offset_of!(AVChannelCustom, id) - 0usize];
    ["Offset of field: AVChannelCustom::name"]
        [::std::mem::offset_of!(AVChannelCustom, name) - 4usize];
    ["Offset of field: AVChannelCustom::opaque"]
        [::std::mem::offset_of!(AVChannelCustom, opaque) - 24usize];
};
impl Default for AVChannelCustom {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct AVChannelLayout {
    pub order: AVChannelOrder,
    pub nb_channels: ::std::os::raw::c_int,
    pub u: AVChannelLayout__bindgen_ty_1,
    pub opaque: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union AVChannelLayout__bindgen_ty_1 {
    pub mask: u64,
    pub map: *mut AVChannelCustom,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AVChannelLayout__bindgen_ty_1"]
        [::std::mem::size_of::<AVChannelLayout__bindgen_ty_1>() - 8usize];
    ["Alignment of AVChannelLayout__bindgen_ty_1"]
        [::std::mem::align_of::<AVChannelLayout__bindgen_ty_1>() - 8usize];
    ["Offset of field: AVChannelLayout__bindgen_ty_1::mask"]
        [::std::mem::offset_of!(AVChannelLayout__bindgen_ty_1, mask) - 0usize];
    ["Offset of field: AVChannelLayout__bindgen_ty_1::map"]
        [::std::mem::offset_of!(AVChannelLayout__bindgen_ty_1, map) - 0usize];
};
impl Default for AVChannelLayout__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AVChannelLayout"][::std::mem::size_of::<AVChannelLayout>() - 24usize];
    ["Alignment of AVChannelLayout"][::std::mem::align_of::<AVChannelLayout>() - 8usize];
    ["Offset of field: AVChannelLayout::order"]
        [::std::mem::offset_of!(AVChannelLayout, order) - 0usize];
    ["Offset of field: AVChannelLayout::nb_channels"]
        [::std::mem::offset_of!(AVChannelLayout, nb_channels) - 4usize];
    ["Offset of field: AVChannelLayout::u"][::std::mem::offset_of!(AVChannelLayout, u) - 8usize];
    ["Offset of field: AVChannelLayout::opaque"]
        [::std::mem::offset_of!(AVChannelLayout, opaque) - 16usize];
};
impl Default for AVChannelLayout {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVDictionary {
    _unused: [u8; 0],
}
pub const AVFrameSideDataType_AV_FRAME_DATA_PANSCAN: AVFrameSideDataType = 0;
pub const AVFrameSideDataType_AV_FRAME_DATA_A53_CC: AVFrameSideDataType = 1;
pub const AVFrameSideDataType_AV_FRAME_DATA_STEREO3D: AVFrameSideDataType = 2;
pub const AVFrameSideDataType_AV_FRAME_DATA_MATRIXENCODING: AVFrameSideDataType = 3;
pub const AVFrameSideDataType_AV_FRAME_DATA_DOWNMIX_INFO: AVFrameSideDataType = 4;
pub const AVFrameSideDataType_AV_FRAME_DATA_REPLAYGAIN: AVFrameSideDataType = 5;
pub const AVFrameSideDataType_AV_FRAME_DATA_DISPLAYMATRIX: AVFrameSideDataType = 6;
pub const AVFrameSideDataType_AV_FRAME_DATA_AFD: AVFrameSideDataType = 7;
pub const AVFrameSideDataType_AV_FRAME_DATA_MOTION_VECTORS: AVFrameSideDataType = 8;
pub const AVFrameSideDataType_AV_FRAME_DATA_SKIP_SAMPLES: AVFrameSideDataType = 9;
pub const AVFrameSideDataType_AV_FRAME_DATA_AUDIO_SERVICE_TYPE: AVFrameSideDataType = 10;
pub const AVFrameSideDataType_AV_FRAME_DATA_MASTERING_DISPLAY_METADATA: AVFrameSideDataType = 11;
pub const AVFrameSideDataType_AV_FRAME_DATA_GOP_TIMECODE: AVFrameSideDataType = 12;
pub const AVFrameSideDataType_AV_FRAME_DATA_SPHERICAL: AVFrameSideDataType = 13;
pub const AVFrameSideDataType_AV_FRAME_DATA_CONTENT_LIGHT_LEVEL: AVFrameSideDataType = 14;
pub const AVFrameSideDataType_AV_FRAME_DATA_ICC_PROFILE: AVFrameSideDataType = 15;
pub const AVFrameSideDataType_AV_FRAME_DATA_S12M_TIMECODE: AVFrameSideDataType = 16;
pub const AVFrameSideDataType_AV_FRAME_DATA_DYNAMIC_HDR_PLUS: AVFrameSideDataType = 17;
pub const AVFrameSideDataType_AV_FRAME_DATA_REGIONS_OF_INTEREST: AVFrameSideDataType = 18;
pub const AVFrameSideDataType_AV_FRAME_DATA_VIDEO_ENC_PARAMS: AVFrameSideDataType = 19;
pub const AVFrameSideDataType_AV_FRAME_DATA_SEI_UNREGISTERED: AVFrameSideDataType = 20;
pub const AVFrameSideDataType_AV_FRAME_DATA_FILM_GRAIN_PARAMS: AVFrameSideDataType = 21;
pub const AVFrameSideDataType_AV_FRAME_DATA_DETECTION_BBOXES: AVFrameSideDataType = 22;
pub const AVFrameSideDataType_AV_FRAME_DATA_DOVI_RPU_BUFFER: AVFrameSideDataType = 23;
pub const AVFrameSideDataType_AV_FRAME_DATA_DOVI_METADATA: AVFrameSideDataType = 24;
pub const AVFrameSideDataType_AV_FRAME_DATA_DYNAMIC_HDR_VIVID: AVFrameSideDataType = 25;
pub const AVFrameSideDataType_AV_FRAME_DATA_AMBIENT_VIEWING_ENVIRONMENT: AVFrameSideDataType = 26;
pub const AVFrameSideDataType_AV_FRAME_DATA_VIDEO_HINT: AVFrameSideDataType = 27;
pub const AVFrameSideDataType_AV_FRAME_DATA_LCEVC: AVFrameSideDataType = 28;
pub const AVFrameSideDataType_AV_FRAME_DATA_VIEW_ID: AVFrameSideDataType = 29;
pub const AVFrameSideDataType_AV_FRAME_DATA_3D_REFERENCE_DISPLAYS: AVFrameSideDataType = 30;
pub type AVFrameSideDataType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVFrameSideData {
    pub type_: AVFrameSideDataType,
    pub data: *mut u8,
    pub size: usize,
    pub metadata: *mut AVDictionary,
    pub buf: *mut AVBufferRef,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AVFrameSideData"][::std::mem::size_of::<AVFrameSideData>() - 40usize];
    ["Alignment of AVFrameSideData"][::std::mem::align_of::<AVFrameSideData>() - 8usize];
    ["Offset of field: AVFrameSideData::type_"]
        [::std::mem::offset_of!(AVFrameSideData, type_) - 0usize];
    ["Offset of field: AVFrameSideData::data"]
        [::std::mem::offset_of!(AVFrameSideData, data) - 8usize];
    ["Offset of field: AVFrameSideData::size"]
        [::std::mem::offset_of!(AVFrameSideData, size) - 16usize];
    ["Offset of field: AVFrameSideData::metadata"]
        [::std::mem::offset_of!(AVFrameSideData, metadata) - 24usize];
    ["Offset of field: AVFrameSideData::buf"]
        [::std::mem::offset_of!(AVFrameSideData, buf) - 32usize];
};
impl Default for AVFrameSideData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct AVFrame {
    pub data: [*mut u8; 8usize],
    pub linesize: [::std::os::raw::c_int; 8usize],
    pub extended_data: *mut *mut u8,
    pub width: ::std::os::raw::c_int,
    pub height: ::std::os::raw::c_int,
    pub nb_samples: ::std::os::raw::c_int,
    pub format: ::std::os::raw::c_int,
    pub pict_type: AVPictureType,
    pub sample_aspect_ratio: AVRational,
    pub pts: i64,
    pub pkt_dts: i64,
    pub time_base: AVRational,
    pub quality: ::std::os::raw::c_int,
    pub opaque: *mut ::std::os::raw::c_void,
    pub repeat_pict: ::std::os::raw::c_int,
    pub sample_rate: ::std::os::raw::c_int,
    pub buf: [*mut AVBufferRef; 8usize],
    pub extended_buf: *mut *mut AVBufferRef,
    pub nb_extended_buf: ::std::os::raw::c_int,
    pub side_data: *mut *mut AVFrameSideData,
    pub nb_side_data: ::std::os::raw::c_int,
    pub flags: ::std::os::raw::c_int,
    pub color_range: AVColorRange,
    pub color_primaries: AVColorPrimaries,
    pub color_trc: AVColorTransferCharacteristic,
    pub colorspace: AVColorSpace,
    pub chroma_location: AVChromaLocation,
    pub best_effort_timestamp: i64,
    pub metadata: *mut AVDictionary,
    pub decode_error_flags: ::std::os::raw::c_int,
    pub hw_frames_ctx: *mut AVBufferRef,
    pub opaque_ref: *mut AVBufferRef,
    pub crop_top: usize,
    pub crop_bottom: usize,
    pub crop_left: usize,
    pub crop_right: usize,
    pub private_ref: *mut ::std::os::raw::c_void,
    pub ch_layout: AVChannelLayout,
    pub duration: i64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AVFrame"][::std::mem::size_of::<AVFrame>() - 416usize];
    ["Alignment of AVFrame"][::std::mem::align_of::<AVFrame>() - 8usize];
    ["Offset of field: AVFrame::data"][::std::mem::offset_of!(AVFrame, data) - 0usize];
    ["Offset of field: AVFrame::linesize"][::std::mem::offset_of!(AVFrame, linesize) - 64usize];
    ["Offset of field: AVFrame::extended_data"]
        [::std::mem::offset_of!(AVFrame, extended_data) - 96usize];
    ["Offset of field: AVFrame::width"][::std::mem::offset_of!(AVFrame, width) - 104usize];
    ["Offset of field: AVFrame::height"][::std::mem::offset_of!(AVFrame, height) - 108usize];
    ["Offset of field: AVFrame::nb_samples"]
        [::std::mem::offset_of!(AVFrame, nb_samples) - 112usize];
    ["Offset of field: AVFrame::format"][::std::mem::offset_of!(AVFrame, format) - 116usize];
    ["Offset of field: AVFrame::pict_type"][::std::mem::offset_of!(AVFrame, pict_type) - 120usize];
    ["Offset of field: AVFrame::sample_aspect_ratio"]
        [::std::mem::offset_of!(AVFrame, sample_aspect_ratio) - 124usize];
    ["Offset of field: AVFrame::pts"][::std::mem::offset_of!(AVFrame, pts) - 136usize];
    ["Offset of field: AVFrame::pkt_dts"][::std::mem::offset_of!(AVFrame, pkt_dts) - 144usize];
    ["Offset of field: AVFrame::time_base"][::std::mem::offset_of!(AVFrame, time_base) - 152usize];
    ["Offset of field: AVFrame::quality"][::std::mem::offset_of!(AVFrame, quality) - 160usize];
    ["Offset of field: AVFrame::opaque"][::std::mem::offset_of!(AVFrame, opaque) - 168usize];
    ["Offset of field: AVFrame::repeat_pict"]
        [::std::mem::offset_of!(AVFrame, repeat_pict) - 176usize];
    ["Offset of field: AVFrame::sample_rate"]
        [::std::mem::offset_of!(AVFrame, sample_rate) - 180usize];
    ["Offset of field: AVFrame::buf"][::std::mem::offset_of!(AVFrame, buf) - 184usize];
    ["Offset of field: AVFrame::extended_buf"]
        [::std::mem::offset_of!(AVFrame, extended_buf) - 248usize];
    ["Offset of field: AVFrame::nb_extended_buf"]
        [::std::mem::offset_of!(AVFrame, nb_extended_buf) - 256usize];
    ["Offset of field: AVFrame::side_data"][::std::mem::offset_of!(AVFrame, side_data) - 264usize];
    ["Offset of field: AVFrame::nb_side_data"]
        [::std::mem::offset_of!(AVFrame, nb_side_data) - 272usize];
    ["Offset of field: AVFrame::flags"][::std::mem::offset_of!(AVFrame, flags) - 276usize];
    ["Offset of field: AVFrame::color_range"]
        [::std::mem::offset_of!(AVFrame, color_range) - 280usize];
    ["Offset of field: AVFrame::color_primaries"]
        [::std::mem::offset_of!(AVFrame, color_primaries) - 284usize];
    ["Offset of field: AVFrame::color_trc"][::std::mem::offset_of!(AVFrame, color_trc) - 288usize];
    ["Offset of field: AVFrame::colorspace"]
        [::std::mem::offset_of!(AVFrame, colorspace) - 292usize];
    ["Offset of field: AVFrame::chroma_location"]
        [::std::mem::offset_of!(AVFrame, chroma_location) - 296usize];
    ["Offset of field: AVFrame::best_effort_timestamp"]
        [::std::mem::offset_of!(AVFrame, best_effort_timestamp) - 304usize];
    ["Offset of field: AVFrame::metadata"][::std::mem::offset_of!(AVFrame, metadata) - 312usize];
    ["Offset of field: AVFrame::decode_error_flags"]
        [::std::mem::offset_of!(AVFrame, decode_error_flags) - 320usize];
    ["Offset of field: AVFrame::hw_frames_ctx"]
        [::std::mem::offset_of!(AVFrame, hw_frames_ctx) - 328usize];
    ["Offset of field: AVFrame::opaque_ref"]
        [::std::mem::offset_of!(AVFrame, opaque_ref) - 336usize];
    ["Offset of field: AVFrame::crop_top"][::std::mem::offset_of!(AVFrame, crop_top) - 344usize];
    ["Offset of field: AVFrame::crop_bottom"]
        [::std::mem::offset_of!(AVFrame, crop_bottom) - 352usize];
    ["Offset of field: AVFrame::crop_left"][::std::mem::offset_of!(AVFrame, crop_left) - 360usize];
    ["Offset of field: AVFrame::crop_right"]
        [::std::mem::offset_of!(AVFrame, crop_right) - 368usize];
    ["Offset of field: AVFrame::private_ref"]
        [::std::mem::offset_of!(AVFrame, private_ref) - 376usize];
    ["Offset of field: AVFrame::ch_layout"][::std::mem::offset_of!(AVFrame, ch_layout) - 384usize];
    ["Offset of field: AVFrame::duration"][::std::mem::offset_of!(AVFrame, duration) - 408usize];
};
impl Default for AVFrame {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const AVPacketSideDataType_AV_PKT_DATA_PALETTE: AVPacketSideDataType = 0;
pub const AVPacketSideDataType_AV_PKT_DATA_NEW_EXTRADATA: AVPacketSideDataType = 1;
pub const AVPacketSideDataType_AV_PKT_DATA_PARAM_CHANGE: AVPacketSideDataType = 2;
pub const AVPacketSideDataType_AV_PKT_DATA_H263_MB_INFO: AVPacketSideDataType = 3;
pub const AVPacketSideDataType_AV_PKT_DATA_REPLAYGAIN: AVPacketSideDataType = 4;
pub const AVPacketSideDataType_AV_PKT_DATA_DISPLAYMATRIX: AVPacketSideDataType = 5;
pub const AVPacketSideDataType_AV_PKT_DATA_STEREO3D: AVPacketSideDataType = 6;
pub const AVPacketSideDataType_AV_PKT_DATA_AUDIO_SERVICE_TYPE: AVPacketSideDataType = 7;
pub const AVPacketSideDataType_AV_PKT_DATA_QUALITY_STATS: AVPacketSideDataType = 8;
pub const AVPacketSideDataType_AV_PKT_DATA_FALLBACK_TRACK: AVPacketSideDataType = 9;
pub const AVPacketSideDataType_AV_PKT_DATA_CPB_PROPERTIES: AVPacketSideDataType = 10;
pub const AVPacketSideDataType_AV_PKT_DATA_SKIP_SAMPLES: AVPacketSideDataType = 11;
pub const AVPacketSideDataType_AV_PKT_DATA_JP_DUALMONO: AVPacketSideDataType = 12;
pub const AVPacketSideDataType_AV_PKT_DATA_STRINGS_METADATA: AVPacketSideDataType = 13;
pub const AVPacketSideDataType_AV_PKT_DATA_SUBTITLE_POSITION: AVPacketSideDataType = 14;
pub const AVPacketSideDataType_AV_PKT_DATA_MATROSKA_BLOCKADDITIONAL: AVPacketSideDataType = 15;
pub const AVPacketSideDataType_AV_PKT_DATA_WEBVTT_IDENTIFIER: AVPacketSideDataType = 16;
pub const AVPacketSideDataType_AV_PKT_DATA_WEBVTT_SETTINGS: AVPacketSideDataType = 17;
pub const AVPacketSideDataType_AV_PKT_DATA_METADATA_UPDATE: AVPacketSideDataType = 18;
pub const AVPacketSideDataType_AV_PKT_DATA_MPEGTS_STREAM_ID: AVPacketSideDataType = 19;
pub const AVPacketSideDataType_AV_PKT_DATA_MASTERING_DISPLAY_METADATA: AVPacketSideDataType = 20;
pub const AVPacketSideDataType_AV_PKT_DATA_SPHERICAL: AVPacketSideDataType = 21;
pub const AVPacketSideDataType_AV_PKT_DATA_CONTENT_LIGHT_LEVEL: AVPacketSideDataType = 22;
pub const AVPacketSideDataType_AV_PKT_DATA_A53_CC: AVPacketSideDataType = 23;
pub const AVPacketSideDataType_AV_PKT_DATA_ENCRYPTION_INIT_INFO: AVPacketSideDataType = 24;
pub const AVPacketSideDataType_AV_PKT_DATA_ENCRYPTION_INFO: AVPacketSideDataType = 25;
pub const AVPacketSideDataType_AV_PKT_DATA_AFD: AVPacketSideDataType = 26;
pub const AVPacketSideDataType_AV_PKT_DATA_PRFT: AVPacketSideDataType = 27;
pub const AVPacketSideDataType_AV_PKT_DATA_ICC_PROFILE: AVPacketSideDataType = 28;
pub const AVPacketSideDataType_AV_PKT_DATA_DOVI_CONF: AVPacketSideDataType = 29;
pub const AVPacketSideDataType_AV_PKT_DATA_S12M_TIMECODE: AVPacketSideDataType = 30;
pub const AVPacketSideDataType_AV_PKT_DATA_DYNAMIC_HDR10_PLUS: AVPacketSideDataType = 31;
pub const AVPacketSideDataType_AV_PKT_DATA_IAMF_MIX_GAIN_PARAM: AVPacketSideDataType = 32;
pub const AVPacketSideDataType_AV_PKT_DATA_IAMF_DEMIXING_INFO_PARAM: AVPacketSideDataType = 33;
pub const AVPacketSideDataType_AV_PKT_DATA_IAMF_RECON_GAIN_INFO_PARAM: AVPacketSideDataType = 34;
pub const AVPacketSideDataType_AV_PKT_DATA_AMBIENT_VIEWING_ENVIRONMENT: AVPacketSideDataType = 35;
pub const AVPacketSideDataType_AV_PKT_DATA_FRAME_CROPPING: AVPacketSideDataType = 36;
pub const AVPacketSideDataType_AV_PKT_DATA_LCEVC: AVPacketSideDataType = 37;
pub const AVPacketSideDataType_AV_PKT_DATA_3D_REFERENCE_DISPLAYS: AVPacketSideDataType = 38;
pub const AVPacketSideDataType_AV_PKT_DATA_RTCP_SR: AVPacketSideDataType = 39;
pub const AVPacketSideDataType_AV_PKT_DATA_NB: AVPacketSideDataType = 40;
pub type AVPacketSideDataType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVPacketSideData {
    pub data: *mut u8,
    pub size: usize,
    pub type_: AVPacketSideDataType,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AVPacketSideData"][::std::mem::size_of::<AVPacketSideData>() - 24usize];
    ["Alignment of AVPacketSideData"][::std::mem::align_of::<AVPacketSideData>() - 8usize];
    ["Offset of field: AVPacketSideData::data"]
        [::std::mem::offset_of!(AVPacketSideData, data) - 0usize];
    ["Offset of field: AVPacketSideData::size"]
        [::std::mem::offset_of!(AVPacketSideData, size) - 8usize];
    ["Offset of field: AVPacketSideData::type_"]
        [::std::mem::offset_of!(AVPacketSideData, type_) - 16usize];
};
impl Default for AVPacketSideData {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AVPacket {
    pub buf: *mut AVBufferRef,
    pub pts: i64,
    pub dts: i64,
    pub data: *mut u8,
    pub size: ::std::os::raw::c_int,
    pub stream_index: ::std::os::raw::c_int,
    pub flags: ::std::os::raw::c_int,
    pub side_data: *mut AVPacketSideData,
    pub side_data_elems: ::std::os::raw::c_int,
    pub duration: i64,
    pub pos: i64,
    pub opaque: *mut ::std::os::raw::c_void,
    pub opaque_ref: *mut AVBufferRef,
    pub time_base: AVRational,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AVPacket"][::std::mem::size_of::<AVPacket>() - 104usize];
    ["Alignment of AVPacket"][::std::mem::align_of::<AVPacket>() - 8usize];
    ["Offset of field: AVPacket::buf"][::std::mem::offset_of!(AVPacket, buf) - 0usize];
    ["Offset of field: AVPacket::pts"][::std::mem::offset_of!(AVPacket, pts) - 8usize];
    ["Offset of field: AVPacket::dts"][::std::mem::offset_of!(AVPacket, dts) - 16usize];
    ["Offset of field: AVPacket::data"][::std::mem::offset_of!(AVPacket, data) - 24usize];
    ["Offset of field: AVPacket::size"][::std::mem::offset_of!(AVPacket, size) - 32usize];
    ["Offset of field: AVPacket::stream_index"]
        [::std::mem::offset_of!(AVPacket, stream_index) - 36usize];
    ["Offset of field: AVPacket::flags"][::std::mem::offset_of!(AVPacket, flags) - 40usize];
    ["Offset of field: AVPacket::side_data"][::std::mem::offset_of!(AVPacket, side_data) - 48usize];
    ["Offset of field: AVPacket::side_data_elems"]
        [::std::mem::offset_of!(AVPacket, side_data_elems) - 56usize];
    ["Offset of field: AVPacket::duration"][::std::mem::offset_of!(AVPacket, duration) - 64usize];
    ["Offset of field: AVPacket::pos"][::std::mem::offset_of!(AVPacket, pos) - 72usize];
    ["Offset of field: AVPacket::opaque"][::std::mem::offset_of!(AVPacket, opaque) - 80usize];
    ["Offset of field: AVPacket::opaque_ref"]
        [::std::mem::offset_of!(AVPacket, opaque_ref) - 88usize];
    ["Offset of field: AVPacket::time_base"][::std::mem::offset_of!(AVPacket, time_base) - 96usize];
};
impl Default for AVPacket {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn edit_distance(
        word1: *mut ::std::os::raw::c_char,
        word2: *mut ::std::os::raw::c_char,
        len1: ::std::os::raw::c_int,
        len2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn convert_pts_to_ms(pts: i64, time_base: AVRational) -> i64;
}
unsafe extern "C" {
    pub fn convert_pts_to_ns(pts: i64, time_base: AVRational) -> i64;
}
unsafe extern "C" {
    pub fn convert_pts_to_s(pts: i64, time_base: AVRational) -> i64;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct word_list {
    pub words: *mut *mut ::std::os::raw::c_char,
    pub len: usize,
    pub capacity: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of word_list"][::std::mem::size_of::<word_list>() - 24usize];
    ["Alignment of word_list"][::std::mem::align_of::<word_list>() - 8usize];
    ["Offset of field: word_list::words"][::std::mem::offset_of!(word_list, words) - 0usize];
    ["Offset of field: word_list::len"][::std::mem::offset_of!(word_list, len) - 8usize];
    ["Offset of field: word_list::capacity"][::std::mem::offset_of!(word_list, capacity) - 16usize];
};
impl Default for word_list {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ccx_ad_pres_format_PRES_FORMAT_SD: ccx_ad_pres_format = 1;
pub const ccx_ad_pres_format_PRES_FORMAT_HD: ccx_ad_pres_format = 2;
pub type ccx_ad_pres_format = ::std::os::raw::c_uint;
pub const mpeg_picture_coding_CCX_MPC_NONE: mpeg_picture_coding = 0;
pub const mpeg_picture_coding_CCX_MPC_I_FRAME: mpeg_picture_coding = 1;
pub const mpeg_picture_coding_CCX_MPC_P_FRAME: mpeg_picture_coding = 2;
pub const mpeg_picture_coding_CCX_MPC_B_FRAME: mpeg_picture_coding = 3;
pub type mpeg_picture_coding = ::std::os::raw::c_uint;
pub const mpeg_picture_struct_CCX_MPS_NONE: mpeg_picture_struct = 0;
pub const mpeg_picture_struct_CCX_MPS_TOP_FIELD: mpeg_picture_struct = 1;
pub const mpeg_picture_struct_CCX_MPS_BOTTOM_FIELD: mpeg_picture_struct = 2;
pub const mpeg_picture_struct_CCX_MPS_FRAME: mpeg_picture_struct = 3;
pub type mpeg_picture_struct = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ccx_gxf_video_track {
    pub track_name: [::std::os::raw::c_char; 256usize],
    pub fs_version: u32,
    #[doc = " Frame Rate Calculate time stamp on basis of this"]
    pub frame_rate: ccx_rational,
    #[doc = " Lines per frame (valid value for AD tracks)\n May be used while parsing vbi"]
    pub line_per_frame: u32,
    #[doc = "  Field per frame (Need when parsing vbi)\n 1 = Progressive\n 2 = Interlaced\n -1 = Not applicable\n -2 = Not available"]
    pub field_per_frame: u32,
    pub p_code: mpeg_picture_coding,
    pub p_struct: mpeg_picture_struct,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_gxf_video_track"][::std::mem::size_of::<ccx_gxf_video_track>() - 284usize];
    ["Alignment of ccx_gxf_video_track"][::std::mem::align_of::<ccx_gxf_video_track>() - 4usize];
    ["Offset of field: ccx_gxf_video_track::track_name"]
        [::std::mem::offset_of!(ccx_gxf_video_track, track_name) - 0usize];
    ["Offset of field: ccx_gxf_video_track::fs_version"]
        [::std::mem::offset_of!(ccx_gxf_video_track, fs_version) - 256usize];
    ["Offset of field: ccx_gxf_video_track::frame_rate"]
        [::std::mem::offset_of!(ccx_gxf_video_track, frame_rate) - 260usize];
    ["Offset of field: ccx_gxf_video_track::line_per_frame"]
        [::std::mem::offset_of!(ccx_gxf_video_track, line_per_frame) - 268usize];
    ["Offset of field: ccx_gxf_video_track::field_per_frame"]
        [::std::mem::offset_of!(ccx_gxf_video_track, field_per_frame) - 272usize];
    ["Offset of field: ccx_gxf_video_track::p_code"]
        [::std::mem::offset_of!(ccx_gxf_video_track, p_code) - 276usize];
    ["Offset of field: ccx_gxf_video_track::p_struct"]
        [::std::mem::offset_of!(ccx_gxf_video_track, p_struct) - 280usize];
};
impl Default for ccx_gxf_video_track {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ccx_gxf_ancillary_data_track {
    pub track_name: [::std::os::raw::c_char; 256usize],
    pub id: ::std::os::raw::c_uchar,
    pub ad_format: ccx_ad_pres_format,
    pub nb_field: ::std::os::raw::c_int,
    pub field_size: ::std::os::raw::c_int,
    #[doc = " Byte size of the ancillary data media packet in 256 byte units:\n This value shall be 256, indicating an ancillary data media packet size\n of 65536 bytes"]
    pub packet_size: ::std::os::raw::c_int,
    pub fs_version: u32,
    #[doc = " Frame Rate XXX AD track do have vaild but this field may\n be ignored since related to only video"]
    pub frame_rate: u32,
    #[doc = " Lines per frame (valid value for AD tracks)\n XXX may be ignored since related to raw video frame"]
    pub line_per_frame: u32,
    pub field_per_frame: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_gxf_ancillary_data_track"]
        [::std::mem::size_of::<ccx_gxf_ancillary_data_track>() - 292usize];
    ["Alignment of ccx_gxf_ancillary_data_track"]
        [::std::mem::align_of::<ccx_gxf_ancillary_data_track>() - 4usize];
    ["Offset of field: ccx_gxf_ancillary_data_track::track_name"]
        [::std::mem::offset_of!(ccx_gxf_ancillary_data_track, track_name) - 0usize];
    ["Offset of field: ccx_gxf_ancillary_data_track::id"]
        [::std::mem::offset_of!(ccx_gxf_ancillary_data_track, id) - 256usize];
    ["Offset of field: ccx_gxf_ancillary_data_track::ad_format"]
        [::std::mem::offset_of!(ccx_gxf_ancillary_data_track, ad_format) - 260usize];
    ["Offset of field: ccx_gxf_ancillary_data_track::nb_field"]
        [::std::mem::offset_of!(ccx_gxf_ancillary_data_track, nb_field) - 264usize];
    ["Offset of field: ccx_gxf_ancillary_data_track::field_size"]
        [::std::mem::offset_of!(ccx_gxf_ancillary_data_track, field_size) - 268usize];
    ["Offset of field: ccx_gxf_ancillary_data_track::packet_size"]
        [::std::mem::offset_of!(ccx_gxf_ancillary_data_track, packet_size) - 272usize];
    ["Offset of field: ccx_gxf_ancillary_data_track::fs_version"]
        [::std::mem::offset_of!(ccx_gxf_ancillary_data_track, fs_version) - 276usize];
    ["Offset of field: ccx_gxf_ancillary_data_track::frame_rate"]
        [::std::mem::offset_of!(ccx_gxf_ancillary_data_track, frame_rate) - 280usize];
    ["Offset of field: ccx_gxf_ancillary_data_track::line_per_frame"]
        [::std::mem::offset_of!(ccx_gxf_ancillary_data_track, line_per_frame) - 284usize];
    ["Offset of field: ccx_gxf_ancillary_data_track::field_per_frame"]
        [::std::mem::offset_of!(ccx_gxf_ancillary_data_track, field_per_frame) - 288usize];
};
impl Default for ccx_gxf_ancillary_data_track {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ccx_gxf {
    pub nb_streams: ::std::os::raw::c_int,
    pub media_name: [::std::os::raw::c_char; 256usize],
    #[doc = "  The first field number shall represent the position on a playout\n  time line of the first recorded field on a track"]
    pub first_field_nb: i32,
    #[doc = " The last field number shall represent the position on a playout\n  time line of the last recorded field plus one."]
    pub last_field_nb: i32,
    #[doc = " The mark in field number shall represent the position on a playout\n  time line of the first field to be played from a track."]
    pub mark_in: i32,
    #[doc = " The mark out field number shall represent the position on a playout\n time line of the last field to be played plus one"]
    pub mark_out: i32,
    #[doc = " Estimated size in kb for bytes multiply by 1024"]
    pub stream_size: i32,
    pub ad_track: *mut ccx_gxf_ancillary_data_track,
    pub vid_track: *mut ccx_gxf_video_track,
    #[doc = " cdp data buffer"]
    pub cdp: *mut ::std::os::raw::c_uchar,
    pub cdp_len: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ccx_gxf"][::std::mem::size_of::<ccx_gxf>() - 312usize];
    ["Alignment of ccx_gxf"][::std::mem::align_of::<ccx_gxf>() - 8usize];
    ["Offset of field: ccx_gxf::nb_streams"][::std::mem::offset_of!(ccx_gxf, nb_streams) - 0usize];
    ["Offset of field: ccx_gxf::media_name"][::std::mem::offset_of!(ccx_gxf, media_name) - 4usize];
    ["Offset of field: ccx_gxf::first_field_nb"]
        [::std::mem::offset_of!(ccx_gxf, first_field_nb) - 260usize];
    ["Offset of field: ccx_gxf::last_field_nb"]
        [::std::mem::offset_of!(ccx_gxf, last_field_nb) - 264usize];
    ["Offset of field: ccx_gxf::mark_in"][::std::mem::offset_of!(ccx_gxf, mark_in) - 268usize];
    ["Offset of field: ccx_gxf::mark_out"][::std::mem::offset_of!(ccx_gxf, mark_out) - 272usize];
    ["Offset of field: ccx_gxf::stream_size"]
        [::std::mem::offset_of!(ccx_gxf, stream_size) - 276usize];
    ["Offset of field: ccx_gxf::ad_track"][::std::mem::offset_of!(ccx_gxf, ad_track) - 280usize];
    ["Offset of field: ccx_gxf::vid_track"][::std::mem::offset_of!(ccx_gxf, vid_track) - 288usize];
    ["Offset of field: ccx_gxf::cdp"][::std::mem::offset_of!(ccx_gxf, cdp) - 296usize];
    ["Offset of field: ccx_gxf::cdp_len"][::std::mem::offset_of!(ccx_gxf, cdp_len) - 304usize];
};
impl Default for ccx_gxf {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn ccx_gxf_probe(
        buf: *mut ::std::os::raw::c_uchar,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn ccx_gxf_init(arg: *mut ccx_demuxer) -> *mut ccx_gxf;
}
pub type UID = [u8; 16usize];
pub const MXFCaptionType_MXF_CT_VBI: MXFCaptionType = 0;
pub const MXFCaptionType_MXF_CT_ANC: MXFCaptionType = 1;
pub type MXFCaptionType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct MXFTrack {
    pub track_id: ::std::os::raw::c_int,
    pub track_number: [u8; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of MXFTrack"][::std::mem::size_of::<MXFTrack>() - 8usize];
    ["Alignment of MXFTrack"][::std::mem::align_of::<MXFTrack>() - 4usize];
    ["Offset of field: MXFTrack::track_id"][::std::mem::offset_of!(MXFTrack, track_id) - 0usize];
    ["Offset of field: MXFTrack::track_number"]
        [::std::mem::offset_of!(MXFTrack, track_number) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MXFContext {
    pub type_: MXFCaptionType,
    pub cap_track_id: ::std::os::raw::c_int,
    pub cap_essence_key: UID,
    pub tracks: [MXFTrack; 32usize],
    pub nb_tracks: ::std::os::raw::c_int,
    pub cap_count: ::std::os::raw::c_int,
    pub edit_rate: ccx_rational,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of MXFContext"][::std::mem::size_of::<MXFContext>() - 296usize];
    ["Alignment of MXFContext"][::std::mem::align_of::<MXFContext>() - 4usize];
    ["Offset of field: MXFContext::type_"][::std::mem::offset_of!(MXFContext, type_) - 0usize];
    ["Offset of field: MXFContext::cap_track_id"]
        [::std::mem::offset_of!(MXFContext, cap_track_id) - 4usize];
    ["Offset of field: MXFContext::cap_essence_key"]
        [::std::mem::offset_of!(MXFContext, cap_essence_key) - 8usize];
    ["Offset of field: MXFContext::tracks"][::std::mem::offset_of!(MXFContext, tracks) - 24usize];
    ["Offset of field: MXFContext::nb_tracks"]
        [::std::mem::offset_of!(MXFContext, nb_tracks) - 280usize];
    ["Offset of field: MXFContext::cap_count"]
        [::std::mem::offset_of!(MXFContext, cap_count) - 284usize];
    ["Offset of field: MXFContext::edit_rate"]
        [::std::mem::offset_of!(MXFContext, edit_rate) - 288usize];
};
impl Default for MXFContext {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn ccx_probe_mxf(ctx: *mut ccx_demuxer) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn ccx_mxf_init(demux: *mut ccx_demuxer) -> *mut MXFContext;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ccx_decoders_xds_context {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ccx_decoder_vbi_ctx {
    pub _address: u8,
}
