/*
 * Fooyin
 * Copyright © 2024, Luke Taylor <LukeT1@proton.me>
 *
 * Fooyin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fooyin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fooyin.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#pragma once

#include "artworkitem.h"

#include <QAbstractItemModel>

namespace Fooyin {
struct ArtworkResult;
struct SearchResult;

class ArtworkModel : public QAbstractListModel
{
    Q_OBJECT

public:
    explicit ArtworkModel(SettingsManager* settings, QObject* parent = nullptr);

    void addPendingCover(const SearchResult& result);
    void loadCover(const QUrl& url, const ArtworkResult& result);
    void updateCoverProgress(const QUrl& url, int progress);
    void removeCover(const QUrl& url);
    void clear();

    [[nodiscard]] Qt::ItemFlags flags(const QModelIndex& index) const override;
    [[nodiscard]] int rowCount(const QModelIndex& parent) const override;
    [[nodiscard]] QVariant data(const QModelIndex& index, int role) const override;

private:
    void invalidateData();

    SettingsManager* m_settings;

    std::vector<ArtworkItem> m_items;
};
} // namespace Fooyin
