#include "help_texts.hpp"
namespace horizon {
const char* HelpTexts::ENTITY_GATE_SWAP_GROUP = R"EOF(Defines whether a gate can be swapped with other gates of the same unit.

Gates in swap group 0 can't be swapped at all.

Gates in a nonzero swap group can be swapped with other gates of the same swap group and unit.)EOF";
const char* HelpTexts::ENTITY_GATE_SUFFIX = R"EOF(Suffix that gets appended to the reference designator, for example U101B.

Leave blank for single-gate entities. Use A,B,C,… for multi-gate entities.

If there's a gate dedicated to power supply, its suffix should be P.)EOF";
const char* HelpTexts::ENTITY_GATE_NAME = R"EOF(If there's only a single gate, its name should be "Main".)EOF";
const char* HelpTexts::UNIT_PIN_ALT_NAMES = R"EOF(If a pin has multiple functions, add these here.

For example: Pin name: PB0, alternate names: I2C0_SDA ADC2_IN.)EOF";
const char* HelpTexts::POSITION_FORMAT = R"EOF(<tt>printf</tt>-style formatting for positions.

<tt>%.</tt>&lt;precision&gt;&lt;unit&gt;
precision: number of decimal places 0...9
unit: <tt>m</tt>: millimeter, <tt>i</tt>: inch, <tt>t</tt>: thou/mil, <tt>u</tt>: micrometer)EOF";
const char* HelpTexts::SYMBOL_CAN_EXPAND = R"EOF(Set this for box-style symbols if there are alternate pin names or the user is expected to add custom pin names. In this case, size the symbol such that it fits the primary pin names.)EOF";
const char* HelpTexts::PLANE_PRIORITY = R"EOF(Planes with lower fill order will get filled first.
Make sure to assign distinct fill orders to overlapping planes.
A plane completely enclosing another one needs a higher fill order than the enclosed plane.)EOF";
const char* HelpTexts::ROUTING_OFFSET = R"EOF(When routing or dragging a track, this offset gets added to the clearance specified in the rules.
You can override it in the router tool.)EOF";
const char* HelpTexts::INPUT_DEVICES = R"EOF(If a touchpad or trackpoint isn't detected as such, you can manually set the device type.)EOF";
const char* HelpTexts::INPUT_DEVICE_TYPES = R"EOF(Select invert zoom/pan to reverse the scrolling direction for zooming or panning.)EOF";
}
