import { Duration } from 'luxon';
import { SemVer } from 'semver';
import { DatabaseExtension, ExifOrientation } from 'src/enum';
export declare const POSTGRES_VERSION_RANGE = ">=14.0.0";
export declare const VECTORCHORD_VERSION_RANGE = ">=0.3 <0.6";
export declare const VECTORS_VERSION_RANGE = ">=0.2 <0.4";
export declare const VECTOR_VERSION_RANGE = ">=0.5 <1";
export declare const NEXT_RELEASE = "NEXT_RELEASE";
export declare const LIFECYCLE_EXTENSION = "x-immich-lifecycle";
export declare const DEPRECATED_IN_PREFIX = "This property was deprecated in ";
export declare const ADDED_IN_PREFIX = "This property was added in ";
export declare const JOBS_ASSET_PAGINATION_SIZE = 1000;
export declare const JOBS_LIBRARY_PAGINATION_SIZE = 10000;
export declare const EXTENSION_NAMES: Record<DatabaseExtension, string>;
export declare const VECTOR_EXTENSIONS: readonly [DatabaseExtension.VectorChord, DatabaseExtension.Vectors, DatabaseExtension.Vector];
export declare const VECTOR_INDEX_TABLES: {
    readonly clip_index: "smart_search";
    readonly face_index: "face_search";
};
export declare const VECTORCHORD_LIST_SLACK_FACTOR = 1.2;
export declare const SALT_ROUNDS = 10;
export declare const IWorker = "IWorker";
export declare const serverVersion: SemVer;
export declare const AUDIT_LOG_MAX_DURATION: Duration<true>;
export declare const ONE_HOUR: Duration<true>;
export declare const citiesFile = "cities500.txt";
export declare const reverseGeocodeMaxDistance = 25000;
export declare const MOBILE_REDIRECT = "app.immich:///oauth-callback";
export declare const LOGIN_URL = "/auth/login?autoLaunch=0";
export declare const excludePaths: string[];
export declare const FACE_THUMBNAIL_SIZE = 250;
type ModelInfo = {
    dimSize: number;
};
export declare const CLIP_MODEL_INFO: Record<string, ModelInfo>;
type SharpRotationData = {
    angle?: number;
    flip?: boolean;
    flop?: boolean;
};
export declare const ORIENTATION_TO_SHARP_ROTATION: Record<ExifOrientation, SharpRotationData>;
export {};
