"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiKeyController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const api_key_dto_1 = require("../dtos/api-key.dto");
const auth_dto_1 = require("../dtos/auth.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const api_key_service_1 = require("../services/api-key.service");
const validation_1 = require("../validation");
let ApiKeyController = class ApiKeyController {
    service;
    constructor(service) {
        this.service = service;
    }
    createApiKey(auth, dto) {
        return this.service.create(auth, dto);
    }
    getApiKeys(auth) {
        return this.service.getAll(auth);
    }
    async getMyApiKey(auth) {
        return this.service.getMine(auth);
    }
    getApiKey(auth, { id }) {
        return this.service.getById(auth, id);
    }
    updateApiKey(auth, { id }, dto) {
        return this.service.update(auth, id, dto);
    }
    deleteApiKey(auth, { id }) {
        return this.service.delete(auth, id);
    }
};
exports.ApiKeyController = ApiKeyController;
__decorate([
    (0, common_1.Post)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.ApiKeyCreate }),
    openapi.ApiResponse({ status: 201, type: require("../dtos/api-key.dto").APIKeyCreateResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, api_key_dto_1.APIKeyCreateDto]),
    __metadata("design:returntype", Promise)
], ApiKeyController.prototype, "createApiKey", null);
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.ApiKeyRead }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/api-key.dto").APIKeyResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], ApiKeyController.prototype, "getApiKeys", null);
__decorate([
    (0, common_1.Get)('me'),
    (0, auth_guard_1.Authenticated)({ permission: false }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/api-key.dto").APIKeyResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], ApiKeyController.prototype, "getMyApiKey", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.ApiKeyRead }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/api-key.dto").APIKeyResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], ApiKeyController.prototype, "getApiKey", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.ApiKeyUpdate }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/api-key.dto").APIKeyResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        api_key_dto_1.APIKeyUpdateDto]),
    __metadata("design:returntype", Promise)
], ApiKeyController.prototype, "updateApiKey", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.ApiKeyDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], ApiKeyController.prototype, "deleteApiKey", null);
exports.ApiKeyController = ApiKeyController = __decorate([
    (0, swagger_1.ApiTags)('API Keys'),
    (0, common_1.Controller)('api-keys'),
    __metadata("design:paramtypes", [api_key_service_1.ApiKeyService])
], ApiKeyController);
//# sourceMappingURL=api-key.controller.js.map