import { NextFunction, Request, Response } from 'express';
import { AssetBulkUploadCheckResponseDto, AssetMediaResponseDto, CheckExistingAssetsResponseDto } from 'src/dtos/asset-media-response.dto';
import { AssetBulkUploadCheckDto, AssetMediaCreateDto, AssetMediaOptionsDto, AssetMediaReplaceDto, CheckExistingAssetsDto } from 'src/dtos/asset-media.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { AssetMediaService } from 'src/services/asset-media.service';
import { UploadFiles } from 'src/types';
import { UUIDParamDto } from 'src/validation';
export declare class AssetMediaController {
    private logger;
    private service;
    constructor(logger: LoggingRepository, service: AssetMediaService);
    uploadAsset(auth: AuthDto, files: UploadFiles, dto: AssetMediaCreateDto, res: Response): Promise<AssetMediaResponseDto>;
    downloadAsset(auth: AuthDto, { id }: UUIDParamDto, res: Response, next: NextFunction): Promise<void>;
    replaceAsset(auth: AuthDto, { id }: UUIDParamDto, files: UploadFiles, dto: AssetMediaReplaceDto, res: Response): Promise<AssetMediaResponseDto>;
    viewAsset(auth: AuthDto, { id }: UUIDParamDto, dto: AssetMediaOptionsDto, req: Request, res: Response, next: NextFunction): Promise<void>;
    playAssetVideo(auth: AuthDto, { id }: UUIDParamDto, res: Response, next: NextFunction): Promise<void>;
    checkExistingAssets(auth: AuthDto, dto: CheckExistingAssetsDto): Promise<CheckExistingAssetsResponseDto>;
    checkBulkUpload(auth: AuthDto, dto: AssetBulkUploadCheckDto): Promise<AssetBulkUploadCheckResponseDto>;
}
