"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const asset_dto_1 = require("../dtos/asset.dto");
const auth_dto_1 = require("../dtos/auth.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const asset_service_1 = require("../services/asset.service");
const validation_1 = require("../validation");
let AssetController = class AssetController {
    service;
    constructor(service) {
        this.service = service;
    }
    getRandom(auth, dto) {
        return this.service.getRandom(auth, dto.count ?? 1);
    }
    getAllUserAssetsByDeviceId(auth, { deviceId }) {
        return this.service.getUserAssetsByDeviceId(auth, deviceId);
    }
    getAssetStatistics(auth, dto) {
        return this.service.getStatistics(auth, dto);
    }
    runAssetJobs(auth, dto) {
        return this.service.run(auth, dto);
    }
    updateAssets(auth, dto) {
        return this.service.updateAll(auth, dto);
    }
    deleteAssets(auth, dto) {
        return this.service.deleteAll(auth, dto);
    }
    getAssetInfo(auth, { id }) {
        return this.service.get(auth, id);
    }
    updateAsset(auth, { id }, dto) {
        return this.service.update(auth, id, dto);
    }
    getAssetMetadata(auth, { id }) {
        return this.service.getMetadata(auth, id);
    }
    updateAssetMetadata(auth, { id }, dto) {
        return this.service.upsertMetadata(auth, id, dto);
    }
    getAssetMetadataByKey(auth, { id, key }) {
        return this.service.getMetadataByKey(auth, id, key);
    }
    deleteAssetMetadata(auth, { id, key }) {
        return this.service.deleteMetadataByKey(auth, id, key);
    }
};
exports.AssetController = AssetController;
__decorate([
    (0, common_1.Get)('random'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetRead }),
    (0, decorators_1.EndpointLifecycle)({ deprecatedAt: 'v1.116.0' }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/asset-response.dto").AssetResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, asset_dto_1.RandomAssetsDto]),
    __metadata("design:returntype", Promise)
], AssetController.prototype, "getRandom", null);
__decorate([
    (0, swagger_1.ApiOperation)({ summary: "Get all asset of a device that are in the database, ID only.", summary: 'getAllUserAssetsByDeviceId',
        description: 'Get all asset of a device that are in the database, ID only.' }),
    (0, common_1.Get)('/device/:deviceId'),
    (0, auth_guard_1.Authenticated)(),
    openapi.ApiResponse({ status: 200, type: [String] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, asset_dto_1.DeviceIdDto]),
    __metadata("design:returntype", void 0)
], AssetController.prototype, "getAllUserAssetsByDeviceId", null);
__decorate([
    (0, common_1.Get)('statistics'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetStatistics }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/asset.dto").AssetStatsResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, asset_dto_1.AssetStatsDto]),
    __metadata("design:returntype", Promise)
], AssetController.prototype, "getAssetStatistics", null);
__decorate([
    (0, common_1.Post)('jobs'),
    (0, auth_guard_1.Authenticated)(),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, asset_dto_1.AssetJobsDto]),
    __metadata("design:returntype", Promise)
], AssetController.prototype, "runAssetJobs", null);
__decorate([
    (0, common_1.Put)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetUpdate }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, asset_dto_1.AssetBulkUpdateDto]),
    __metadata("design:returntype", Promise)
], AssetController.prototype, "updateAssets", null);
__decorate([
    (0, common_1.Delete)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, asset_dto_1.AssetBulkDeleteDto]),
    __metadata("design:returntype", Promise)
], AssetController.prototype, "deleteAssets", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetRead, sharedLink: true }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/asset-response.dto").AssetResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], AssetController.prototype, "getAssetInfo", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetUpdate }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/asset-response.dto").AssetResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        asset_dto_1.UpdateAssetDto]),
    __metadata("design:returntype", Promise)
], AssetController.prototype, "updateAsset", null);
__decorate([
    (0, common_1.Get)(':id/metadata'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetRead }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/asset.dto").AssetMetadataResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], AssetController.prototype, "getAssetMetadata", null);
__decorate([
    (0, common_1.Put)(':id/metadata'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetUpdate }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/asset.dto").AssetMetadataResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        asset_dto_1.AssetMetadataUpsertDto]),
    __metadata("design:returntype", Promise)
], AssetController.prototype, "updateAssetMetadata", null);
__decorate([
    (0, common_1.Get)(':id/metadata/:key'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetRead }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/asset.dto").AssetMetadataResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        asset_dto_1.AssetMetadataRouteParams]),
    __metadata("design:returntype", Promise)
], AssetController.prototype, "getAssetMetadataByKey", null);
__decorate([
    (0, common_1.Delete)(':id/metadata/:key'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetUpdate }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, asset_dto_1.AssetMetadataRouteParams]),
    __metadata("design:returntype", Promise)
], AssetController.prototype, "deleteAssetMetadata", null);
exports.AssetController = AssetController = __decorate([
    (0, swagger_1.ApiTags)('Assets'),
    (0, common_1.Controller)(enum_1.RouteKey.Asset),
    __metadata("design:paramtypes", [asset_service_1.AssetService])
], AssetController);
//# sourceMappingURL=asset.controller.js.map