"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const auth_dto_1 = require("../dtos/auth.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const auth_service_1 = require("../services/auth.service");
const response_1 = require("../utils/response");
let AuthController = class AuthController {
    service;
    constructor(service) {
        this.service = service;
    }
    async login(res, loginCredential, loginDetails) {
        const body = await this.service.login(loginCredential, loginDetails);
        return (0, response_1.respondWithCookie)(res, body, {
            isSecure: loginDetails.isSecure,
            values: [
                { key: enum_1.ImmichCookie.AccessToken, value: body.accessToken },
                { key: enum_1.ImmichCookie.AuthType, value: enum_1.AuthType.Password },
                { key: enum_1.ImmichCookie.IsAuthenticated, value: 'true' },
            ],
        });
    }
    signUpAdmin(dto) {
        return this.service.adminSignUp(dto);
    }
    validateAccessToken() {
        return { authStatus: true };
    }
    changePassword(auth, dto) {
        return this.service.changePassword(auth, dto);
    }
    async logout(request, res, auth) {
        const authType = (request.cookies || {})[enum_1.ImmichCookie.AuthType];
        const body = await this.service.logout(auth, authType);
        return (0, response_1.respondWithoutCookie)(res, body, [
            enum_1.ImmichCookie.AccessToken,
            enum_1.ImmichCookie.AuthType,
            enum_1.ImmichCookie.IsAuthenticated,
        ]);
    }
    getAuthStatus(auth) {
        return this.service.getAuthStatus(auth);
    }
    setupPinCode(auth, dto) {
        return this.service.setupPinCode(auth, dto);
    }
    async changePinCode(auth, dto) {
        return this.service.changePinCode(auth, dto);
    }
    async resetPinCode(auth, dto) {
        return this.service.resetPinCode(auth, dto);
    }
    async unlockAuthSession(auth, dto) {
        return this.service.unlockSession(auth, dto);
    }
    async lockAuthSession(auth) {
        return this.service.lockSession(auth);
    }
};
exports.AuthController = AuthController;
__decorate([
    (0, common_1.Post)('login'),
    openapi.ApiResponse({ status: 201, type: require("../dtos/auth.dto").LoginResponseDto }),
    __param(0, (0, common_1.Res)({ passthrough: true })),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, auth_guard_1.GetLoginDetails)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, auth_dto_1.LoginCredentialDto, Object]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "login", null);
__decorate([
    (0, common_1.Post)('admin-sign-up'),
    openapi.ApiResponse({ status: 201, type: require("../dtos/user.dto").UserAdminResponseDto }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.SignUpDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "signUpAdmin", null);
__decorate([
    (0, common_1.Post)('validateToken'),
    (0, auth_guard_1.Authenticated)({ permission: false }),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: require("../dtos/auth.dto").ValidateAccessTokenResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", auth_dto_1.ValidateAccessTokenResponseDto)
], AuthController.prototype, "validateAccessToken", null);
__decorate([
    (0, common_1.Post)('change-password'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AuthChangePassword }),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: require("../dtos/user.dto").UserAdminResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, auth_dto_1.ChangePasswordDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "changePassword", null);
__decorate([
    (0, common_1.Post)('logout'),
    (0, auth_guard_1.Authenticated)(),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: require("../dtos/auth.dto").LogoutResponseDto }),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Res)({ passthrough: true })),
    __param(2, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object, auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "logout", null);
__decorate([
    (0, common_1.Get)('status'),
    (0, auth_guard_1.Authenticated)(),
    openapi.ApiResponse({ status: 200, type: require("../dtos/auth.dto").AuthStatusResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "getAuthStatus", null);
__decorate([
    (0, common_1.Post)('pin-code'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PinCodeCreate }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, auth_dto_1.PinCodeSetupDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "setupPinCode", null);
__decorate([
    (0, common_1.Put)('pin-code'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PinCodeUpdate }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, auth_dto_1.PinCodeChangeDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "changePinCode", null);
__decorate([
    (0, common_1.Delete)('pin-code'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PinCodeDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, auth_dto_1.PinCodeResetDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "resetPinCode", null);
__decorate([
    (0, common_1.Post)('session/unlock'),
    (0, auth_guard_1.Authenticated)(),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, auth_dto_1.SessionUnlockDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "unlockAuthSession", null);
__decorate([
    (0, common_1.Post)('session/lock'),
    (0, auth_guard_1.Authenticated)(),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "lockAuthSession", null);
exports.AuthController = AuthController = __decorate([
    (0, swagger_1.ApiTags)('Authentication'),
    (0, common_1.Controller)('auth'),
    __metadata("design:paramtypes", [auth_service_1.AuthService])
], AuthController);
//# sourceMappingURL=auth.controller.js.map