"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DownloadController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const asset_dto_1 = require("../dtos/asset.dto");
const auth_dto_1 = require("../dtos/auth.dto");
const download_dto_1 = require("../dtos/download.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const download_service_1 = require("../services/download.service");
const file_1 = require("../utils/file");
let DownloadController = class DownloadController {
    service;
    constructor(service) {
        this.service = service;
    }
    getDownloadInfo(auth, dto) {
        return this.service.getDownloadInfo(auth, dto);
    }
    downloadArchive(auth, dto) {
        return this.service.downloadArchive(auth, dto).then(file_1.asStreamableFile);
    }
};
exports.DownloadController = DownloadController;
__decorate([
    (0, common_1.Post)('info'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetDownload, sharedLink: true }),
    openapi.ApiResponse({ status: 201, type: require("../dtos/download.dto").DownloadResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, download_dto_1.DownloadInfoDto]),
    __metadata("design:returntype", Promise)
], DownloadController.prototype, "getDownloadInfo", null);
__decorate([
    (0, common_1.Post)('archive'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.AssetDownload, sharedLink: true }),
    (0, auth_guard_1.FileResponse)(),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, asset_dto_1.AssetIdsDto]),
    __metadata("design:returntype", Promise)
], DownloadController.prototype, "downloadArchive", null);
exports.DownloadController = DownloadController = __decorate([
    (0, swagger_1.ApiTags)('Download'),
    (0, common_1.Controller)('download'),
    __metadata("design:paramtypes", [download_service_1.DownloadService])
], DownloadController);
//# sourceMappingURL=download.controller.js.map