"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DuplicateController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const asset_ids_response_dto_1 = require("../dtos/asset-ids.response.dto");
const auth_dto_1 = require("../dtos/auth.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const duplicate_service_1 = require("../services/duplicate.service");
const validation_1 = require("../validation");
let DuplicateController = class DuplicateController {
    service;
    constructor(service) {
        this.service = service;
    }
    getAssetDuplicates(auth) {
        return this.service.getDuplicates(auth);
    }
    deleteDuplicates(auth, dto) {
        return this.service.deleteAll(auth, dto);
    }
    deleteDuplicate(auth, { id }) {
        return this.service.delete(auth, id);
    }
};
exports.DuplicateController = DuplicateController;
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.DuplicateRead }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/duplicate.dto").DuplicateResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], DuplicateController.prototype, "getAssetDuplicates", null);
__decorate([
    (0, common_1.Delete)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.DuplicateDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, asset_ids_response_dto_1.BulkIdsDto]),
    __metadata("design:returntype", Promise)
], DuplicateController.prototype, "deleteDuplicates", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.DuplicateDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], DuplicateController.prototype, "deleteDuplicate", null);
exports.DuplicateController = DuplicateController = __decorate([
    (0, swagger_1.ApiTags)('Duplicates'),
    (0, common_1.Controller)('duplicates'),
    __metadata("design:paramtypes", [duplicate_service_1.DuplicateService])
], DuplicateController);
//# sourceMappingURL=duplicate.controller.js.map