"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FaceController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const auth_dto_1 = require("../dtos/auth.dto");
const person_dto_1 = require("../dtos/person.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const person_service_1 = require("../services/person.service");
const validation_1 = require("../validation");
let FaceController = class FaceController {
    service;
    constructor(service) {
        this.service = service;
    }
    createFace(auth, dto) {
        return this.service.createFace(auth, dto);
    }
    getFaces(auth, dto) {
        return this.service.getFacesById(auth, dto);
    }
    reassignFacesById(auth, { id }, dto) {
        return this.service.reassignFacesById(auth, id, dto);
    }
    deleteFace(auth, { id }, dto) {
        return this.service.deleteFace(auth, id, dto);
    }
};
exports.FaceController = FaceController;
__decorate([
    (0, common_1.Post)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.FaceCreate }),
    openapi.ApiResponse({ status: 201 }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, person_dto_1.AssetFaceCreateDto]),
    __metadata("design:returntype", void 0)
], FaceController.prototype, "createFace", null);
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.FaceRead }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/person.dto").AssetFaceResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, person_dto_1.FaceDto]),
    __metadata("design:returntype", Promise)
], FaceController.prototype, "getFaces", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.FaceUpdate }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/person.dto").PersonResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        person_dto_1.FaceDto]),
    __metadata("design:returntype", Promise)
], FaceController.prototype, "reassignFacesById", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.FaceDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto, person_dto_1.AssetFaceDeleteDto]),
    __metadata("design:returntype", Promise)
], FaceController.prototype, "deleteFace", null);
exports.FaceController = FaceController = __decorate([
    (0, swagger_1.ApiTags)('Faces'),
    (0, common_1.Controller)('faces'),
    __metadata("design:paramtypes", [person_service_1.PersonService])
], FaceController);
//# sourceMappingURL=face.controller.js.map