"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const job_dto_1 = require("../dtos/job.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const job_service_1 = require("../services/job.service");
let JobController = class JobController {
    service;
    constructor(service) {
        this.service = service;
    }
    getAllJobsStatus() {
        return this.service.getAllJobsStatus();
    }
    createJob(dto) {
        return this.service.create(dto);
    }
    sendJobCommand({ id }, dto) {
        return this.service.handleCommand(id, dto);
    }
};
exports.JobController = JobController;
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.JobRead, admin: true }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/job.dto").AllJobStatusResponseDto }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], JobController.prototype, "getAllJobsStatus", null);
__decorate([
    (0, common_1.Post)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.JobCreate, admin: true }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [job_dto_1.JobCreateDto]),
    __metadata("design:returntype", Promise)
], JobController.prototype, "createJob", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.JobCreate, admin: true }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/job.dto").JobStatusDto }),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [job_dto_1.JobIdParamDto, job_dto_1.JobCommandDto]),
    __metadata("design:returntype", Promise)
], JobController.prototype, "sendJobCommand", null);
exports.JobController = JobController = __decorate([
    (0, swagger_1.ApiTags)('Jobs'),
    (0, common_1.Controller)('jobs'),
    __metadata("design:paramtypes", [job_service_1.JobService])
], JobController);
//# sourceMappingURL=job.controller.js.map