"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LibraryController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const library_dto_1 = require("../dtos/library.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const library_service_1 = require("../services/library.service");
const validation_1 = require("../validation");
let LibraryController = class LibraryController {
    service;
    constructor(service) {
        this.service = service;
    }
    getAllLibraries() {
        return this.service.getAll();
    }
    createLibrary(dto) {
        return this.service.create(dto);
    }
    getLibrary({ id }) {
        return this.service.get(id);
    }
    updateLibrary({ id }, dto) {
        return this.service.update(id, dto);
    }
    deleteLibrary({ id }) {
        return this.service.delete(id);
    }
    validate({ id }, dto) {
        return this.service.validate(id, dto);
    }
    getLibraryStatistics({ id }) {
        return this.service.getStatistics(id);
    }
    scanLibrary({ id }) {
        return this.service.queueScan(id);
    }
};
exports.LibraryController = LibraryController;
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.LibraryRead, admin: true }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/library.dto").LibraryResponseDto] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], LibraryController.prototype, "getAllLibraries", null);
__decorate([
    (0, common_1.Post)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.LibraryCreate, admin: true }),
    openapi.ApiResponse({ status: 201, type: require("../dtos/library.dto").LibraryResponseDto }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [library_dto_1.CreateLibraryDto]),
    __metadata("design:returntype", Promise)
], LibraryController.prototype, "createLibrary", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.LibraryRead, admin: true }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/library.dto").LibraryResponseDto }),
    __param(0, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], LibraryController.prototype, "getLibrary", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.LibraryUpdate, admin: true }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/library.dto").LibraryResponseDto }),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [validation_1.UUIDParamDto, library_dto_1.UpdateLibraryDto]),
    __metadata("design:returntype", Promise)
], LibraryController.prototype, "updateLibrary", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.LibraryDelete, admin: true }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], LibraryController.prototype, "deleteLibrary", null);
__decorate([
    (0, common_1.Post)(':id/validate'),
    (0, auth_guard_1.Authenticated)({ admin: true }),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: require("../dtos/library.dto").ValidateLibraryResponseDto }),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [validation_1.UUIDParamDto, library_dto_1.ValidateLibraryDto]),
    __metadata("design:returntype", Promise)
], LibraryController.prototype, "validate", null);
__decorate([
    (0, common_1.Get)(':id/statistics'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.LibraryStatistics, admin: true }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/library.dto").LibraryStatsResponseDto }),
    __param(0, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], LibraryController.prototype, "getLibraryStatistics", null);
__decorate([
    (0, common_1.Post)(':id/scan'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.LibraryUpdate, admin: true }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], LibraryController.prototype, "scanLibrary", null);
exports.LibraryController = LibraryController = __decorate([
    (0, swagger_1.ApiTags)('Libraries'),
    (0, common_1.Controller)('libraries'),
    __metadata("design:paramtypes", [library_service_1.LibraryService])
], LibraryController);
//# sourceMappingURL=library.controller.js.map