"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationAdminController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const auth_dto_1 = require("../dtos/auth.dto");
const notification_dto_1 = require("../dtos/notification.dto");
const system_config_dto_1 = require("../dtos/system-config.dto");
const auth_guard_1 = require("../middleware/auth.guard");
const email_repository_1 = require("../repositories/email.repository");
const notification_admin_service_1 = require("../services/notification-admin.service");
let NotificationAdminController = class NotificationAdminController {
    service;
    constructor(service) {
        this.service = service;
    }
    createNotification(auth, dto) {
        return this.service.create(auth, dto);
    }
    sendTestEmailAdmin(auth, dto) {
        return this.service.sendTestEmail(auth.user.id, dto);
    }
    getNotificationTemplateAdmin(auth, name, dto) {
        return this.service.getTemplate(name, dto.template);
    }
};
exports.NotificationAdminController = NotificationAdminController;
__decorate([
    (0, common_1.Post)(),
    (0, auth_guard_1.Authenticated)({ admin: true }),
    openapi.ApiResponse({ status: 201, type: require("../dtos/notification.dto").NotificationDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, notification_dto_1.NotificationCreateDto]),
    __metadata("design:returntype", Promise)
], NotificationAdminController.prototype, "createNotification", null);
__decorate([
    (0, common_1.Post)('test-email'),
    (0, auth_guard_1.Authenticated)({ admin: true }),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: require("../dtos/notification.dto").TestEmailResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, system_config_dto_1.SystemConfigSmtpDto]),
    __metadata("design:returntype", Promise)
], NotificationAdminController.prototype, "sendTestEmailAdmin", null);
__decorate([
    (0, common_1.Post)('templates/:name'),
    (0, auth_guard_1.Authenticated)({ admin: true }),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    openapi.ApiResponse({ status: common_1.HttpStatus.OK, type: require("../dtos/notification.dto").TemplateResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)('name')),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, String, notification_dto_1.TemplateDto]),
    __metadata("design:returntype", Promise)
], NotificationAdminController.prototype, "getNotificationTemplateAdmin", null);
exports.NotificationAdminController = NotificationAdminController = __decorate([
    (0, swagger_1.ApiTags)('Notifications (Admin)'),
    (0, common_1.Controller)('admin/notifications'),
    __metadata("design:paramtypes", [notification_admin_service_1.NotificationAdminService])
], NotificationAdminController);
//# sourceMappingURL=notification-admin.controller.js.map