import { AuthDto } from 'src/dtos/auth.dto';
import { NotificationDeleteAllDto, NotificationDto, NotificationSearchDto, NotificationUpdateAllDto, NotificationUpdateDto } from 'src/dtos/notification.dto';
import { NotificationService } from 'src/services/notification.service';
import { UUIDParamDto } from 'src/validation';
export declare class NotificationController {
    private service;
    constructor(service: NotificationService);
    getNotifications(auth: AuthDto, dto: NotificationSearchDto): Promise<NotificationDto[]>;
    updateNotifications(auth: AuthDto, dto: NotificationUpdateAllDto): Promise<void>;
    deleteNotifications(auth: AuthDto, dto: NotificationDeleteAllDto): Promise<void>;
    getNotification(auth: AuthDto, { id }: UUIDParamDto): Promise<NotificationDto>;
    updateNotification(auth: AuthDto, { id }: UUIDParamDto, dto: NotificationUpdateDto): Promise<NotificationDto>;
    deleteNotification(auth: AuthDto, { id }: UUIDParamDto): Promise<void>;
}
