"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const auth_dto_1 = require("../dtos/auth.dto");
const notification_dto_1 = require("../dtos/notification.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const notification_service_1 = require("../services/notification.service");
const validation_1 = require("../validation");
let NotificationController = class NotificationController {
    service;
    constructor(service) {
        this.service = service;
    }
    getNotifications(auth, dto) {
        return this.service.search(auth, dto);
    }
    updateNotifications(auth, dto) {
        return this.service.updateAll(auth, dto);
    }
    deleteNotifications(auth, dto) {
        return this.service.deleteAll(auth, dto);
    }
    getNotification(auth, { id }) {
        return this.service.get(auth, id);
    }
    updateNotification(auth, { id }, dto) {
        return this.service.update(auth, id, dto);
    }
    deleteNotification(auth, { id }) {
        return this.service.delete(auth, id);
    }
};
exports.NotificationController = NotificationController;
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.NotificationRead }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/notification.dto").NotificationDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, notification_dto_1.NotificationSearchDto]),
    __metadata("design:returntype", Promise)
], NotificationController.prototype, "getNotifications", null);
__decorate([
    (0, common_1.Put)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.NotificationUpdate }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, notification_dto_1.NotificationUpdateAllDto]),
    __metadata("design:returntype", Promise)
], NotificationController.prototype, "updateNotifications", null);
__decorate([
    (0, common_1.Delete)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.NotificationDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, notification_dto_1.NotificationDeleteAllDto]),
    __metadata("design:returntype", Promise)
], NotificationController.prototype, "deleteNotifications", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.NotificationRead }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/notification.dto").NotificationDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], NotificationController.prototype, "getNotification", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.NotificationUpdate }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/notification.dto").NotificationDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        notification_dto_1.NotificationUpdateDto]),
    __metadata("design:returntype", Promise)
], NotificationController.prototype, "updateNotification", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.NotificationDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], NotificationController.prototype, "deleteNotification", null);
exports.NotificationController = NotificationController = __decorate([
    (0, swagger_1.ApiTags)('Notifications'),
    (0, common_1.Controller)('notifications'),
    __metadata("design:paramtypes", [notification_service_1.NotificationService])
], NotificationController);
//# sourceMappingURL=notification.controller.js.map