"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PartnerController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const auth_dto_1 = require("../dtos/auth.dto");
const partner_dto_1 = require("../dtos/partner.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const partner_service_1 = require("../services/partner.service");
const validation_1 = require("../validation");
let PartnerController = class PartnerController {
    service;
    constructor(service) {
        this.service = service;
    }
    getPartners(auth, dto) {
        return this.service.search(auth, dto);
    }
    createPartner(auth, dto) {
        return this.service.create(auth, dto);
    }
    createPartnerDeprecated(auth, { id }) {
        return this.service.create(auth, { sharedWithId: id });
    }
    updatePartner(auth, { id }, dto) {
        return this.service.update(auth, id, dto);
    }
    removePartner(auth, { id }) {
        return this.service.remove(auth, id);
    }
};
exports.PartnerController = PartnerController;
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PartnerRead }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/partner.dto").PartnerResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, partner_dto_1.PartnerSearchDto]),
    __metadata("design:returntype", Promise)
], PartnerController.prototype, "getPartners", null);
__decorate([
    (0, common_1.Post)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PartnerCreate }),
    openapi.ApiResponse({ status: 201, type: require("../dtos/partner.dto").PartnerResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, partner_dto_1.PartnerCreateDto]),
    __metadata("design:returntype", Promise)
], PartnerController.prototype, "createPartner", null);
__decorate([
    (0, common_1.Post)(':id'),
    (0, decorators_1.EndpointLifecycle)({ deprecatedAt: 'v1.141.0' }),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PartnerCreate }),
    openapi.ApiResponse({ status: 201, type: require("../dtos/partner.dto").PartnerResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], PartnerController.prototype, "createPartnerDeprecated", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PartnerUpdate }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/partner.dto").PartnerResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        validation_1.UUIDParamDto,
        partner_dto_1.PartnerUpdateDto]),
    __metadata("design:returntype", Promise)
], PartnerController.prototype, "updatePartner", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PartnerDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], PartnerController.prototype, "removePartner", null);
exports.PartnerController = PartnerController = __decorate([
    (0, swagger_1.ApiTags)('Partners'),
    (0, common_1.Controller)('partners'),
    __metadata("design:paramtypes", [partner_service_1.PartnerService])
], PartnerController);
//# sourceMappingURL=partner.controller.js.map