"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const auth_dto_1 = require("../dtos/auth.dto");
const license_dto_1 = require("../dtos/license.dto");
const onboarding_dto_1 = require("../dtos/onboarding.dto");
const user_preferences_dto_1 = require("../dtos/user-preferences.dto");
const user_profile_dto_1 = require("../dtos/user-profile.dto");
const user_dto_1 = require("../dtos/user.dto");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const file_upload_interceptor_1 = require("../middleware/file-upload.interceptor");
const logging_repository_1 = require("../repositories/logging.repository");
const user_service_1 = require("../services/user.service");
const file_1 = require("../utils/file");
const validation_1 = require("../validation");
let UserController = class UserController {
    service;
    logger;
    constructor(service, logger) {
        this.service = service;
        this.logger = logger;
    }
    searchUsers(auth) {
        return this.service.search(auth);
    }
    getMyUser(auth) {
        return this.service.getMe(auth);
    }
    updateMyUser(auth, dto) {
        return this.service.updateMe(auth, dto);
    }
    getMyPreferences(auth) {
        return this.service.getMyPreferences(auth);
    }
    updateMyPreferences(auth, dto) {
        return this.service.updateMyPreferences(auth, dto);
    }
    getUserLicense(auth) {
        return this.service.getLicense(auth);
    }
    async setUserLicense(auth, license) {
        return this.service.setLicense(auth, license);
    }
    async deleteUserLicense(auth) {
        await this.service.deleteLicense(auth);
    }
    getUserOnboarding(auth) {
        return this.service.getOnboarding(auth);
    }
    async setUserOnboarding(auth, Onboarding) {
        return this.service.setOnboarding(auth, Onboarding);
    }
    async deleteUserOnboarding(auth) {
        await this.service.deleteOnboarding(auth);
    }
    getUser({ id }) {
        return this.service.get(id);
    }
    createProfileImage(auth, fileInfo) {
        return this.service.createProfileImage(auth, fileInfo);
    }
    deleteProfileImage(auth) {
        return this.service.deleteProfileImage(auth);
    }
    async getProfileImage(res, next, { id }) {
        await (0, file_1.sendFile)(res, next, () => this.service.getProfileImage(id), this.logger);
    }
};
exports.UserController = UserController;
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.UserRead }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/user.dto").UserResponseDto] }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "searchUsers", null);
__decorate([
    (0, common_1.Get)('me'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.UserRead }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/user.dto").UserAdminResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "getMyUser", null);
__decorate([
    (0, common_1.Put)('me'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.UserUpdate }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/user.dto").UserAdminResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, user_dto_1.UserUpdateMeDto]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "updateMyUser", null);
__decorate([
    (0, common_1.Get)('me/preferences'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.UserPreferenceRead }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/user-preferences.dto").UserPreferencesResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "getMyPreferences", null);
__decorate([
    (0, common_1.Put)('me/preferences'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.UserPreferenceUpdate }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/user-preferences.dto").UserPreferencesResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto,
        user_preferences_dto_1.UserPreferencesUpdateDto]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "updateMyPreferences", null);
__decorate([
    (0, common_1.Get)('me/license'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.UserLicenseRead }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/license.dto").LicenseResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "getUserLicense", null);
__decorate([
    (0, common_1.Put)('me/license'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.UserLicenseUpdate }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/license.dto").LicenseResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, license_dto_1.LicenseKeyDto]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "setUserLicense", null);
__decorate([
    (0, common_1.Delete)('me/license'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.UserLicenseDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "deleteUserLicense", null);
__decorate([
    (0, common_1.Get)('me/onboarding'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.UserOnboardingRead }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/onboarding.dto").OnboardingResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "getUserOnboarding", null);
__decorate([
    (0, common_1.Put)('me/onboarding'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.UserOnboardingUpdate }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/onboarding.dto").OnboardingResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, onboarding_dto_1.OnboardingDto]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "setUserOnboarding", null);
__decorate([
    (0, common_1.Delete)('me/onboarding'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.UserOnboardingDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "deleteUserOnboarding", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.UserRead }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/user.dto").UserResponseDto }),
    __param(0, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "getUser", null);
__decorate([
    (0, common_1.Post)('profile-image'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.UserProfileImageUpdate }),
    (0, common_1.UseInterceptors)(file_upload_interceptor_1.FileUploadInterceptor),
    (0, swagger_1.ApiConsumes)('multipart/form-data'),
    (0, swagger_1.ApiBody)({ description: 'A new avatar for the user', type: user_profile_dto_1.CreateProfileImageDto }),
    openapi.ApiResponse({ status: 201, type: require("../dtos/user-profile.dto").CreateProfileImageResponseDto }),
    __param(0, (0, auth_guard_1.Auth)()),
    __param(1, (0, common_1.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto, Object]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "createProfileImage", null);
__decorate([
    (0, common_1.Delete)('profile-image'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.UserProfileImageDelete }),
    (0, common_1.HttpCode)(common_1.HttpStatus.NO_CONTENT),
    openapi.ApiResponse({ status: common_1.HttpStatus.NO_CONTENT }),
    __param(0, (0, auth_guard_1.Auth)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthDto]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "deleteProfileImage", null);
__decorate([
    (0, common_1.Get)(':id/profile-image'),
    (0, auth_guard_1.FileResponse)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.UserProfileImageRead }),
    openapi.ApiResponse({ status: 200 }),
    __param(0, (0, common_1.Res)()),
    __param(1, (0, common_1.Next)()),
    __param(2, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Function, validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "getProfileImage", null);
exports.UserController = UserController = __decorate([
    (0, swagger_1.ApiTags)('Users'),
    (0, common_1.Controller)(enum_1.RouteKey.User),
    __metadata("design:paramtypes", [user_service_1.UserService,
        logging_repository_1.LoggingRepository])
], UserController);
//# sourceMappingURL=user.controller.js.map