import { StorageAsset } from 'src/database';
import { AssetPathType, ImageFormat, PathType, PersonPathType, StorageFolder } from 'src/enum';
import { AssetRepository } from 'src/repositories/asset.repository';
import { ConfigRepository } from 'src/repositories/config.repository';
import { CryptoRepository } from 'src/repositories/crypto.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { MoveRepository } from 'src/repositories/move.repository';
import { PersonRepository } from 'src/repositories/person.repository';
import { StorageRepository } from 'src/repositories/storage.repository';
import { SystemMetadataRepository } from 'src/repositories/system-metadata.repository';
export interface MoveRequest {
    entityId: string;
    pathType: PathType;
    oldPath: string | null;
    newPath: string;
    assetInfo?: {
        sizeInBytes: number;
        checksum: Buffer;
    };
}
export type GeneratedImageType = AssetPathType.Preview | AssetPathType.Thumbnail | AssetPathType.FullSize;
export type GeneratedAssetType = GeneratedImageType | AssetPathType.EncodedVideo;
export type ThumbnailPathEntity = {
    id: string;
    ownerId: string;
};
export declare class StorageCore {
    private assetRepository;
    private configRepository;
    private cryptoRepository;
    private moveRepository;
    private personRepository;
    private storageRepository;
    private systemMetadataRepository;
    private logger;
    private constructor();
    static create(assetRepository: AssetRepository, configRepository: ConfigRepository, cryptoRepository: CryptoRepository, moveRepository: MoveRepository, personRepository: PersonRepository, storageRepository: StorageRepository, systemMetadataRepository: SystemMetadataRepository, logger: LoggingRepository): StorageCore;
    static reset(): void;
    static getMediaLocation(): string;
    static setMediaLocation(location: string): void;
    static getFolderLocation(folder: StorageFolder, userId: string): string;
    static getLibraryFolder(user: {
        storageLabel: string | null;
        id: string;
    }): string;
    static getBaseFolder(folder: StorageFolder): string;
    static getPersonThumbnailPath(person: ThumbnailPathEntity): string;
    static getImagePath(asset: ThumbnailPathEntity, type: GeneratedImageType, format: 'jpeg' | 'webp'): string;
    static getEncodedVideoPath(asset: ThumbnailPathEntity): string;
    static getAndroidMotionPath(asset: ThumbnailPathEntity, uuid: string): string;
    static isAndroidMotionPath(originalPath: string): boolean;
    static isImmichPath(path: string): boolean;
    moveAssetImage(asset: StorageAsset, pathType: GeneratedImageType, format: ImageFormat): Promise<void>;
    moveAssetVideo(asset: StorageAsset): Promise<void>;
    movePersonFile(person: {
        id: string;
        ownerId: string;
        thumbnailPath: string;
    }, pathType: PersonPathType): Promise<void>;
    moveFile(request: MoveRequest): Promise<void>;
    private verifyNewPathContentsMatchesExpected;
    ensureFolders(input: string): void;
    removeEmptyDirs(folder: StorageFolder): Promise<void>;
    private savePath;
    static getNestedFolder(folder: StorageFolder, ownerId: string, filename: string): string;
    static getNestedPath(folder: StorageFolder, ownerId: string, filename: string): string;
    static getTempPathInDir(dir: string): string;
}
