import { AuthApiKey, AuthSession, AuthSharedLink, AuthUser, UserAdmin } from 'src/database';
import { ImmichCookie } from 'src/enum';
export type CookieResponse = {
    isSecure: boolean;
    values: Array<{
        key: ImmichCookie;
        value: string | null;
    }>;
};
export declare class AuthDto {
    user: AuthUser;
    apiKey?: AuthApiKey;
    sharedLink?: AuthSharedLink;
    session?: AuthSession;
}
export declare class LoginCredentialDto {
    email: string;
    password: string;
}
export declare class LoginResponseDto {
    accessToken: string;
    userId: string;
    userEmail: string;
    name: string;
    profileImagePath: string;
    isAdmin: boolean;
    shouldChangePassword: boolean;
    isOnboarded: boolean;
}
export declare function mapLoginResponse(entity: UserAdmin, accessToken: string): LoginResponseDto;
export declare class LogoutResponseDto {
    successful: boolean;
    redirectUri: string;
}
export declare class SignUpDto extends LoginCredentialDto {
    name: string;
}
export declare class ChangePasswordDto {
    password: string;
    newPassword: string;
}
export declare class PinCodeSetupDto {
    pinCode: string;
}
export declare class PinCodeResetDto {
    pinCode?: string;
    password?: string;
}
export declare class SessionUnlockDto extends PinCodeResetDto {
}
export declare class PinCodeChangeDto extends PinCodeResetDto {
    newPinCode: string;
}
export declare class ValidateAccessTokenResponseDto {
    authStatus: boolean;
}
export declare class OAuthCallbackDto {
    url: string;
    state?: string;
    codeVerifier?: string;
}
export declare class OAuthConfigDto {
    redirectUri: string;
    state?: string;
    codeChallenge?: string;
}
export declare class OAuthAuthorizeResponseDto {
    url: string;
}
export declare class AuthStatusResponseDto {
    pinCode: boolean;
    password: boolean;
    isElevated: boolean;
    expiresAt?: string;
    pinExpiresAt?: string;
}
