import { JobCommand, ManualJobName, QueueName } from 'src/enum';
export declare class JobIdParamDto {
    id: QueueName;
}
export declare class JobCommandDto {
    command: JobCommand;
    force?: boolean;
}
export declare class JobCreateDto {
    name: ManualJobName;
}
export declare class JobCountsDto {
    active: number;
    completed: number;
    failed: number;
    delayed: number;
    waiting: number;
    paused: number;
}
export declare class QueueStatusDto {
    isActive: boolean;
    isPaused: boolean;
}
export declare class JobStatusDto {
    jobCounts: JobCountsDto;
    queueStatus: QueueStatusDto;
}
export declare class AllJobStatusResponseDto implements Record<QueueName, JobStatusDto> {
    [QueueName.ThumbnailGeneration]: JobStatusDto;
    [QueueName.MetadataExtraction]: JobStatusDto;
    [QueueName.VideoConversion]: JobStatusDto;
    [QueueName.SmartSearch]: JobStatusDto;
    [QueueName.StorageTemplateMigration]: JobStatusDto;
    [QueueName.Migration]: JobStatusDto;
    [QueueName.BackgroundTask]: JobStatusDto;
    [QueueName.Search]: JobStatusDto;
    [QueueName.DuplicateDetection]: JobStatusDto;
    [QueueName.FaceDetection]: JobStatusDto;
    [QueueName.FacialRecognition]: JobStatusDto;
    [QueueName.Sidecar]: JobStatusDto;
    [QueueName.Library]: JobStatusDto;
    [QueueName.Notification]: JobStatusDto;
    [QueueName.BackupDatabase]: JobStatusDto;
}
