"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MapMarkerResponseDto = exports.MapMarkerDto = exports.MapReverseGeocodeResponseDto = exports.MapReverseGeocodeDto = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const validation_1 = require("../validation");
class MapReverseGeocodeDto {
    lat;
    lon;
    static _OPENAPI_METADATA_FACTORY() {
        return { lat: { required: true, type: () => Number }, lon: { required: true, type: () => Number } };
    }
}
exports.MapReverseGeocodeDto = MapReverseGeocodeDto;
__decorate([
    (0, swagger_1.ApiProperty)({ format: 'double' }),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsLatitude)({ message: ({ property }) => `${property} must be a number between -90 and 90` }),
    __metadata("design:type", Number)
], MapReverseGeocodeDto.prototype, "lat", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ format: 'double' }),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsLongitude)({ message: ({ property }) => `${property} must be a number between -180 and 180` }),
    __metadata("design:type", Number)
], MapReverseGeocodeDto.prototype, "lon", void 0);
class MapReverseGeocodeResponseDto {
    city;
    state;
    country;
    static _OPENAPI_METADATA_FACTORY() {
        return { city: { required: true, type: () => String, nullable: true }, state: { required: true, type: () => String, nullable: true }, country: { required: true, type: () => String, nullable: true } };
    }
}
exports.MapReverseGeocodeResponseDto = MapReverseGeocodeResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Object)
], MapReverseGeocodeResponseDto.prototype, "city", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Object)
], MapReverseGeocodeResponseDto.prototype, "state", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Object)
], MapReverseGeocodeResponseDto.prototype, "country", void 0);
class MapMarkerDto {
    isArchived;
    isFavorite;
    fileCreatedAfter;
    fileCreatedBefore;
    withPartners;
    withSharedAlbums;
    static _OPENAPI_METADATA_FACTORY() {
        return { isArchived: { required: false, type: () => Boolean }, isFavorite: { required: false, type: () => Boolean }, fileCreatedAfter: { required: false, type: () => Date }, fileCreatedBefore: { required: false, type: () => Date }, withPartners: { required: false, type: () => Boolean }, withSharedAlbums: { required: false, type: () => Boolean } };
    }
}
exports.MapMarkerDto = MapMarkerDto;
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], MapMarkerDto.prototype, "isArchived", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], MapMarkerDto.prototype, "isFavorite", void 0);
__decorate([
    (0, validation_1.ValidateDate)({ optional: true }),
    __metadata("design:type", Date)
], MapMarkerDto.prototype, "fileCreatedAfter", void 0);
__decorate([
    (0, validation_1.ValidateDate)({ optional: true }),
    __metadata("design:type", Date)
], MapMarkerDto.prototype, "fileCreatedBefore", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], MapMarkerDto.prototype, "withPartners", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true }),
    __metadata("design:type", Boolean)
], MapMarkerDto.prototype, "withSharedAlbums", void 0);
class MapMarkerResponseDto {
    id;
    lat;
    lon;
    city;
    state;
    country;
    static _OPENAPI_METADATA_FACTORY() {
        return { id: { required: true, type: () => String }, lat: { required: true, type: () => Number }, lon: { required: true, type: () => Number }, city: { required: true, type: () => String, nullable: true }, state: { required: true, type: () => String, nullable: true }, country: { required: true, type: () => String, nullable: true } };
    }
}
exports.MapMarkerResponseDto = MapMarkerResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], MapMarkerResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ format: 'double' }),
    __metadata("design:type", Number)
], MapMarkerResponseDto.prototype, "lat", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ format: 'double' }),
    __metadata("design:type", Number)
], MapMarkerResponseDto.prototype, "lon", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Object)
], MapMarkerResponseDto.prototype, "city", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Object)
], MapMarkerResponseDto.prototype, "state", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Object)
], MapMarkerResponseDto.prototype, "country", void 0);
//# sourceMappingURL=map.dto.js.map