import { Memory } from 'src/database';
import { AssetResponseDto } from 'src/dtos/asset-response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { MemoryType } from 'src/enum';
declare class MemoryBaseDto {
    isSaved?: boolean;
    seenAt?: Date;
}
export declare class MemorySearchDto {
    type?: MemoryType;
    for?: Date;
    isTrashed?: boolean;
    isSaved?: boolean;
}
declare class OnThisDayDto {
    year: number;
}
type MemoryData = OnThisDayDto;
export declare class MemoryUpdateDto extends MemoryBaseDto {
    memoryAt?: Date;
}
export declare class MemoryCreateDto extends MemoryBaseDto {
    type: MemoryType;
    data: MemoryData;
    memoryAt: Date;
    assetIds?: string[];
}
export declare class MemoryStatisticsResponseDto {
    total: number;
}
export declare class MemoryResponseDto {
    id: string;
    createdAt: Date;
    updatedAt: Date;
    deletedAt?: Date;
    memoryAt: Date;
    seenAt?: Date;
    showAt?: Date;
    hideAt?: Date;
    ownerId: string;
    type: MemoryType;
    data: MemoryData;
    isSaved: boolean;
    assets: AssetResponseDto[];
}
export declare const mapMemory: (entity: Memory, auth: AuthDto) => MemoryResponseDto;
export {};
