"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FacialRecognitionConfig = exports.DuplicateDetectionConfig = exports.CLIPConfig = exports.ModelConfig = exports.TaskConfig = void 0;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const validation_1 = require("../validation");
class TaskConfig {
    enabled;
    static _OPENAPI_METADATA_FACTORY() {
        return { enabled: { required: true, type: () => Boolean } };
    }
}
exports.TaskConfig = TaskConfig;
__decorate([
    (0, validation_1.ValidateBoolean)(),
    __metadata("design:type", Boolean)
], TaskConfig.prototype, "enabled", void 0);
class ModelConfig extends TaskConfig {
    modelName;
    static _OPENAPI_METADATA_FACTORY() {
        return { modelName: { required: true, type: () => String } };
    }
}
exports.ModelConfig = ModelConfig;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], ModelConfig.prototype, "modelName", void 0);
class CLIPConfig extends ModelConfig {
    static _OPENAPI_METADATA_FACTORY() {
        return {};
    }
}
exports.CLIPConfig = CLIPConfig;
class DuplicateDetectionConfig extends TaskConfig {
    maxDistance;
    static _OPENAPI_METADATA_FACTORY() {
        return { maxDistance: { required: true, type: () => Number, minimum: 0.001, maximum: 0.1 } };
    }
}
exports.DuplicateDetectionConfig = DuplicateDetectionConfig;
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0.001),
    (0, class_validator_1.Max)(0.1),
    (0, class_transformer_1.Type)(() => Number),
    (0, swagger_1.ApiProperty)({ type: 'number', format: 'double' }),
    __metadata("design:type", Number)
], DuplicateDetectionConfig.prototype, "maxDistance", void 0);
class FacialRecognitionConfig extends ModelConfig {
    minScore;
    maxDistance;
    minFaces;
    static _OPENAPI_METADATA_FACTORY() {
        return { minScore: { required: true, type: () => Number, minimum: 0.1, maximum: 1 }, maxDistance: { required: true, type: () => Number, minimum: 0.1, maximum: 2 }, minFaces: { required: true, type: () => Number, minimum: 1 } };
    }
}
exports.FacialRecognitionConfig = FacialRecognitionConfig;
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0.1),
    (0, class_validator_1.Max)(1),
    (0, class_transformer_1.Type)(() => Number),
    (0, swagger_1.ApiProperty)({ type: 'number', format: 'double' }),
    __metadata("design:type", Number)
], FacialRecognitionConfig.prototype, "minScore", void 0);
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0.1),
    (0, class_validator_1.Max)(2),
    (0, class_transformer_1.Type)(() => Number),
    (0, swagger_1.ApiProperty)({ type: 'number', format: 'double' }),
    __metadata("design:type", Number)
], FacialRecognitionConfig.prototype, "maxDistance", void 0);
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(1),
    (0, class_transformer_1.Type)(() => Number),
    (0, swagger_1.ApiProperty)({ type: 'integer' }),
    __metadata("design:type", Number)
], FacialRecognitionConfig.prototype, "minFaces", void 0);
//# sourceMappingURL=model-config.dto.js.map