import { Place } from 'src/database';
import { AlbumResponseDto } from 'src/dtos/album.dto';
import { AssetResponseDto } from 'src/dtos/asset-response.dto';
import { AssetOrder, AssetType, AssetVisibility } from 'src/enum';
declare class BaseSearchDto {
    libraryId?: string | null;
    deviceId?: string;
    type?: AssetType;
    isEncoded?: boolean;
    isFavorite?: boolean;
    isMotion?: boolean;
    isOffline?: boolean;
    visibility?: AssetVisibility;
    createdBefore?: Date;
    createdAfter?: Date;
    updatedBefore?: Date;
    updatedAfter?: Date;
    trashedBefore?: Date;
    trashedAfter?: Date;
    takenBefore?: Date;
    takenAfter?: Date;
    city?: string | null;
    state?: string | null;
    country?: string | null;
    make?: string;
    model?: string | null;
    lensModel?: string | null;
    isNotInAlbum?: boolean;
    personIds?: string[];
    tagIds?: string[] | null;
    albumIds?: string[];
    rating?: number;
}
declare class BaseSearchWithResultsDto extends BaseSearchDto {
    withDeleted?: boolean;
    withExif?: boolean;
    size?: number;
}
export declare class RandomSearchDto extends BaseSearchWithResultsDto {
    withStacked?: boolean;
    withPeople?: boolean;
}
export declare class LargeAssetSearchDto extends BaseSearchWithResultsDto {
    minFileSize?: number;
}
export declare class MetadataSearchDto extends RandomSearchDto {
    id?: string;
    deviceAssetId?: string;
    description?: string;
    checksum?: string;
    originalFileName?: string;
    originalPath?: string;
    previewPath?: string;
    thumbnailPath?: string;
    encodedVideoPath?: string;
    order?: AssetOrder;
    page?: number;
}
export declare class StatisticsSearchDto extends BaseSearchDto {
    description?: string;
}
export declare class SmartSearchDto extends BaseSearchWithResultsDto {
    query?: string;
    queryAssetId?: string;
    language?: string;
    page?: number;
}
export declare class SearchPlacesDto {
    name: string;
}
export declare class SearchPeopleDto {
    name: string;
    withHidden?: boolean;
}
export declare class PlacesResponseDto {
    name: string;
    latitude: number;
    longitude: number;
    admin1name?: string;
    admin2name?: string;
}
export declare function mapPlaces(place: Place): PlacesResponseDto;
export declare enum SearchSuggestionType {
    COUNTRY = "country",
    STATE = "state",
    CITY = "city",
    CAMERA_MAKE = "camera-make",
    CAMERA_MODEL = "camera-model"
}
export declare class SearchSuggestionRequestDto {
    type: SearchSuggestionType;
    country?: string;
    state?: string;
    make?: string;
    model?: string;
    includeNull?: boolean;
}
declare class SearchFacetCountResponseDto {
    count: number;
    value: string;
}
declare class SearchFacetResponseDto {
    fieldName: string;
    counts: SearchFacetCountResponseDto[];
}
declare class SearchAlbumResponseDto {
    total: number;
    count: number;
    items: AlbumResponseDto[];
    facets: SearchFacetResponseDto[];
}
declare class SearchAssetResponseDto {
    total: number;
    count: number;
    items: AssetResponseDto[];
    facets: SearchFacetResponseDto[];
    nextPage: string | null;
}
export declare class SearchResponseDto {
    albums: SearchAlbumResponseDto;
    assets: SearchAssetResponseDto;
}
export declare class SearchStatisticsResponseDto {
    total: number;
}
declare class SearchExploreItem {
    value: string;
    data: AssetResponseDto;
}
export declare class SearchExploreResponseDto {
    fieldName: string;
    items: SearchExploreItem[];
}
export declare class MemoryLaneDto {
    day: number;
    month: number;
}
export {};
