import { SemVer } from 'semver';
import { SystemConfigThemeDto } from 'src/dtos/system-config.dto';
export declare class ServerPingResponse {
    res: string;
}
export declare class ServerAboutResponseDto {
    version: string;
    versionUrl: string;
    repository?: string;
    repositoryUrl?: string;
    sourceRef?: string;
    sourceCommit?: string;
    sourceUrl?: string;
    build?: string;
    buildUrl?: string;
    buildImage?: string;
    buildImageUrl?: string;
    nodejs?: string;
    ffmpeg?: string;
    imagemagick?: string;
    libvips?: string;
    exiftool?: string;
    licensed: boolean;
    thirdPartySourceUrl?: string;
    thirdPartyBugFeatureUrl?: string;
    thirdPartyDocumentationUrl?: string;
    thirdPartySupportUrl?: string;
}
export declare class ServerApkLinksDto {
    arm64v8a: string;
    armeabiv7a: string;
    universal: string;
    x86_64: string;
}
export declare class ServerStorageResponseDto {
    diskSize: string;
    diskUse: string;
    diskAvailable: string;
    diskSizeRaw: number;
    diskUseRaw: number;
    diskAvailableRaw: number;
    diskUsagePercentage: number;
}
export declare class ServerVersionResponseDto {
    major: number;
    minor: number;
    patch: number;
    static fromSemVer(value: SemVer): {
        major: number;
        minor: number;
        patch: number;
    };
}
export declare class ServerVersionHistoryResponseDto {
    id: string;
    createdAt: Date;
    version: string;
}
export declare class UsageByUserDto {
    userId: string;
    userName: string;
    photos: number;
    videos: number;
    usage: number;
    usagePhotos: number;
    usageVideos: number;
    quotaSizeInBytes: number | null;
}
export declare class ServerStatsResponseDto {
    photos: number;
    videos: number;
    usage: number;
    usagePhotos: number;
    usageVideos: number;
    usageByUser: UsageByUserDto[];
}
export declare class ServerMediaTypesResponseDto {
    video: string[];
    image: string[];
    sidecar: string[];
}
export declare class ServerThemeDto extends SystemConfigThemeDto {
}
export declare class ServerConfigDto {
    oauthButtonText: string;
    loginPageMessage: string;
    trashDays: number;
    userDeleteDelay: number;
    isInitialized: boolean;
    isOnboarded: boolean;
    externalDomain: string;
    publicUsers: boolean;
    mapDarkStyleUrl: string;
    mapLightStyleUrl: string;
}
export declare class ServerFeaturesDto {
    smartSearch: boolean;
    duplicateDetection: boolean;
    configFile: boolean;
    facialRecognition: boolean;
    map: boolean;
    trash: boolean;
    reverseGeocoding: boolean;
    importFaces: boolean;
    oauth: boolean;
    oauthAutoLaunch: boolean;
    passwordLogin: boolean;
    sidecar: boolean;
    search: boolean;
    email: boolean;
}
export interface ReleaseNotification {
    isAvailable: boolean;
    checkedAt: string;
    serverVersion: ServerVersionResponseDto;
    releaseVersion: ServerVersionResponseDto;
}
