"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobCommand = exports.JobName = exports.QueueName = exports.BootstrapEventPriority = exports.DatabaseExtension = exports.ExifOrientation = exports.ImmichTelemetry = exports.ImmichWorker = exports.ImmichEnvironment = exports.CacheControl = exports.RouteKey = exports.MetadataKey = exports.ApiCustomExtension = exports.LogLevel = exports.RawExtractedFormat = exports.ImageFormat = exports.Colorspace = exports.CQMode = exports.ToneMapping = exports.TranscodeHardwareAcceleration = exports.VideoContainer = exports.AudioCodec = exports.VideoCodec = exports.TranscodeTarget = exports.TranscodePolicy = exports.UserPathType = exports.PersonPathType = exports.AssetPathType = exports.ManualJobName = exports.SourceType = exports.AssetStatus = exports.UserStatus = exports.UserAvatarColor = exports.AssetMetadataKey = exports.UserMetadataKey = exports.SystemMetadataKey = exports.StorageFolder = exports.SharedLinkType = exports.Permission = exports.MemoryType = exports.EntityType = exports.DatabaseAction = exports.AssetOrder = exports.AlbumUserRole = exports.AssetFileType = exports.AssetType = exports.ImmichQuery = exports.ImmichHeader = exports.ImmichCookie = exports.AuthType = void 0;
exports.CronJob = exports.AssetVisibility = exports.DatabaseSslMode = exports.OAuthTokenEndpointAuthMethod = exports.NotificationType = exports.NotificationLevel = exports.SyncEntityType = exports.SyncRequestType = exports.DatabaseLock = exports.VectorIndex = exports.QueueCleanType = exports.JobStatus = void 0;
var AuthType;
(function (AuthType) {
    AuthType["Password"] = "password";
    AuthType["OAuth"] = "oauth";
})(AuthType || (exports.AuthType = AuthType = {}));
var ImmichCookie;
(function (ImmichCookie) {
    ImmichCookie["AccessToken"] = "immich_access_token";
    ImmichCookie["AuthType"] = "immich_auth_type";
    ImmichCookie["IsAuthenticated"] = "immich_is_authenticated";
    ImmichCookie["SharedLinkToken"] = "immich_shared_link_token";
    ImmichCookie["OAuthState"] = "immich_oauth_state";
    ImmichCookie["OAuthCodeVerifier"] = "immich_oauth_code_verifier";
})(ImmichCookie || (exports.ImmichCookie = ImmichCookie = {}));
var ImmichHeader;
(function (ImmichHeader) {
    ImmichHeader["ApiKey"] = "x-api-key";
    ImmichHeader["UserToken"] = "x-immich-user-token";
    ImmichHeader["SessionToken"] = "x-immich-session-token";
    ImmichHeader["SharedLinkKey"] = "x-immich-share-key";
    ImmichHeader["SharedLinkSlug"] = "x-immich-share-slug";
    ImmichHeader["Checksum"] = "x-immich-checksum";
    ImmichHeader["Cid"] = "x-immich-cid";
})(ImmichHeader || (exports.ImmichHeader = ImmichHeader = {}));
var ImmichQuery;
(function (ImmichQuery) {
    ImmichQuery["SharedLinkKey"] = "key";
    ImmichQuery["SharedLinkSlug"] = "slug";
    ImmichQuery["ApiKey"] = "apiKey";
    ImmichQuery["SessionKey"] = "sessionKey";
})(ImmichQuery || (exports.ImmichQuery = ImmichQuery = {}));
var AssetType;
(function (AssetType) {
    AssetType["Image"] = "IMAGE";
    AssetType["Video"] = "VIDEO";
    AssetType["Audio"] = "AUDIO";
    AssetType["Other"] = "OTHER";
})(AssetType || (exports.AssetType = AssetType = {}));
var AssetFileType;
(function (AssetFileType) {
    AssetFileType["FullSize"] = "fullsize";
    AssetFileType["Preview"] = "preview";
    AssetFileType["Thumbnail"] = "thumbnail";
})(AssetFileType || (exports.AssetFileType = AssetFileType = {}));
var AlbumUserRole;
(function (AlbumUserRole) {
    AlbumUserRole["Editor"] = "editor";
    AlbumUserRole["Viewer"] = "viewer";
})(AlbumUserRole || (exports.AlbumUserRole = AlbumUserRole = {}));
var AssetOrder;
(function (AssetOrder) {
    AssetOrder["Asc"] = "asc";
    AssetOrder["Desc"] = "desc";
})(AssetOrder || (exports.AssetOrder = AssetOrder = {}));
var DatabaseAction;
(function (DatabaseAction) {
    DatabaseAction["Create"] = "CREATE";
    DatabaseAction["Update"] = "UPDATE";
    DatabaseAction["Delete"] = "DELETE";
})(DatabaseAction || (exports.DatabaseAction = DatabaseAction = {}));
var EntityType;
(function (EntityType) {
    EntityType["Asset"] = "ASSET";
    EntityType["Album"] = "ALBUM";
})(EntityType || (exports.EntityType = EntityType = {}));
var MemoryType;
(function (MemoryType) {
    MemoryType["OnThisDay"] = "on_this_day";
})(MemoryType || (exports.MemoryType = MemoryType = {}));
var Permission;
(function (Permission) {
    Permission["All"] = "all";
    Permission["ActivityCreate"] = "activity.create";
    Permission["ActivityRead"] = "activity.read";
    Permission["ActivityUpdate"] = "activity.update";
    Permission["ActivityDelete"] = "activity.delete";
    Permission["ActivityStatistics"] = "activity.statistics";
    Permission["ApiKeyCreate"] = "apiKey.create";
    Permission["ApiKeyRead"] = "apiKey.read";
    Permission["ApiKeyUpdate"] = "apiKey.update";
    Permission["ApiKeyDelete"] = "apiKey.delete";
    Permission["AssetRead"] = "asset.read";
    Permission["AssetUpdate"] = "asset.update";
    Permission["AssetDelete"] = "asset.delete";
    Permission["AssetStatistics"] = "asset.statistics";
    Permission["AssetShare"] = "asset.share";
    Permission["AssetView"] = "asset.view";
    Permission["AssetDownload"] = "asset.download";
    Permission["AssetUpload"] = "asset.upload";
    Permission["AssetReplace"] = "asset.replace";
    Permission["AlbumCreate"] = "album.create";
    Permission["AlbumRead"] = "album.read";
    Permission["AlbumUpdate"] = "album.update";
    Permission["AlbumDelete"] = "album.delete";
    Permission["AlbumStatistics"] = "album.statistics";
    Permission["AlbumShare"] = "album.share";
    Permission["AlbumDownload"] = "album.download";
    Permission["AlbumAssetCreate"] = "albumAsset.create";
    Permission["AlbumAssetDelete"] = "albumAsset.delete";
    Permission["AlbumUserCreate"] = "albumUser.create";
    Permission["AlbumUserUpdate"] = "albumUser.update";
    Permission["AlbumUserDelete"] = "albumUser.delete";
    Permission["AuthChangePassword"] = "auth.changePassword";
    Permission["AuthDeviceDelete"] = "authDevice.delete";
    Permission["ArchiveRead"] = "archive.read";
    Permission["DuplicateRead"] = "duplicate.read";
    Permission["DuplicateDelete"] = "duplicate.delete";
    Permission["FaceCreate"] = "face.create";
    Permission["FaceRead"] = "face.read";
    Permission["FaceUpdate"] = "face.update";
    Permission["FaceDelete"] = "face.delete";
    Permission["JobCreate"] = "job.create";
    Permission["JobRead"] = "job.read";
    Permission["LibraryCreate"] = "library.create";
    Permission["LibraryRead"] = "library.read";
    Permission["LibraryUpdate"] = "library.update";
    Permission["LibraryDelete"] = "library.delete";
    Permission["LibraryStatistics"] = "library.statistics";
    Permission["TimelineRead"] = "timeline.read";
    Permission["TimelineDownload"] = "timeline.download";
    Permission["MemoryCreate"] = "memory.create";
    Permission["MemoryRead"] = "memory.read";
    Permission["MemoryUpdate"] = "memory.update";
    Permission["MemoryDelete"] = "memory.delete";
    Permission["MemoryStatistics"] = "memory.statistics";
    Permission["MemoryAssetCreate"] = "memoryAsset.create";
    Permission["MemoryAssetDelete"] = "memoryAsset.delete";
    Permission["NotificationCreate"] = "notification.create";
    Permission["NotificationRead"] = "notification.read";
    Permission["NotificationUpdate"] = "notification.update";
    Permission["NotificationDelete"] = "notification.delete";
    Permission["PartnerCreate"] = "partner.create";
    Permission["PartnerRead"] = "partner.read";
    Permission["PartnerUpdate"] = "partner.update";
    Permission["PartnerDelete"] = "partner.delete";
    Permission["PersonCreate"] = "person.create";
    Permission["PersonRead"] = "person.read";
    Permission["PersonUpdate"] = "person.update";
    Permission["PersonDelete"] = "person.delete";
    Permission["PersonStatistics"] = "person.statistics";
    Permission["PersonMerge"] = "person.merge";
    Permission["PersonReassign"] = "person.reassign";
    Permission["PinCodeCreate"] = "pinCode.create";
    Permission["PinCodeUpdate"] = "pinCode.update";
    Permission["PinCodeDelete"] = "pinCode.delete";
    Permission["ServerAbout"] = "server.about";
    Permission["ServerApkLinks"] = "server.apkLinks";
    Permission["ServerStorage"] = "server.storage";
    Permission["ServerStatistics"] = "server.statistics";
    Permission["ServerVersionCheck"] = "server.versionCheck";
    Permission["ServerLicenseRead"] = "serverLicense.read";
    Permission["ServerLicenseUpdate"] = "serverLicense.update";
    Permission["ServerLicenseDelete"] = "serverLicense.delete";
    Permission["SessionCreate"] = "session.create";
    Permission["SessionRead"] = "session.read";
    Permission["SessionUpdate"] = "session.update";
    Permission["SessionDelete"] = "session.delete";
    Permission["SessionLock"] = "session.lock";
    Permission["SharedLinkCreate"] = "sharedLink.create";
    Permission["SharedLinkRead"] = "sharedLink.read";
    Permission["SharedLinkUpdate"] = "sharedLink.update";
    Permission["SharedLinkDelete"] = "sharedLink.delete";
    Permission["StackCreate"] = "stack.create";
    Permission["StackRead"] = "stack.read";
    Permission["StackUpdate"] = "stack.update";
    Permission["StackDelete"] = "stack.delete";
    Permission["SyncStream"] = "sync.stream";
    Permission["SyncCheckpointRead"] = "syncCheckpoint.read";
    Permission["SyncCheckpointUpdate"] = "syncCheckpoint.update";
    Permission["SyncCheckpointDelete"] = "syncCheckpoint.delete";
    Permission["SystemConfigRead"] = "systemConfig.read";
    Permission["SystemConfigUpdate"] = "systemConfig.update";
    Permission["SystemMetadataRead"] = "systemMetadata.read";
    Permission["SystemMetadataUpdate"] = "systemMetadata.update";
    Permission["TagCreate"] = "tag.create";
    Permission["TagRead"] = "tag.read";
    Permission["TagUpdate"] = "tag.update";
    Permission["TagDelete"] = "tag.delete";
    Permission["TagAsset"] = "tag.asset";
    Permission["UserRead"] = "user.read";
    Permission["UserUpdate"] = "user.update";
    Permission["UserLicenseCreate"] = "userLicense.create";
    Permission["UserLicenseRead"] = "userLicense.read";
    Permission["UserLicenseUpdate"] = "userLicense.update";
    Permission["UserLicenseDelete"] = "userLicense.delete";
    Permission["UserOnboardingRead"] = "userOnboarding.read";
    Permission["UserOnboardingUpdate"] = "userOnboarding.update";
    Permission["UserOnboardingDelete"] = "userOnboarding.delete";
    Permission["UserPreferenceRead"] = "userPreference.read";
    Permission["UserPreferenceUpdate"] = "userPreference.update";
    Permission["UserProfileImageCreate"] = "userProfileImage.create";
    Permission["UserProfileImageRead"] = "userProfileImage.read";
    Permission["UserProfileImageUpdate"] = "userProfileImage.update";
    Permission["UserProfileImageDelete"] = "userProfileImage.delete";
    Permission["AdminUserCreate"] = "adminUser.create";
    Permission["AdminUserRead"] = "adminUser.read";
    Permission["AdminUserUpdate"] = "adminUser.update";
    Permission["AdminUserDelete"] = "adminUser.delete";
    Permission["AdminAuthUnlinkAll"] = "adminAuth.unlinkAll";
})(Permission || (exports.Permission = Permission = {}));
var SharedLinkType;
(function (SharedLinkType) {
    SharedLinkType["Album"] = "ALBUM";
    SharedLinkType["Individual"] = "INDIVIDUAL";
})(SharedLinkType || (exports.SharedLinkType = SharedLinkType = {}));
var StorageFolder;
(function (StorageFolder) {
    StorageFolder["EncodedVideo"] = "encoded-video";
    StorageFolder["Library"] = "library";
    StorageFolder["Upload"] = "upload";
    StorageFolder["Profile"] = "profile";
    StorageFolder["Thumbnails"] = "thumbs";
    StorageFolder["Backups"] = "backups";
})(StorageFolder || (exports.StorageFolder = StorageFolder = {}));
var SystemMetadataKey;
(function (SystemMetadataKey) {
    SystemMetadataKey["MediaLocation"] = "MediaLocation";
    SystemMetadataKey["ReverseGeocodingState"] = "reverse-geocoding-state";
    SystemMetadataKey["FacialRecognitionState"] = "facial-recognition-state";
    SystemMetadataKey["MemoriesState"] = "memories-state";
    SystemMetadataKey["AdminOnboarding"] = "admin-onboarding";
    SystemMetadataKey["SystemConfig"] = "system-config";
    SystemMetadataKey["SystemFlags"] = "system-flags";
    SystemMetadataKey["VersionCheckState"] = "version-check-state";
    SystemMetadataKey["License"] = "license";
})(SystemMetadataKey || (exports.SystemMetadataKey = SystemMetadataKey = {}));
var UserMetadataKey;
(function (UserMetadataKey) {
    UserMetadataKey["Preferences"] = "preferences";
    UserMetadataKey["License"] = "license";
    UserMetadataKey["Onboarding"] = "onboarding";
})(UserMetadataKey || (exports.UserMetadataKey = UserMetadataKey = {}));
var AssetMetadataKey;
(function (AssetMetadataKey) {
    AssetMetadataKey["MobileApp"] = "mobile-app";
})(AssetMetadataKey || (exports.AssetMetadataKey = AssetMetadataKey = {}));
var UserAvatarColor;
(function (UserAvatarColor) {
    UserAvatarColor["Primary"] = "primary";
    UserAvatarColor["Pink"] = "pink";
    UserAvatarColor["Red"] = "red";
    UserAvatarColor["Yellow"] = "yellow";
    UserAvatarColor["Blue"] = "blue";
    UserAvatarColor["Green"] = "green";
    UserAvatarColor["Purple"] = "purple";
    UserAvatarColor["Orange"] = "orange";
    UserAvatarColor["Gray"] = "gray";
    UserAvatarColor["Amber"] = "amber";
})(UserAvatarColor || (exports.UserAvatarColor = UserAvatarColor = {}));
var UserStatus;
(function (UserStatus) {
    UserStatus["Active"] = "active";
    UserStatus["Removing"] = "removing";
    UserStatus["Deleted"] = "deleted";
})(UserStatus || (exports.UserStatus = UserStatus = {}));
var AssetStatus;
(function (AssetStatus) {
    AssetStatus["Active"] = "active";
    AssetStatus["Trashed"] = "trashed";
    AssetStatus["Deleted"] = "deleted";
})(AssetStatus || (exports.AssetStatus = AssetStatus = {}));
var SourceType;
(function (SourceType) {
    SourceType["MachineLearning"] = "machine-learning";
    SourceType["Exif"] = "exif";
    SourceType["Manual"] = "manual";
})(SourceType || (exports.SourceType = SourceType = {}));
var ManualJobName;
(function (ManualJobName) {
    ManualJobName["PersonCleanup"] = "person-cleanup";
    ManualJobName["TagCleanup"] = "tag-cleanup";
    ManualJobName["UserCleanup"] = "user-cleanup";
    ManualJobName["MemoryCleanup"] = "memory-cleanup";
    ManualJobName["MemoryCreate"] = "memory-create";
    ManualJobName["BackupDatabase"] = "backup-database";
})(ManualJobName || (exports.ManualJobName = ManualJobName = {}));
var AssetPathType;
(function (AssetPathType) {
    AssetPathType["Original"] = "original";
    AssetPathType["FullSize"] = "fullsize";
    AssetPathType["Preview"] = "preview";
    AssetPathType["Thumbnail"] = "thumbnail";
    AssetPathType["EncodedVideo"] = "encoded_video";
    AssetPathType["Sidecar"] = "sidecar";
})(AssetPathType || (exports.AssetPathType = AssetPathType = {}));
var PersonPathType;
(function (PersonPathType) {
    PersonPathType["Face"] = "face";
})(PersonPathType || (exports.PersonPathType = PersonPathType = {}));
var UserPathType;
(function (UserPathType) {
    UserPathType["Profile"] = "profile";
})(UserPathType || (exports.UserPathType = UserPathType = {}));
var TranscodePolicy;
(function (TranscodePolicy) {
    TranscodePolicy["All"] = "all";
    TranscodePolicy["Optimal"] = "optimal";
    TranscodePolicy["Bitrate"] = "bitrate";
    TranscodePolicy["Required"] = "required";
    TranscodePolicy["Disabled"] = "disabled";
})(TranscodePolicy || (exports.TranscodePolicy = TranscodePolicy = {}));
var TranscodeTarget;
(function (TranscodeTarget) {
    TranscodeTarget["None"] = "NONE";
    TranscodeTarget["Audio"] = "AUDIO";
    TranscodeTarget["Video"] = "VIDEO";
    TranscodeTarget["All"] = "ALL";
})(TranscodeTarget || (exports.TranscodeTarget = TranscodeTarget = {}));
var VideoCodec;
(function (VideoCodec) {
    VideoCodec["H264"] = "h264";
    VideoCodec["Hevc"] = "hevc";
    VideoCodec["Vp9"] = "vp9";
    VideoCodec["Av1"] = "av1";
})(VideoCodec || (exports.VideoCodec = VideoCodec = {}));
var AudioCodec;
(function (AudioCodec) {
    AudioCodec["Mp3"] = "mp3";
    AudioCodec["Aac"] = "aac";
    AudioCodec["LibOpus"] = "libopus";
    AudioCodec["PcmS16le"] = "pcm_s16le";
})(AudioCodec || (exports.AudioCodec = AudioCodec = {}));
var VideoContainer;
(function (VideoContainer) {
    VideoContainer["Mov"] = "mov";
    VideoContainer["Mp4"] = "mp4";
    VideoContainer["Ogg"] = "ogg";
    VideoContainer["Webm"] = "webm";
})(VideoContainer || (exports.VideoContainer = VideoContainer = {}));
var TranscodeHardwareAcceleration;
(function (TranscodeHardwareAcceleration) {
    TranscodeHardwareAcceleration["Nvenc"] = "nvenc";
    TranscodeHardwareAcceleration["Qsv"] = "qsv";
    TranscodeHardwareAcceleration["Vaapi"] = "vaapi";
    TranscodeHardwareAcceleration["Rkmpp"] = "rkmpp";
    TranscodeHardwareAcceleration["Disabled"] = "disabled";
})(TranscodeHardwareAcceleration || (exports.TranscodeHardwareAcceleration = TranscodeHardwareAcceleration = {}));
var ToneMapping;
(function (ToneMapping) {
    ToneMapping["Hable"] = "hable";
    ToneMapping["Mobius"] = "mobius";
    ToneMapping["Reinhard"] = "reinhard";
    ToneMapping["Disabled"] = "disabled";
})(ToneMapping || (exports.ToneMapping = ToneMapping = {}));
var CQMode;
(function (CQMode) {
    CQMode["Auto"] = "auto";
    CQMode["Cqp"] = "cqp";
    CQMode["Icq"] = "icq";
})(CQMode || (exports.CQMode = CQMode = {}));
var Colorspace;
(function (Colorspace) {
    Colorspace["Srgb"] = "srgb";
    Colorspace["P3"] = "p3";
})(Colorspace || (exports.Colorspace = Colorspace = {}));
var ImageFormat;
(function (ImageFormat) {
    ImageFormat["Jpeg"] = "jpeg";
    ImageFormat["Webp"] = "webp";
})(ImageFormat || (exports.ImageFormat = ImageFormat = {}));
var RawExtractedFormat;
(function (RawExtractedFormat) {
    RawExtractedFormat["Jpeg"] = "jpeg";
    RawExtractedFormat["Jxl"] = "jxl";
})(RawExtractedFormat || (exports.RawExtractedFormat = RawExtractedFormat = {}));
var LogLevel;
(function (LogLevel) {
    LogLevel["Verbose"] = "verbose";
    LogLevel["Debug"] = "debug";
    LogLevel["Log"] = "log";
    LogLevel["Warn"] = "warn";
    LogLevel["Error"] = "error";
    LogLevel["Fatal"] = "fatal";
})(LogLevel || (exports.LogLevel = LogLevel = {}));
var ApiCustomExtension;
(function (ApiCustomExtension) {
    ApiCustomExtension["Permission"] = "x-immich-permission";
    ApiCustomExtension["AdminOnly"] = "x-immich-admin-only";
})(ApiCustomExtension || (exports.ApiCustomExtension = ApiCustomExtension = {}));
var MetadataKey;
(function (MetadataKey) {
    MetadataKey["AuthRoute"] = "auth_route";
    MetadataKey["AdminRoute"] = "admin_route";
    MetadataKey["SharedRoute"] = "shared_route";
    MetadataKey["ApiKeySecurity"] = "api_key";
    MetadataKey["EventConfig"] = "event_config";
    MetadataKey["JobConfig"] = "job_config";
    MetadataKey["TelemetryEnabled"] = "telemetry_enabled";
})(MetadataKey || (exports.MetadataKey = MetadataKey = {}));
var RouteKey;
(function (RouteKey) {
    RouteKey["Asset"] = "assets";
    RouteKey["User"] = "users";
})(RouteKey || (exports.RouteKey = RouteKey = {}));
var CacheControl;
(function (CacheControl) {
    CacheControl["PrivateWithCache"] = "private_with_cache";
    CacheControl["PrivateWithoutCache"] = "private_without_cache";
    CacheControl["None"] = "none";
})(CacheControl || (exports.CacheControl = CacheControl = {}));
var ImmichEnvironment;
(function (ImmichEnvironment) {
    ImmichEnvironment["Development"] = "development";
    ImmichEnvironment["Testing"] = "testing";
    ImmichEnvironment["Production"] = "production";
})(ImmichEnvironment || (exports.ImmichEnvironment = ImmichEnvironment = {}));
var ImmichWorker;
(function (ImmichWorker) {
    ImmichWorker["Api"] = "api";
    ImmichWorker["Microservices"] = "microservices";
})(ImmichWorker || (exports.ImmichWorker = ImmichWorker = {}));
var ImmichTelemetry;
(function (ImmichTelemetry) {
    ImmichTelemetry["Host"] = "host";
    ImmichTelemetry["Api"] = "api";
    ImmichTelemetry["Io"] = "io";
    ImmichTelemetry["Repo"] = "repo";
    ImmichTelemetry["Job"] = "job";
})(ImmichTelemetry || (exports.ImmichTelemetry = ImmichTelemetry = {}));
var ExifOrientation;
(function (ExifOrientation) {
    ExifOrientation[ExifOrientation["Horizontal"] = 1] = "Horizontal";
    ExifOrientation[ExifOrientation["MirrorHorizontal"] = 2] = "MirrorHorizontal";
    ExifOrientation[ExifOrientation["Rotate180"] = 3] = "Rotate180";
    ExifOrientation[ExifOrientation["MirrorVertical"] = 4] = "MirrorVertical";
    ExifOrientation[ExifOrientation["MirrorHorizontalRotate270CW"] = 5] = "MirrorHorizontalRotate270CW";
    ExifOrientation[ExifOrientation["Rotate90CW"] = 6] = "Rotate90CW";
    ExifOrientation[ExifOrientation["MirrorHorizontalRotate90CW"] = 7] = "MirrorHorizontalRotate90CW";
    ExifOrientation[ExifOrientation["Rotate270CW"] = 8] = "Rotate270CW";
})(ExifOrientation || (exports.ExifOrientation = ExifOrientation = {}));
var DatabaseExtension;
(function (DatabaseExtension) {
    DatabaseExtension["Cube"] = "cube";
    DatabaseExtension["EarthDistance"] = "earthdistance";
    DatabaseExtension["Vector"] = "vector";
    DatabaseExtension["Vectors"] = "vectors";
    DatabaseExtension["VectorChord"] = "vchord";
})(DatabaseExtension || (exports.DatabaseExtension = DatabaseExtension = {}));
var BootstrapEventPriority;
(function (BootstrapEventPriority) {
    BootstrapEventPriority[BootstrapEventPriority["DatabaseService"] = -200] = "DatabaseService";
    BootstrapEventPriority[BootstrapEventPriority["StorageService"] = -195] = "StorageService";
    BootstrapEventPriority[BootstrapEventPriority["JobService"] = -190] = "JobService";
    BootstrapEventPriority[BootstrapEventPriority["SystemConfig"] = 100] = "SystemConfig";
})(BootstrapEventPriority || (exports.BootstrapEventPriority = BootstrapEventPriority = {}));
var QueueName;
(function (QueueName) {
    QueueName["ThumbnailGeneration"] = "thumbnailGeneration";
    QueueName["MetadataExtraction"] = "metadataExtraction";
    QueueName["VideoConversion"] = "videoConversion";
    QueueName["FaceDetection"] = "faceDetection";
    QueueName["FacialRecognition"] = "facialRecognition";
    QueueName["SmartSearch"] = "smartSearch";
    QueueName["DuplicateDetection"] = "duplicateDetection";
    QueueName["BackgroundTask"] = "backgroundTask";
    QueueName["StorageTemplateMigration"] = "storageTemplateMigration";
    QueueName["Migration"] = "migration";
    QueueName["Search"] = "search";
    QueueName["Sidecar"] = "sidecar";
    QueueName["Library"] = "library";
    QueueName["Notification"] = "notifications";
    QueueName["BackupDatabase"] = "backupDatabase";
})(QueueName || (exports.QueueName = QueueName = {}));
var JobName;
(function (JobName) {
    JobName["AssetDelete"] = "AssetDelete";
    JobName["AssetDeleteCheck"] = "AssetDeleteCheck";
    JobName["AssetDetectFacesQueueAll"] = "AssetDetectFacesQueueAll";
    JobName["AssetDetectFaces"] = "AssetDetectFaces";
    JobName["AssetDetectDuplicatesQueueAll"] = "AssetDetectDuplicatesQueueAll";
    JobName["AssetDetectDuplicates"] = "AssetDetectDuplicates";
    JobName["AssetEncodeVideoQueueAll"] = "AssetEncodeVideoQueueAll";
    JobName["AssetEncodeVideo"] = "AssetEncodeVideo";
    JobName["AssetEmptyTrash"] = "AssetEmptyTrash";
    JobName["AssetExtractMetadataQueueAll"] = "AssetExtractMetadataQueueAll";
    JobName["AssetExtractMetadata"] = "AssetExtractMetadata";
    JobName["AssetFileMigration"] = "AssetFileMigration";
    JobName["AssetGenerateThumbnailsQueueAll"] = "AssetGenerateThumbnailsQueueAll";
    JobName["AssetGenerateThumbnails"] = "AssetGenerateThumbnails";
    JobName["AuditLogCleanup"] = "AuditLogCleanup";
    JobName["AuditTableCleanup"] = "AuditTableCleanup";
    JobName["DatabaseBackup"] = "DatabaseBackup";
    JobName["FacialRecognitionQueueAll"] = "FacialRecognitionQueueAll";
    JobName["FacialRecognition"] = "FacialRecognition";
    JobName["FileDelete"] = "FileDelete";
    JobName["FileMigrationQueueAll"] = "FileMigrationQueueAll";
    JobName["LibraryDeleteCheck"] = "LibraryDeleteCheck";
    JobName["LibraryDelete"] = "LibraryDelete";
    JobName["LibraryRemoveAsset"] = "LibraryRemoveAsset";
    JobName["LibrarySyncAssetsQueueAll"] = "LibraryScanAssetsQueueAll";
    JobName["LibrarySyncAssets"] = "LibrarySyncAssets";
    JobName["LibrarySyncFilesQueueAll"] = "LibrarySyncFilesQueueAll";
    JobName["LibrarySyncFiles"] = "LibrarySyncFiles";
    JobName["LibraryScanQueueAll"] = "LibraryScanQueueAll";
    JobName["MemoryCleanup"] = "MemoryCleanup";
    JobName["MemoryGenerate"] = "MemoryGenerate";
    JobName["NotificationsCleanup"] = "NotificationsCleanup";
    JobName["NotifyUserSignup"] = "NotifyUserSignup";
    JobName["NotifyAlbumInvite"] = "NotifyAlbumInvite";
    JobName["NotifyAlbumUpdate"] = "NotifyAlbumUpdate";
    JobName["UserDelete"] = "UserDelete";
    JobName["UserDeleteCheck"] = "UserDeleteCheck";
    JobName["UserSyncUsage"] = "UserSyncUsage";
    JobName["PersonCleanup"] = "PersonCleanup";
    JobName["PersonFileMigration"] = "PersonFileMigration";
    JobName["PersonGenerateThumbnail"] = "PersonGenerateThumbnail";
    JobName["SessionCleanup"] = "SessionCleanup";
    JobName["SendMail"] = "SendMail";
    JobName["SidecarQueueAll"] = "SidecarQueueAll";
    JobName["SidecarCheck"] = "SidecarCheck";
    JobName["SidecarWrite"] = "SidecarWrite";
    JobName["SmartSearchQueueAll"] = "SmartSearchQueueAll";
    JobName["SmartSearch"] = "SmartSearch";
    JobName["StorageTemplateMigration"] = "StorageTemplateMigration";
    JobName["StorageTemplateMigrationSingle"] = "StorageTemplateMigrationSingle";
    JobName["TagCleanup"] = "TagCleanup";
    JobName["VersionCheck"] = "VersionCheck";
})(JobName || (exports.JobName = JobName = {}));
var JobCommand;
(function (JobCommand) {
    JobCommand["Start"] = "start";
    JobCommand["Pause"] = "pause";
    JobCommand["Resume"] = "resume";
    JobCommand["Empty"] = "empty";
    JobCommand["ClearFailed"] = "clear-failed";
})(JobCommand || (exports.JobCommand = JobCommand = {}));
var JobStatus;
(function (JobStatus) {
    JobStatus["Success"] = "success";
    JobStatus["Failed"] = "failed";
    JobStatus["Skipped"] = "skipped";
})(JobStatus || (exports.JobStatus = JobStatus = {}));
var QueueCleanType;
(function (QueueCleanType) {
    QueueCleanType["Failed"] = "failed";
})(QueueCleanType || (exports.QueueCleanType = QueueCleanType = {}));
var VectorIndex;
(function (VectorIndex) {
    VectorIndex["Clip"] = "clip_index";
    VectorIndex["Face"] = "face_index";
})(VectorIndex || (exports.VectorIndex = VectorIndex = {}));
var DatabaseLock;
(function (DatabaseLock) {
    DatabaseLock[DatabaseLock["GeodataImport"] = 100] = "GeodataImport";
    DatabaseLock[DatabaseLock["Migrations"] = 200] = "Migrations";
    DatabaseLock[DatabaseLock["SystemFileMounts"] = 300] = "SystemFileMounts";
    DatabaseLock[DatabaseLock["StorageTemplateMigration"] = 420] = "StorageTemplateMigration";
    DatabaseLock[DatabaseLock["VersionHistory"] = 500] = "VersionHistory";
    DatabaseLock[DatabaseLock["CLIPDimSize"] = 512] = "CLIPDimSize";
    DatabaseLock[DatabaseLock["Library"] = 1337] = "Library";
    DatabaseLock[DatabaseLock["NightlyJobs"] = 600] = "NightlyJobs";
    DatabaseLock[DatabaseLock["MediaLocation"] = 700] = "MediaLocation";
    DatabaseLock[DatabaseLock["GetSystemConfig"] = 69] = "GetSystemConfig";
    DatabaseLock[DatabaseLock["BackupDatabase"] = 42] = "BackupDatabase";
    DatabaseLock[DatabaseLock["MemoryCreation"] = 777] = "MemoryCreation";
})(DatabaseLock || (exports.DatabaseLock = DatabaseLock = {}));
var SyncRequestType;
(function (SyncRequestType) {
    SyncRequestType["AlbumsV1"] = "AlbumsV1";
    SyncRequestType["AlbumUsersV1"] = "AlbumUsersV1";
    SyncRequestType["AlbumToAssetsV1"] = "AlbumToAssetsV1";
    SyncRequestType["AlbumAssetsV1"] = "AlbumAssetsV1";
    SyncRequestType["AlbumAssetExifsV1"] = "AlbumAssetExifsV1";
    SyncRequestType["AssetsV1"] = "AssetsV1";
    SyncRequestType["AssetExifsV1"] = "AssetExifsV1";
    SyncRequestType["AssetMetadataV1"] = "AssetMetadataV1";
    SyncRequestType["AuthUsersV1"] = "AuthUsersV1";
    SyncRequestType["MemoriesV1"] = "MemoriesV1";
    SyncRequestType["MemoryToAssetsV1"] = "MemoryToAssetsV1";
    SyncRequestType["PartnersV1"] = "PartnersV1";
    SyncRequestType["PartnerAssetsV1"] = "PartnerAssetsV1";
    SyncRequestType["PartnerAssetExifsV1"] = "PartnerAssetExifsV1";
    SyncRequestType["PartnerStacksV1"] = "PartnerStacksV1";
    SyncRequestType["StacksV1"] = "StacksV1";
    SyncRequestType["UsersV1"] = "UsersV1";
    SyncRequestType["PeopleV1"] = "PeopleV1";
    SyncRequestType["AssetFacesV1"] = "AssetFacesV1";
    SyncRequestType["UserMetadataV1"] = "UserMetadataV1";
})(SyncRequestType || (exports.SyncRequestType = SyncRequestType = {}));
var SyncEntityType;
(function (SyncEntityType) {
    SyncEntityType["AuthUserV1"] = "AuthUserV1";
    SyncEntityType["UserV1"] = "UserV1";
    SyncEntityType["UserDeleteV1"] = "UserDeleteV1";
    SyncEntityType["AssetV1"] = "AssetV1";
    SyncEntityType["AssetDeleteV1"] = "AssetDeleteV1";
    SyncEntityType["AssetExifV1"] = "AssetExifV1";
    SyncEntityType["AssetMetadataV1"] = "AssetMetadataV1";
    SyncEntityType["AssetMetadataDeleteV1"] = "AssetMetadataDeleteV1";
    SyncEntityType["PartnerV1"] = "PartnerV1";
    SyncEntityType["PartnerDeleteV1"] = "PartnerDeleteV1";
    SyncEntityType["PartnerAssetV1"] = "PartnerAssetV1";
    SyncEntityType["PartnerAssetBackfillV1"] = "PartnerAssetBackfillV1";
    SyncEntityType["PartnerAssetDeleteV1"] = "PartnerAssetDeleteV1";
    SyncEntityType["PartnerAssetExifV1"] = "PartnerAssetExifV1";
    SyncEntityType["PartnerAssetExifBackfillV1"] = "PartnerAssetExifBackfillV1";
    SyncEntityType["PartnerStackBackfillV1"] = "PartnerStackBackfillV1";
    SyncEntityType["PartnerStackDeleteV1"] = "PartnerStackDeleteV1";
    SyncEntityType["PartnerStackV1"] = "PartnerStackV1";
    SyncEntityType["AlbumV1"] = "AlbumV1";
    SyncEntityType["AlbumDeleteV1"] = "AlbumDeleteV1";
    SyncEntityType["AlbumUserV1"] = "AlbumUserV1";
    SyncEntityType["AlbumUserBackfillV1"] = "AlbumUserBackfillV1";
    SyncEntityType["AlbumUserDeleteV1"] = "AlbumUserDeleteV1";
    SyncEntityType["AlbumAssetCreateV1"] = "AlbumAssetCreateV1";
    SyncEntityType["AlbumAssetUpdateV1"] = "AlbumAssetUpdateV1";
    SyncEntityType["AlbumAssetBackfillV1"] = "AlbumAssetBackfillV1";
    SyncEntityType["AlbumAssetExifCreateV1"] = "AlbumAssetExifCreateV1";
    SyncEntityType["AlbumAssetExifUpdateV1"] = "AlbumAssetExifUpdateV1";
    SyncEntityType["AlbumAssetExifBackfillV1"] = "AlbumAssetExifBackfillV1";
    SyncEntityType["AlbumToAssetV1"] = "AlbumToAssetV1";
    SyncEntityType["AlbumToAssetDeleteV1"] = "AlbumToAssetDeleteV1";
    SyncEntityType["AlbumToAssetBackfillV1"] = "AlbumToAssetBackfillV1";
    SyncEntityType["MemoryV1"] = "MemoryV1";
    SyncEntityType["MemoryDeleteV1"] = "MemoryDeleteV1";
    SyncEntityType["MemoryToAssetV1"] = "MemoryToAssetV1";
    SyncEntityType["MemoryToAssetDeleteV1"] = "MemoryToAssetDeleteV1";
    SyncEntityType["StackV1"] = "StackV1";
    SyncEntityType["StackDeleteV1"] = "StackDeleteV1";
    SyncEntityType["PersonV1"] = "PersonV1";
    SyncEntityType["PersonDeleteV1"] = "PersonDeleteV1";
    SyncEntityType["AssetFaceV1"] = "AssetFaceV1";
    SyncEntityType["AssetFaceDeleteV1"] = "AssetFaceDeleteV1";
    SyncEntityType["UserMetadataV1"] = "UserMetadataV1";
    SyncEntityType["UserMetadataDeleteV1"] = "UserMetadataDeleteV1";
    SyncEntityType["SyncAckV1"] = "SyncAckV1";
    SyncEntityType["SyncResetV1"] = "SyncResetV1";
    SyncEntityType["SyncCompleteV1"] = "SyncCompleteV1";
})(SyncEntityType || (exports.SyncEntityType = SyncEntityType = {}));
var NotificationLevel;
(function (NotificationLevel) {
    NotificationLevel["Success"] = "success";
    NotificationLevel["Error"] = "error";
    NotificationLevel["Warning"] = "warning";
    NotificationLevel["Info"] = "info";
})(NotificationLevel || (exports.NotificationLevel = NotificationLevel = {}));
var NotificationType;
(function (NotificationType) {
    NotificationType["JobFailed"] = "JobFailed";
    NotificationType["BackupFailed"] = "BackupFailed";
    NotificationType["SystemMessage"] = "SystemMessage";
    NotificationType["AlbumInvite"] = "AlbumInvite";
    NotificationType["AlbumUpdate"] = "AlbumUpdate";
    NotificationType["Custom"] = "Custom";
})(NotificationType || (exports.NotificationType = NotificationType = {}));
var OAuthTokenEndpointAuthMethod;
(function (OAuthTokenEndpointAuthMethod) {
    OAuthTokenEndpointAuthMethod["ClientSecretPost"] = "client_secret_post";
    OAuthTokenEndpointAuthMethod["ClientSecretBasic"] = "client_secret_basic";
})(OAuthTokenEndpointAuthMethod || (exports.OAuthTokenEndpointAuthMethod = OAuthTokenEndpointAuthMethod = {}));
var DatabaseSslMode;
(function (DatabaseSslMode) {
    DatabaseSslMode["Disable"] = "disable";
    DatabaseSslMode["Allow"] = "allow";
    DatabaseSslMode["Prefer"] = "prefer";
    DatabaseSslMode["Require"] = "require";
    DatabaseSslMode["VerifyFull"] = "verify-full";
})(DatabaseSslMode || (exports.DatabaseSslMode = DatabaseSslMode = {}));
var AssetVisibility;
(function (AssetVisibility) {
    AssetVisibility["Archive"] = "archive";
    AssetVisibility["Timeline"] = "timeline";
    AssetVisibility["Hidden"] = "hidden";
    AssetVisibility["Locked"] = "locked";
})(AssetVisibility || (exports.AssetVisibility = AssetVisibility = {}));
var CronJob;
(function (CronJob) {
    CronJob["LibraryScan"] = "LibraryScan";
    CronJob["NightlyJobs"] = "NightlyJobs";
})(CronJob || (exports.CronJob = CronJob = {}));
//# sourceMappingURL=enum.js.map