"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetUploadInterceptor = void 0;
const common_1 = require("@nestjs/common");
const rxjs_1 = require("rxjs");
const asset_media_response_dto_1 = require("../dtos/asset-media-response.dto");
const enum_1 = require("../enum");
const asset_media_service_1 = require("../services/asset-media.service");
const request_1 = require("../utils/request");
let AssetUploadInterceptor = class AssetUploadInterceptor {
    service;
    constructor(service) {
        this.service = service;
    }
    async intercept(context, next) {
        const req = context.switchToHttp().getRequest();
        const res = context.switchToHttp().getResponse();
        const checksum = (0, request_1.fromMaybeArray)(req.headers[enum_1.ImmichHeader.Checksum]);
        const response = await this.service.getUploadAssetIdByChecksum(req.user, checksum);
        if (response) {
            res.status(200);
            return (0, rxjs_1.of)({ status: asset_media_response_dto_1.AssetMediaStatus.DUPLICATE, id: response.id });
        }
        return next.handle();
    }
};
exports.AssetUploadInterceptor = AssetUploadInterceptor;
exports.AssetUploadInterceptor = AssetUploadInterceptor = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [asset_media_service_1.AssetMediaService])
], AssetUploadInterceptor);
//# sourceMappingURL=asset-upload.interceptor.js.map