import { Insertable, Kysely } from 'kysely';
import { DB } from 'src/schema';
import { ActivityTable } from 'src/schema/tables/activity.table';
export interface ActivitySearch {
    albumId?: string;
    assetId?: string | null;
    userId?: string;
    isLiked?: boolean;
}
export declare class ActivityRepository {
    private db;
    constructor(db: Kysely<DB>);
    search(options: ActivitySearch): Promise<{
        id: string;
        assetId: string | null;
        comment: string | null;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        userId: string;
        albumId: string;
        isLiked: boolean;
        user: {
            id: string;
            name: string;
            email: string;
            profileImagePath: string;
            avatarColor: import("src/enum").UserAvatarColor | null;
            profileChangedAt: Date;
        };
    }[]>;
    create(activity: Insertable<ActivityTable>): Promise<{
        id: string;
        assetId: string | null;
        user: {
            id: string;
            name: string;
            email: string;
            profileImagePath: string;
            avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB, "user" | "activity", "avatarColor">;
            profileChangedAt: Date;
        };
        comment: string | null;
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        userId: string;
        albumId: string;
        isLiked: boolean;
    }>;
    delete(id: string): Promise<void>;
    getStatistics({ albumId, assetId, }: {
        albumId: string;
        assetId?: string;
    }): Promise<{
        comments: number;
        likes: number;
    }>;
}
