import { Insertable, Kysely, Updateable } from 'kysely';
import { AlbumUserRole } from 'src/enum';
import { DB } from 'src/schema';
import { AlbumUserTable } from 'src/schema/tables/album-user.table';
export type AlbumPermissionId = {
    albumsId: string;
    usersId: string;
};
export declare class AlbumUserRepository {
    private db;
    constructor(db: Kysely<DB>);
    create(albumUser: Insertable<AlbumUserTable>): Promise<{
        role: AlbumUserRole;
        albumsId: string;
        usersId: string;
    }>;
    update({ usersId, albumsId }: AlbumPermissionId, dto: Updateable<AlbumUserTable>): Promise<{
        updatedAt: Date;
        createdAt: Date;
        updateId: string;
        role: AlbumUserRole;
        albumsId: string;
        usersId: string;
        createId: string;
    }>;
    delete({ usersId, albumsId }: AlbumPermissionId): Promise<void>;
}
