"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbumUserRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const nestjs_kysely_1 = require("nestjs-kysely");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
let AlbumUserRepository = class AlbumUserRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    create(albumUser) {
        return this.db
            .insertInto('album_user')
            .values(albumUser)
            .returning(['usersId', 'albumsId', 'role'])
            .executeTakeFirstOrThrow();
    }
    update({ usersId, albumsId }, dto) {
        return this.db
            .updateTable('album_user')
            .set(dto)
            .where('usersId', '=', usersId)
            .where('albumsId', '=', albumsId)
            .returningAll()
            .executeTakeFirstOrThrow();
    }
    async delete({ usersId, albumsId }) {
        await this.db.deleteFrom('album_user').where('usersId', '=', usersId).where('albumsId', '=', albumsId).execute();
    }
};
exports.AlbumUserRepository = AlbumUserRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ usersId: decorators_1.DummyValue.UUID, albumsId: decorators_1.DummyValue.UUID }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], AlbumUserRepository.prototype, "create", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ usersId: decorators_1.DummyValue.UUID, albumsId: decorators_1.DummyValue.UUID }, { role: enum_1.AlbumUserRole.Viewer }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], AlbumUserRepository.prototype, "update", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [{ usersId: decorators_1.DummyValue.UUID, albumsId: decorators_1.DummyValue.UUID }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AlbumUserRepository.prototype, "delete", null);
exports.AlbumUserRepository = AlbumUserRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], AlbumUserRepository);
//# sourceMappingURL=album-user.repository.js.map