import { Insertable, Kysely, Updateable } from 'kysely';
import { Exif } from 'src/database';
import { AlbumUserCreateDto } from 'src/dtos/album.dto';
import { DB } from 'src/schema';
import { AlbumTable } from 'src/schema/tables/album.table';
export interface AlbumAssetCount {
    albumId: string;
    assetCount: number;
    startDate: Date | null;
    endDate: Date | null;
    lastModifiedAssetTimestamp: Date | null;
}
export interface AlbumInfoOptions {
    withAssets: boolean;
}
export declare class AlbumRepository {
    private db;
    constructor(db: Kysely<DB>);
    getById(id: string, options: AlbumInfoOptions): Promise<{
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updatedAt: Date;
            createdAt: Date;
            deletedAt: Date | null;
            status: import("../enum").AssetStatus;
            updateId: string;
            ownerId: string;
            deviceAssetId: string;
            deviceId: string;
            originalPath: string;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isFavorite: boolean;
            duration: string | null;
            encodedVideoPath: string | null;
            checksum: Buffer<ArrayBufferLike>;
            livePhotoVideoId: string | null;
            originalFileName: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            isOffline: boolean;
            libraryId: string | null;
            isExternal: boolean;
            localDateTime: Date;
            stackId: string | null;
            duplicateId: string | null;
            visibility: import("../enum").AssetVisibility;
            exifInfo: Exif;
        }[] | undefined;
        id: string;
        description: string;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        updateId: string;
        ownerId: string;
        albumName: string;
        albumThumbnailAssetId: string | null;
        isActivityEnabled: boolean;
        order: import("../enum").AssetOrder;
        owner: {
            id: string;
            name: string;
            email: string;
            profileImagePath: string;
            avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB, "user" | "album", "avatarColor">;
            profileChangedAt: Date;
        };
        sharedLinks: {
            password: string | null;
            key: Buffer<ArrayBufferLike>;
            slug: string | null;
            id: string;
            type: import("../enum").SharedLinkType;
            description: string | null;
            updatedAt: Date;
            createdAt: Date;
            deletedAt: Date | null;
            updateId: string;
            ownerId: string;
            userId: string;
            albumId: string | null;
            albumName: string;
            albumThumbnailAssetId: string | null;
            isActivityEnabled: boolean;
            order: import("../enum").AssetOrder;
            expiresAt: Date | null;
            allowUpload: boolean;
            allowDownload: boolean;
            showExif: boolean;
        }[];
        albumUsers: {
            role: import("../enum").AlbumUserRole;
            user: {
                id: string;
                name: string;
                email: string;
                profileImagePath: string;
                avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB, "user" | "album" | "album_user", "avatarColor">;
                profileChangedAt: Date;
            };
        }[];
    } | undefined>;
    getByAssetId(ownerId: string, assetId: string): Promise<{
        id: string;
        description: string;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        updateId: string;
        ownerId: string;
        albumName: string;
        albumThumbnailAssetId: string | null;
        isActivityEnabled: boolean;
        order: import("../enum").AssetOrder;
        owner: {
            id: string;
            name: string;
            email: string;
            profileImagePath: string;
            avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB, "user" | "album", "avatarColor">;
            profileChangedAt: Date;
        };
        albumUsers: {
            role: import("../enum").AlbumUserRole;
            user: {
                id: string;
                name: string;
                email: string;
                profileImagePath: string;
                avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB, "user" | "album" | "album_user", "avatarColor">;
                profileChangedAt: Date;
            };
        }[];
    }[]>;
    getMetadataForIds(ids: string[]): Promise<AlbumAssetCount[]>;
    getOwned(ownerId: string): Promise<{
        id: string;
        description: string;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        updateId: string;
        ownerId: string;
        albumName: string;
        albumThumbnailAssetId: string | null;
        isActivityEnabled: boolean;
        order: import("../enum").AssetOrder;
        owner: {
            id: string;
            name: string;
            email: string;
            profileImagePath: string;
            avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB, "user" | "album", "avatarColor">;
            profileChangedAt: Date;
        };
        albumUsers: {
            role: import("../enum").AlbumUserRole;
            user: {
                id: string;
                name: string;
                email: string;
                profileImagePath: string;
                avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB, "user" | "album" | "album_user", "avatarColor">;
                profileChangedAt: Date;
            };
        }[];
        sharedLinks: {
            password: string | null;
            key: Buffer<ArrayBufferLike>;
            slug: string | null;
            id: string;
            type: import("../enum").SharedLinkType;
            description: string | null;
            updatedAt: Date;
            createdAt: Date;
            deletedAt: Date | null;
            updateId: string;
            ownerId: string;
            userId: string;
            albumId: string | null;
            albumName: string;
            albumThumbnailAssetId: string | null;
            isActivityEnabled: boolean;
            order: import("../enum").AssetOrder;
            expiresAt: Date | null;
            allowUpload: boolean;
            allowDownload: boolean;
            showExif: boolean;
        }[];
    }[]>;
    getShared(ownerId: string): Promise<{
        id: string;
        description: string;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        updateId: string;
        ownerId: string;
        albumName: string;
        albumThumbnailAssetId: string | null;
        isActivityEnabled: boolean;
        order: import("../enum").AssetOrder;
        albumUsers: {
            role: import("../enum").AlbumUserRole;
            user: {
                id: string;
                name: string;
                email: string;
                profileImagePath: string;
                avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB, "user" | "album" | "album_user", "avatarColor">;
                profileChangedAt: Date;
            };
        }[];
        owner: {
            id: string;
            name: string;
            email: string;
            profileImagePath: string;
            avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB, "user" | "album", "avatarColor">;
            profileChangedAt: Date;
        };
        sharedLinks: {
            password: string | null;
            key: Buffer<ArrayBufferLike>;
            slug: string | null;
            id: string;
            type: import("../enum").SharedLinkType;
            description: string | null;
            updatedAt: Date;
            createdAt: Date;
            deletedAt: Date | null;
            updateId: string;
            ownerId: string;
            userId: string;
            albumId: string | null;
            albumName: string;
            albumThumbnailAssetId: string | null;
            isActivityEnabled: boolean;
            order: import("../enum").AssetOrder;
            expiresAt: Date | null;
            allowUpload: boolean;
            allowDownload: boolean;
            showExif: boolean;
        }[];
    }[]>;
    getNotShared(ownerId: string): Promise<{
        id: string;
        description: string;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        updateId: string;
        ownerId: string;
        albumName: string;
        albumThumbnailAssetId: string | null;
        isActivityEnabled: boolean;
        order: import("../enum").AssetOrder;
        owner: {
            id: string;
            name: string;
            email: string;
            profileImagePath: string;
            avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB, "user" | "album", "avatarColor">;
            profileChangedAt: Date;
        };
    }[]>;
    restoreAll(userId: string): Promise<void>;
    softDeleteAll(userId: string): Promise<void>;
    deleteAll(userId: string): Promise<void>;
    removeAssetsFromAll(assetIds: string[]): Promise<void>;
    removeAssetIds(albumId: string, assetIds: string[]): Promise<void>;
    getAssetIds(albumId: string, assetIds: string[]): Promise<Set<string>>;
    addAssetIds(albumId: string, assetIds: string[]): Promise<void>;
    create(album: Insertable<AlbumTable>, assetIds: string[], albumUsers: AlbumUserCreateDto[]): Promise<{
        assets: {
            id: string;
            type: import("../enum").AssetType;
            updatedAt: Date;
            createdAt: Date;
            deletedAt: Date | null;
            status: import("../enum").AssetStatus;
            updateId: string;
            ownerId: string;
            deviceAssetId: string;
            deviceId: string;
            originalPath: string;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isFavorite: boolean;
            duration: string | null;
            encodedVideoPath: string | null;
            checksum: Buffer<ArrayBufferLike>;
            livePhotoVideoId: string | null;
            originalFileName: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            isOffline: boolean;
            libraryId: string | null;
            isExternal: boolean;
            localDateTime: Date;
            stackId: string | null;
            duplicateId: string | null;
            visibility: import("../enum").AssetVisibility;
            exifInfo: Exif;
        }[];
        id: string;
        description: string;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        updateId: string;
        ownerId: string;
        albumName: string;
        albumThumbnailAssetId: string | null;
        isActivityEnabled: boolean;
        order: import("../enum").AssetOrder;
        owner: {
            id: string;
            name: string;
            email: string;
            profileImagePath: string;
            avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB, "user" | "album", "avatarColor">;
            profileChangedAt: Date;
        };
        albumUsers: {
            role: import("../enum").AlbumUserRole;
            user: {
                id: string;
                name: string;
                email: string;
                profileImagePath: string;
                avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB, "user" | "album" | "album_user", "avatarColor">;
                profileChangedAt: Date;
            };
        }[];
    }>;
    update(id: string, album: Updateable<AlbumTable>): Promise<{
        id: string;
        description: string;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        updateId: string;
        ownerId: string;
        albumName: string;
        albumThumbnailAssetId: string | null;
        isActivityEnabled: boolean;
        order: import("../enum").AssetOrder;
        owner: {
            id: string;
            name: string;
            email: string;
            profileImagePath: string;
            avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB, "user" | "album", "avatarColor">;
            profileChangedAt: Date;
        };
        sharedLinks: {
            password: string | null;
            key: Buffer<ArrayBufferLike>;
            slug: string | null;
            id: string;
            type: import("../enum").SharedLinkType;
            description: string | null;
            updatedAt: Date;
            createdAt: Date;
            deletedAt: Date | null;
            updateId: string;
            ownerId: string;
            userId: string;
            albumId: string | null;
            albumName: string;
            albumThumbnailAssetId: string | null;
            isActivityEnabled: boolean;
            order: import("../enum").AssetOrder;
            expiresAt: Date | null;
            allowUpload: boolean;
            allowDownload: boolean;
            showExif: boolean;
        }[];
        albumUsers: {
            role: import("../enum").AlbumUserRole;
            user: {
                id: string;
                name: string;
                email: string;
                profileImagePath: string;
                avatarColor: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<DB, "user" | "album" | "album_user", "avatarColor">;
                profileChangedAt: Date;
            };
        }[];
    }>;
    delete(id: string): Promise<void>;
    private addAssets;
    addAssetIdsToAlbums(values: {
        albumsId: string;
        assetsId: string;
    }[]): Promise<void>;
    updateThumbnails(): Promise<number | undefined>;
    private updateThumbnailBuilder;
}
