"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbumRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const postgres_1 = require("kysely/helpers/postgres");
const nestjs_kysely_1 = require("nestjs-kysely");
const database_1 = require("../database");
const decorators_1 = require("../decorators");
const database_2 = require("../utils/database");
const withOwner = (eb) => {
    return (0, postgres_1.jsonObjectFrom)(eb.selectFrom('user').select(database_1.columns.user).whereRef('user.id', '=', 'album.ownerId'))
        .$notNull()
        .as('owner');
};
const withAlbumUsers = (eb) => {
    return (0, postgres_1.jsonArrayFrom)(eb
        .selectFrom('album_user')
        .select('album_user.role')
        .select((eb) => (0, postgres_1.jsonObjectFrom)(eb.selectFrom('user').select(database_1.columns.user).whereRef('user.id', '=', 'album_user.usersId'))
        .$notNull()
        .as('user'))
        .whereRef('album_user.albumsId', '=', 'album.id'))
        .$notNull()
        .as('albumUsers');
};
const withSharedLink = (eb) => {
    return (0, postgres_1.jsonArrayFrom)(eb.selectFrom('shared_link').selectAll().whereRef('shared_link.albumId', '=', 'album.id')).as('sharedLinks');
};
const withAssets = (eb) => {
    return eb
        .selectFrom((eb) => eb
        .selectFrom('asset')
        .selectAll('asset')
        .leftJoin('asset_exif', 'asset.id', 'asset_exif.assetId')
        .select((eb) => eb.table('asset_exif').$castTo().as('exifInfo'))
        .innerJoin('album_asset', 'album_asset.assetsId', 'asset.id')
        .whereRef('album_asset.albumsId', '=', 'album.id')
        .where('asset.deletedAt', 'is', null)
        .$call(database_2.withDefaultVisibility)
        .orderBy('asset.fileCreatedAt', 'desc')
        .as('asset'))
        .select((eb) => eb.fn.jsonAgg('asset').as('assets'))
        .as('assets');
};
let AlbumRepository = class AlbumRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    async getById(id, options) {
        return this.db
            .selectFrom('album')
            .selectAll('album')
            .where('album.id', '=', id)
            .where('album.deletedAt', 'is', null)
            .select(withOwner)
            .select(withAlbumUsers)
            .select(withSharedLink)
            .$if(options.withAssets, (eb) => eb.select(withAssets))
            .$narrowType()
            .executeTakeFirst();
    }
    async getByAssetId(ownerId, assetId) {
        return this.db
            .selectFrom('album')
            .selectAll('album')
            .innerJoin('album_asset', 'album_asset.albumsId', 'album.id')
            .where((eb) => eb.or([
            eb('album.ownerId', '=', ownerId),
            eb.exists(eb
                .selectFrom('album_user')
                .whereRef('album_user.albumsId', '=', 'album.id')
                .where('album_user.usersId', '=', ownerId)),
        ]))
            .where('album_asset.assetsId', '=', assetId)
            .where('album.deletedAt', 'is', null)
            .orderBy('album.createdAt', 'desc')
            .select(withOwner)
            .select(withAlbumUsers)
            .orderBy('album.createdAt', 'desc')
            .execute();
    }
    async getMetadataForIds(ids) {
        if (ids.length === 0) {
            return [];
        }
        return (this.db
            .selectFrom('asset')
            .$call(database_2.withDefaultVisibility)
            .innerJoin('album_asset', 'album_asset.assetsId', 'asset.id')
            .select('album_asset.albumsId as albumId')
            .select((eb) => eb.fn.min((0, kysely_1.sql) `("asset"."localDateTime" AT TIME ZONE 'UTC'::text)::date`).as('startDate'))
            .select((eb) => eb.fn.max((0, kysely_1.sql) `("asset"."localDateTime" AT TIME ZONE 'UTC'::text)::date`).as('endDate'))
            .select((eb) => eb.fn.max('asset.updatedAt').as('lastModifiedAssetTimestamp'))
            .select((eb) => (0, kysely_1.sql) `${eb.fn.count('asset.id')}::int`.as('assetCount'))
            .where('album_asset.albumsId', 'in', ids)
            .where('asset.deletedAt', 'is', null)
            .groupBy('album_asset.albumsId')
            .execute());
    }
    async getOwned(ownerId) {
        return this.db
            .selectFrom('album')
            .selectAll('album')
            .select(withOwner)
            .select(withAlbumUsers)
            .select(withSharedLink)
            .where('album.ownerId', '=', ownerId)
            .where('album.deletedAt', 'is', null)
            .orderBy('album.createdAt', 'desc')
            .execute();
    }
    async getShared(ownerId) {
        return this.db
            .selectFrom('album')
            .selectAll('album')
            .where((eb) => eb.or([
            eb.exists(eb
                .selectFrom('album_user')
                .whereRef('album_user.albumsId', '=', 'album.id')
                .where((eb) => eb.or([eb('album.ownerId', '=', ownerId), eb('album_user.usersId', '=', ownerId)]))),
            eb.exists(eb
                .selectFrom('shared_link')
                .whereRef('shared_link.albumId', '=', 'album.id')
                .where('shared_link.userId', '=', ownerId)),
        ]))
            .where('album.deletedAt', 'is', null)
            .select(withAlbumUsers)
            .select(withOwner)
            .select(withSharedLink)
            .orderBy('album.createdAt', 'desc')
            .execute();
    }
    async getNotShared(ownerId) {
        return this.db
            .selectFrom('album')
            .selectAll('album')
            .where('album.ownerId', '=', ownerId)
            .where('album.deletedAt', 'is', null)
            .where((eb) => eb.not(eb.exists(eb.selectFrom('album_user').whereRef('album_user.albumsId', '=', 'album.id'))))
            .where((eb) => eb.not(eb.exists(eb.selectFrom('shared_link').whereRef('shared_link.albumId', '=', 'album.id'))))
            .select(withOwner)
            .orderBy('album.createdAt', 'desc')
            .execute();
    }
    async restoreAll(userId) {
        await this.db.updateTable('album').set({ deletedAt: null }).where('ownerId', '=', userId).execute();
    }
    async softDeleteAll(userId) {
        await this.db.updateTable('album').set({ deletedAt: new Date() }).where('ownerId', '=', userId).execute();
    }
    async deleteAll(userId) {
        await this.db.deleteFrom('album').where('ownerId', '=', userId).execute();
    }
    async removeAssetsFromAll(assetIds) {
        await this.db.deleteFrom('album_asset').where('album_asset.assetsId', 'in', assetIds).execute();
    }
    async removeAssetIds(albumId, assetIds) {
        if (assetIds.length === 0) {
            return;
        }
        await this.db
            .deleteFrom('album_asset')
            .where('album_asset.albumsId', '=', albumId)
            .where('album_asset.assetsId', 'in', assetIds)
            .execute();
    }
    async getAssetIds(albumId, assetIds) {
        if (assetIds.length === 0) {
            return new Set();
        }
        return this.db
            .selectFrom('album_asset')
            .selectAll()
            .where('album_asset.albumsId', '=', albumId)
            .where('album_asset.assetsId', 'in', assetIds)
            .execute()
            .then((results) => new Set(results.map(({ assetsId }) => assetsId)));
    }
    async addAssetIds(albumId, assetIds) {
        await this.addAssets(this.db, albumId, assetIds);
    }
    create(album, assetIds, albumUsers) {
        return this.db.transaction().execute(async (tx) => {
            const newAlbum = await tx.insertInto('album').values(album).returning('album.id').executeTakeFirst();
            if (!newAlbum) {
                throw new Error('Failed to create album');
            }
            if (assetIds.length > 0) {
                await this.addAssets(tx, newAlbum.id, assetIds);
            }
            if (albumUsers.length > 0) {
                await tx
                    .insertInto('album_user')
                    .values(albumUsers.map((albumUser) => ({ albumsId: newAlbum.id, usersId: albumUser.userId, role: albumUser.role })))
                    .execute();
            }
            return tx
                .selectFrom('album')
                .selectAll()
                .where('id', '=', newAlbum.id)
                .select(withOwner)
                .select(withAssets)
                .select(withAlbumUsers)
                .$narrowType()
                .executeTakeFirstOrThrow();
        });
    }
    update(id, album) {
        return this.db
            .updateTable('album')
            .set(album)
            .where('id', '=', id)
            .returningAll('album')
            .returning(withOwner)
            .returning(withSharedLink)
            .returning(withAlbumUsers)
            .executeTakeFirstOrThrow();
    }
    async delete(id) {
        await this.db.deleteFrom('album').where('id', '=', id).execute();
    }
    async addAssets(db, albumId, assetIds) {
        if (assetIds.length === 0) {
            return;
        }
        await db
            .insertInto('album_asset')
            .values(assetIds.map((assetId) => ({ albumsId: albumId, assetsId: assetId })))
            .execute();
    }
    async addAssetIdsToAlbums(values) {
        if (values.length === 0) {
            return;
        }
        await this.db.insertInto('album_asset').values(values).execute();
    }
    async updateThumbnails() {
        const result = await this.db
            .updateTable('album')
            .set((eb) => ({
            albumThumbnailAssetId: this.updateThumbnailBuilder(eb)
                .select('album_asset.assetsId')
                .orderBy('asset.fileCreatedAt', 'desc')
                .limit(1),
        }))
            .where((eb) => eb.or([
            eb.and([
                eb('albumThumbnailAssetId', 'is', null),
                eb.exists(this.updateThumbnailBuilder(eb).select((0, kysely_1.sql) `1`.as('1'))),
            ]),
            eb.and([
                eb('albumThumbnailAssetId', 'is not', null),
                eb.not(eb.exists(this.updateThumbnailBuilder(eb)
                    .select((0, kysely_1.sql) `1`.as('1'))
                    .whereRef('album.albumThumbnailAssetId', '=', 'album_asset.assetsId'))),
            ]),
        ]))
            .execute();
        return Number(result[0].numUpdatedRows);
    }
    updateThumbnailBuilder(eb) {
        return eb
            .selectFrom('album_asset')
            .innerJoin('asset', (join) => join.onRef('album_asset.assetsId', '=', 'asset.id').on('asset.deletedAt', 'is', null))
            .whereRef('album_asset.albumsId', '=', 'album.id');
    }
};
exports.AlbumRepository = AlbumRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, { withAssets: true }] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "getById", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "getByAssetId", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [[decorators_1.DummyValue.UUID]] }),
    (0, decorators_1.ChunkedArray)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "getMetadataForIds", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "getOwned", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "getShared", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "getNotShared", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [[decorators_1.DummyValue.UUID]] }),
    (0, decorators_1.Chunked)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "removeAssetsFromAll", null);
__decorate([
    (0, decorators_1.Chunked)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "removeAssetIds", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, [decorators_1.DummyValue.UUID]] }),
    (0, decorators_1.ChunkedSet)({ paramIndex: 1 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Array]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "getAssetIds", null);
__decorate([
    (0, decorators_1.Chunked)({ paramIndex: 2, chunkSize: 30_000 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [kysely_1.Kysely, String, Array]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "addAssets", null);
__decorate([
    (0, decorators_1.Chunked)({ chunkSize: 30_000 }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", Promise)
], AlbumRepository.prototype, "addAssetIdsToAlbums", null);
exports.AlbumRepository = AlbumRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], AlbumRepository);
//# sourceMappingURL=album.repository.js.map