import { Kysely } from 'kysely';
import { Asset } from 'src/database';
import { AssetFileType, AssetType, AssetVisibility } from 'src/enum';
import { DB } from 'src/schema';
import { StorageAsset } from 'src/types';
export declare class AssetJobRepository {
    private db;
    constructor(db: Kysely<DB>);
    getForSearchDuplicatesJob(id: string): Promise<{
        id: string;
        type: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<{
            library: import("../schema/tables/library.table").LibraryTable;
            api_key: import("../schema/tables/api-key.table").ApiKeyTable;
            smart_search: import("kysely").Nullable<import("../schema/tables/smart-search.table").SmartSearchTable>;
            face_search: import("../schema/tables/face-search.table").FaceSearchTable;
            user: import("../schema/tables/user.table").UserTable;
            user_metadata_audit: import("../schema/tables/user-metadata-audit.table").UserMetadataAuditTable;
            asset_metadata_audit: import("../schema/tables/asset-metadata-audit.table").AssetMetadataAuditTable;
            asset_face_audit: import("../schema/tables/asset-face-audit.table").AssetFaceAuditTable;
            stack: import("../schema/tables/stack.table").StackTable;
            activity: import("../schema/tables/activity.table").ActivityTable;
            album: import("../schema/tables/album.table").AlbumTable;
            album_audit: import("../schema/tables/album-audit.table").AlbumAuditTable;
            album_asset: import("../schema/tables/album-asset.table").AlbumAssetTable;
            album_asset_audit: import("../schema/tables/album-asset-audit.table").AlbumAssetAuditTable;
            album_user: import("../schema/tables/album-user.table").AlbumUserTable;
            album_user_audit: import("../schema/tables/album-user-audit.table").AlbumUserAuditTable;
            asset: import("../schema/tables/asset.table").AssetTable;
            asset_audit: import("../schema/tables/asset-audit.table").AssetAuditTable;
            asset_exif: import("../schema/tables/asset-exif.table").AssetExifTable;
            asset_face: import("../schema/tables/asset-face.table").AssetFaceTable;
            asset_file: import("../schema/tables/asset-file.table").AssetFileTable;
            asset_metadata: import("../schema/tables/asset-metadata.table").AssetMetadataTable<import("src/enum").AssetMetadataKey>;
            asset_job_status: import("../schema/tables/asset-job-status.table").AssetJobStatusTable;
            audit: import("../schema/tables/audit.table").AuditTable;
            geodata_places: import("../schema/tables/geodata-places.table").GeodataPlacesTable;
            memory: import("../schema/tables/memory.table").MemoryTable;
            memory_audit: import("../schema/tables/memory-audit.table").MemoryAuditTable;
            memory_asset: import("../schema/tables/memory-asset.table").MemoryAssetTable;
            memory_asset_audit: import("../schema/tables/memory-asset-audit.table").MemoryAssetAuditTable;
            migrations: import("src/schema").Migrations;
            notification: import("../schema/tables/notification.table").NotificationTable;
            move_history: import("../schema/tables/move.table").MoveTable;
            naturalearth_countries: import("../schema/tables/natural-earth-countries.table").NaturalEarthCountriesTable;
            partner: import("../schema/tables/partner.table").PartnerTable;
            partner_audit: import("../schema/tables/partner-audit.table").PartnerAuditTable;
            person: import("../schema/tables/person.table").PersonTable;
            person_audit: import("../schema/tables/person-audit.table").PersonAuditTable;
            session: import("../schema/tables/session.table").SessionTable;
            session_sync_checkpoint: import("../schema/tables/sync-checkpoint.table").SessionSyncCheckpointTable;
            shared_link: import("../schema/tables/shared-link.table").SharedLinkTable;
            shared_link_asset: import("../schema/tables/shared-link-asset.table").SharedLinkAssetTable;
            stack_audit: import("../schema/tables/stack-audit.table").StackAuditTable;
            system_metadata: import("../schema/tables/system-metadata.table").SystemMetadataTable<import("src/enum").SystemMetadataKey>;
            tag: import("../schema/tables/tag.table").TagTable;
            tag_asset: import("../schema/tables/tag-asset.table").TagAssetTable;
            tag_closure: import("../schema/tables/tag-closure.table").TagClosureTable;
            user_audit: import("../schema/tables/user-audit.table").UserAuditTable;
            user_metadata: import("../schema/tables/user-metadata.table").UserMetadataTable<import("src/enum").UserMetadataKey>;
            version_history: import("../schema/tables/version-history.table").VersionHistoryTable;
        }, "smart_search" | "asset", "type">;
        ownerId: string;
        stackId: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<{
            library: import("../schema/tables/library.table").LibraryTable;
            api_key: import("../schema/tables/api-key.table").ApiKeyTable;
            smart_search: import("kysely").Nullable<import("../schema/tables/smart-search.table").SmartSearchTable>;
            face_search: import("../schema/tables/face-search.table").FaceSearchTable;
            user: import("../schema/tables/user.table").UserTable;
            user_metadata_audit: import("../schema/tables/user-metadata-audit.table").UserMetadataAuditTable;
            asset_metadata_audit: import("../schema/tables/asset-metadata-audit.table").AssetMetadataAuditTable;
            asset_face_audit: import("../schema/tables/asset-face-audit.table").AssetFaceAuditTable;
            stack: import("../schema/tables/stack.table").StackTable;
            activity: import("../schema/tables/activity.table").ActivityTable;
            album: import("../schema/tables/album.table").AlbumTable;
            album_audit: import("../schema/tables/album-audit.table").AlbumAuditTable;
            album_asset: import("../schema/tables/album-asset.table").AlbumAssetTable;
            album_asset_audit: import("../schema/tables/album-asset-audit.table").AlbumAssetAuditTable;
            album_user: import("../schema/tables/album-user.table").AlbumUserTable;
            album_user_audit: import("../schema/tables/album-user-audit.table").AlbumUserAuditTable;
            asset: import("../schema/tables/asset.table").AssetTable;
            asset_audit: import("../schema/tables/asset-audit.table").AssetAuditTable;
            asset_exif: import("../schema/tables/asset-exif.table").AssetExifTable;
            asset_face: import("../schema/tables/asset-face.table").AssetFaceTable;
            asset_file: import("../schema/tables/asset-file.table").AssetFileTable;
            asset_metadata: import("../schema/tables/asset-metadata.table").AssetMetadataTable<import("src/enum").AssetMetadataKey>;
            asset_job_status: import("../schema/tables/asset-job-status.table").AssetJobStatusTable;
            audit: import("../schema/tables/audit.table").AuditTable;
            geodata_places: import("../schema/tables/geodata-places.table").GeodataPlacesTable;
            memory: import("../schema/tables/memory.table").MemoryTable;
            memory_audit: import("../schema/tables/memory-audit.table").MemoryAuditTable;
            memory_asset: import("../schema/tables/memory-asset.table").MemoryAssetTable;
            memory_asset_audit: import("../schema/tables/memory-asset-audit.table").MemoryAssetAuditTable;
            migrations: import("src/schema").Migrations;
            notification: import("../schema/tables/notification.table").NotificationTable;
            move_history: import("../schema/tables/move.table").MoveTable;
            naturalearth_countries: import("../schema/tables/natural-earth-countries.table").NaturalEarthCountriesTable;
            partner: import("../schema/tables/partner.table").PartnerTable;
            partner_audit: import("../schema/tables/partner-audit.table").PartnerAuditTable;
            person: import("../schema/tables/person.table").PersonTable;
            person_audit: import("../schema/tables/person-audit.table").PersonAuditTable;
            session: import("../schema/tables/session.table").SessionTable;
            session_sync_checkpoint: import("../schema/tables/sync-checkpoint.table").SessionSyncCheckpointTable;
            shared_link: import("../schema/tables/shared-link.table").SharedLinkTable;
            shared_link_asset: import("../schema/tables/shared-link-asset.table").SharedLinkAssetTable;
            stack_audit: import("../schema/tables/stack-audit.table").StackAuditTable;
            system_metadata: import("../schema/tables/system-metadata.table").SystemMetadataTable<import("src/enum").SystemMetadataKey>;
            tag: import("../schema/tables/tag.table").TagTable;
            tag_asset: import("../schema/tables/tag-asset.table").TagAssetTable;
            tag_closure: import("../schema/tables/tag-closure.table").TagClosureTable;
            user_audit: import("../schema/tables/user-audit.table").UserAuditTable;
            user_metadata: import("../schema/tables/user-metadata.table").UserMetadataTable<import("src/enum").UserMetadataKey>;
            version_history: import("../schema/tables/version-history.table").VersionHistoryTable;
        }, "smart_search" | "asset", "stackId">;
        duplicateId: import("node_modules/kysely/dist/cjs/util/type-utils").ExtractColumnType<{
            library: import("../schema/tables/library.table").LibraryTable;
            api_key: import("../schema/tables/api-key.table").ApiKeyTable;
            smart_search: import("kysely").Nullable<import("../schema/tables/smart-search.table").SmartSearchTable>;
            face_search: import("../schema/tables/face-search.table").FaceSearchTable;
            user: import("../schema/tables/user.table").UserTable;
            user_metadata_audit: import("../schema/tables/user-metadata-audit.table").UserMetadataAuditTable;
            asset_metadata_audit: import("../schema/tables/asset-metadata-audit.table").AssetMetadataAuditTable;
            asset_face_audit: import("../schema/tables/asset-face-audit.table").AssetFaceAuditTable;
            stack: import("../schema/tables/stack.table").StackTable;
            activity: import("../schema/tables/activity.table").ActivityTable;
            album: import("../schema/tables/album.table").AlbumTable;
            album_audit: import("../schema/tables/album-audit.table").AlbumAuditTable;
            album_asset: import("../schema/tables/album-asset.table").AlbumAssetTable;
            album_asset_audit: import("../schema/tables/album-asset-audit.table").AlbumAssetAuditTable;
            album_user: import("../schema/tables/album-user.table").AlbumUserTable;
            album_user_audit: import("../schema/tables/album-user-audit.table").AlbumUserAuditTable;
            asset: import("../schema/tables/asset.table").AssetTable;
            asset_audit: import("../schema/tables/asset-audit.table").AssetAuditTable;
            asset_exif: import("../schema/tables/asset-exif.table").AssetExifTable;
            asset_face: import("../schema/tables/asset-face.table").AssetFaceTable;
            asset_file: import("../schema/tables/asset-file.table").AssetFileTable;
            asset_metadata: import("../schema/tables/asset-metadata.table").AssetMetadataTable<import("src/enum").AssetMetadataKey>;
            asset_job_status: import("../schema/tables/asset-job-status.table").AssetJobStatusTable;
            audit: import("../schema/tables/audit.table").AuditTable;
            geodata_places: import("../schema/tables/geodata-places.table").GeodataPlacesTable;
            memory: import("../schema/tables/memory.table").MemoryTable;
            memory_audit: import("../schema/tables/memory-audit.table").MemoryAuditTable;
            memory_asset: import("../schema/tables/memory-asset.table").MemoryAssetTable;
            memory_asset_audit: import("../schema/tables/memory-asset-audit.table").MemoryAssetAuditTable;
            migrations: import("src/schema").Migrations;
            notification: import("../schema/tables/notification.table").NotificationTable;
            move_history: import("../schema/tables/move.table").MoveTable;
            naturalearth_countries: import("../schema/tables/natural-earth-countries.table").NaturalEarthCountriesTable;
            partner: import("../schema/tables/partner.table").PartnerTable;
            partner_audit: import("../schema/tables/partner-audit.table").PartnerAuditTable;
            person: import("../schema/tables/person.table").PersonTable;
            person_audit: import("../schema/tables/person-audit.table").PersonAuditTable;
            session: import("../schema/tables/session.table").SessionTable;
            session_sync_checkpoint: import("../schema/tables/sync-checkpoint.table").SessionSyncCheckpointTable;
            shared_link: import("../schema/tables/shared-link.table").SharedLinkTable;
            shared_link_asset: import("../schema/tables/shared-link-asset.table").SharedLinkAssetTable;
            stack_audit: import("../schema/tables/stack-audit.table").StackAuditTable;
            system_metadata: import("../schema/tables/system-metadata.table").SystemMetadataTable<import("src/enum").SystemMetadataKey>;
            tag: import("../schema/tables/tag.table").TagTable;
            tag_asset: import("../schema/tables/tag-asset.table").TagAssetTable;
            tag_closure: import("../schema/tables/tag-closure.table").TagClosureTable;
            user_audit: import("../schema/tables/user-audit.table").UserAuditTable;
            user_metadata: import("../schema/tables/user-metadata.table").UserMetadataTable<import("src/enum").UserMetadataKey>;
            version_history: import("../schema/tables/version-history.table").VersionHistoryTable;
        }, "smart_search" | "asset", "duplicateId">;
        visibility: AssetVisibility;
        embedding: string | null;
    } | undefined>;
    getForSidecarWriteJob(id: string): Promise<{
        id: string;
        originalPath: string;
        sidecarPath: string | null;
        tags: {
            value: string;
        }[];
    } | undefined>;
    getForSidecarCheckJob(id: string): Promise<{
        id: string;
        originalPath: string;
        sidecarPath: string | null;
    } | undefined>;
    streamForThumbnailJob(force: boolean): AsyncIterableIterator<{
        id: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
    } & {
        files: {
            id: string;
            type: AssetFileType;
            path: string;
        }[];
    } & Partial<Omit<unknown, "id" | "thumbhash" | "files">>>;
    getForMigrationJob(id: string): Promise<{
        id: string;
        ownerId: string;
        encodedVideoPath: string | null;
        files: {
            id: string;
            type: AssetFileType;
            path: string;
        }[];
    } | undefined>;
    getForGenerateThumbnailJob(id: string): Promise<{
        id: string;
        type: AssetType;
        ownerId: string;
        originalPath: string;
        originalFileName: string;
        thumbhash: Buffer<ArrayBufferLike> | null;
        visibility: AssetVisibility;
        files: {
            id: string;
            type: AssetFileType;
            path: string;
        }[];
        exifInfo: import("src/database").Exif;
    } | undefined>;
    getForMetadataExtraction(id: string): Promise<{
        id: string;
        type: AssetType;
        ownerId: string;
        deviceAssetId: string;
        deviceId: string;
        originalPath: string;
        fileCreatedAt: Date;
        fileModifiedAt: Date;
        checksum: Buffer<ArrayBufferLike>;
        livePhotoVideoId: string | null;
        originalFileName: string;
        sidecarPath: string | null;
        libraryId: string | null;
        isExternal: boolean;
        localDateTime: Date;
        visibility: AssetVisibility;
        faces: {
            id: string;
            assetId: string;
            updatedAt: Date;
            deletedAt: Date | null;
            updateId: string;
            personId: string | null;
            imageWidth: number;
            imageHeight: number;
            boundingBoxX1: number;
            boundingBoxY1: number;
            boundingBoxX2: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
        }[];
    } | undefined>;
    getAlbumThumbnailFiles(id: string, fileType?: AssetFileType): Promise<{
        id: string;
        type: AssetFileType;
        path: string;
    }[]>;
    private assetsWithPreviews;
    streamForSearchDuplicates(force?: boolean): AsyncIterableIterator<{
        id: string;
    } & Partial<Omit<unknown, "id">>>;
    streamForEncodeClip(force?: boolean): AsyncIterableIterator<{
        id: string;
    } & Partial<Omit<unknown, "id">>>;
    getForClipEncoding(id: string): Promise<{
        id: string;
        visibility: AssetVisibility;
        files: {
            id: string;
            type: AssetFileType;
            path: string;
        }[];
    } | undefined>;
    getForDetectFacesJob(id: string): Promise<{
        id: string;
        visibility: AssetVisibility;
        exifInfo: import("src/database").Exif;
        faces: {
            id: string;
            assetId: string;
            updatedAt: Date;
            deletedAt: Date | null;
            updateId: string;
            personId: string | null;
            imageWidth: number;
            imageHeight: number;
            boundingBoxX1: number;
            boundingBoxY1: number;
            boundingBoxX2: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
        }[];
        files: {
            id: string;
            type: AssetFileType;
            path: string;
        }[];
    } | undefined>;
    getForSyncAssets(ids: string[]): Promise<{
        id: string;
        status: import("src/enum").AssetStatus;
        originalPath: string;
        fileModifiedAt: Date;
        isOffline: boolean;
        libraryId: string | null;
    }[]>;
    getForAssetDeletion(id: string): Promise<{
        id: string;
        ownerId: string;
        originalPath: string;
        encodedVideoPath: string | null;
        livePhotoVideoId: string | null;
        sidecarPath: string | null;
        libraryId: string | null;
        visibility: AssetVisibility;
        exifInfo: import("src/database").Exif | null;
        faces: {
            id: string;
            assetId: string;
            updatedAt: Date;
            deletedAt: Date | null;
            updateId: string;
            personId: string | null;
            imageWidth: number;
            imageHeight: number;
            boundingBoxX1: number;
            boundingBoxY1: number;
            boundingBoxX2: number;
            boundingBoxY2: number;
            sourceType: import("src/enum").SourceType;
            person: import("src/database").Person;
        }[];
        files: {
            id: string;
            type: AssetFileType;
            path: string;
        }[];
        stack: {
            assets: Asset[];
            id: string;
            primaryAssetId: string;
        } | null;
    } | undefined>;
    streamForVideoConversion(force?: boolean): AsyncIterableIterator<{
        id: string;
    } & Partial<Omit<unknown, "id">>>;
    getForVideoConversion(id: string): Promise<{
        id: string;
        ownerId: string;
        originalPath: string;
        encodedVideoPath: string | null;
    } | undefined>;
    streamForMetadataExtraction(force?: boolean): AsyncIterableIterator<{
        id: string;
    } & Partial<Omit<unknown, "id">>>;
    private storageTemplateAssetQuery;
    getForStorageTemplateJob(id: string): Promise<StorageAsset | undefined>;
    streamForStorageTemplateJob(): AsyncIterableIterator<StorageAsset>;
    streamForDeletedJob(trashedBefore: Date): AsyncIterableIterator<{
        id: string;
        isOffline: boolean;
    }>;
    streamForSidecar(force?: boolean): AsyncIterableIterator<{
        id: string;
    } & Partial<Omit<unknown, "id">>>;
    streamForDetectFacesJob(force?: boolean): AsyncIterableIterator<Partial<Omit<unknown, never>> & {
        id: string;
    }>;
    streamForMigrationJob(): AsyncIterableIterator<{
        id: string;
    }>;
}
