"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetJobRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const postgres_1 = require("kysely/helpers/postgres");
const nestjs_kysely_1 = require("nestjs-kysely");
const database_1 = require("../database");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const database_2 = require("../utils/database");
let AssetJobRepository = class AssetJobRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    getForSearchDuplicatesJob(id) {
        return this.db
            .selectFrom('asset')
            .where('asset.id', '=', (0, database_2.asUuid)(id))
            .leftJoin('smart_search', 'asset.id', 'smart_search.assetId')
            .select(['id', 'type', 'ownerId', 'duplicateId', 'stackId', 'visibility', 'smart_search.embedding'])
            .limit(1)
            .executeTakeFirst();
    }
    getForSidecarWriteJob(id) {
        return this.db
            .selectFrom('asset')
            .where('asset.id', '=', (0, database_2.asUuid)(id))
            .select(['id', 'sidecarPath', 'originalPath'])
            .select((eb) => (0, postgres_1.jsonArrayFrom)(eb
            .selectFrom('tag')
            .select(['tag.value'])
            .innerJoin('tag_asset', 'tag.id', 'tag_asset.tagsId')
            .whereRef('asset.id', '=', 'tag_asset.assetsId')).as('tags'))
            .limit(1)
            .executeTakeFirst();
    }
    getForSidecarCheckJob(id) {
        return this.db
            .selectFrom('asset')
            .where('asset.id', '=', (0, database_2.asUuid)(id))
            .select(['id', 'sidecarPath', 'originalPath'])
            .limit(1)
            .executeTakeFirst();
    }
    streamForThumbnailJob(force) {
        return this.db
            .selectFrom('asset')
            .select(['asset.id', 'asset.thumbhash'])
            .select(database_2.withFiles)
            .where('asset.deletedAt', 'is', null)
            .where('asset.visibility', '!=', enum_1.AssetVisibility.Hidden)
            .$if(!force, (qb) => qb
            .innerJoin('asset_job_status', 'asset_job_status.assetId', 'asset.id')
            .where((eb) => eb.or([
            eb('asset_job_status.previewAt', 'is', null),
            eb('asset_job_status.thumbnailAt', 'is', null),
            eb('asset.thumbhash', 'is', null),
        ])))
            .stream();
    }
    getForMigrationJob(id) {
        return this.db
            .selectFrom('asset')
            .select(['asset.id', 'asset.ownerId', 'asset.encodedVideoPath'])
            .select(database_2.withFiles)
            .where('asset.id', '=', id)
            .executeTakeFirst();
    }
    getForGenerateThumbnailJob(id) {
        return this.db
            .selectFrom('asset')
            .select([
            'asset.id',
            'asset.visibility',
            'asset.originalFileName',
            'asset.originalPath',
            'asset.ownerId',
            'asset.thumbhash',
            'asset.type',
        ])
            .select(database_2.withFiles)
            .$call(database_2.withExifInner)
            .where('asset.id', '=', id)
            .executeTakeFirst();
    }
    getForMetadataExtraction(id) {
        return this.db
            .selectFrom('asset')
            .select(database_1.columns.asset)
            .select(database_2.withFaces)
            .where('asset.id', '=', id)
            .executeTakeFirst();
    }
    getAlbumThumbnailFiles(id, fileType) {
        return this.db
            .selectFrom('asset_file')
            .select(database_1.columns.assetFiles)
            .where('asset_file.assetId', '=', id)
            .$if(!!fileType, (qb) => qb.where('asset_file.type', '=', fileType))
            .execute();
    }
    assetsWithPreviews() {
        return this.db
            .selectFrom('asset')
            .where('asset.visibility', '!=', enum_1.AssetVisibility.Hidden)
            .where('asset.deletedAt', 'is', null)
            .innerJoin('asset_job_status as job_status', 'assetId', 'asset.id')
            .where('job_status.previewAt', 'is not', null);
    }
    streamForSearchDuplicates(force) {
        return this.db
            .selectFrom('asset')
            .select(['asset.id'])
            .where('asset.deletedAt', 'is', null)
            .innerJoin('smart_search', 'asset.id', 'smart_search.assetId')
            .$call(database_2.withDefaultVisibility)
            .$if(!force, (qb) => qb
            .innerJoin('asset_job_status as job_status', 'job_status.assetId', 'asset.id')
            .where('job_status.duplicatesDetectedAt', 'is', null))
            .stream();
    }
    streamForEncodeClip(force) {
        return this.assetsWithPreviews()
            .select(['asset.id'])
            .$if(!force, (qb) => qb.where((eb) => eb.not((eb) => eb.exists(eb.selectFrom('smart_search').whereRef('assetId', '=', 'asset.id')))))
            .stream();
    }
    getForClipEncoding(id) {
        return this.db
            .selectFrom('asset')
            .select(['asset.id', 'asset.visibility'])
            .select((eb) => (0, database_2.withFiles)(eb, enum_1.AssetFileType.Preview))
            .where('asset.id', '=', id)
            .executeTakeFirst();
    }
    getForDetectFacesJob(id) {
        return this.db
            .selectFrom('asset')
            .select(['asset.id', 'asset.visibility'])
            .$call(database_2.withExifInner)
            .select((eb) => (0, database_2.withFaces)(eb, true))
            .select((eb) => (0, database_2.withFiles)(eb, enum_1.AssetFileType.Preview))
            .where('asset.id', '=', id)
            .executeTakeFirst();
    }
    getForSyncAssets(ids) {
        return this.db
            .selectFrom('asset')
            .select([
            'asset.id',
            'asset.isOffline',
            'asset.libraryId',
            'asset.originalPath',
            'asset.status',
            'asset.fileModifiedAt',
        ])
            .where('asset.id', '=', (0, database_2.anyUuid)(ids))
            .execute();
    }
    getForAssetDeletion(id) {
        return this.db
            .selectFrom('asset')
            .select([
            'asset.id',
            'asset.visibility',
            'asset.libraryId',
            'asset.ownerId',
            'asset.livePhotoVideoId',
            'asset.sidecarPath',
            'asset.encodedVideoPath',
            'asset.originalPath',
        ])
            .$call(database_2.withExif)
            .select(database_2.withFacesAndPeople)
            .select(database_2.withFiles)
            .leftJoin('stack', 'stack.id', 'asset.stackId')
            .leftJoinLateral((eb) => eb
            .selectFrom('asset as stacked')
            .select(['stack.id', 'stack.primaryAssetId'])
            .select((eb) => eb.fn('array_agg', [eb.table('stacked')]).as('assets'))
            .where('stacked.deletedAt', 'is not', null)
            .where('stacked.visibility', '=', enum_1.AssetVisibility.Timeline)
            .whereRef('stacked.stackId', '=', 'stack.id')
            .groupBy('stack.id')
            .as('stacked_assets'), (join) => join.on('stack.id', 'is not', null))
            .select((eb) => (0, database_2.toJson)(eb, 'stacked_assets').as('stack'))
            .where('asset.id', '=', id)
            .executeTakeFirst();
    }
    streamForVideoConversion(force) {
        return this.db
            .selectFrom('asset')
            .select(['asset.id'])
            .where('asset.type', '=', enum_1.AssetType.Video)
            .$if(!force, (qb) => qb
            .where((eb) => eb.or([eb('asset.encodedVideoPath', 'is', null), eb('asset.encodedVideoPath', '=', '')]))
            .where('asset.visibility', '!=', enum_1.AssetVisibility.Hidden))
            .where('asset.deletedAt', 'is', null)
            .stream();
    }
    getForVideoConversion(id) {
        return this.db
            .selectFrom('asset')
            .select(['asset.id', 'asset.ownerId', 'asset.originalPath', 'asset.encodedVideoPath'])
            .where('asset.id', '=', id)
            .where('asset.type', '=', enum_1.AssetType.Video)
            .executeTakeFirst();
    }
    streamForMetadataExtraction(force) {
        return this.db
            .selectFrom('asset')
            .select(['asset.id'])
            .$if(!force, (qb) => qb
            .leftJoin('asset_job_status', 'asset_job_status.assetId', 'asset.id')
            .where((eb) => eb.or([eb('asset_job_status.metadataExtractedAt', 'is', null), eb('asset_job_status.assetId', 'is', null)])))
            .where('asset.deletedAt', 'is', null)
            .stream();
    }
    storageTemplateAssetQuery() {
        return this.db
            .selectFrom('asset')
            .innerJoin('asset_exif', 'asset.id', 'asset_exif.assetId')
            .select([
            'asset.id',
            'asset.ownerId',
            'asset.type',
            'asset.checksum',
            'asset.originalPath',
            'asset.isExternal',
            'asset.sidecarPath',
            'asset.originalFileName',
            'asset.livePhotoVideoId',
            'asset.fileCreatedAt',
            'asset_exif.timeZone',
            'asset_exif.fileSizeInByte',
        ])
            .where('asset.deletedAt', 'is', null);
    }
    getForStorageTemplateJob(id) {
        return this.storageTemplateAssetQuery().where('asset.id', '=', id).executeTakeFirst();
    }
    streamForStorageTemplateJob() {
        return this.storageTemplateAssetQuery().stream();
    }
    streamForDeletedJob(trashedBefore) {
        return this.db
            .selectFrom('asset')
            .select(['id', 'isOffline'])
            .where('asset.deletedAt', '<=', trashedBefore)
            .stream();
    }
    streamForSidecar(force) {
        return this.db
            .selectFrom('asset')
            .select(['asset.id'])
            .$if(!force, (qb) => qb.where((eb) => eb.or([eb('asset.sidecarPath', '=', ''), eb('asset.sidecarPath', 'is', null)])))
            .where('asset.visibility', '!=', enum_1.AssetVisibility.Hidden)
            .stream();
    }
    streamForDetectFacesJob(force) {
        return this.assetsWithPreviews()
            .$if(force === false, (qb) => qb.where('job_status.facesRecognizedAt', 'is', null))
            .select(['asset.id'])
            .orderBy('asset.fileCreatedAt', 'desc')
            .stream();
    }
    streamForMigrationJob() {
        return this.db.selectFrom('asset').select(['id']).where('asset.deletedAt', 'is', null).stream();
    }
};
exports.AssetJobRepository = AssetJobRepository;
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getForSearchDuplicatesJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getForSidecarWriteJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getForSidecarCheckJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [false], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Boolean]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "streamForThumbnailJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getForMigrationJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getForGenerateThumbnailJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getForMetadataExtraction", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID, enum_1.AssetFileType.Thumbnail] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getAlbumThumbnailFiles", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Boolean]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "streamForSearchDuplicates", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Boolean]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "streamForEncodeClip", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getForClipEncoding", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getForDetectFacesJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [[decorators_1.DummyValue.UUID]] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getForSyncAssets", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getForAssetDeletion", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Boolean]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "streamForVideoConversion", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "getForVideoConversion", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Boolean]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "streamForMetadataExtraction", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.UUID] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AssetJobRepository.prototype, "getForStorageTemplateJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "streamForStorageTemplateJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.DATE], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Date]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "streamForDeletedJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Boolean]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "streamForSidecar", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Boolean]),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "streamForDetectFacesJob", null);
__decorate([
    (0, decorators_1.GenerateSql)({ params: [decorators_1.DummyValue.DATE], stream: true }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], AssetJobRepository.prototype, "streamForMigrationJob", null);
exports.AssetJobRepository = AssetJobRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], AssetJobRepository);
//# sourceMappingURL=asset-job.repository.js.map