"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var CronRepository_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CronRepository = void 0;
const common_1 = require("@nestjs/common");
const schedule_1 = require("@nestjs/schedule");
const cron_1 = require("cron");
const logging_repository_1 = require("./logging.repository");
let CronRepository = CronRepository_1 = class CronRepository {
    schedulerRegistry;
    logger;
    constructor(schedulerRegistry, logger) {
        this.schedulerRegistry = schedulerRegistry;
        this.logger = logger;
        this.logger.setContext(CronRepository_1.name);
    }
    create({ name, expression, onTick, start = true }) {
        const job = new cron_1.CronJob(expression, onTick, undefined, start, undefined, undefined, undefined, undefined, true);
        this.schedulerRegistry.addCronJob(name, job);
    }
    update({ name, expression, start }) {
        const job = this.schedulerRegistry.getCronJob(name);
        if (expression) {
            job.setTime(new cron_1.CronTime(expression));
        }
        if (start !== undefined) {
            if (start) {
                job.start();
            }
            else {
                void job.stop();
            }
        }
    }
};
exports.CronRepository = CronRepository;
exports.CronRepository = CronRepository = CronRepository_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [schedule_1.SchedulerRegistry,
        logging_repository_1.LoggingRepository])
], CronRepository);
//# sourceMappingURL=cron.repository.js.map