"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DownloadRepository = void 0;
const common_1 = require("@nestjs/common");
const kysely_1 = require("kysely");
const nestjs_kysely_1 = require("nestjs-kysely");
const enum_1 = require("../enum");
const database_1 = require("../utils/database");
const builder = (db) => db
    .selectFrom('asset')
    .innerJoin('asset_exif', 'assetId', 'id')
    .select(['asset.id', 'asset.livePhotoVideoId', 'asset_exif.fileSizeInByte as size'])
    .where('asset.deletedAt', 'is', null);
let DownloadRepository = class DownloadRepository {
    db;
    constructor(db) {
        this.db = db;
    }
    downloadAssetIds(ids) {
        return builder(this.db).where('asset.id', '=', (0, database_1.anyUuid)(ids)).stream();
    }
    downloadMotionAssetIds(ids) {
        return builder(this.db).select(['asset.originalPath']).where('asset.id', '=', (0, database_1.anyUuid)(ids)).stream();
    }
    downloadAlbumId(albumId) {
        return builder(this.db)
            .innerJoin('album_asset', 'asset.id', 'album_asset.assetsId')
            .where('album_asset.albumsId', '=', albumId)
            .stream();
    }
    downloadUserId(userId) {
        return builder(this.db)
            .where('asset.ownerId', '=', userId)
            .where('asset.visibility', '!=', enum_1.AssetVisibility.Hidden)
            .stream();
    }
};
exports.DownloadRepository = DownloadRepository;
exports.DownloadRepository = DownloadRepository = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, nestjs_kysely_1.InjectKysely)()),
    __metadata("design:paramtypes", [kysely_1.Kysely])
], DownloadRepository);
//# sourceMappingURL=download.repository.js.map