import { LoggingRepository } from 'src/repositories/logging.repository';
import { EmailImageAttachment } from 'src/types';
export type SendEmailOptions = {
    from: string;
    to: string;
    replyTo?: string;
    subject: string;
    html: string;
    text: string;
    imageAttachments?: EmailImageAttachment[];
    smtp: SmtpOptions;
};
export type SmtpOptions = {
    host: string;
    port?: number;
    username?: string;
    password?: string;
    ignoreCert?: boolean;
};
export declare enum EmailTemplate {
    TEST_EMAIL = "test",
    WELCOME = "welcome",
    RESET_PASSWORD = "reset-password",
    ALBUM_INVITE = "album-invite",
    ALBUM_UPDATE = "album-update"
}
interface BaseEmailProps {
    baseUrl: string;
    customTemplate?: string;
}
export interface TestEmailProps extends BaseEmailProps {
    displayName: string;
}
export interface WelcomeEmailProps extends BaseEmailProps {
    displayName: string;
    username: string;
    password?: string;
}
export interface AlbumInviteEmailProps extends BaseEmailProps {
    albumName: string;
    albumId: string;
    senderName: string;
    recipientName: string;
    cid?: string;
}
export interface AlbumUpdateEmailProps extends BaseEmailProps {
    albumName: string;
    albumId: string;
    recipientName: string;
    cid?: string;
}
export type EmailRenderRequest = {
    template: EmailTemplate.TEST_EMAIL;
    data: TestEmailProps;
    customTemplate: string;
} | {
    template: EmailTemplate.WELCOME;
    data: WelcomeEmailProps;
    customTemplate: string;
} | {
    template: EmailTemplate.ALBUM_INVITE;
    data: AlbumInviteEmailProps;
    customTemplate: string;
} | {
    template: EmailTemplate.ALBUM_UPDATE;
    data: AlbumUpdateEmailProps;
    customTemplate: string;
};
export type SendEmailResponse = {
    messageId: string;
    response: any;
};
export declare class EmailRepository {
    private logger;
    constructor(logger: LoggingRepository);
    verifySmtp(options: SmtpOptions): Promise<true>;
    renderEmail(request: EmailRenderRequest): Promise<{
        html: string;
        text: string;
    }>;
    sendEmail({ to, from, subject, html, text, smtp, imageAttachments }: SendEmailOptions): Promise<SendEmailResponse>;
    private render;
    private createTransport;
}
export {};
