import { ModuleRef } from '@nestjs/core';
import { OnGatewayConnection, OnGatewayDisconnect, OnGatewayInit } from '@nestjs/websockets';
import { ClassConstructor } from 'class-transformer';
import { Server, Socket } from 'socket.io';
import { SystemConfig } from 'src/config';
import { AssetResponseDto } from 'src/dtos/asset-response.dto';
import { AuthDto } from 'src/dtos/auth.dto';
import { NotificationDto } from 'src/dtos/notification.dto';
import { ReleaseNotification, ServerVersionResponseDto } from 'src/dtos/server.dto';
import { SyncAssetExifV1, SyncAssetV1 } from 'src/dtos/sync.dto';
import { QueueName } from 'src/enum';
import { ConfigRepository } from 'src/repositories/config.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { JobItem, JobSource } from 'src/types';
type EventMap = {
    AppBootstrap: [];
    AppShutdown: [];
    ConfigInit: [{
        newConfig: SystemConfig;
    }];
    ConfigUpdate: [
        {
            newConfig: SystemConfig;
            oldConfig: SystemConfig;
        }
    ];
    ConfigValidate: [{
        newConfig: SystemConfig;
        oldConfig: SystemConfig;
    }];
    AlbumUpdate: [{
        id: string;
        recipientId: string;
    }];
    AlbumInvite: [{
        id: string;
        userId: string;
    }];
    AssetTag: [{
        assetId: string;
    }];
    AssetUntag: [{
        assetId: string;
    }];
    AssetHide: [{
        assetId: string;
        userId: string;
    }];
    AssetShow: [{
        assetId: string;
        userId: string;
    }];
    AssetTrash: [{
        assetId: string;
        userId: string;
    }];
    AssetDelete: [{
        assetId: string;
        userId: string;
    }];
    AssetMetadataExtracted: [{
        assetId: string;
        userId: string;
        source?: JobSource;
    }];
    AssetTrashAll: [{
        assetIds: string[];
        userId: string;
    }];
    AssetDeleteAll: [{
        assetIds: string[];
        userId: string;
    }];
    AssetRestoreAll: [{
        assetIds: string[];
        userId: string;
    }];
    JobStart: [QueueName, JobItem];
    JobFailed: [{
        job: JobItem;
        error: Error | any;
    }];
    SessionDelete: [{
        sessionId: string;
    }];
    StackCreate: [{
        stackId: string;
        userId: string;
    }];
    StackUpdate: [{
        stackId: string;
        userId: string;
    }];
    StackDelete: [{
        stackId: string;
        userId: string;
    }];
    StackDeleteAll: [{
        stackIds: string[];
        userId: string;
    }];
    UserSignup: [{
        notify: boolean;
        id: string;
        password?: string;
    }];
    WebsocketConnect: [{
        userId: string;
    }];
};
export declare const serverEvents: readonly ["ConfigUpdate"];
export type ServerEvents = (typeof serverEvents)[number];
export type EmitEvent = keyof EventMap;
export type EmitHandler<T extends EmitEvent> = (...args: ArgsOf<T>) => Promise<void> | void;
export type ArgOf<T extends EmitEvent> = EventMap[T][0];
export type ArgsOf<T extends EmitEvent> = EventMap[T];
export interface ClientEventMap {
    on_upload_success: [AssetResponseDto];
    on_user_delete: [string];
    on_asset_delete: [string];
    on_asset_trash: [string[]];
    on_asset_update: [AssetResponseDto];
    on_asset_hidden: [string];
    on_asset_restore: [string[]];
    on_asset_stack_update: string[];
    on_person_thumbnail: [string];
    on_server_version: [ServerVersionResponseDto];
    on_config_update: [];
    on_new_release: [ReleaseNotification];
    on_notification: [NotificationDto];
    on_session_delete: [string];
    AssetUploadReadyV1: [{
        asset: SyncAssetV1;
        exif: SyncAssetExifV1;
    }];
}
export type EventItem<T extends EmitEvent> = {
    event: T;
    handler: EmitHandler<T>;
    server: boolean;
};
export type AuthFn = (client: Socket) => Promise<AuthDto>;
export declare class EventRepository implements OnGatewayConnection, OnGatewayDisconnect, OnGatewayInit {
    private moduleRef;
    private configRepository;
    private logger;
    private emitHandlers;
    private authFn?;
    private server?;
    constructor(moduleRef: ModuleRef, configRepository: ConfigRepository, logger: LoggingRepository);
    setup({ services }: {
        services: ClassConstructor<unknown>[];
    }): void;
    afterInit(server: Server): void;
    handleConnection(client: Socket): Promise<void>;
    handleDisconnect(client: Socket): Promise<void>;
    private addHandler;
    emit<T extends EmitEvent>(event: T, ...args: ArgsOf<T>): Promise<void>;
    private onEvent;
    clientSend<T extends keyof ClientEventMap>(event: T, room: string, ...data: ClientEventMap[T]): void;
    clientBroadcast<T extends keyof ClientEventMap>(event: T, ...data: ClientEventMap[T]): void;
    serverSend<T extends ServerEvents>(event: T, ...args: ArgsOf<T>): void;
    setAuthFn(fn: (client: Socket) => Promise<AuthDto>): void;
    private authenticate;
}
export {};
