import { Insertable, Kysely, Updateable } from 'kysely';
import { LibraryStatsResponseDto } from 'src/dtos/library.dto';
import { DB } from 'src/schema';
import { LibraryTable } from 'src/schema/tables/library.table';
export declare enum AssetSyncResult {
    DO_NOTHING = 0,
    UPDATE = 1,
    OFFLINE = 2,
    CHECK_OFFLINE = 3
}
export declare class LibraryRepository {
    private db;
    constructor(db: Kysely<DB>);
    get(id: string, withDeleted?: boolean): Promise<{
        id: string;
        name: string;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        updateId: string;
        ownerId: string;
        importPaths: string[];
        exclusionPatterns: string[];
        refreshedAt: Date | null;
    } | undefined>;
    getAll(withDeleted?: boolean): Promise<{
        id: string;
        name: string;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        updateId: string;
        ownerId: string;
        importPaths: string[];
        exclusionPatterns: string[];
        refreshedAt: Date | null;
    }[]>;
    getAllDeleted(): Promise<{
        id: string;
        name: string;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        updateId: string;
        ownerId: string;
        importPaths: string[];
        exclusionPatterns: string[];
        refreshedAt: Date | null;
    }[]>;
    create(library: Insertable<LibraryTable>): Promise<{
        id: string;
        name: string;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        updateId: string;
        ownerId: string;
        importPaths: string[];
        exclusionPatterns: string[];
        refreshedAt: Date | null;
    }>;
    delete(id: string): Promise<void>;
    softDelete(id: string): Promise<void>;
    update(id: string, library: Updateable<LibraryTable>): Promise<{
        id: string;
        name: string;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        updateId: string;
        ownerId: string;
        importPaths: string[];
        exclusionPatterns: string[];
        refreshedAt: Date | null;
    }>;
    getStatistics(id: string): Promise<LibraryStatsResponseDto | undefined>;
    streamAssetIds(libraryId: string): AsyncIterableIterator<{
        id: string;
    }>;
}
