"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var LoggingRepository_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoggingRepository = exports.MyConsoleLogger = void 0;
const common_1 = require("@nestjs/common");
const is_log_level_enabled_util_1 = require("@nestjs/common/services/utils/is-log-level-enabled.util");
const nestjs_cls_1 = require("nestjs-cls");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const config_repository_1 = require("./config.repository");
const LOG_LEVELS = [enum_1.LogLevel.Verbose, enum_1.LogLevel.Debug, enum_1.LogLevel.Log, enum_1.LogLevel.Warn, enum_1.LogLevel.Error, enum_1.LogLevel.Fatal];
var LogColor;
(function (LogColor) {
    LogColor[LogColor["RED"] = 31] = "RED";
    LogColor[LogColor["GREEN"] = 32] = "GREEN";
    LogColor[LogColor["YELLOW"] = 33] = "YELLOW";
    LogColor[LogColor["BLUE"] = 34] = "BLUE";
    LogColor[LogColor["MAGENTA_BRIGHT"] = 95] = "MAGENTA_BRIGHT";
    LogColor[LogColor["CYAN_BRIGHT"] = 96] = "CYAN_BRIGHT";
})(LogColor || (LogColor = {}));
let appName;
let logLevels = [enum_1.LogLevel.Log, enum_1.LogLevel.Warn, enum_1.LogLevel.Error, enum_1.LogLevel.Fatal];
class MyConsoleLogger extends common_1.ConsoleLogger {
    cls;
    isColorEnabled;
    constructor(cls, options) {
        super(options?.context || MyConsoleLogger.name);
        this.cls = cls;
        this.isColorEnabled = options?.color || false;
    }
    isLevelEnabled(level) {
        return (0, is_log_level_enabled_util_1.isLogLevelEnabled)(level, logLevels);
    }
    formatContext(context) {
        let prefix = appName || '';
        if (context) {
            prefix += (prefix ? ':' : '') + context;
        }
        const correlationId = this.cls?.getId();
        if (correlationId) {
            prefix += `~${correlationId}`;
        }
        if (!prefix) {
            return '';
        }
        return this.colors.yellow(`[${prefix}]`) + ' ';
    }
    colors = {
        red: (text) => this.withColor(text, LogColor.RED),
        green: (text) => this.withColor(text, LogColor.GREEN),
        yellow: (text) => this.withColor(text, LogColor.YELLOW),
        blue: (text) => this.withColor(text, LogColor.BLUE),
        magentaBright: (text) => this.withColor(text, LogColor.MAGENTA_BRIGHT),
        cyanBright: (text) => this.withColor(text, LogColor.CYAN_BRIGHT),
    };
    withColor(text, color) {
        return this.isColorEnabled ? `\u001B[${color}m${text}\u001B[39m` : text;
    }
}
exports.MyConsoleLogger = MyConsoleLogger;
let LoggingRepository = LoggingRepository_1 = class LoggingRepository {
    logger;
    constructor(cls, configRepository) {
        let noColor = false;
        if (configRepository) {
            noColor = configRepository.getEnv().noColor;
        }
        this.logger = new MyConsoleLogger(cls, { context: LoggingRepository_1.name, color: !noColor });
    }
    static create(context) {
        const logger = new LoggingRepository_1(undefined, undefined);
        if (context) {
            logger.setContext(context);
        }
        return logger;
    }
    setAppName(name) {
        appName = name.charAt(0).toUpperCase() + name.slice(1);
    }
    setContext(context) {
        this.logger.setContext(context);
    }
    isLevelEnabled(level) {
        return this.logger.isLevelEnabled(level);
    }
    setLogLevel(level) {
        logLevels = level ? LOG_LEVELS.slice(LOG_LEVELS.indexOf(level)) : [];
    }
    verbose(message, ...details) {
        this.handleMessage(enum_1.LogLevel.Verbose, message, details);
    }
    verboseFn(message, ...details) {
        this.handleFunction(enum_1.LogLevel.Verbose, message, details);
    }
    debug(message, ...details) {
        this.handleMessage(enum_1.LogLevel.Debug, message, details);
    }
    debugFn(message, ...details) {
        this.handleFunction(enum_1.LogLevel.Debug, message, details);
    }
    log(message, ...details) {
        this.handleMessage(enum_1.LogLevel.Log, message, details);
    }
    warn(message, ...details) {
        this.handleMessage(enum_1.LogLevel.Warn, message, details);
    }
    error(message, ...details) {
        this.handleMessage(enum_1.LogLevel.Error, message, details);
    }
    fatal(message, ...details) {
        this.handleMessage(enum_1.LogLevel.Fatal, message, details);
    }
    deprecate(message) {
        this.warn(`[Deprecated] ${message}`);
    }
    handleFunction(level, message, details) {
        if (this.logger.isLevelEnabled(level)) {
            this.handleMessage(level, message(), details);
        }
    }
    handleMessage(level, message, details) {
        switch (level) {
            case enum_1.LogLevel.Verbose: {
                this.logger.verbose(message, ...details);
                break;
            }
            case enum_1.LogLevel.Debug: {
                this.logger.debug(message, ...details);
                break;
            }
            case enum_1.LogLevel.Log: {
                this.logger.log(message, ...details);
                break;
            }
            case enum_1.LogLevel.Warn: {
                this.logger.warn(message, ...details);
                break;
            }
            case enum_1.LogLevel.Error: {
                this.logger.error(message, ...details);
                break;
            }
            case enum_1.LogLevel.Fatal: {
                this.logger.fatal(message, ...details);
                break;
            }
        }
    }
};
exports.LoggingRepository = LoggingRepository;
exports.LoggingRepository = LoggingRepository = LoggingRepository_1 = __decorate([
    (0, common_1.Injectable)({ scope: common_1.Scope.TRANSIENT }),
    (0, decorators_1.Telemetry)({ enabled: false }),
    __param(0, (0, common_1.Inject)(nestjs_cls_1.ClsService)),
    __param(1, (0, common_1.Inject)(config_repository_1.ConfigRepository)),
    __metadata("design:paramtypes", [Object, Object])
], LoggingRepository);
//# sourceMappingURL=logging.repository.js.map