import { Kysely } from 'kysely';
import { ConfigRepository } from 'src/repositories/config.repository';
import { LoggingRepository } from 'src/repositories/logging.repository';
import { SystemMetadataRepository } from 'src/repositories/system-metadata.repository';
import { DB } from 'src/schema';
import { GeodataPlacesTable } from 'src/schema/tables/geodata-places.table';
import { NaturalEarthCountriesTable } from 'src/schema/tables/natural-earth-countries.table';
export interface MapMarkerSearchOptions {
    isArchived?: boolean;
    isFavorite?: boolean;
    fileCreatedBefore?: Date;
    fileCreatedAfter?: Date;
}
export interface GeoPoint {
    latitude: number;
    longitude: number;
}
export interface ReverseGeocodeResult {
    country: string | null;
    state: string | null;
    city: string | null;
}
export interface MapMarker extends ReverseGeocodeResult {
    id: string;
    lat: number;
    lon: number;
}
interface MapDB extends DB {
    geodata_places_tmp: GeodataPlacesTable;
    naturalearth_countries_tmp: NaturalEarthCountriesTable;
}
export declare class MapRepository {
    private configRepository;
    private metadataRepository;
    private logger;
    private db;
    constructor(configRepository: ConfigRepository, metadataRepository: SystemMetadataRepository, logger: LoggingRepository, db: Kysely<MapDB>);
    init(): Promise<void>;
    getMapMarkers(ownerIds: string[], albumIds: string[], { isArchived, isFavorite, fileCreatedAfter, fileCreatedBefore }?: MapMarkerSearchOptions): Promise<{
        id: string;
        city: string | null;
        state: string | null;
        country: string | null;
        lat: number;
        lon: number;
    }[]>;
    reverseGeocode(point: GeoPoint): Promise<ReverseGeocodeResult>;
    private importNaturalEarthCountries;
    private importGeodata;
    private loadCities500;
    private loadAdmin;
    private createGeodataIndices;
}
export {};
