import { Insertable, Kysely, Updateable } from 'kysely';
import { MemorySearchDto } from 'src/dtos/memory.dto';
import { AssetVisibility } from 'src/enum';
import { DB } from 'src/schema';
import { MemoryTable } from 'src/schema/tables/memory.table';
import { IBulkAsset } from 'src/types';
export declare class MemoryRepository implements IBulkAsset {
    private db;
    constructor(db: Kysely<DB>);
    cleanup(): Promise<import("kysely").DeleteResult[]>;
    searchBuilder(ownerId: string, dto: MemorySearchDto): import("kysely").SelectQueryBuilder<DB, "memory", Partial<Omit<unknown, never>>>;
    statistics(ownerId: string, dto: MemorySearchDto): Promise<{
        total: number;
    }>;
    search(ownerId: string, dto: MemorySearchDto): Promise<{
        assets: {
            id: string;
            type: import("src/enum").AssetType;
            updatedAt: Date;
            createdAt: Date;
            deletedAt: Date | null;
            status: import("src/enum").AssetStatus;
            updateId: string;
            ownerId: string;
            deviceAssetId: string;
            deviceId: string;
            originalPath: string;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isFavorite: boolean;
            duration: string | null;
            encodedVideoPath: string | null;
            checksum: Buffer<ArrayBufferLike>;
            livePhotoVideoId: string | null;
            originalFileName: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            isOffline: boolean;
            libraryId: string | null;
            isExternal: boolean;
            localDateTime: Date;
            stackId: string | null;
            duplicateId: string | null;
            visibility: AssetVisibility;
        }[];
        id: string;
        type: import("src/enum").MemoryType;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        updateId: string;
        ownerId: string;
        data: object;
        isSaved: boolean;
        memoryAt: Date;
        seenAt: Date | null;
        showAt: Date | null;
        hideAt: Date | null;
    }[]>;
    get(id: string): Promise<{
        id: string;
        type: import("src/enum").MemoryType;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        updateId: string;
        ownerId: string;
        data: object;
        isSaved: boolean;
        memoryAt: Date;
        seenAt: Date | null;
        showAt: Date | null;
        hideAt: Date | null;
        assets: {
            id: string;
            type: import("src/enum").AssetType;
            updatedAt: Date;
            createdAt: Date;
            deletedAt: Date | null;
            status: import("src/enum").AssetStatus;
            updateId: string;
            ownerId: string;
            deviceAssetId: string;
            deviceId: string;
            originalPath: string;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isFavorite: boolean;
            duration: string | null;
            encodedVideoPath: string | null;
            checksum: Buffer<ArrayBufferLike>;
            livePhotoVideoId: string | null;
            originalFileName: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            isOffline: boolean;
            libraryId: string | null;
            isExternal: boolean;
            localDateTime: Date;
            stackId: string | null;
            duplicateId: string | null;
            visibility: AssetVisibility;
        }[];
    } | undefined>;
    create(memory: Insertable<MemoryTable>, assetIds: Set<string>): Promise<{
        id: string;
        type: import("src/enum").MemoryType;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        updateId: string;
        ownerId: string;
        data: object;
        isSaved: boolean;
        memoryAt: Date;
        seenAt: Date | null;
        showAt: Date | null;
        hideAt: Date | null;
        assets: {
            id: string;
            type: import("src/enum").AssetType;
            updatedAt: Date;
            createdAt: Date;
            deletedAt: Date | null;
            status: import("src/enum").AssetStatus;
            updateId: string;
            ownerId: string;
            deviceAssetId: string;
            deviceId: string;
            originalPath: string;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isFavorite: boolean;
            duration: string | null;
            encodedVideoPath: string | null;
            checksum: Buffer<ArrayBufferLike>;
            livePhotoVideoId: string | null;
            originalFileName: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            isOffline: boolean;
            libraryId: string | null;
            isExternal: boolean;
            localDateTime: Date;
            stackId: string | null;
            duplicateId: string | null;
            visibility: AssetVisibility;
        }[];
    }>;
    update(id: string, memory: Updateable<MemoryTable>): Promise<{
        id: string;
        type: import("src/enum").MemoryType;
        updatedAt: Date;
        createdAt: Date;
        deletedAt: Date | null;
        updateId: string;
        ownerId: string;
        data: object;
        isSaved: boolean;
        memoryAt: Date;
        seenAt: Date | null;
        showAt: Date | null;
        hideAt: Date | null;
        assets: {
            id: string;
            type: import("src/enum").AssetType;
            updatedAt: Date;
            createdAt: Date;
            deletedAt: Date | null;
            status: import("src/enum").AssetStatus;
            updateId: string;
            ownerId: string;
            deviceAssetId: string;
            deviceId: string;
            originalPath: string;
            fileCreatedAt: Date;
            fileModifiedAt: Date;
            isFavorite: boolean;
            duration: string | null;
            encodedVideoPath: string | null;
            checksum: Buffer<ArrayBufferLike>;
            livePhotoVideoId: string | null;
            originalFileName: string;
            sidecarPath: string | null;
            thumbhash: Buffer<ArrayBufferLike> | null;
            isOffline: boolean;
            libraryId: string | null;
            isExternal: boolean;
            localDateTime: Date;
            stackId: string | null;
            duplicateId: string | null;
            visibility: AssetVisibility;
        }[];
    }>;
    delete(id: string): Promise<void>;
    getAssetIds(id: string, assetIds: string[]): Promise<Set<string>>;
    addAssetIds(id: string, assetIds: string[]): Promise<void>;
    removeAssetIds(id: string, assetIds: string[]): Promise<void>;
    private getByIdBuilder;
}
